/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jfinal.json.FastJson;
import com.jfinal.json.JFinalJson;
import com.jfinal.json.Json;
import com.jfinal.plugin.activerecord.CPI;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.weixin.sdk.utils.ClassUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class JsonUtils {
    private static final Json json;

    private JsonUtils() {
    }

    public static String toJson(Model<? extends Model<?>> model) {
        return JsonUtils.toJson(CPI.getAttrs(model));
    }

    public static String toJson(Collection<Model<? extends Model<?>>> models) {
        ArrayList<Map> list = new ArrayList<Map>();
        for (Model<Model<?>> model : models) {
            list.add(CPI.getAttrs(model));
        }
        return JsonUtils.toJson(list);
    }

    public static String toJson(Record record) {
        return JsonUtils.toJson(record.getColumns());
    }

    public static String toJson(List<Record> records) {
        ArrayList<Map> list = new ArrayList<Map>();
        for (Record record : records) {
            list.add(record.getColumns());
        }
        return JsonUtils.toJson(list);
    }

    public static String toJson(Object object) {
        if (json == null) {
            throw new RuntimeException("Jackson, Fastjson or JFinalJson not supported");
        }
        return json.toJson(object);
    }

    public static <T> T parse(String jsonString, Class<T> valueType) {
        if (json == null) {
            throw new RuntimeException("Jackson, Fastjson not supported");
        }
        return (T)json.parse(jsonString, valueType);
    }

    static {
        Object jsonToUse = null;
        jsonToUse = ClassUtils.isPresent("com.fasterxml.jackson.databind.ObjectMapper", JsonUtils.class.getClassLoader()) ? new Jackson() : (ClassUtils.isPresent("com.alibaba.fastjson.JSONObject", JsonUtils.class.getClassLoader()) ? new FastJson() : new JFinalJson());
        json = jsonToUse;
    }

    private static class Jackson
    extends Json {
        private final ObjectMapper objectMapper = new ObjectMapper();

        public Jackson() {
            this.objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
            this.objectMapper.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
        }

        public String toJson(Object object) {
            try {
                return this.objectMapper.writeValueAsString(object);
            }
            catch (Exception e) {
                throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
            }
        }

        public <T> T parse(String jsonString, Class<T> type) {
            try {
                return (T)this.objectMapper.readValue(jsonString, type);
            }
            catch (Exception e) {
                throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
            }
        }
    }
}

