/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.eventbus.configuration;

import com.nepxion.eventbus.aop.EventBeanPostProcessor;
import com.nepxion.eventbus.context.EventContextClosedHandler;
import com.nepxion.eventbus.core.EventControllerFactory;
import com.nepxion.eventbus.thread.ThreadPoolFactory;
import com.nepxion.eventbus.thread.entity.ThreadCustomization;
import com.nepxion.eventbus.thread.entity.ThreadParameter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class EventAutoConfiguration {
    @Value(value="${threadpool.multi.mode:false}")
    private boolean threadPoolMultiMode;
    @Value(value="${threadpool.shared.name:EventBus}")
    private String threadPoolSharedName;
    @Value(value="${threadpool.name.customized:true}")
    private boolean threadPoolNameCustomized;
    @Value(value="${threadpool.name.ipshown:true}")
    private boolean threadPoolNameIPShown;
    @Value(value="${threadpool.core.pool.size:4}")
    private int threadPoolCorePoolSize;
    @Value(value="${threadpool.maximum.pool.size:8}")
    private int threadPoolMaximumPoolSize;
    @Value(value="${threadpool.keep.alive.time:900000}")
    private long threadPoolKeepAliveTime;
    @Value(value="${threadpool.allow.core.thread.timeout:false}")
    private boolean threadPoolAllowCoreThreadTimeout;
    @Value(value="${threadpool.queue:LinkedBlockingQueue}")
    private String threadPoolQueue;
    @Value(value="${threadpool.queue.capacity:1024}")
    private int threadPoolQueueCapacity;
    @Value(value="${threadpool.rejected.policy:BlockingPolicyWithReport}")
    private String threadPoolRejectedPolicy;

    @Bean
    public ThreadPoolFactory threadPoolFactory() {
        ThreadCustomization threadCustomization = new ThreadCustomization();
        threadCustomization.setThreadPoolMultiMode(this.threadPoolMultiMode);
        threadCustomization.setThreadPoolSharedName(this.threadPoolSharedName);
        threadCustomization.setThreadPoolNameCustomized(this.threadPoolNameCustomized);
        threadCustomization.setThreadPoolNameIPShown(this.threadPoolNameIPShown);
        ThreadParameter threadParameter = new ThreadParameter();
        threadParameter.setThreadPoolCorePoolSize(this.threadPoolCorePoolSize);
        threadParameter.setThreadPoolMaximumPoolSize(this.threadPoolMaximumPoolSize);
        threadParameter.setThreadPoolKeepAliveTime(this.threadPoolKeepAliveTime);
        threadParameter.setThreadPoolAllowCoreThreadTimeout(this.threadPoolAllowCoreThreadTimeout);
        threadParameter.setThreadPoolQueue(this.threadPoolQueue);
        threadParameter.setThreadPoolQueueCapacity(this.threadPoolQueueCapacity);
        threadParameter.setThreadPoolRejectedPolicy(this.threadPoolRejectedPolicy);
        return new ThreadPoolFactory(threadCustomization, threadParameter);
    }

    @Bean
    public EventControllerFactory eventControllerFactory() {
        return new EventControllerFactory();
    }

    @Bean
    public EventBeanPostProcessor eventBeanPostProcessor() {
        return new EventBeanPostProcessor();
    }

    @Bean
    public EventContextClosedHandler eventContextClosedHandler() {
        return new EventContextClosedHandler();
    }

    static {
        System.out.println("");
        System.out.println("\u2554\u2550\u2550\u2550\u2557        \u2554\u2557\u2554\u2550\u2550\u2557");
        System.out.println("\u2551\u2554\u2550\u2550\u255d       \u2554\u255d\u255a\u2563\u2554\u2557\u2551");
        System.out.println("\u2551\u255a\u2550\u2550\u2566\u2557\u2554\u2566\u2550\u2550\u2566\u2550\u256c\u2557\u2554\u2563\u255a\u255d\u255a\u2566\u2557\u2554\u2566\u2550\u2550\u2557");
        System.out.println("\u2551\u2554\u2550\u2550\u2563\u255a\u255d\u2551\u2551\u2550\u2563\u2554\u2557\u2563\u2551\u2551\u2554\u2550\u2557\u2551\u2551\u2551\u2551\u2550\u2550\u2563");
        System.out.println("\u2551\u255a\u2550\u2550\u256c\u2557\u2554\u2563\u2551\u2550\u2563\u2551\u2551\u2551\u255a\u2563\u255a\u2550\u255d\u2551\u255a\u255d\u2560\u2550\u2550\u2551");
        System.out.println("\u255a\u2550\u2550\u2550\u255d\u255a\u255d\u255a\u2550\u2550\u2569\u255d\u255a\u2569\u2550\u2569\u2550\u2550\u2550\u2569\u2550\u2550\u2569\u2550\u2550\u255d");
        System.out.println("Nepxion EventBus  v2.0.2");
        System.out.println("");
    }
}

