/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.model;

import com.google.common.net.UrlEscapers;
import com.offbytwo.jenkins.model.BaseModel;
import com.offbytwo.jenkins.model.ComputerWithDetails;
import java.io.IOException;
import java.util.List;

public class Computer
extends BaseModel {
    private String displayName;
    List<Computer> computer;

    public List<Computer> getComputers() {
        return this.computer;
    }

    public void setComputer(List<Computer> computer) {
        this.computer = computer;
    }

    public Computer() {
    }

    public Computer(String displayName) {
        this();
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ComputerWithDetails details() throws IOException {
        String name = "master".equals(this.displayName) ? "(master)" : UrlEscapers.urlPathSegmentEscaper().escape(this.displayName);
        ComputerWithDetails computerWithDetails = this.client.get("/computer/" + name + "/?depth=2", ComputerWithDetails.class);
        computerWithDetails.setClient(this.client);
        return computerWithDetails;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Computer other = (Computer)obj;
        if (this.computer == null ? other.computer != null : !this.computer.equals(other.computer)) {
            return false;
        }
        return !(this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.computer == null ? 0 : this.computer.hashCode());
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        return result;
    }
}

