/*
 * Decompiled with CFR 0.152.
 */
package com.ofcard.component.cache;

import com.google.code.yanf4j.core.impl.StandardSocketOption;
import com.ofcard.component.cache.exception.OFCacheException;
import com.ofcard.component.configuration.ConstantsPropertyUtil;
import java.io.IOException;
import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.MemcachedSessionLocator;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.command.BinaryCommandFactory;
import net.rubyeye.xmemcached.impl.KetamaMemcachedSessionLocator;
import net.rubyeye.xmemcached.impl.MemcachedConnector;
import net.rubyeye.xmemcached.networking.MemcachedSession;
import net.rubyeye.xmemcached.utils.AddrUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcachedUtil {
    private static Logger logger = LoggerFactory.getLogger(MemcachedUtil.class);
    private static MemcachedClient memcachedClient;
    public static int DEFALUT_EXPIRETIME;
    public static int DEFALUT_TIMEOUT;
    public static boolean DEFALUT_HAS_PRE;
    public static String PROJECT_NAME;

    public static MemcachedClient getMemcachedClient() throws OFCacheException {
        if (memcachedClient == null) {
            MemcachedUtil.buildClient();
        }
        return memcachedClient;
    }

    public static boolean set(String key, Object value) throws OFCacheException {
        return MemcachedUtil.set(key, value, DEFALUT_EXPIRETIME, DEFALUT_HAS_PRE);
    }

    public static boolean set(String key, Object value, boolean hasPre) throws OFCacheException {
        return MemcachedUtil.set(key, value, DEFALUT_EXPIRETIME, hasPre);
    }

    public static boolean set(String key, Object value, int expireTime) throws OFCacheException {
        return MemcachedUtil.set(key, value, expireTime, DEFALUT_HAS_PRE);
    }

    public static boolean set(String key, Object value, int expireTime, boolean hasPre) throws OFCacheException {
        try {
            if (value != null) {
                return MemcachedUtil.getMemcachedClient().set(MemcachedUtil.getKey(key, hasPre), expireTime, value, (long)DEFALUT_TIMEOUT);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            throw new OFCacheException(e.getMessage());
        }
        return false;
    }

    public static <T> T get(String key) throws OFCacheException {
        return MemcachedUtil.get(key, DEFALUT_TIMEOUT, DEFALUT_HAS_PRE);
    }

    public static <T> T get(String key, boolean hasPre) throws OFCacheException {
        return MemcachedUtil.get(key, DEFALUT_TIMEOUT, hasPre);
    }

    public static <T> T get(String key, int timeout) throws OFCacheException {
        return MemcachedUtil.get(key, timeout, DEFALUT_HAS_PRE);
    }

    public static <T> T get(String key, int timeout, boolean hasPre) throws OFCacheException {
        try {
            MemcachedSession ms = (MemcachedSession)((MemcachedConnector)MemcachedUtil.getMemcachedClient().getConnector()).findSessionByKey(key);
            return (T)MemcachedUtil.getMemcachedClient().get(MemcachedUtil.getKey(key, hasPre), (long)timeout);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new OFCacheException(e.getMessage());
        }
    }

    public static boolean delete(String key) throws OFCacheException {
        return MemcachedUtil.delete(key, DEFALUT_TIMEOUT, DEFALUT_HAS_PRE);
    }

    public static boolean delete(String key, boolean hasPre) throws OFCacheException {
        return MemcachedUtil.delete(key, DEFALUT_TIMEOUT, hasPre);
    }

    public static boolean delete(String key, int timeout) throws OFCacheException {
        return MemcachedUtil.delete(key, timeout, DEFALUT_HAS_PRE);
    }

    public static boolean delete(String key, int timeout, boolean hasPre) throws OFCacheException {
        try {
            return MemcachedUtil.getMemcachedClient().delete(MemcachedUtil.getKey(key, hasPre), (long)timeout);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new OFCacheException(e.getMessage());
        }
    }

    private static String getKey(String myKey, boolean hasPre) {
        if (hasPre) {
            return PROJECT_NAME + myKey;
        }
        return myKey;
    }

    public static synchronized void buildClient() throws OFCacheException {
        if (memcachedClient == null || memcachedClient.isShutdown()) {
            XMemcachedClientBuilder builder = new XMemcachedClientBuilder(AddrUtil.getAddresses((String)ConstantsPropertyUtil.getConstantsValue("memcached.server.addresses")));
            builder.setConnectionPoolSize(ConstantsPropertyUtil.getConstantsConfig().getInt("memcached.server.poolSize"));
            builder.setCommandFactory((CommandFactory)new BinaryCommandFactory());
            builder.setSocketOption(StandardSocketOption.TCP_NODELAY, (Object)false);
            builder.setSessionLocator((MemcachedSessionLocator)new KetamaMemcachedSessionLocator());
            builder.getTranscoder().setCompressionThreshold(1024);
            String projectName = ConstantsPropertyUtil.getConstantsConfig().getString("project.name");
            if (StringUtils.isNotBlank((String)projectName)) {
                PROJECT_NAME = projectName;
            }
            System.out.println("buildClient:  " + builder + " poolSzie:" + ConstantsPropertyUtil.getConstantsConfig().getInt("memcached.server.poolSize") + "   addresses:" + ConstantsPropertyUtil.getConstantsValue("memcached.server.addresses") + "   projectName:" + PROJECT_NAME);
            try {
                memcachedClient = builder.build();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new OFCacheException(e.getMessage());
            }
        }
    }

    public static void closeClient() {
        if (memcachedClient != null && !memcachedClient.isShutdown()) {
            try {
                memcachedClient.shutdown();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    static {
        DEFALUT_EXPIRETIME = 0;
        DEFALUT_TIMEOUT = 2000;
        DEFALUT_HAS_PRE = true;
        PROJECT_NAME = "";
        try {
            memcachedClient = MemcachedUtil.getMemcachedClient();
        }
        catch (OFCacheException e) {
            e.printStackTrace();
            logger.error("memcache \u521d\u59cb\u5316\u5931\u8d25\uff0c\u539f\u56e0\u662f:" + e.getMessage());
        }
    }
}

