/*
 * Decompiled with CFR 0.152.
 */
package com.ofcard.component.cache;

import com.ofcard.component.cache.exception.OFCacheException;
import com.ofcard.component.configuration.ConstantsPropertyUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisUtil {
    private static Logger logger = LoggerFactory.getLogger(RedisUtil.class);
    private static JedisPool jp = null;
    public static String OK = "OK";
    private static RedisUtil redisUtil = new RedisUtil();
    private static int DEFAULT_TIMEOUT = 3000;
    private static int DEFAULT_MAXACTIVE = 100;
    private static int DEFAULT_MAXIDLE = 30;
    private static int DEFAULT_MINIDLE = 1;
    private static long DEFAULT_MAXWAITTIME = 5000L;
    private static int DEFAULT_DBINDEX = 0;
    private static boolean DEFAULT_TESTONRETURN = true;
    private static boolean DEFAULT_TESTONBORROW = false;
    private static boolean DEFAULT_TESTWHILEIDLE = true;
    private static int DEFAULT_NUMTESTSPEREVICTIONRUN = -1;
    private static int DEFAULT_MINEVICTABLEIDLETIMEMILLIS = 60000;
    private static int DEFAULT_TIMEBETWEENEVICTIONRUNSMILLIS = 30000;
    private static String REDIS_POOL_MAXACTIVE = "redis.pool.maxActive";
    private static String REDIS_POOL_MAXIDLE = "redis.pool.maxIdle";
    private static String REDIS_POOL_MAXWAITTIME = "redis.pool.maxWaitTime";
    private static String REDIS_POOL_TIMEOUT = "redis.pool.timeout";
    private static String REDIS_HOST = "redis.host";
    private static String REDIS_PORT = "redis.port";
    private static String REDIS_DBINDEX = "redis.dbIndex";
    private static String REDIS_AUTH = "redis.auth";

    public static Jedis getJedisClient() {
        String host = ConstantsPropertyUtil.getConstantsValue(REDIS_HOST);
        int port = Integer.valueOf(ConstantsPropertyUtil.getConstantsValue(REDIS_PORT));
        String auth = "";
        int dbindex = 0;
        System.out.println("host:" + host);
        if (ConstantsPropertyUtil.getConstantsValue(REDIS_AUTH) != null && !ConstantsPropertyUtil.getConstantsValue(REDIS_AUTH).equals("")) {
            auth = ConstantsPropertyUtil.getConstantsValue(REDIS_AUTH);
        }
        if (ConstantsPropertyUtil.getConstantsValue(REDIS_DBINDEX) != null) {
            dbindex = Integer.valueOf(ConstantsPropertyUtil.getConstantsValue(REDIS_DBINDEX));
        }
        Jedis jedis = new Jedis(host, port);
        jedis.select(dbindex);
        return jedis;
    }

    public static boolean existsKey(String key) {
        boolean r = false;
        Jedis jd = null;
        try {
            jd = RedisUtil.getRedisClient();
            r = jd.exists(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OFCacheException("Redis error:" + e.getMessage());
        }
        finally {
            RedisUtil.release(jd);
        }
        return r;
    }

    public static boolean del(String key) {
        long r = 0L;
        Jedis jd = null;
        try {
            jd = RedisUtil.getRedisClient();
            r = jd.del(new String[]{key});
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OFCacheException("Redis error:" + e.getMessage());
        }
        finally {
            RedisUtil.release(jd);
        }
        return 0L != r;
    }

    public static boolean set(String key, String value) {
        return RedisUtil.set(key, value, -1);
    }

    public static boolean set(String key, String value, int timeout) {
        String r = "";
        Jedis jd = null;
        try {
            jd = RedisUtil.getRedisClient();
            r = jd.set(key, value);
            if (timeout != -1) {
                RedisUtil.getRedisClient().expire(key, timeout);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OFCacheException("set \u5931\u8d25\uff0c\u539f\u56e0\u662f:" + e.getMessage());
        }
        finally {
            RedisUtil.release(jd);
        }
        return OK.equals(r);
    }

    public static String get(String key) {
        String s = null;
        Jedis jd = null;
        try {
            jd = RedisUtil.getRedisClient();
            s = jd.get(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OFCacheException("get \u5931\u8d25\uff0c\u539f\u56e0\u662f:" + e.getMessage());
        }
        finally {
            RedisUtil.release(jd);
        }
        return s;
    }

    public static JedisPool getJedisPool() {
        if (jp == null) {
            JedisPoolConfig config = new JedisPoolConfig();
            int maxActive = DEFAULT_MAXACTIVE;
            int maxidle = DEFAULT_MAXIDLE;
            long maxwaittime = DEFAULT_MAXWAITTIME;
            int timeout = DEFAULT_TIMEOUT;
            int dbindex = DEFAULT_DBINDEX;
            String auth = null;
            if (ConstantsPropertyUtil.getConstantsValue(REDIS_POOL_MAXACTIVE) != null) {
                maxActive = Integer.valueOf(ConstantsPropertyUtil.getConstantsValue(REDIS_POOL_MAXACTIVE));
            }
            if (ConstantsPropertyUtil.getConstantsValue(REDIS_POOL_MAXIDLE) != null) {
                maxidle = Integer.valueOf(ConstantsPropertyUtil.getConstantsValue(REDIS_POOL_MAXIDLE));
            }
            if (ConstantsPropertyUtil.getConstantsValue(REDIS_POOL_MAXWAITTIME) != null) {
                maxwaittime = Long.valueOf(ConstantsPropertyUtil.getConstantsValue(REDIS_POOL_MAXWAITTIME));
            }
            if (ConstantsPropertyUtil.getConstantsValue(REDIS_POOL_TIMEOUT) != null) {
                timeout = Integer.valueOf(ConstantsPropertyUtil.getConstantsValue(REDIS_POOL_TIMEOUT));
            }
            String host = ConstantsPropertyUtil.getConstantsValue(REDIS_HOST);
            int port = Integer.valueOf(ConstantsPropertyUtil.getConstantsValue(REDIS_PORT));
            if (ConstantsPropertyUtil.getConstantsValue(REDIS_AUTH) != null && !ConstantsPropertyUtil.getConstantsValue(REDIS_AUTH).equals("")) {
                auth = ConstantsPropertyUtil.getConstantsValue(REDIS_AUTH);
            }
            if (ConstantsPropertyUtil.getConstantsValue(REDIS_DBINDEX) != null) {
                dbindex = Integer.valueOf(ConstantsPropertyUtil.getConstantsValue(REDIS_DBINDEX));
            }
            config.setMaxActive(maxActive);
            config.setMaxIdle(maxidle);
            config.setMinIdle(DEFAULT_MINIDLE);
            config.setMaxWait(maxwaittime);
            config.setTestOnReturn(DEFAULT_TESTONRETURN);
            config.setTestOnBorrow(DEFAULT_TESTONBORROW);
            config.setTestWhileIdle(DEFAULT_TESTWHILEIDLE);
            config.setNumTestsPerEvictionRun(DEFAULT_NUMTESTSPEREVICTIONRUN);
            config.setMinEvictableIdleTimeMillis((long)DEFAULT_MINEVICTABLEIDLETIMEMILLIS);
            config.setTimeBetweenEvictionRunsMillis((long)DEFAULT_TIMEBETWEENEVICTIONRUNSMILLIS);
            logger.info("JedisPool init ... maxActive:" + maxActive + "  maxidle:" + maxidle + "  maxwaittime:" + maxwaittime);
            System.out.println("JedisPool init ...host:" + host + "  port:" + port + "  maxActive:" + maxActive + "  maxidle:" + maxidle + "  maxwaittime:" + maxwaittime + "  timeout:" + timeout);
            jp = new JedisPool((GenericObjectPool.Config)config, host, port, timeout, auth);
            logger.info("JedisPool init success\uff01\uff01\uff01");
        }
        return jp;
    }

    public static void jedisPoolReset() {
        try {
            if (jp != null) {
                jp.destroy();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u91cd\u7f6ejedis\u8fde\u63a5\u6c60\u51fa\u9519\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage());
        }
        RedisUtil.getJedisPool();
    }

    public static void destroy() {
        try {
            if (jp != null) {
                jp.destroy();
                logger.info("redis pool destroy!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Jedis getRedisClient() {
        return (Jedis)RedisUtil.getJedisPool().getResource();
    }

    public static long getStackSize(String key) {
        long r = 0L;
        Jedis jd = null;
        try {
            jd = RedisUtil.getRedisClient();
            r = jd.llen(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("getStackSize \u51fa\u9519\uff0c\u539f\u56e0\u662f:" + e.getMessage());
            throw new OFCacheException("getStackSize \u5931\u8d25\uff0c\u539f\u56e0\u662f:" + e.getMessage());
        }
        finally {
            RedisUtil.release(jd);
        }
        return r;
    }

    public static boolean pushStack(String key, String value) {
        Jedis jd = null;
        long r = 0L;
        try {
            jd = RedisUtil.getRedisClient();
            r = jd.lpush(key, new String[]{value});
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("push \u51fa\u9519\uff0c\u539f\u56e0\u662f:" + e.getMessage());
            throw new OFCacheException("push \u5931\u8d25\uff0c\u539f\u56e0\u662f:" + e.getMessage());
        }
        finally {
            RedisUtil.release(jd);
        }
        return r > 0L;
    }

    public static String popStack(String key) {
        String s = null;
        Jedis jd = null;
        try {
            jd = RedisUtil.getRedisClient();
            s = jd.rpop(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("pop \u51fa\u9519\uff0c\u539f\u56e0\u662f:" + e.getMessage());
            throw new OFCacheException("pop \u5931\u8d25\uff0c\u539f\u56e0\u662f:" + e.getMessage());
        }
        finally {
            RedisUtil.release(jd);
        }
        return s;
    }

    public static void setMap(String key, Map<String, String> map) {
        RedisUtil.setMap(key, map, -1);
    }

    public static void setMap(String key, Map<String, String> map, int timeout) {
        Jedis jd = null;
        try {
            if (map != null && !map.isEmpty()) {
                jd = RedisUtil.getRedisClient();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    jd.hset(key, entry.getKey(), entry.getValue());
                }
                if (timeout != -1) {
                    jd.expire(key, timeout);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("setMap\u51fa\u9519\uff0c\u539f\u56e0\u662f:" + e.getMessage());
            throw new OFCacheException("\u5199\u5165\u5931\u8d25\uff0c\u539f\u56e0\u662f:" + e.getMessage());
        }
        finally {
            RedisUtil.release(jd);
        }
    }

    public static Map<String, String> getMap(String key) {
        HashMap<String, String> map = new HashMap();
        Jedis jd = null;
        try {
            jd = RedisUtil.getRedisClient();
            map = jd.hgetAll(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("getMap\u51fa\u9519\uff0c\u539f\u56e0\u662f:" + e.getMessage());
            throw new OFCacheException("getMap\u5931\u8d25\uff0c\u539f\u56e0\u662f:" + e.getMessage());
        }
        finally {
            RedisUtil.release(jd);
        }
        return map;
    }

    public static boolean containsKeyInMap(String key, String keyInMap) {
        boolean r = false;
        Jedis jd = null;
        try {
            jd = RedisUtil.getRedisClient();
            r = jd.hexists(key, keyInMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("containsKeyInMap\u51fa\u9519\uff0c\u539f\u56e0\u662f:" + e.getMessage());
            throw new OFCacheException("containsKeyInMap\u5931\u8d25\uff0c\u539f\u56e0\u662f:" + e.getMessage());
        }
        finally {
            RedisUtil.release(jd);
        }
        return r;
    }

    public static Set<String> getKeysInMap(String key) {
        Jedis jd = null;
        HashSet<String> keySet = new HashSet();
        try {
            jd = RedisUtil.getRedisClient();
            keySet = jd.hkeys(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("getKeysInMap\u51fa\u9519\uff0c\u539f\u56e0\u662f:" + e.getMessage());
            throw new OFCacheException("getKeysInMap\u5931\u8d25\uff0c\u539f\u56e0\u662f:" + e.getMessage());
        }
        finally {
            RedisUtil.release(jd);
        }
        return keySet;
    }

    public static Set<String> delkeyInMap(String key) {
        Jedis jd = null;
        HashSet<String> keySet = new HashSet();
        try {
            jd = RedisUtil.getRedisClient();
            keySet = jd.hkeys(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("delkeyInMap\u51fa\u9519\uff0c\u539f\u56e0\u662f:" + e.getMessage());
            throw new OFCacheException("delkeyInMap\u5931\u8d25\uff0c\u539f\u56e0\u662f:" + e.getMessage());
        }
        finally {
            RedisUtil.release(jd);
        }
        return keySet;
    }

    public static void release(Jedis jd) {
        try {
            if (jp != null && jd != null) {
                jp.returnResource((Object)jd);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void destroy(Jedis jd) {
        try {
            if (jp != null && jd != null) {
                jd.select(0);
                jp.returnBrokenResource((Object)jd);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void sAdd(String key, Set<String> set) {
        RedisUtil.sAdd(key, set, -1);
    }

    public static void sAdd(String key, String value) {
        RedisUtil.sAdd(key, value, -1);
    }

    public static void sAdd(String key, String ... values) {
        RedisUtil.sAdd(key, -1, values);
    }

    public static void sAdd(String key, int timeout, String ... values) {
        Jedis jd = null;
        try {
            jd = RedisUtil.getRedisClient();
            for (String value : values) {
                jd.sadd(key, new String[]{value});
            }
            if (timeout != -1) {
                jd.expire(key, timeout);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("sAdd\u51fa\u9519\uff0c\u539f\u56e0\u662f:" + e.getMessage());
            throw new OFCacheException("sAdd\u5931\u8d25\uff0c\u539f\u56e0\u662f:" + e.getMessage());
        }
        finally {
            RedisUtil.release(jd);
        }
    }

    public static void sAdd(String key, Set<String> set, int timeout) {
        Jedis jd = null;
        try {
            if (set != null && !set.isEmpty()) {
                jd = RedisUtil.getRedisClient();
                for (String value : set) {
                    jd.sadd(key, new String[]{value});
                }
                if (timeout != -1) {
                    jd.expire(key, timeout);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("sAdd\u51fa\u9519\uff0c\u539f\u56e0\u662f:" + e.getMessage());
            throw new OFCacheException("sAdd\u5931\u8d25\uff0c\u539f\u56e0\u662f:" + e.getMessage());
        }
        finally {
            RedisUtil.release(jd);
        }
    }

    public static void sAdd(String key, String value, int timeout) {
        Jedis jd = null;
        try {
            jd = RedisUtil.getRedisClient();
            jd.sadd(key, new String[]{value});
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("sAdd\u51fa\u9519\uff0c\u539f\u56e0\u662f:" + e.getMessage());
            throw new OFCacheException("sAdd\u5931\u8d25\uff0c\u539f\u56e0\u662f:" + e.getMessage());
        }
        finally {
            RedisUtil.release(jd);
        }
    }

    public static Set<String> sMembers(String key) {
        HashSet<String> set = new HashSet();
        Jedis jd = null;
        try {
            jd = RedisUtil.getRedisClient();
            set = jd.smembers(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("sMembers\u51fa\u9519\uff0c\u539f\u56e0\u662f:" + e.getMessage());
            throw new OFCacheException("sMembers\u5931\u8d25\uff0c\u539f\u56e0\u662f:" + e.getMessage());
        }
        finally {
            RedisUtil.release(jd);
        }
        return set;
    }

    public static boolean sRem(String key, String value) {
        boolean b = false;
        Jedis jd = null;
        try {
            jd = RedisUtil.getRedisClient();
            jd.srem(key, new String[]{value});
            b = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("sRem\u51fa\u9519\uff0c\u539f\u56e0\u662f:" + e.getMessage());
            throw new OFCacheException("sRem\u5931\u8d25\uff0c\u539f\u56e0\u662f:" + e.getMessage());
        }
        finally {
            RedisUtil.release(jd);
        }
        return b;
    }

    public static boolean sIsMember(String key, String value) {
        boolean b = false;
        Jedis jd = null;
        try {
            jd = RedisUtil.getRedisClient();
            b = jd.sismember(key, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("sIsMember\u51fa\u9519\uff0c\u539f\u56e0\u662f:" + e.getMessage());
            throw new OFCacheException("sIsMember\u5931\u8d25\uff0c\u539f\u56e0\u662f:" + e.getMessage());
        }
        finally {
            RedisUtil.release(jd);
        }
        return b;
    }

    public void closeJedisPool() {
        if (jp != null) {
            try {
                jp.destroy();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    static {
        jp = RedisUtil.getJedisPool();
    }
}

