/*
 * Decompiled with CFR 0.152.
 */
package com.ofcard.component.configuration;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstantsPropertyUtil {
    private static Logger logger = LoggerFactory.getLogger(ConstantsPropertyUtil.class);
    private static Map<String, PropertiesConfiguration> configurationMap = new HashMap<String, PropertiesConfiguration>();
    private static Map<String, String> badAddressMap = new HashMap<String, String>();
    private static PropertiesConfiguration config = null;
    private static String PROPERTIES_FILE = "constants.properties";
    private static String TEST_PROPERTIES_FILE = "test-constants.properties";
    private static String DEV_PROPERTIES_FILE = "dev-constants.properties";
    private static String PROPERTIES_KEY = "propPath";

    public static synchronized PropertiesConfiguration getConfig(String resourcePathInClasses) {
        PropertiesConfiguration cp = null;
        if (!configurationMap.containsKey(resourcePathInClasses)) {
            try {
                cp = new PropertiesConfiguration(resourcePathInClasses);
            }
            catch (ConfigurationException e) {
                logger.error(e.getMessage(), (Throwable)e);
                try {
                    cp = new PropertiesConfiguration(ConstantsPropertyUtil.class.getClassLoader().getResource("").getPath() + resourcePathInClasses);
                }
                catch (ConfigurationException e1) {
                    e1.printStackTrace();
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (cp != null) {
                configurationMap.put(resourcePathInClasses, cp);
            } else {
                badAddressMap.put(resourcePathInClasses, resourcePathInClasses);
            }
        }
        return configurationMap.get(resourcePathInClasses);
    }

    public static synchronized PropertiesConfiguration getConstantsConfig() {
        String propPath = System.getProperty(PROPERTIES_KEY);
        if (!badAddressMap.containsKey(propPath) && propPath != null && !"".equals(propPath) && (config = ConstantsPropertyUtil.getConfig(propPath)) != null) {
            logger.info("loading  properties file success !!! filename:===" + propPath + "===");
        }
        if (config == null && !badAddressMap.containsKey(DEV_PROPERTIES_FILE) && (config = ConstantsPropertyUtil.getConfig(DEV_PROPERTIES_FILE)) != null) {
            logger.info("loading  properties file success !!! filename:===" + DEV_PROPERTIES_FILE + "===");
        }
        if (config == null && !badAddressMap.containsKey(TEST_PROPERTIES_FILE) && (config = ConstantsPropertyUtil.getConfig(TEST_PROPERTIES_FILE)) != null) {
            logger.info("loading  properties file success !!! filename:===" + TEST_PROPERTIES_FILE + "===");
        }
        if (config == null && !badAddressMap.containsKey(PROPERTIES_FILE) && (config = ConstantsPropertyUtil.getConfig(PROPERTIES_FILE)) != null) {
            logger.info("loading  properties file success !!! filename:===" + PROPERTIES_FILE + "===");
            System.out.println("loading  properties file success !!! filename:===" + PROPERTIES_FILE + "===");
        }
        if (config == null) {
            throw new RuntimeException("properties file not found\uff01");
        }
        return config;
    }

    public static String getConstantsValue(String definedKey) {
        if (config == null) {
            config = ConstantsPropertyUtil.getConstantsConfig();
        }
        System.out.println("config:" + config);
        return config.getString(definedKey);
    }

    static {
        config = ConstantsPropertyUtil.getConstantsConfig();
    }
}

