/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.util;

import java.security.SignatureException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class GenerateMac {
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private static String[] hexmap = new String[256];

    public static String get_hex(byte byt) {
        return hexmap[(short)(byt & 0xFF)];
    }

    public static String calculateRFC2104HMAC(String data, String key) throws SignatureException {
        StringBuilder hexMAC = new StringBuilder();
        try {
            byte[] keyBytes = key.getBytes();
            SecretKeySpec signingKey = new SecretKeySpec(keyBytes, HMAC_SHA1_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(data.getBytes());
            for (int i = 0; i < rawHmac.length; ++i) {
                hexMAC.append(GenerateMac.get_hex(rawHmac[i]));
            }
        }
        catch (Exception e) {
            throw new SignatureException("Failed to generate HMAC : " + e.getMessage());
        }
        return hexMAC.toString();
    }

    static {
        GenerateMac.hexmap[0] = "00";
        GenerateMac.hexmap[1] = "01";
        GenerateMac.hexmap[2] = "02";
        GenerateMac.hexmap[3] = "03";
        GenerateMac.hexmap[4] = "04";
        GenerateMac.hexmap[5] = "05";
        GenerateMac.hexmap[6] = "06";
        GenerateMac.hexmap[7] = "07";
        GenerateMac.hexmap[8] = "08";
        GenerateMac.hexmap[9] = "09";
        GenerateMac.hexmap[10] = "0a";
        GenerateMac.hexmap[11] = "0b";
        GenerateMac.hexmap[12] = "0c";
        GenerateMac.hexmap[13] = "0d";
        GenerateMac.hexmap[14] = "0e";
        GenerateMac.hexmap[15] = "0f";
        for (int i = 16; i < 256; ++i) {
            GenerateMac.hexmap[i] = Integer.toHexString(i);
        }
    }
}

