/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.activiti.controller;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.act.domain.PageData;
import com.qjsoft.laser.controller.facade.act.repository.ActModelServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/act/model"}, name="\u5de5\u4f5c\u6d41\u6a21\u578b\u670d\u52a1")
public class ModelCon
extends SpringmvcController {
    private static String CODE = "act.model.con";
    @Autowired
    private ActModelServiceRepository actModelServiceRepository;

    protected String getContext() {
        return "model";
    }

    @RequestMapping(value={"getXmlFromModelId.json"}, name="\u9884\u89c8xml")
    @ResponseBody
    public HtmlJsonReBean getXmlFromModelId(String modelId) {
        if (StringUtils.isBlank((String)modelId)) {
            this.logger.error(CODE + ".getXmlFromModelId", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.actModelServiceRepository.getXmlFromModelId(modelId);
    }

    @RequestMapping(value={"saveModel.json"}, name="\u4fdd\u5b58\u6d41\u7a0b\u8bbe\u8ba1\u5668")
    @ResponseBody
    public HtmlJsonReBean saveModel(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        HashMap<String, String> map = new HashMap<String, String>();
        if (null == param) {
            this.logger.error(CODE + ".getXmlFromModelId", (Object)"modelId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String modelId = (String)param.get("modelId");
        String name = (String)param.get("name");
        String description = (String)param.get("description");
        String json_xml = (String)param.get("json_xml");
        String svg_xml = (String)param.get("svg_xml");
        if (StringUtils.isBlank((String)modelId)) {
            this.logger.error(CODE + ".getXmlFromModelId", (Object)"modelId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (StringUtils.isBlank((String)name)) {
            this.logger.error(CODE + ".getXmlFromModelId", (Object)"name is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (StringUtils.isBlank((String)description)) {
            this.logger.error(CODE + ".getXmlFromModelId", (Object)"description is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (StringUtils.isBlank((String)json_xml)) {
            this.logger.error(CODE + ".getXmlFromModelId", (Object)"json_xml is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (StringUtils.isBlank((String)svg_xml)) {
            this.logger.error(CODE + ".getXmlFromModelId", (Object)"svg_xml is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        map.put("name", name);
        map.put("description", description);
        map.put("json_xml", json_xml);
        map.put("svg_xml", svg_xml);
        return this.actModelServiceRepository.saveModel(modelId, map);
    }

    @RequestMapping(value={"isCanexportXml.json"}, name="\u5224\u65ad\u80fd\u5426\u6b63\u5e38\u6839\u636e\u6a21\u578bID\u5bfc\u51faxml\u6587\u4ef6")
    @ResponseBody
    public Boolean isCanexportXml(String modelId) {
        if (StringUtils.isBlank((String)modelId)) {
            this.logger.error(CODE + ".isCanexportXml", (Object)"param is null");
        }
        return this.actModelServiceRepository.isCanexportXml(modelId);
    }

    @RequestMapping(value={"saveDeployment.json"}, name="\u90e8\u7f72\u6d41\u7a0b\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean saveDeployment(String modelId) {
        if (StringUtils.isBlank((String)modelId)) {
            this.logger.error(CODE + ".saveDeployment", (Object)"param is null");
        }
        return this.actModelServiceRepository.saveDeployment(modelId);
    }

    @RequestMapping(value={"getEditorJson.json"}, name="\u83b7\u53d6\u6d41\u7a0b\u8bbe\u8ba1\u5668\u4fe1\u606f")
    @ResponseBody
    public ObjectNode getEditorJson(String modelId) {
        if (StringUtils.isBlank((String)modelId)) {
            this.logger.error(CODE + ".getEditorJson", (Object)"param is null");
        }
        return this.actModelServiceRepository.getEditorJson(modelId);
    }

    @RequestMapping(value={"deleteModel.json"}, name="\u5220\u9664\u6a21\u578b")
    @ResponseBody
    public HtmlJsonReBean deleteModel(String modelId) {
        if (StringUtils.isBlank((String)modelId)) {
            this.logger.error(CODE + ".deleteModel", (Object)"param is null");
        }
        return this.actModelServiceRepository.deleteModel(modelId);
    }

    @RequestMapping(value={"saveModelForm.json"}, name="\u6dfb\u52a0\u6d41\u7a0b\u6a21\u578b\u5e76\u8fd4\u56demodelId")
    @ResponseBody
    public HtmlJsonReBean saveModelForm(HttpServletRequest request) {
        String processId;
        Map map = this.assemMapParam(request);
        if (null == map) {
            this.logger.error(CODE + ".saveModelForm", (Object)"param is null");
        }
        if (StringUtils.isBlank((String)(processId = (String)map.get("processId")))) {
            this.logger.error(CODE + ".saveModelForm", (Object)"processId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String processAuthor = (String)map.get("processAuthor");
        String name = (String)map.get("name");
        String modelName = (String)map.get("modelName");
        if (StringUtils.isBlank((String)modelName)) {
            this.logger.error(CODE + ".saveModelForm", (Object)"modelName is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String description = (String)map.get("description");
        if (StringUtils.isBlank((String)description)) {
            this.logger.error(CODE + ".saveModelForm", (Object)"description is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String category = (String)map.get("category");
        String tenantCode = this.getTenantCode(request);
        map.put("tenantCode", tenantCode);
        return this.actModelServiceRepository.saveModelForm(map);
    }

    @RequestMapping(value={"queryModel.json"}, name="\u5206\u9875\u67e5\u8be2 Model \u5bf9\u8c61")
    @ResponseBody
    public SupQueryResult<PageData> queryModel(HttpServletRequest request) {
        Map map = this.assemMapParam(request);
        this.logger.error(CODE + ".queryModel", (Object)("map : " + map));
        String startRow = (String)map.get("startRow");
        String rows = (String)map.get("rows");
        if (StringUtils.isBlank((String)startRow)) {
            this.logger.error(CODE + ".queryModel", (Object)"startRow is null");
            map.put("startRow", 1);
        }
        if (StringUtils.isBlank((String)rows)) {
            this.logger.error(CODE + ".queryModel", (Object)"rows is null");
            map.put("rows", 5);
        }
        Integer startRow1 = Integer.valueOf(startRow);
        Integer rows1 = Integer.valueOf(rows);
        map.put("startRow", startRow1);
        map.put("rows", rows1);
        String tenantCode = this.getTenantCode(request);
        map.put("tenantCode", tenantCode);
        this.logger.error(CODE + ".queryModel", (Object)("tenantCode : " + tenantCode));
        return this.actModelServiceRepository.queryModel(map);
    }

    @RequestMapping(value={"deleteModelBatch.json"}, name="\u5220\u9664\u6a21\u578b")
    @ResponseBody
    public HtmlJsonReBean deleteModelBatch(List<String> ids) {
        if (ListUtil.isEmpty(ids)) {
            this.logger.error(CODE + ".deleteModelBatch", (Object)"param is null");
        }
        return this.actModelServiceRepository.deleteModelBatch(ids);
    }
}

