/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.appmanage.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.core.util.HtmlUtil;
import com.qjsoft.laser.controller.facade.am.domain.AmAppmanageDomain;
import com.qjsoft.laser.controller.facade.am.domain.AmAppmanageReDomain;
import com.qjsoft.laser.controller.facade.am.repository.AppmanageServiceRepository;
import com.qjsoft.laser.controller.facade.sm.domain.SmSeclistReDomain;
import com.qjsoft.laser.controller.facade.sm.repository.SeclistServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.router.AppState;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/am/appmanage"})
public class AppmanageCon
extends SpringmvcController {
    private static String CODE = "am.appmanage.con";
    @Autowired
    private AppmanageServiceRepository appmanageServiceRepository;
    @Autowired
    private SeclistServiceRepository seclistServiceRepository;

    protected String getContext() {
        return "appmanage";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(AmAppmanageDomain amAppmanageDomain) {
        if (null == amAppmanageDomain) {
            this.logger.error(CODE + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.appmanageServiceRepository.saveAppmanage(amAppmanageDomain);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, Integer appmanageId, ModelMap modelMap) {
        modelMap.put((Object)"appmanageReBean", (Object)this.getAppmanage(appmanageId));
        return this.getFtlTempPath(request) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, AmAppmanageDomain amAppmanageDomain) {
        if (null == amAppmanageDomain) {
            this.logger.error(CODE + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.appmanageServiceRepository.updateAppmanage(amAppmanageDomain);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, Integer appmanageId) {
        if (StringUtils.isBlank((Integer)appmanageId)) {
            this.logger.error(CODE + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.appmanageServiceRepository.deleteAppmanage(appmanageId);
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, Integer appmanageId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((Integer)appmanageId) || StringUtils.isBlank((Integer)dataState) || StringUtils.isBlank((Integer)oldDataState)) {
            this.logger.error(CODE + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.appmanageServiceRepository.updateAppmanageState(appmanageId, dataState, oldDataState);
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, Integer appmanageId, ModelMap modelMap) {
        modelMap.put((Object)"appmanageReBean", (Object)this.getAppmanage(appmanageId));
        return this.getFtlTempPath(request) + "view";
    }

    private String getAppmanage(Integer appmanageId) {
        String rs = "{}";
        if (StringUtils.isBlank((Integer)appmanageId)) {
            this.logger.error(CODE + ".getAppmanage", (Object)"appmanageId is null");
        } else {
            rs = JsonUtil.buildNormalBinder().toJson((Object)this.appmanageServiceRepository.getAppmanage(appmanageId));
        }
        return rs;
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public SupQueryResult<AmAppmanageReDomain> listQuery(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.appmanageServiceRepository.queryAppmanageList(param);
    }

    @RequestMapping(value={"audit.json"})
    @ResponseBody
    public HtmlJsonReBean audit(HttpServletRequest request, Integer appmanageId, String appmanageAppkey) {
        if (StringUtils.isBlank((Integer)appmanageId)) {
            this.logger.error(CODE + ".audit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        this.appmanageServiceRepository.updateAppmanageState(appmanageId, Integer.valueOf(AppState.ONLINE.getCode()), Integer.valueOf(AppState.APPLY_ONLINE.getCode()));
        SmSeclistReDomain sm = this.querySmSeclist(appmanageAppkey, "1");
        if (sm == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5b89\u5168\u914d\u7f6e\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01");
        }
        return this.seclistServiceRepository.updateSeclistState(sm.getSeclistId(), Integer.valueOf(1), Integer.valueOf(0));
    }

    private SmSeclistReDomain querySmSeclist(String seclistOcode, String seclistUtype) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("seclistOcode", seclistOcode);
        map.put("seclistOtype", "0");
        map.put("seclistUtype", seclistUtype);
        SupQueryResult rs = this.seclistServiceRepository.querySeclistPage(map);
        if (null == rs || rs.getList().size() == 0) {
            return null;
        }
        return (SmSeclistReDomain)rs.getList().get(0);
    }

    @RequestMapping(value={"queryAppmanageLoadCache.json"}, name="APP\u52a0\u8f7dCACHE")
    @ResponseBody
    public HtmlJsonReBean queryAppmanageLoadCache() {
        return this.appmanageServiceRepository.queryAppmanageLoadCache();
    }
}

