/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.appmanage.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.core.util.HtmlUtil;
import com.qjsoft.laser.controller.facade.am.domain.AmPermissionListDomainBean;
import com.qjsoft.laser.controller.facade.am.domain.AmPermissionListReDomainBean;
import com.qjsoft.laser.controller.facade.am.repository.AmPermissionServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/am/permissionlist"})
public class PermissionListCon
extends SpringmvcController {
    private static String CODE = "am.permissionlist.con";
    @Autowired
    private AmPermissionServiceRepository amPermissionServiceRepository;

    protected String getContext() {
        return "permissionlist";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public SupQueryResult<AmPermissionListReDomainBean> listQuery(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.amPermissionServiceRepository.queryUpPermissionListPage(param);
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(AmPermissionListDomainBean amPermissionListDomainBean) {
        if (null == amPermissionListDomainBean) {
            this.logger.error(CODE + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.amPermissionServiceRepository.savePermissionList(amPermissionListDomainBean);
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, AmPermissionListDomainBean amPermissionListDomainBean) {
        if (null == amPermissionListDomainBean) {
            this.logger.error(CODE + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.amPermissionServiceRepository.updatePermissionList(amPermissionListDomainBean);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, String appapiId) {
        if (StringUtils.isBlank((String)appapiId)) {
            this.logger.error(CODE + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.amPermissionServiceRepository.deletePermissionList(Integer.valueOf(appapiId));
    }

    @RequestMapping(value={"getPermissionListAll.json"})
    @ResponseBody
    public Object getPermissionListAll(HttpServletRequest request, Integer permissionListId) {
        if (!StringUtils.isBlank((Integer)permissionListId)) {
            return this.amPermissionServiceRepository.getPermissionListAll(permissionListId);
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
    }

    @RequestMapping(value={"preciseQuery.json"})
    @ResponseBody
    public SupQueryResult<AmPermissionListReDomainBean> preciseQuery(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", false);
        }
        return this.amPermissionServiceRepository.queryUpPermissionListPage(param);
    }

    @RequestMapping(value={"queryLocalCache.json"}, name="\u52a0\u8f7d\u6743\u9650")
    @ResponseBody
    public HtmlJsonReBean queryLocalCache() {
        return this.amPermissionServiceRepository.queryLocalCache();
    }
}

