/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.appmanage.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.core.util.HtmlUtil;
import com.qjsoft.laser.controller.facade.am.domain.AmAppapiErrorDomain;
import com.qjsoft.laser.controller.facade.am.repository.AppapiServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/am/appapiError"})
public class AppapiErrorCon
extends SpringmvcController {
    private static String CODE = "am.appapiError.con";
    @Autowired
    private AppapiServiceRepository appapiServiceRepository;

    protected String getContext() {
        return "appapiError";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(AmAppapiErrorDomain amAppapiError) {
        if (null == amAppapiError) {
            this.logger.error(CODE + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.appapiServiceRepository.saveAppapiError(amAppapiError);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, Integer errorId, ModelMap modelMap) {
        modelMap.put((Object)"appapiErrorReBean", (Object)this.getAppapiError(errorId));
        return this.getFtlTempPath(request) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, AmAppapiErrorDomain amAppapiError) {
        if (null == amAppapiError) {
            this.logger.error(CODE + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.appapiServiceRepository.updateAppapiError(amAppapiError);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, Integer errorId) {
        if (StringUtils.isBlank((Integer)errorId)) {
            this.logger.error(CODE + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.appapiServiceRepository.deleteAppapiError(Integer.valueOf(errorId));
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, Integer errorId, Integer dataState, Integer oldDataState) {
        if (null == errorId || StringUtils.isBlank((Integer)dataState) || StringUtils.isBlank((Integer)oldDataState)) {
            this.logger.error(CODE + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.appapiServiceRepository.updateAppapiErrorState(errorId, dataState, oldDataState);
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, Integer errorId, ModelMap modelMap) {
        modelMap.put((Object)"appapiErrorReBean", (Object)this.getAppapiError(errorId));
        return this.getFtlTempPath(request) + "view";
    }

    private String getAppapiError(Integer errorId) {
        String rs = "{}";
        if (null == errorId) {
            this.logger.error(CODE + ".getAppapiError", (Object)"errorId is null");
        } else {
            rs = JsonUtil.buildNormalBinder().toJson((Object)this.appapiServiceRepository.getAppapiError(errorId));
        }
        return rs;
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public Object listQuery(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.appapiServiceRepository.queryAppapiErrorPage(param);
    }
}

