/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.appmanage.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.core.util.HtmlUtil;
import com.qjsoft.laser.controller.facade.am.domain.AmAppmanageDomain;
import com.qjsoft.laser.controller.facade.am.domain.AmAppmanageReDomain;
import com.qjsoft.laser.controller.facade.am.domain.AmAppwarDomain;
import com.qjsoft.laser.controller.facade.am.domain.AmAppwarJarDomain;
import com.qjsoft.laser.controller.facade.am.domain.AmAppwarJarReDomain;
import com.qjsoft.laser.controller.facade.am.domain.AmAppwarReDomain;
import com.qjsoft.laser.controller.facade.am.repository.AmAppwarServiceRepository;
import com.qjsoft.laser.controller.facade.am.repository.AppapiServiceRepository;
import com.qjsoft.laser.controller.facade.am.repository.AppmanageServiceRepository;
import com.qjsoft.laser.controller.facade.tm.domain.TmTenantReDomain;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.qjsoft.laser.controller.tenant.controller.TenantCon;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/am/appwar"}, name="APPWAR\u7ba1\u7406")
public class AppwarCon
extends SpringmvcController {
    private static String CODE = "am.appwar.con";
    @Autowired
    private AmAppwarServiceRepository amAppwarServiceRepository;
    @Autowired
    private TenantCon tenantCon;
    @Autowired
    private AppapiServiceRepository appapiServiceRepository;
    @Autowired
    private AppmanageServiceRepository appmanageServiceRepository;

    protected String getContext() {
        return "appwar";
    }

    @RequestMapping(value={"saveAppwar.json"}, name="\u589e\u52a0APPWAR\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean saveAppwar(AmAppwarDomain appwarDomain) {
        if (null == appwarDomain) {
            this.logger.error(CODE + ".saveAppwar", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.amAppwarServiceRepository.saveAppwar(appwarDomain);
    }

    @RequestMapping(value={"saveAppwarListStr.json"}, name="\u589e\u52a0APPWAR\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean saveAppwarListStr(String appwarDomainListStr, String tenantCode) throws IOException {
        if (StringUtils.isBlank((String)appwarDomainListStr) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".saveAppwar", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List AmAppwarDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(appwarDomainListStr, AmAppwarDomain.class);
        for (AmAppwarDomain appwar : AmAppwarDomainList) {
            appwar.setTenantCode(tenantCode);
            this.amAppwarServiceRepository.saveAppwar(appwar);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("tenantCode", "00000000");
            param.put("order", true);
            param.put("appwarIcode", appwar.getAppwarIcode());
            SupQueryResult appwarJarPage = this.amAppwarServiceRepository.queryAppwarJarPage(param);
            if (!ListUtil.isNotEmpty((Collection)appwarJarPage.getList())) continue;
            for (AmAppwarJarReDomain amAppwarJarReDomain : appwarJarPage.getList()) {
                amAppwarJarReDomain.setAppwarJarId(null);
                amAppwarJarReDomain.setTenantCode(tenantCode);
                this.amAppwarServiceRepository.saveAppwarJar((AmAppwarJarDomain)amAppwarJarReDomain);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("tenantCode", "00000000");
                map.put("order", true);
                map.put("appmanageIcode", amAppwarJarReDomain.getAppmanageIcode());
                SupQueryResult amAppmanageList = this.appmanageServiceRepository.queryAppmanageList(map);
                AmAppmanageReDomain amAppmanage = (AmAppmanageReDomain)amAppmanageList.getList().get(0);
                if (null == amAppmanage) {
                    this.logger.error(CODE + ".saveAppwarListStr", (Object)"amAppmanage is null");
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
                }
                amAppmanage.setTenantCode(tenantCode);
                amAppmanage.setAppmanageId(null);
                this.appmanageServiceRepository.saveAppmanage((AmAppmanageDomain)amAppmanage);
            }
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"getAppwar.json"}, name="\u83b7\u53d6APPWAR\u7ba1\u7406\u4fe1\u606f")
    @ResponseBody
    public AmAppwarReDomain getAppwar(String appwarId) {
        if (StringUtils.isBlank((String)appwarId)) {
            this.logger.error(CODE + ".getAppwar", (Object)"param is null");
            return null;
        }
        return this.amAppwarServiceRepository.getAppwar(Integer.valueOf(appwarId));
    }

    @RequestMapping(value={"updateAppwar.json"}, name="\u66f4\u65b0APPWAR\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean updateAppwar(AmAppwarDomain appwarDomain) {
        if (null == appwarDomain) {
            this.logger.error(CODE + ".updateAppwar", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.amAppwarServiceRepository.updateAppwar(appwarDomain);
    }

    @RequestMapping(value={"deleteAppwar.json"}, name="\u5220\u9664APPWAR\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean deleteAppwar(String appwarId) {
        if (StringUtils.isBlank((String)appwarId)) {
            this.logger.error(CODE + ".deleteAppwar", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.amAppwarServiceRepository.deleteAppwar(Integer.valueOf(appwarId));
    }

    @RequestMapping(value={"deleteAppwarStr.json"}, name="\u5220\u9664APPWAR\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean deleteAppwarStr(String appwarId) {
        if (StringUtils.isBlank((String)appwarId)) {
            this.logger.error(CODE + ".deleteAppwar", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        AmAppwarReDomain amAppwarReDomain = this.amAppwarServiceRepository.getAppwar(Integer.valueOf(appwarId));
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", amAppwarReDomain.getTenantCode());
        param.put("appwarIcode", amAppwarReDomain.getAppwarIcode());
        param.put("order", true);
        SupQueryResult appwarJarPage = this.amAppwarServiceRepository.queryAppwarJarPage(param);
        if (ListUtil.isNotEmpty((Collection)appwarJarPage.getList())) {
            for (AmAppwarJarReDomain amAppwarJarReDomain : appwarJarPage.getList()) {
                String appmanageIcode = amAppwarJarReDomain.getAppmanageIcode();
                String tenantCode = amAppwarJarReDomain.getTenantCode();
                this.amAppwarServiceRepository.deleteAppwarJar(amAppwarJarReDomain.getAppwarJarId());
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("tenantCode", tenantCode);
                map.put("appwarIcode", appmanageIcode);
                map.put("order", true);
                SupQueryResult amAppmanagePage = this.appmanageServiceRepository.queryAppmanageList(param);
                if (ListUtil.isEmpty((Collection)amAppmanagePage.getList())) {
                    this.logger.error(CODE + ".deleteAppwar", (Object)"amAppmanagePage is null");
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
                }
                AmAppmanageDomain manage = (AmAppmanageDomain)amAppmanagePage.getList().get(0);
                this.appmanageServiceRepository.deleteAppmanage(manage.getAppmanageId());
            }
        }
        return this.amAppwarServiceRepository.deleteAppwar(Integer.valueOf(appwarId));
    }

    @RequestMapping(value={"queryAppwarPage.json"}, name="\u67e5\u8be2APPWAR\u7ba1\u7406\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AmAppwarReDomain> queryAppwarPage(HttpServletRequest request) {
        Map param = this.makeMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.amAppwarServiceRepository.queryAppwarPage(param);
    }

    @RequestMapping(value={"queryAppwarPageStr.json"}, name="\u67e5\u8be2APPWAR\u7ba1\u7406\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AmAppwarReDomain> queryAppwarPageStr(HttpServletRequest request, String tenantCode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)tenantCode)) {
            param.put("tenantCode", tenantCode);
        }
        param.put("order", true);
        param.put("fuzzy", true);
        return this.amAppwarServiceRepository.queryAppwarPage(param);
    }

    @RequestMapping(value={"updateAppwarState.json"}, name="\u66f4\u65b0APPWAR\u7ba1\u7406\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAppwarState(String appwarId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)appwarId)) {
            this.logger.error(CODE + ".updateAppwarState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.amAppwarServiceRepository.updateAppwarState(Integer.valueOf(appwarId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryAppwarJarLoadCache.json"}, name="APPWAR\u52a0\u8f7dCACHE")
    @ResponseBody
    public HtmlJsonReBean queryAppwarJarLoadCache() {
        return this.amAppwarServiceRepository.queryAppwarJarLoadCache();
    }

    @RequestMapping(value={"queryAppwarName.json"}, name="\u67e5\u8be2\u975e\u540e\u7aef\u5305\u540d")
    @ResponseBody
    public List<AmAppwarReDomain> queryAppwarName(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("appwarType", "2");
            param.put("tenantCode", "00000000");
        }
        ArrayList<AmAppwarReDomain> amlist = new ArrayList<AmAppwarReDomain>();
        SupQueryResult amResult = this.amAppwarServiceRepository.queryAppwarPage(param);
        if (ListUtil.isEmpty((Collection)amResult.getList())) {
            return null;
        }
        String warName = null;
        for (AmAppwarReDomain amAppwarReDomain : amResult.getList()) {
            if (!amAppwarReDomain.getAppwarIcode().contains("paas")) continue;
            int startNum = amAppwarReDomain.getAppwarIcode().indexOf("/") + 1;
            int endNum = amAppwarReDomain.getAppwarIcode().length();
            warName = amAppwarReDomain.getAppwarIcode().substring(startNum, endNum);
            amAppwarReDomain.setAppwarIcode(warName);
            amlist.add(amAppwarReDomain);
        }
        return amlist;
    }

    @RequestMapping(value={"queryAppwarNames.json"}, name="\u67e5\u8be2\u975e\u540e\u7aef\u5305\u540d")
    @ResponseBody
    public List<AmAppwarReDomain> queryAppwarNames(HttpServletRequest request, String tenantCode) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("appwarType", "2");
            param.put("tenantCode", tenantCode);
        }
        ArrayList<AmAppwarReDomain> amlist = new ArrayList<AmAppwarReDomain>();
        SupQueryResult amResult = this.amAppwarServiceRepository.queryAppwarPage(param);
        if (ListUtil.isEmpty((Collection)amResult.getList())) {
            return null;
        }
        String warName = null;
        for (AmAppwarReDomain amAppwarReDomain : amResult.getList()) {
            if (!amAppwarReDomain.getAppwarIcode().contains("paas")) continue;
            int startNum = amAppwarReDomain.getAppwarIcode().indexOf("/") + 1;
            int endNum = amAppwarReDomain.getAppwarIcode().length();
            warName = amAppwarReDomain.getAppwarIcode().substring(startNum, endNum);
            amAppwarReDomain.setAppwarIcode(warName);
            amlist.add(amAppwarReDomain);
        }
        return amlist;
    }

    @RequestMapping(value={"queryTenantPage.json"}, name="\u67e5\u8be2\u79df\u6237\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<TmTenantReDomain> queryTenantPage(HttpServletRequest request) {
        return this.tenantCon.fetchQuery(request);
    }

    @RequestMapping(value={"queryAppwarjarPage.json"}, name="\u67e5\u8be2APPWARJAR\u7ba1\u7406\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AmAppwarJarReDomain> queryAppwarjarPage(HttpServletRequest request) {
        Map param = this.makeMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.amAppwarServiceRepository.queryAppwarJarPage(param);
    }

    @RequestMapping(value={"queryApiLoadCache.json"}, name="API\u52a0\u8f7dCACHE")
    @ResponseBody
    public HtmlJsonReBean queryApiLoadCache() {
        return this.appapiServiceRepository.queryApiLoadCache();
    }

    @RequestMapping(value={"saveAppwarjar.json"}, name="\u589e\u52a0APPWARJAR\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean saveAppwarjar(AmAppwarJarDomain appwarjarDomain) {
        if (null == appwarjarDomain) {
            this.logger.error(CODE + ".saveAppwarjar", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.amAppwarServiceRepository.saveAppwarJar(appwarjarDomain);
    }

    @RequestMapping(value={"updateAppwarjar.json"}, name="\u66f4\u65b0APPWARJAR\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean updateAppwarjar(AmAppwarJarDomain appwarjarDomain) {
        if (null == appwarjarDomain) {
            this.logger.error(CODE + ".updateAppwarjar", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.amAppwarServiceRepository.updateAppwarJar(appwarjarDomain);
    }

    @RequestMapping(value={"deleteAppwarjar.json"}, name="\u5220\u9664APPWARJAR\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean deleteAppwarjar(String appwarJarId) {
        if (StringUtils.isBlank((String)appwarJarId)) {
            this.logger.error(CODE + ".deleteAppwarjar", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.amAppwarServiceRepository.deleteAppwarJar(Integer.valueOf(appwarJarId));
    }
}

