/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.appmanage.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.am.domain.AmAsileDomain;
import com.qjsoft.laser.controller.facade.am.domain.AmAsileReDomain;
import com.qjsoft.laser.controller.facade.am.repository.AsileServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/am/asile"})
public class AsileCon
extends SpringmvcController {
    private static String CODE = "am.asile.con";
    @Autowired
    private AsileServiceRepository asileServiceRepository;

    protected String getContext() {
        return "asile";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(AmAsileDomain amAsileDomain) {
        if (null == amAsileDomain) {
            this.logger.error(CODE + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.asileServiceRepository.saveAsile(amAsileDomain);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, Integer asileId, ModelMap modelMap) {
        modelMap.put((Object)"asileReBean", (Object)this.getAsile(asileId));
        return this.getFtlTempPath(request) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, AmAsileDomain amAsileDomain) {
        if (null == amAsileDomain) {
            this.logger.error(CODE + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.asileServiceRepository.updateAsile(amAsileDomain);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, Integer asileId) {
        if (StringUtils.isBlank((Integer)asileId)) {
            this.logger.error(CODE + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.asileServiceRepository.deleteAsile(asileId);
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, Integer asileId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((Integer)asileId) || StringUtils.isBlank((Integer)dataState) || StringUtils.isBlank((Integer)oldDataState)) {
            this.logger.error(CODE + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.asileServiceRepository.updateAsileState(asileId, dataState, oldDataState);
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, Integer asileId, ModelMap modelMap) {
        modelMap.put((Object)"asileReBean", (Object)this.getAsile(asileId));
        return this.getFtlTempPath(request) + "view";
    }

    private String getAsile(Integer asileId) {
        String rs = "{}";
        if (StringUtils.isBlank((Integer)asileId)) {
            this.logger.error(CODE + ".getAsile", (Object)"asileId is null");
        } else {
            rs = JsonUtil.buildNormalBinder().toJson((Object)this.asileServiceRepository.getAsile(asileId));
        }
        return rs;
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public Object listQuery(HttpServletRequest request) {
        Map param = this.makeMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.asileServiceRepository.queryAsilePage(param);
    }

    @RequestMapping(value={"getAsile.json"})
    @ResponseBody
    public AmAsileReDomain getAsileFor(Integer asileId) {
        if (StringUtils.isBlank((Integer)asileId)) {
            this.logger.error(CODE + ".getAppmanage", (Object)"param is null");
            return null;
        }
        return this.asileServiceRepository.getAsile(asileId);
    }
}

