/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.appmanage.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.core.util.HtmlUtil;
import com.qjsoft.laser.controller.facade.am.domain.AmAppwarDomain;
import com.qjsoft.laser.controller.facade.am.domain.AmAppwarReDomain;
import com.qjsoft.laser.controller.facade.am.repository.AmAppwarServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/am/appwar"}, name="APPWAR\u7ba1\u7406")
public class AppwarCon
extends SpringmvcController {
    private static String CODE = "am.appwar.con";
    @Autowired
    private AmAppwarServiceRepository amAppwarServiceRepository;

    protected String getContext() {
        return "appwar";
    }

    @RequestMapping(value={"saveAppwar.json"}, name="\u589e\u52a0APPWAR\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean saveAppwar(AmAppwarDomain appwarDomain) {
        if (null == appwarDomain) {
            this.logger.error(CODE + ".saveAppwar", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.amAppwarServiceRepository.saveAppwar(appwarDomain);
    }

    @RequestMapping(value={"getAppwar.json"}, name="\u83b7\u53d6APPWAR\u7ba1\u7406\u4fe1\u606f")
    @ResponseBody
    public AmAppwarReDomain getAppwar(String appwarId) {
        if (StringUtils.isBlank((String)appwarId)) {
            this.logger.error(CODE + ".getAppwar", (Object)"param is null");
            return null;
        }
        return this.amAppwarServiceRepository.getAppwar(Integer.valueOf(appwarId));
    }

    @RequestMapping(value={"updateAppwar.json"}, name="\u66f4\u65b0APPWAR\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean updateAppwar(AmAppwarDomain appwarDomain) {
        if (null == appwarDomain) {
            this.logger.error(CODE + ".updateAppwar", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.amAppwarServiceRepository.updateAppwar(appwarDomain);
    }

    @RequestMapping(value={"deleteAppwar.json"}, name="\u5220\u9664APPWAR\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean deleteAppwar(String appwarId) {
        if (StringUtils.isBlank((String)appwarId)) {
            this.logger.error(CODE + ".deleteAppwar", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.amAppwarServiceRepository.deleteAppwar(Integer.valueOf(appwarId));
    }

    @RequestMapping(value={"queryAppwarPage.json"}, name="\u67e5\u8be2APPWAR\u7ba1\u7406\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AmAppwarReDomain> queryAppwarPage(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.amAppwarServiceRepository.queryAppwarPage(param);
    }

    @RequestMapping(value={"updateAppwarState.json"}, name="\u66f4\u65b0APPWAR\u7ba1\u7406\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAppwarState(String appwarId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)appwarId)) {
            this.logger.error(CODE + ".updateAppwarState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.amAppwarServiceRepository.updateAppwarState(Integer.valueOf(appwarId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryAppwarJarLoadCache.json"}, name="APPWAR\u52a0\u8f7dCACHE")
    @ResponseBody
    public HtmlJsonReBean queryAppwarJarLoadCache() {
        return this.amAppwarServiceRepository.queryAppwarJarLoadCache();
    }

    @RequestMapping(value={"queryAppwarName.json"}, name="\u67e5\u8be2\u975e\u540e\u7aef\u5305\u540d")
    @ResponseBody
    public List<AmAppwarReDomain> queryAppwarName(HttpServletRequest request, String appwarFwtype) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("appwarFwtype", appwarFwtype);
            param.put("appwarType", "2");
            param.put("tenantCode", "00000000");
        }
        ArrayList<AmAppwarReDomain> amlist = new ArrayList<AmAppwarReDomain>();
        SupQueryResult amResult = this.amAppwarServiceRepository.queryAppwarPage(param);
        if (ListUtil.isEmpty((Collection)amResult.getList())) {
            return null;
        }
        String warName = null;
        for (AmAppwarReDomain amAppwarReDomain : amResult.getList()) {
            if (!amAppwarReDomain.getAppwarIcode().contains("paas")) continue;
            int startNum = amAppwarReDomain.getAppwarIcode().indexOf("/") + 1;
            int endNum = amAppwarReDomain.getAppwarIcode().length();
            warName = amAppwarReDomain.getAppwarIcode().substring(startNum, endNum);
            amAppwarReDomain.setAppwarIcode(warName);
            amlist.add(amAppwarReDomain);
        }
        return amlist;
    }
}

