/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.appmanage.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.core.util.HtmlUtil;
import com.qjsoft.laser.controller.facade.am.domain.AmAppapiParamDomain;
import com.qjsoft.laser.controller.facade.am.domain.AmAppapiParamReDomain;
import com.qjsoft.laser.controller.facade.am.repository.AppapiServiceRepository;
import com.qjsoft.laser.controller.facade.am.repository.DataparamServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/am/appapiParam"})
public class AppapiParamCon
extends SpringmvcController {
    private static String CODE = "am.appapiParam.con";
    @Autowired
    private AppapiServiceRepository appapiServiceRepository;
    @Autowired
    private DataparamServiceRepository dataparamServiceRepository;

    protected String getContext() {
        return "appapiParam";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(AmAppapiParamDomain amAppapiParam) {
        if (null == amAppapiParam) {
            this.logger.error(CODE + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.appapiServiceRepository.saveAppapiParam(amAppapiParam);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, Integer appapiParamId, ModelMap modelMap) {
        modelMap.put((Object)"appapiParamReBean", (Object)this.getAppapiParam(appapiParamId));
        return this.getFtlTempPath(request) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, AmAppapiParamDomain amAppapiParam) {
        if (null == amAppapiParam) {
            this.logger.error(CODE + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.appapiServiceRepository.updateAppapiParam(amAppapiParam);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, Integer appapiParamId) {
        if (StringUtils.isBlank((Integer)appapiParamId)) {
            this.logger.error(CODE + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.appapiServiceRepository.deleteAppapiParam(appapiParamId);
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, Integer appapiParamId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((Integer)appapiParamId) || StringUtils.isBlank((Integer)dataState) || StringUtils.isBlank((Integer)oldDataState)) {
            this.logger.error(CODE + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.appapiServiceRepository.updateAppapiParamState(appapiParamId, dataState, dataState, oldDataState);
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, Integer appapiParamId, ModelMap modelMap) {
        modelMap.put((Object)"appapiParamReBean", (Object)this.getAppapiParam(appapiParamId));
        return this.getFtlTempPath(request) + "view";
    }

    private String getAppapiParam(Integer appapiParamId) {
        String rs = "{}";
        if (StringUtils.isBlank((Integer)appapiParamId)) {
            this.logger.error(CODE + ".getAppapiParam", (Object)"appapiParamId is null");
        } else {
            rs = JsonUtil.buildNormalBinder().toJson((Object)this.appapiServiceRepository.getAppapiParam(appapiParamId));
        }
        return rs;
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public SupQueryResult<AmAppapiParamReDomain> listQuery(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.appapiServiceRepository.queryAppapiParamPage(param);
    }

    @RequestMapping(value={"getParamAll.json"})
    @ResponseBody
    public List<AmAppapiParamReDomain> getParamAll(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        List amAppapiParamReDomains = this.appapiServiceRepository.queryAppapiParamList(param);
        for (AmAppapiParamReDomain amAppapiParamReDomain : amAppapiParamReDomains) {
            List dataparamBycode = this.dataparamServiceRepository.queryDataparamListByCode(amAppapiParamReDomain.getParamClassname(), amAppapiParamReDomain.getTenantCode());
            amAppapiParamReDomain.setDataparamList(dataparamBycode);
        }
        return amAppapiParamReDomains;
    }
}

