/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.at.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionFileDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionGinfoDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionGinfoReDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionGoodsDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionGoodsReDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionMemDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionMemReDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionReDomain;
import com.qjsoft.laser.controller.facade.at.repository.AtAuctionServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/at/auction"}, name="\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
public class AuctionCon
extends SpringmvcController {
    private static String CODE = "at.auction.con";
    @Autowired
    private AtAuctionServiceRepository atAuctionServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;

    protected String getContext() {
        return "auction";
    }

    @RequestMapping(value={"saveAuction.json"}, name="\u589e\u52a0\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveAuction(HttpServletRequest request, AtAuctionDomain atAuctionDomain) {
        String flag = this.dataCollation(request, atAuctionDomain);
        if ("error".equals(flag)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
        }
        return this.atAuctionServiceRepository.saveatAuction(atAuctionDomain);
    }

    @RequestMapping(value={"getAuction.json"}, name="\u83b7\u53d6\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public AtAuctionReDomain getAuction(Integer auctionId) {
        if (StringUtils.isBlank((Integer)auctionId)) {
            this.logger.error(CODE + ".getAuction", (Object)"auctionId is null");
            return null;
        }
        return this.atAuctionServiceRepository.getatAuction(auctionId);
    }

    @RequestMapping(value={"updateAuction.json"}, name="\u66f4\u65b0\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateAuction(HttpServletRequest request, AtAuctionDomain atAuctionDomain) {
        String flag = this.dataCollation(request, atAuctionDomain);
        if ("error".equals(flag)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
        }
        return this.atAuctionServiceRepository.updateatAuction(atAuctionDomain);
    }

    @RequestMapping(value={"deleteAuction.json"}, name="\u5220\u9664\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteAuction(String auctionId) {
        String[] auctions;
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionId.split(",")) {
            AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            if (atAuctionReDomain.getDataState() != 2) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53ea\u80fd\u5728\u7ec8\u6b62\u72b6\u6001\u624d\u80fd\u5220\u9664");
            }
            this.atAuctionServiceRepository.deleteatAuction(Integer.valueOf(str));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"deleteAuctionRevoke.json"}, name="\u64a4\u9500")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionRevoke(String auctionId) {
        AtAuctionReDomain atAuctionReDomain;
        String[] auctions;
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"auctionId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionId.split(",")) {
            atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            if (atAuctionReDomain.getDataState() == 1 || atAuctionReDomain.getDataState() == 0) continue;
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9009\u53d6\u53ea\u80fd\u4e3a\u65b0\u589e\u548c\u5df2\u53d1\u5e03\u7684\u4fe1\u606f");
        }
        for (String str : auctions) {
            atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(str), Integer.valueOf(2), atAuctionReDomain.getDataState(), null);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"deleteAuctionByCode.json"}, name="\u6839\u636ecode\u5220\u9664\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteAuction(HttpServletRequest request, String auctionCode) {
        if (StringUtils.isBlank((String)auctionCode)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"auctionCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuctionByCode(this.getTenantCode(request), auctionCode);
        if (atAuctionReDomain.getDataState() != 2) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53ea\u80fd\u5728\u7ec8\u6b62\u72b6\u6001\u624d\u80fd\u5220\u9664");
        }
        return this.atAuctionServiceRepository.deleteatAuctionByCode(this.getTenantCode(request), auctionCode);
    }

    @RequestMapping(value={"queryAuctionPage.json"}, name="\u67e5\u8be2\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"updateAuctionState.json"}, name="\u66f4\u65b0\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAuctionState(String auctionId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.atAuctionServiceRepository.updateatAuctionFileState(Integer.valueOf(auctionId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryAuctionMemPage.json"}, name="\u67e5\u8be2\u5206\u7ec4\u4fe1\u606f")
    @ResponseBody
    public SupQueryResult<AtAuctionMemReDomain> queryAuctionMemPage(HttpServletRequest request, String auctionCode) {
        if (StringUtils.isBlank((String)auctionCode)) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.atAuctionServiceRepository.queryatAuctionMemPage(param);
    }

    @RequestMapping(value={"updateAcutionRelease.json"}, name="\u91cd\u65b0\u53d1\u5e03")
    @ResponseBody
    public HtmlJsonReBean updateAcutionRelease(String auctionId) {
        if (StringUtils.isBlank((String)auctionId)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "auctionId is null");
        }
        return this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(auctionId), Integer.valueOf(0), Integer.valueOf(2), null);
    }

    @RequestMapping(value={"queryAuctionPageNotice.json"}, name="\u53ea\u67e5\u8be2\u9884\u544a\u4fe1\u606f\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPageNotice(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("auctionType", "00");
            param.put("auctionAudit", 1);
        }
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"deleteAuctions.json"}, name="\u5220\u9664\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteAuctions(String auctionId) {
        String[] auctions;
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionId.split(",")) {
            AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            if (atAuctionReDomain.getDataState() != 2) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53ea\u80fd\u5728\u7ec8\u6b62\u72b6\u6001\u624d\u80fd\u5220\u9664");
            }
            this.atAuctionServiceRepository.deleteatAuction(Integer.valueOf(str));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateAuctionTermination.json"}, name="\u64a4\u9500--\u516c\u544a")
    @ResponseBody
    public HtmlJsonReBean updateAuctionTermination(String auctionId) {
        AtAuctionReDomain atAuctionReDomain;
        String[] auctions;
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"auctionId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionId.split(",")) {
            atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            if (atAuctionReDomain.getDataState() == 1 || atAuctionReDomain.getDataState() == 0) continue;
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53d1\u5e03\uff0c\u65b0\u589e\u72b6\u6001\u624d\u80fd\u64a4\u9500");
        }
        for (String str : auctions) {
            atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(str), Integer.valueOf(2), atAuctionReDomain.getDataState(), null);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateAuctionTerminationForAt.json"}, name="\u7ec8\u6b62-\u516c\u544a")
    @ResponseBody
    public HtmlJsonReBean updateAuctionTerminationForAt(String auctionStr) {
        if (StringUtils.isBlank((String)auctionStr)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"auctionId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ArrayList<AtAuctionReDomain> atAuctionReDomains = new ArrayList<AtAuctionReDomain>();
        String[] auctions = auctionStr.split(",");
        for (String str : auctions) {
            AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            Date date = new Date();
            if (atAuctionReDomain.getAuctionSdate().getTime() > date.getTime()) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53ea\u80fd\u5728\u516c\u544a\u5f00\u59cb\u7684\u65f6\u5019\u624d\u80fd\u7ec8\u6b62\uff01");
            }
            atAuctionReDomains.add(atAuctionReDomain);
        }
        for (AtAuctionReDomain atAuctionReDomain : atAuctionReDomains) {
            this.atAuctionServiceRepository.updateatAuctionState(atAuctionReDomain.getAuctionId(), Integer.valueOf(2), atAuctionReDomain.getDataState(), null);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"saveAuctionGinfo.json"}, name="\u4fdd\u5b58\u5305\u88f9\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveAuctionGinfo(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "paramStr is null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        AtAuctionGoodsDomain atAuctionGoodsDomain = null;
        ArrayList<AtAuctionGoodsDomain> atAuctionGoodsList = null;
        HashMap<String, String> map = null;
        List AtAuctionGinfoDomain2 = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, AtAuctionGinfoDomain.class);
        for (AtAuctionGinfoDomain atAuctionGinfoDomain : AtAuctionGinfoDomain2) {
            atAuctionGinfoDomain.setMemberCode(userSession.getUserPcode());
            atAuctionGinfoDomain.setMemberName(userSession.getUserName());
            atAuctionGinfoDomain.setTenantCode(this.getTenantCode(request));
            String[] goodsCode = atAuctionGinfoDomain.getAtAuctionGoodsJson().split(",");
            atAuctionGoodsList = new ArrayList<AtAuctionGoodsDomain>();
            for (String str : goodsCode) {
                atAuctionGoodsDomain = new AtAuctionGoodsDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)atAuctionGoodsDomain, (Object)atAuctionGinfoDomain);
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".saveatAuctionGinfoBatch", (Throwable)e);
                }
                map = new HashMap<String, String>();
                map.put("goodsCode", str);
                map.put("tenantCode", atAuctionGinfoDomain.getTenantCode());
                map.put("unwantedRelatedData", "unwantedRelatedData");
                RsResourceGoodsReDomain resourceGoods = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
                try {
                    BeanUtils.copyAllPropertys((Object)atAuctionGoodsDomain, (Object)resourceGoods);
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".saveatAuctionGinfoBatch", (Throwable)e);
                }
                atAuctionGoodsList.add(atAuctionGoodsDomain);
            }
            this.calculation(atAuctionGinfoDomain, atAuctionGoodsList);
            atAuctionGinfoDomain.setAtAuctionGoodsDomain(atAuctionGoodsList);
        }
        return this.atAuctionServiceRepository.saveatAuctionGinfoBatch(AtAuctionGinfoDomain2);
    }

    @RequestMapping(value={"getAuctionGinfo.json"}, name="\u83b7\u53d6\u5305\u88f9\u4fe1\u606f")
    @ResponseBody
    public AtAuctionGinfoReDomain getAuctionGinfo(HttpServletRequest request, String auctionGinfCode) {
        if (StringUtils.isBlank((String)auctionGinfCode)) {
            this.logger.error(CODE + ".getAuction", (Object)"auctionId is null");
            return null;
        }
        return this.atAuctionServiceRepository.getatAuctionGinfoByCode(this.getTenantCode(request), auctionGinfCode);
    }

    @RequestMapping(value={"queryAuctionGinfo.json"}, name="\u67e5\u770b\u7ade\u4ef7\u8be6\u60c5--\u516c\u544a\u9875\u9762")
    @ResponseBody
    public SupQueryResult<AtAuctionGinfoReDomain> queryAuctionGinfo(HttpServletRequest request, String auctionCode) {
        if (StringUtils.isBlank((String)auctionCode)) {
            this.logger.error(CODE + ".getAuction", (Object)"auctionId is null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auctionCode", auctionCode);
        map.put("tenantCode", this.getTenantCode(request));
        SupQueryResult atAuctionGinfoReDomainSupQueryResult = this.atAuctionServiceRepository.queryatAuctionGinfoPage(map);
        return atAuctionGinfoReDomainSupQueryResult;
    }

    @RequestMapping(value={"updateAuctionDtRange.json"}, name="\u4fee\u6539\u5168\u573a\u4fdd\u8bc1\u91d1\u8303\u56f4")
    @ResponseBody
    public HtmlJsonReBean updateAuctionDtRange(AtAuctionDomain atAuctionDomain) {
        if (null == atAuctionDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.atAuctionServiceRepository.updateatAuction(atAuctionDomain);
    }

    @RequestMapping(value={"updateAuctionGinfoDtRange.json"}, name="\u4fee\u6539\u5305\u88f9\u4fdd\u8bc1\u91d1\u8303\u56f4")
    @ResponseBody
    public HtmlJsonReBean updateAuctionGinfoDtRange(String paramStr) {
        if (StringUtils.isNotBlank((String)paramStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        List atAuctionGinfoDomains = (List)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, AtAuctionGinfoDomain.class);
        if (ListUtil.isNotEmpty((Collection)atAuctionGinfoDomains)) {
            for (AtAuctionGinfoDomain atAuctionGinfoDomain : atAuctionGinfoDomains) {
                this.atAuctionServiceRepository.updateatAuctionGinfo(atAuctionGinfoDomain);
            }
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateAcutionReleases.json"}, name="\u91cd\u65b0\u53d1\u5e03--\u516c\u544a")
    @ResponseBody
    public HtmlJsonReBean updateAcutionReleases(String auctionId) {
        if (StringUtils.isBlank((String)auctionId)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "auctionId is null");
        }
        return this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(auctionId), Integer.valueOf(0), Integer.valueOf(2), null);
    }

    @RequestMapping(value={"saveAuctionItems.json"}, name="\u589e\u52a0\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveAuctionItems(HttpServletRequest request, AtAuctionDomain atAuctionDomain) {
        String flag = this.dataCollation(request, atAuctionDomain);
        if ("error".equals(flag)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
        }
        atAuctionDomain.setAuctionruleScope("1");
        return this.atAuctionServiceRepository.saveatAuction(atAuctionDomain);
    }

    @RequestMapping(value={"updateAuctionItems.json"}, name="\u66f4\u65b0\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateAuctionItems(HttpServletRequest request, AtAuctionDomain atAuctionDomain) {
        String flag = this.dataCollation(request, atAuctionDomain);
        if ("error".equals(flag)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
        }
        return this.atAuctionServiceRepository.updateatAuction(atAuctionDomain);
    }

    @RequestMapping(value={"getAuctionItems.json"}, name="\u83b7\u53d6\u5355\u54c1")
    @ResponseBody
    public AtAuctionReDomain getAuctionItems(Integer auctionId) {
        if (StringUtils.isBlank((Integer)auctionId)) {
            this.logger.error(CODE + ".getAuction", (Object)"auctionId is null");
            return null;
        }
        return this.atAuctionServiceRepository.getatAuction(auctionId);
    }

    @RequestMapping(value={"deleteAuctionsItems.json"}, name="\u5220\u9664\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionsItems(String auctionId) {
        String[] auctions;
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionId.split(",")) {
            AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            if (atAuctionReDomain.getDataState() != 2) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53ea\u80fd\u5728\u7ec8\u6b62\u72b6\u6001\u624d\u80fd\u5220\u9664");
            }
            this.atAuctionServiceRepository.deleteatAuction(Integer.valueOf(str));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateAcutionReleasesItems.json"}, name="\u91cd\u65b0\u53d1\u5e03-\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateAcutionReleasesItems(String auctionId) {
        if (StringUtils.isBlank((String)auctionId)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "auctionId is null");
        }
        return this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(auctionId), Integer.valueOf(0), Integer.valueOf(2), null);
    }

    @RequestMapping(value={"updateAcutionUp.json"}, name="\u91cd\u65b0\u4e0a\u67b6-\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateAcutionUp(String auctionId) {
        if (StringUtils.isBlank((String)auctionId)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "auctionId is null");
        }
        AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(auctionId));
        return this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(auctionId), Integer.valueOf(1), atAuctionReDomain.getDataState(), null);
    }

    @RequestMapping(value={"queryAuctionGinfoItems.json"}, name="\u67e5\u770b\u7ade\u4ef7\u8be6\u60c5--\u5355\u54c1\u9875\u9762")
    @ResponseBody
    public SupQueryResult<AtAuctionGinfoReDomain> queryAuctionGinfoItems(HttpServletRequest request, String auctionCode) {
        if (StringUtils.isBlank((String)auctionCode)) {
            this.logger.error(CODE + ".getAuction", (Object)"auctionId is null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auctionCode", auctionCode);
        map.put("tenantCode", this.getTenantCode(request));
        SupQueryResult atAuctionGinfoReDomainSupQueryResult = this.atAuctionServiceRepository.queryatAuctionGinfoPage(map);
        return atAuctionGinfoReDomainSupQueryResult;
    }

    @RequestMapping(value={"queryAuctionPageItems.json"}, name="\u53ea\u67e5\u8be2\u5355\u54c1\u4fe1\u606f\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPageItems(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("auctionType", "01");
        param.put("auctionruleScope", "1");
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"queryAuctionGinfoPageItems.json"}, name="\u53ea\u67e5\u8be2\u5355\u54c1\u4fe1\u606f\u5217\u8868")
    @ResponseBody
    public List<AtAuctionGinfoReDomain> queryAuctionGinfoPageItems(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("auctionType", "01");
        param.put("auctionruleScope", "1");
        ArrayList<AtAuctionGinfoReDomain> atAuctionGinfoReDomains = new ArrayList<AtAuctionGinfoReDomain>();
        HashMap<String, String> map = new HashMap<String, String>();
        List list = this.atAuctionServiceRepository.queryatAuctionPage(param).getList();
        for (AtAuctionReDomain atAuctionReDomain : list) {
            map.put("auctionCode", atAuctionReDomain.getAuctionCode());
            map.put("tenantCode", atAuctionReDomain.getTenantCode());
            List auctionGinfoReDomains = this.atAuctionServiceRepository.queryatAuctionGinfoPage(map).getList();
            atAuctionGinfoReDomains.addAll(auctionGinfoReDomains);
        }
        return atAuctionGinfoReDomains;
    }

    @RequestMapping(value={"updateAuctionGinfoItems.json"}, name="\u66f4\u65b0\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateAuctionGinfoItems(AtAuctionGinfoDomain atAuctionGinfoDomain) {
        if (null == atAuctionGinfoDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u6709\u8bef");
        }
        this.atAuctionServiceRepository.deleteatAuctionGinfo(atAuctionGinfoDomain.getAuctionGinfoId());
        AtAuctionGoodsDomain atAuctionGoodsDomain = null;
        ArrayList<AtAuctionGoodsDomain> atAuctionGoodsList = null;
        HashMap<String, String> map = null;
        String[] goodsCode = atAuctionGinfoDomain.getAtAuctionGoodsJson().split(",");
        atAuctionGoodsList = new ArrayList<AtAuctionGoodsDomain>();
        for (String str : goodsCode) {
            atAuctionGoodsDomain = new AtAuctionGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)atAuctionGoodsDomain, (Object)atAuctionGinfoDomain);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".saveAuction:2", (Throwable)e);
            }
            map = new HashMap<String, String>();
            map.put("goodsCode", str);
            map.put("tenantCode", atAuctionGinfoDomain.getTenantCode());
            map.put("unwantedRelatedData", "unwantedRelatedData");
            RsResourceGoodsReDomain resourceGoods = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
            try {
                BeanUtils.copyAllPropertys((Object)atAuctionGoodsDomain, (Object)resourceGoods);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".saveAuction:3", (Throwable)e);
            }
            atAuctionGoodsList.add(atAuctionGoodsDomain);
        }
        this.calculation(atAuctionGinfoDomain, atAuctionGoodsList);
        atAuctionGinfoDomain.setAtAuctionGoodsDomain(atAuctionGoodsList);
        ArrayList<AtAuctionGinfoDomain> atAuctionGinfoDomainList = new ArrayList<AtAuctionGinfoDomain>();
        atAuctionGinfoDomainList.add(atAuctionGinfoDomain);
        return this.atAuctionServiceRepository.saveatAuctionGinfoBatch(atAuctionGinfoDomainList);
    }

    @RequestMapping(value={"deleteAuctionGinfoItems.json"}, name="\u5220\u9664\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionGinfoItems(String auctionGinfoId) {
        String[] auctions;
        if (StringUtils.isBlank((String)auctionGinfoId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionGinfoId.split(",")) {
            this.atAuctionServiceRepository.deleteatAuctionGinfo(Integer.valueOf(str));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"queryAuctionPagePC.json"}, name="\u67e5\u8be2\u516c\u544a\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPagePC(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("auctionType", "01");
        }
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"queryAuctionPageNoticePc.json"}, name="\u67e5\u8be2\u9884\u544a\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPageNoticePc(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("auctionType", "00");
        }
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"getAuctionPC.json"}, name="\u83b7\u53d6\u516c\u544a\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public AtAuctionReDomain getAuctionPC(Integer auctionId) {
        if (StringUtils.isBlank((Integer)auctionId)) {
            this.logger.error(CODE + ".getAuction", (Object)"auctionId is null");
            return null;
        }
        return this.atAuctionServiceRepository.getatAuction(auctionId);
    }

    @RequestMapping(value={"getAuctionNoticePc.json"}, name="\u83b7\u53d6\u9884\u544a\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public AtAuctionReDomain getAuctionNoticePc(Integer auctionId) {
        if (StringUtils.isBlank((Integer)auctionId)) {
            this.logger.error(CODE + ".getAuction", (Object)"auctionId is null");
            return null;
        }
        return this.atAuctionServiceRepository.getatAuction(auctionId);
    }

    @RequestMapping(value={"queryAuctionPC.json"}, name="\u67e5\u8be2\u516c\u544a\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPC(HttpServletRequest request, String classtreeCodeStr) {
        Map param = this.assemMapParam(request);
        StringBuffer auctionCodeStr = new StringBuffer();
        if (null != classtreeCodeStr) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("order", true);
            map.put("fuzzy", true);
            map.put("classtreeCodeStr", classtreeCodeStr);
            List list = this.atAuctionServiceRepository.queryatAuctionGoodsPage(param).getList();
            for (AtAuctionGoodsReDomain atAuctionGoodsReDomain : list) {
                auctionCodeStr.append("'" + atAuctionGoodsReDomain.getAuctionCode() + "',");
            }
            auctionCodeStr.deleteCharAt(auctionCodeStr.length() - 1);
        }
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("auctionType", "01");
        }
        param.put("auctionCodeStr", auctionCodeStr);
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"queryAuctionNoticePC.json"}, name="\u67e5\u8be2\u9884\u544a\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionNoticePC(HttpServletRequest request, String classtreeCodeStr) {
        Map param = this.assemMapParam(request);
        StringBuffer auctionCodeStr = new StringBuffer();
        if (null != classtreeCodeStr) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("order", true);
            map.put("fuzzy", true);
            map.put("classtreeCodeStr", classtreeCodeStr);
            List list = this.atAuctionServiceRepository.queryatAuctionGoodsPage(param).getList();
            for (AtAuctionGoodsReDomain atAuctionGoodsReDomain : list) {
                auctionCodeStr.append("'" + atAuctionGoodsReDomain.getAuctionCode() + "',");
            }
            auctionCodeStr.deleteCharAt(auctionCodeStr.length() - 1);
        }
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("auctionType", "00");
        }
        param.put("auctionCodeStr", auctionCodeStr);
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"updateAuctionAuditPaas.json"}, name="\u5e73\u53f0\u5ba1\u6838--\u516c\u544a")
    @ResponseBody
    public HtmlJsonReBean updateAuctionAuditPaas(HttpServletRequest request, String auctionId, Integer auctionAudit, Integer oldauctionAudit, String auctionAuremark) {
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auctionAuremark", auctionAuremark);
        map.put("userCode", userSession.getUserPcode());
        map.put("userName", userSession.getUserName());
        return this.atAuctionServiceRepository.updateAuctionAuctionAudit(Integer.valueOf(auctionId), auctionAudit, oldauctionAudit, map);
    }

    @RequestMapping(value={"queryAuctionPagePaas.json"}, name="\u67e5\u8be2\u516c\u544a\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPagePaas(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("auctionType", "01");
        }
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"queryAuctionGinfoPaas.json"}, name="\u67e5\u770b\u7ade\u4ef7\u8be6\u60c5--\u516c\u544a\u9875\u9762")
    @ResponseBody
    public SupQueryResult<AtAuctionGinfoReDomain> queryAuctionGinfoPaas(HttpServletRequest request, String auctionCode) {
        if (StringUtils.isBlank((String)auctionCode)) {
            this.logger.error(CODE + ".getAuction", (Object)"auctionId is null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auctionCode", auctionCode);
        map.put("tenantCode", this.getTenantCode(request));
        SupQueryResult atAuctionGinfoReDomainSupQueryResult = this.atAuctionServiceRepository.queryatAuctionGinfoPage(map);
        return atAuctionGinfoReDomainSupQueryResult;
    }

    @RequestMapping(value={"updateAuctionTrailerAudit.json"}, name="\u5e73\u53f0\u5ba1\u6838--\u9884\u544a")
    @ResponseBody
    public HtmlJsonReBean updateAuctionTrailerAudit(HttpServletRequest request, String auctionId, Integer auctionAudit, Integer oldauctionAudit, String auctionAuremark) {
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auctionAuremark", auctionAuremark);
        map.put("userCode", userSession.getUserPcode());
        map.put("userName", userSession.getUserName());
        return this.atAuctionServiceRepository.updateAuctionAuctionAudit(Integer.valueOf(auctionId), auctionAudit, oldauctionAudit, map);
    }

    @RequestMapping(value={"queryAuctionPageTrailer.json"}, name="\u67e5\u8be2\u9884\u544a\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPageTrailer(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("auctionType", "00");
        }
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"updateAuctionItemAudit.json"}, name="\u5e73\u53f0\u5ba1\u6838--\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateAuctionItemAudit(HttpServletRequest request, String auctionId, Integer auctionAudit, Integer oldauctionAudit, String auctionAuremark) {
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auctionAuremark", auctionAuremark);
        map.put("userCode", userSession.getUserPcode());
        map.put("userName", userSession.getUserName());
        return this.atAuctionServiceRepository.updateAuctionAuctionAudit(Integer.valueOf(auctionId), auctionAudit, oldauctionAudit, map);
    }

    @RequestMapping(value={"queryAuctionPageItem.json"}, name="\u67e5\u8be2\u5355\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPageItem(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("auctionType", "01");
        param.put("auctionruleScope", "1");
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    private String dataCollation(HttpServletRequest request, AtAuctionDomain atAuctionDomain) {
        if (null == atAuctionDomain) {
            this.logger.error(CODE + ".saveAuction", (Object)"atAuctionDomain is null");
            return "error";
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveAuction", (Object)"userSession is null");
            return "error";
        }
        if (atAuctionDomain.getMemberCode() == null) {
            atAuctionDomain.setMemberCode(userSession.getUserPcode());
            atAuctionDomain.setMemberName(userSession.getUserName());
        }
        if (StringUtils.isNotBlank((String)atAuctionDomain.getAtAuctionFileStr())) {
            AtAuctionFileDomain atAuctionFileDomain = (AtAuctionFileDomain)JsonUtil.buildNormalBinder().getJsonToObject(atAuctionDomain.getAtAuctionFileStr(), AtAuctionFileDomain.class);
            atAuctionDomain.setAtAuctionFileDomain(atAuctionFileDomain);
        }
        if (StringUtils.isNotBlank((String)atAuctionDomain.getAtAuctionMemStr())) {
            List atAuctionMemDomain = (List)JsonUtil.buildNormalBinder().getJsonToList(atAuctionDomain.getAtAuctionMemStr(), AtAuctionMemDomain.class);
            atAuctionDomain.setAtAuctionMemDomainList(atAuctionMemDomain);
        }
        AtAuctionGoodsDomain atAuctionGoodsDomain = null;
        ArrayList<AtAuctionGoodsDomain> atAuctionGoodsList = null;
        HashMap<String, String> map = null;
        if (StringUtils.isNotBlank((String)atAuctionDomain.getAuctionGinfoStr())) {
            List atAuctionGinfoDomains = (List)JsonUtil.buildNormalBinder().getJsonToList(atAuctionDomain.getAuctionGinfoStr(), AtAuctionGinfoDomain.class);
            for (AtAuctionGinfoDomain atAuctionGinfoDomain : atAuctionGinfoDomains) {
                if (null != atAuctionGinfoDomain.getAuctionGinfoId()) {
                    AtAuctionGinfoReDomain atAuctionGinfoReDomain = this.atAuctionServiceRepository.getatAuctionGinfo(atAuctionGinfoDomain.getAuctionGinfoId());
                    try {
                        BeanUtils.copyAllPropertys((Object)atAuctionGinfoDomain, (Object)atAuctionGinfoReDomain);
                    }
                    catch (Exception e) {
                        this.logger.error(CODE + ".saveAuction:1", (Throwable)e);
                    }
                    continue;
                }
                String[] goodsCode = atAuctionGinfoDomain.getAtAuctionGoodsJson().split(",");
                atAuctionGoodsList = new ArrayList<AtAuctionGoodsDomain>();
                for (String str : goodsCode) {
                    atAuctionGoodsDomain = new AtAuctionGoodsDomain();
                    try {
                        BeanUtils.copyAllPropertys((Object)atAuctionGoodsDomain, (Object)atAuctionGinfoDomain);
                    }
                    catch (Exception e) {
                        this.logger.error(CODE + ".saveAuction:2", (Throwable)e);
                    }
                    map = new HashMap<String, String>();
                    map.put("goodsCode", str);
                    map.put("tenantCode", atAuctionGinfoDomain.getTenantCode());
                    map.put("unwantedRelatedData", "unwantedRelatedData");
                    RsResourceGoodsReDomain resourceGoods = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
                    try {
                        BeanUtils.copyAllPropertys((Object)atAuctionGoodsDomain, (Object)resourceGoods);
                    }
                    catch (Exception e) {
                        this.logger.error(CODE + ".saveAuction:3", (Throwable)e);
                    }
                    atAuctionGoodsList.add(atAuctionGoodsDomain);
                }
                this.calculation(atAuctionGinfoDomain, atAuctionGoodsList);
                atAuctionGinfoDomain.setAtAuctionGoodsDomain(atAuctionGoodsList);
                atAuctionGinfoDomain.setAuctionruleDelaysum(atAuctionDomain.getAuctionruleDelaysum());
                atAuctionGinfoDomain.setAuctionruleDelayflag(atAuctionDomain.getAuctionruleDelayflag());
                atAuctionGinfoDomain.setAuctionruleDelay(atAuctionDomain.getAuctionruleDelay());
                atAuctionGinfoDomain.setAuctionSdate(atAuctionDomain.getAuctionSgdate());
                atAuctionGinfoDomain.setAuctionEdate(atAuctionDomain.getAuctionEdate());
                atAuctionGinfoDomain.setGoodsNum(new BigDecimal(atAuctionGoodsList.size()));
            }
            atAuctionDomain.setAuctionGinfoDomainList(atAuctionGinfoDomains);
        }
        atAuctionDomain.setTenantCode(this.getTenantCode(request));
        return "success";
    }

    private void calculation(AtAuctionGinfoDomain atAuctionGinfoDomain, List<AtAuctionGoodsDomain> atAuctionGoodsList) {
        if (null == atAuctionGinfoDomain || ListUtil.isEmpty(atAuctionGoodsList)) {
            return;
        }
        BigDecimal goodsnpirce = new BigDecimal(0);
        BigDecimal goodsweight = new BigDecimal(0);
        BigDecimal goodsprice = new BigDecimal(0);
        String partsnameWeightunit = null;
        for (AtAuctionGoodsDomain atAuctionGoodsDomain : atAuctionGoodsList) {
            goodsprice = goodsprice.add(atAuctionGoodsDomain.getGoodsSupplyweight().multiply(atAuctionGoodsDomain.getPricesetNprice()));
            goodsweight = goodsweight.add(atAuctionGoodsDomain.getGoodsSupplyweight());
            partsnameWeightunit = atAuctionGoodsDomain.getPartsnameWeightunit();
        }
        goodsnpirce = goodsnpirce.add(goodsprice.divide(goodsweight, 2));
        atAuctionGinfoDomain.setPricesetNprice(goodsnpirce);
        atAuctionGinfoDomain.setGoodsSupplyweight(goodsweight);
        atAuctionGinfoDomain.setPricesetPrefprice(goodsprice);
        atAuctionGinfoDomain.setPartsnameWeightunit(partsnameWeightunit);
    }

    @RequestMapping(value={"saveAuctionForPaas.json"}, name="\u589e\u52a0\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveAuctionForPaas(HttpServletRequest request, AtAuctionDomain atAuctionDomain) {
        String flag = this.dataCollation(request, atAuctionDomain);
        if ("error".equals(flag)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
        }
        return this.atAuctionServiceRepository.saveatAuction(atAuctionDomain);
    }

    @RequestMapping(value={"getAuctionForPaas.json"}, name="\u83b7\u53d6\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public AtAuctionReDomain getAuctionForPaas(Integer auctionId) {
        if (StringUtils.isBlank((Integer)auctionId)) {
            this.logger.error(CODE + ".getAuction", (Object)"auctionId is null");
            return null;
        }
        return this.atAuctionServiceRepository.getatAuction(auctionId);
    }

    @RequestMapping(value={"updateAuctionForPaas.json"}, name="\u66f4\u65b0\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateAuctionForPaas(HttpServletRequest request, AtAuctionDomain atAuctionDomain) {
        String flag = this.dataCollation(request, atAuctionDomain);
        if ("error".equals(flag)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
        }
        return this.atAuctionServiceRepository.updateatAuction(atAuctionDomain);
    }

    @RequestMapping(value={"deleteAuctionForPaas.json"}, name="\u5220\u9664\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionForPaas(String auctionId) {
        String[] auctions;
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionId.split(",")) {
            AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            if (atAuctionReDomain.getDataState() != 2) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53ea\u80fd\u5728\u7ec8\u6b62\u72b6\u6001\u624d\u80fd\u5220\u9664");
            }
            this.atAuctionServiceRepository.deleteatAuction(Integer.valueOf(str));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"deleteAuctionRevokeForPaas.json"}, name="\u64a4\u9500")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionRevokeForPaas(String auctionId) {
        AtAuctionReDomain atAuctionReDomain;
        String[] auctions;
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"auctionId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionId.split(",")) {
            atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            if (atAuctionReDomain.getDataState() == 1 || atAuctionReDomain.getDataState() == 0) continue;
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9009\u53d6\u53ea\u80fd\u4e3a\u65b0\u589e\u548c\u5df2\u53d1\u5e03\u7684\u4fe1\u606f");
        }
        for (String str : auctions) {
            atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(str), Integer.valueOf(2), atAuctionReDomain.getDataState(), null);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"queryAuctionPageForPaas.json"}, name="\u67e5\u8be2\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPageForPaas(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"updateAuctionStateForPaas.json"}, name="\u66f4\u65b0\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAuctionStateForPaas(String auctionId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.atAuctionServiceRepository.updateatAuctionFileState(Integer.valueOf(auctionId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"updateAcutionReleaseForPaas.json"}, name="\u91cd\u65b0\u53d1\u5e03")
    @ResponseBody
    public HtmlJsonReBean updateAcutionReleaseForPaas(String auctionId) {
        if (StringUtils.isBlank((String)auctionId)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "auctionId is null");
        }
        return this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(auctionId), Integer.valueOf(0), Integer.valueOf(2), null);
    }

    @RequestMapping(value={"queryAuctionPageNoticeForPaas.json"}, name="\u53ea\u67e5\u8be2\u9884\u544a\u4fe1\u606f\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPageNoticeForPaas(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("auctionType", "00");
        }
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"deleteAuctionsForPaas.json"}, name="\u5220\u9664\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionsForPaas(String auctionId) {
        String[] auctions;
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionId.split(",")) {
            AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            if (atAuctionReDomain.getDataState() != 2) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53ea\u80fd\u5728\u7ec8\u6b62\u72b6\u6001\u624d\u80fd\u5220\u9664");
            }
            this.atAuctionServiceRepository.deleteatAuction(Integer.valueOf(str));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateAuctionTerminationForPaas.json"}, name="\u64a4\u9500--\u516c\u544a")
    @ResponseBody
    public HtmlJsonReBean updateAuctionTerminationForPaas(String auctionId) {
        AtAuctionReDomain atAuctionReDomain;
        String[] auctions;
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"auctionId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionId.split(",")) {
            atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            if (atAuctionReDomain.getDataState() == 1 || atAuctionReDomain.getDataState() == 0) continue;
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53d1\u5e03\uff0c\u65b0\u589e\u72b6\u6001\u624d\u80fd\u64a4\u9500");
        }
        for (String str : auctions) {
            atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(str), Integer.valueOf(2), atAuctionReDomain.getDataState(), null);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateAuctionTerminationForAtPaas.json"}, name="\u7ec8\u6b62-\u516c\u544a")
    @ResponseBody
    public HtmlJsonReBean updateAuctionTerminationForAtPaas(String auctionStr) {
        if (StringUtils.isBlank((String)auctionStr)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"auctionId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ArrayList<AtAuctionReDomain> atAuctionReDomains = new ArrayList<AtAuctionReDomain>();
        String[] auctions = auctionStr.split(",");
        for (String str : auctions) {
            AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            Date date = new Date();
            if (atAuctionReDomain.getAuctionSdate().getTime() > date.getTime()) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53ea\u80fd\u5728\u516c\u544a\u5f00\u59cb\u7684\u65f6\u5019\u624d\u80fd\u7ec8\u6b62\uff01");
            }
            atAuctionReDomains.add(atAuctionReDomain);
        }
        for (AtAuctionReDomain atAuctionReDomain : atAuctionReDomains) {
            this.atAuctionServiceRepository.updateatAuctionState(atAuctionReDomain.getAuctionId(), Integer.valueOf(2), atAuctionReDomain.getDataState(), null);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"saveAuctionGinfoForPaas.json"}, name="\u4fdd\u5b58\u5305\u88f9\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveAuctionGinfoForPaas(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "paramStr is null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        AtAuctionGoodsDomain atAuctionGoodsDomain = null;
        ArrayList<AtAuctionGoodsDomain> atAuctionGoodsList = null;
        HashMap<String, String> map = null;
        List AtAuctionGinfoDomain2 = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, AtAuctionGinfoDomain.class);
        for (AtAuctionGinfoDomain atAuctionGinfoDomain : AtAuctionGinfoDomain2) {
            atAuctionGinfoDomain.setMemberCode(userSession.getUserPcode());
            atAuctionGinfoDomain.setMemberName(userSession.getUserName());
            atAuctionGinfoDomain.setTenantCode(this.getTenantCode(request));
            String[] goodsCode = atAuctionGinfoDomain.getAtAuctionGoodsJson().split(",");
            atAuctionGoodsList = new ArrayList<AtAuctionGoodsDomain>();
            for (String str : goodsCode) {
                atAuctionGoodsDomain = new AtAuctionGoodsDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)atAuctionGoodsDomain, (Object)atAuctionGinfoDomain);
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".saveatAuctionGinfoBatch", (Throwable)e);
                }
                map = new HashMap<String, String>();
                map.put("goodsCode", str);
                map.put("tenantCode", atAuctionGinfoDomain.getTenantCode());
                map.put("unwantedRelatedData", "unwantedRelatedData");
                RsResourceGoodsReDomain resourceGoods = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
                try {
                    BeanUtils.copyAllPropertys((Object)atAuctionGoodsDomain, (Object)resourceGoods);
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".saveatAuctionGinfoBatch", (Throwable)e);
                }
                atAuctionGoodsList.add(atAuctionGoodsDomain);
            }
            this.calculation(atAuctionGinfoDomain, atAuctionGoodsList);
            atAuctionGinfoDomain.setAtAuctionGoodsDomain(atAuctionGoodsList);
        }
        return this.atAuctionServiceRepository.saveatAuctionGinfoBatch(AtAuctionGinfoDomain2);
    }

    @RequestMapping(value={"getAuctionGinfoForPaasForPaas.json"}, name="\u83b7\u53d6\u5305\u88f9\u4fe1\u606f")
    @ResponseBody
    public AtAuctionGinfoReDomain getAuctionGinfoForPaas(HttpServletRequest request, String auctionGinfCode) {
        if (StringUtils.isBlank((String)auctionGinfCode)) {
            this.logger.error(CODE + ".getAuction", (Object)"auctionId is null");
            return null;
        }
        return this.atAuctionServiceRepository.getatAuctionGinfoByCode(this.getTenantCode(request), auctionGinfCode);
    }

    @RequestMapping(value={"queryAuctionGinfoForPaas.json"}, name="\u67e5\u770b\u7ade\u4ef7\u8be6\u60c5--\u516c\u544a\u9875\u9762")
    @ResponseBody
    public SupQueryResult<AtAuctionGinfoReDomain> queryAuctionGinfoForPaas(HttpServletRequest request, String auctionCode) {
        if (StringUtils.isBlank((String)auctionCode)) {
            this.logger.error(CODE + ".getAuction", (Object)"auctionId is null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auctionCode", auctionCode);
        map.put("tenantCode", this.getTenantCode(request));
        SupQueryResult atAuctionGinfoReDomainSupQueryResult = this.atAuctionServiceRepository.queryatAuctionGinfoPage(map);
        return atAuctionGinfoReDomainSupQueryResult;
    }

    @RequestMapping(value={"updateAcutionReleasesForPaas.json"}, name="\u91cd\u65b0\u53d1\u5e03--\u516c\u544a")
    @ResponseBody
    public HtmlJsonReBean updateAcutionReleasesForPaas(String auctionId) {
        if (StringUtils.isBlank((String)auctionId)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "auctionId is null");
        }
        return this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(auctionId), Integer.valueOf(0), Integer.valueOf(2), null);
    }

    @RequestMapping(value={"saveAuctionItemsForPaas.json"}, name="\u589e\u52a0\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveAuctionItemsForPaas(HttpServletRequest request, AtAuctionDomain atAuctionDomain) {
        String flag = this.dataCollation(request, atAuctionDomain);
        if ("error".equals(flag)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
        }
        atAuctionDomain.setAuctionruleScope("1");
        return this.atAuctionServiceRepository.saveatAuction(atAuctionDomain);
    }

    @RequestMapping(value={"updateAuctionItemsForPaas.json"}, name="\u66f4\u65b0\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateAuctionItemsForPaas(HttpServletRequest request, AtAuctionDomain atAuctionDomain) {
        String flag = this.dataCollation(request, atAuctionDomain);
        if ("error".equals(flag)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
        }
        return this.atAuctionServiceRepository.updateatAuction(atAuctionDomain);
    }

    @RequestMapping(value={"getAuctionItemsForPaas.json"}, name="\u83b7\u53d6\u5355\u54c1")
    @ResponseBody
    public AtAuctionReDomain getAuctionItemsForPaas(Integer auctionId) {
        if (StringUtils.isBlank((Integer)auctionId)) {
            this.logger.error(CODE + ".getAuction", (Object)"auctionId is null");
            return null;
        }
        return this.atAuctionServiceRepository.getatAuction(auctionId);
    }

    @RequestMapping(value={"deleteAuctionsItemsForPaas.json"}, name="\u5220\u9664\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionsItemsForPaas(String auctionId) {
        String[] auctions;
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionId.split(",")) {
            AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            if (atAuctionReDomain.getDataState() != 2) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53ea\u80fd\u5728\u7ec8\u6b62\u72b6\u6001\u624d\u80fd\u5220\u9664");
            }
            this.atAuctionServiceRepository.deleteatAuction(Integer.valueOf(str));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateAcutionReleasesItemsForPaas.json"}, name="\u91cd\u65b0\u53d1\u5e03-\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateAcutionReleasesItemsForPaas(String auctionId) {
        if (StringUtils.isBlank((String)auctionId)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "auctionId is null");
        }
        return this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(auctionId), Integer.valueOf(0), Integer.valueOf(2), null);
    }

    @RequestMapping(value={"updateAcutionUpForPaas.json"}, name="\u91cd\u65b0\u4e0a\u67b6-\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateAcutionUpForPaas(String auctionId) {
        if (StringUtils.isBlank((String)auctionId)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "auctionId is null");
        }
        AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(auctionId));
        return this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(auctionId), Integer.valueOf(1), atAuctionReDomain.getDataState(), null);
    }

    @RequestMapping(value={"queryAuctionGinfoItemsForPaas.json"}, name="\u67e5\u770b\u7ade\u4ef7\u8be6\u60c5--\u5355\u54c1\u9875\u9762")
    @ResponseBody
    public SupQueryResult<AtAuctionGinfoReDomain> queryAuctionGinfoItemsForPaas(HttpServletRequest request, String auctionCode) {
        if (StringUtils.isBlank((String)auctionCode)) {
            this.logger.error(CODE + ".getAuction", (Object)"auctionId is null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auctionCode", auctionCode);
        map.put("tenantCode", this.getTenantCode(request));
        SupQueryResult atAuctionGinfoReDomainSupQueryResult = this.atAuctionServiceRepository.queryatAuctionGinfoPage(map);
        return atAuctionGinfoReDomainSupQueryResult;
    }

    @RequestMapping(value={"queryAuctionGinfoPageItemsForPaas.json"}, name="\u53ea\u67e5\u8be2\u5355\u54c1\u4fe1\u606f\u5217\u8868")
    @ResponseBody
    public List<AtAuctionGinfoReDomain> queryAuctionGinfoPageItemsForPaas(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("auctionType", "01");
        param.put("auctionruleScope", "1");
        ArrayList<AtAuctionGinfoReDomain> atAuctionGinfoReDomains = new ArrayList<AtAuctionGinfoReDomain>();
        HashMap<String, String> map = new HashMap<String, String>();
        List list = this.atAuctionServiceRepository.queryatAuctionPage(param).getList();
        for (AtAuctionReDomain atAuctionReDomain : list) {
            map.put("auctionCode", atAuctionReDomain.getAuctionCode());
            map.put("tenantCode", atAuctionReDomain.getTenantCode());
            List auctionGinfoReDomains = this.atAuctionServiceRepository.queryatAuctionGinfoPage(map).getList();
            atAuctionGinfoReDomains.addAll(auctionGinfoReDomains);
        }
        return atAuctionGinfoReDomains;
    }

    @RequestMapping(value={"updateAuctionGinfoItemsForPaas.json"}, name="\u66f4\u65b0\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateAuctionGinfoItemsForPaas(AtAuctionGinfoDomain atAuctionGinfoDomain) {
        if (null == atAuctionGinfoDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u6709\u8bef");
        }
        this.atAuctionServiceRepository.deleteatAuctionGinfo(atAuctionGinfoDomain.getAuctionGinfoId());
        AtAuctionGoodsDomain atAuctionGoodsDomain = null;
        ArrayList<AtAuctionGoodsDomain> atAuctionGoodsList = null;
        HashMap<String, String> map = null;
        String[] goodsCode = atAuctionGinfoDomain.getAtAuctionGoodsJson().split(",");
        atAuctionGoodsList = new ArrayList<AtAuctionGoodsDomain>();
        for (String str : goodsCode) {
            atAuctionGoodsDomain = new AtAuctionGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)atAuctionGoodsDomain, (Object)atAuctionGinfoDomain);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".saveAuction:2", (Throwable)e);
            }
            map = new HashMap<String, String>();
            map.put("goodsCode", str);
            map.put("tenantCode", atAuctionGinfoDomain.getTenantCode());
            map.put("unwantedRelatedData", "unwantedRelatedData");
            RsResourceGoodsReDomain resourceGoods = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
            try {
                BeanUtils.copyAllPropertys((Object)atAuctionGoodsDomain, (Object)resourceGoods);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".saveAuction:3", (Throwable)e);
            }
            atAuctionGoodsList.add(atAuctionGoodsDomain);
        }
        this.calculation(atAuctionGinfoDomain, atAuctionGoodsList);
        atAuctionGinfoDomain.setAtAuctionGoodsDomain(atAuctionGoodsList);
        ArrayList<AtAuctionGinfoDomain> atAuctionGinfoDomainList = new ArrayList<AtAuctionGinfoDomain>();
        atAuctionGinfoDomainList.add(atAuctionGinfoDomain);
        return this.atAuctionServiceRepository.saveatAuctionGinfoBatch(atAuctionGinfoDomainList);
    }

    @RequestMapping(value={"deleteAuctionGinfoItemsForPaas.json"}, name="\u5220\u9664\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionGinfoItemsForPaas(String auctionGinfoId) {
        String[] auctions;
        if (StringUtils.isBlank((String)auctionGinfoId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionGinfoId.split(",")) {
            this.atAuctionServiceRepository.deleteatAuctionGinfo(Integer.valueOf(str));
        }
        return new HtmlJsonReBean();
    }
}

