/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.at.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionPriceDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionPriceReDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionReDomain;
import com.qjsoft.laser.controller.facade.at.domain.PriceBigDataReDomain;
import com.qjsoft.laser.controller.facade.at.repository.AtAuctionPriceServiceRepository;
import com.qjsoft.laser.controller.facade.at.repository.AtAuctionServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/at/auctionPrice"}, name="\u7ade\u4ef7\u51fa\u4ef7\u6d41\u6c34")
public class AuctionPriceCon
extends SpringmvcController {
    private static String CODE = "at.auctionPrice.con";
    @Autowired
    private AtAuctionPriceServiceRepository atAuctionPriceServiceRepository;
    @Autowired
    private AtAuctionServiceRepository atAuctionServiceRepository;

    protected String getContext() {
        return "auctionPrice";
    }

    @RequestMapping(value={"saveAuctionPrice.json"}, name="\u589e\u52a0\u7ade\u4ef7\u51fa\u4ef7\u6d41\u6c34")
    @ResponseBody
    public HtmlJsonReBean saveAuctionPrice(HttpServletRequest request, AtAuctionPriceDomain atAuctionPriceDomain) {
        if (null == atAuctionPriceDomain) {
            this.logger.error(CODE + ".saveAuctionPrice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveAuctionPrice", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        atAuctionPriceDomain.setMemberBcode(userSession.getUserPcode());
        atAuctionPriceDomain.setMemberBname(userSession.getMerberCompname());
        atAuctionPriceDomain.setUserCode(userSession.getUserCode());
        atAuctionPriceDomain.setUserName(userSession.getUserName());
        atAuctionPriceDomain.setTenantCode(this.getTenantCode(request));
        HtmlJsonReBean htmlJsonReBean = this.atAuctionPriceServiceRepository.saveatAuctionPrice(atAuctionPriceDomain);
        if ("success".equals(htmlJsonReBean.getDataObj())) {
            new HtmlJsonReBean((Object)"\u64cd\u4f5c\u6210\u529f");
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"getAuctionPrice.json"}, name="\u83b7\u53d6\u7ade\u4ef7\u51fa\u4ef7\u6d41\u6c34\u4fe1\u606f")
    @ResponseBody
    public AtAuctionPriceReDomain getAuctionPrice(Integer auctionPriceId) {
        if (StringUtils.isBlank((Integer)auctionPriceId)) {
            this.logger.error(CODE + ".getAuctionPrice", (Object)"param is null");
            return null;
        }
        return this.atAuctionPriceServiceRepository.getatAuctionPrice(auctionPriceId);
    }

    @RequestMapping(value={"updateAuctionPrice.json"}, name="\u66f4\u65b0\u7ade\u4ef7\u51fa\u4ef7\u6d41\u6c34")
    @ResponseBody
    public HtmlJsonReBean updateAuctionPrice(HttpServletRequest request, AtAuctionPriceDomain atAuctionPriceDomain) {
        if (null == atAuctionPriceDomain) {
            this.logger.error(CODE + ".updateAuctionPrice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        atAuctionPriceDomain.setTenantCode(this.getTenantCode(request));
        return this.atAuctionPriceServiceRepository.updateatAuctionPrice(atAuctionPriceDomain);
    }

    @RequestMapping(value={"deleteAuctionPrice.json"}, name="\u5220\u9664\u7ade\u4ef7\u51fa\u4ef7\u6d41\u6c34")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionPrice(Integer auctionPriceId) {
        if (StringUtils.isBlank((Integer)auctionPriceId)) {
            this.logger.error(CODE + ".deleteAuctionPrice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.atAuctionPriceServiceRepository.deleteatAuctionPrice(auctionPriceId);
    }

    @RequestMapping(value={"queryAuctionPricePage.json"}, name="\u67e5\u8be2\u7ade\u4ef7\u51fa\u4ef7\u6d41\u6c34\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionPriceReDomain> queryAuctionPricePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.atAuctionPriceServiceRepository.queryatAuctionPricePage(param);
    }

    @RequestMapping(value={"updateAuctionPriceState.json"}, name="\u66f4\u65b0\u7ade\u4ef7\u51fa\u4ef7\u6d41\u6c34\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAuctionPriceState(String auctionPriceId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)auctionPriceId)) {
            this.logger.error(CODE + ".updateAuctionPriceState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.atAuctionPriceServiceRepository.updateatAuctionPriceState(Integer.valueOf(auctionPriceId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryofferInfo.json"}, name="\u67e5\u8be2\u51fa\u4ef7\u4fe1\u606f")
    @ResponseBody
    public SupQueryResult<AtAuctionPriceReDomain> queryofferInfo(HttpServletRequest request, String auctionCode, String auctionGinfoCode) {
        SupQueryResult atAuctionPriceReDomainSupQueryResult;
        if (StringUtils.isBlank((String)auctionCode) || StringUtils.isBlank((String)auctionGinfoCode)) {
            this.logger.error(CODE + ".queryofferInfo", (Object)"param is null");
            return null;
        }
        Map param = this.assemMapParam(request);
        param.put("auctionCode", auctionCode);
        param.put("auctionGinfoCode", auctionGinfoCode);
        AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuctionByCode(this.getTenantCode(request), auctionCode);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (ListUtil.isEmpty((Collection)(atAuctionPriceReDomainSupQueryResult = this.atAuctionPriceServiceRepository.queryatAuctionPricePage(param)).getList())) {
            this.logger.error(CODE + ".atAuctionPriceReDomainSupQueryResult", (Object)"param is null");
            return null;
        }
        for (AtAuctionPriceReDomain atAuctionPriceReDomain : atAuctionPriceReDomainSupQueryResult.getList()) {
            if (atAuctionReDomain.getDataState() == 2) continue;
            StringBuffer memberName = new StringBuffer();
            String memberName1 = atAuctionPriceReDomain.getMemberBname();
            int length = 0;
            if (StringUtils.isNotBlank((String)memberName1)) {
                length = memberName1.length();
            }
            for (int i = 0; i <= length; ++i) {
                memberName.append("*");
            }
            atAuctionPriceReDomain.setMemberBname(memberName.toString());
            if (!atAuctionReDomain.getAuctionruleType().equals("0")) continue;
            atAuctionPriceReDomain.setAuctionPriceAmount(null);
            atAuctionPriceReDomain.setAuctionPriceOld(null);
        }
        return atAuctionPriceReDomainSupQueryResult;
    }

    @RequestMapping(value={"queryPositiveJJPriceBigData.json"}, name="\u67e5\u8be2\u6b63\u5411\u7ade\u4ef7\u6ea2\u4ef7\u6570\u636e")
    @ResponseBody
    public List<PriceBigDataReDomain> queryJJPriceBigData(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        param.put("auctionPriceType", "1");
        return this.atAuctionPriceServiceRepository.queryJJPriceBigData(param);
    }

    @RequestMapping(value={"queryReverseJJPriceBigData.json"}, name="\u67e5\u8be2\u53cd\u5411\u7ade\u4ef7\u6ea2\u4ef7\u6570\u636e")
    @ResponseBody
    public List<PriceBigDataReDomain> queryReverseJJPriceBigData(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        param.put("auctionPriceType", "-1");
        return this.atAuctionPriceServiceRepository.queryJJPriceBigData(param);
    }
}

