/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.at.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionEnrollDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionEnrollReDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionFileDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionGinfoDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionGinfoReDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionGoodsDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionGoodsReDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionMemDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionMemReDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionPriceReDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionReDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctiondtReDomain;
import com.qjsoft.laser.controller.facade.at.domain.AuctionGinfoBean;
import com.qjsoft.laser.controller.facade.at.domain.DdFalgSettingReDomain;
import com.qjsoft.laser.controller.facade.at.repository.AtAuctionEnrollServiceRepository;
import com.qjsoft.laser.controller.facade.at.repository.AtAuctionPriceServiceRepository;
import com.qjsoft.laser.controller.facade.at.repository.AtAuctionServiceRepository;
import com.qjsoft.laser.controller.facade.at.repository.AtAuctionUserginfoServiceRepository;
import com.qjsoft.laser.controller.facade.at.repository.AtAuctiondtServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmGroupListReDomain;
import com.qjsoft.laser.controller.facade.um.repository.UmGroupServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/at/auction"}, name="\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
public class AuctionCon
extends SpringmvcController {
    private static String CODE = "at.auction.con";
    @Autowired
    private AtAuctionServiceRepository atAuctionServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;
    @Autowired
    private AtAuctionPriceServiceRepository atAuctionPriceServiceRepository;
    @Autowired
    private AtAuctionEnrollServiceRepository atAuctionEnrollServiceRepository;
    @Autowired
    private AtAuctionUserginfoServiceRepository atAuctionUserginfoServiceRepository;
    @Autowired
    private AtAuctiondtServiceRepository atAuctiondtServiceRepository;
    @Autowired
    private UmGroupServiceRepository umGroupServiceRepository;
    @Autowired
    private OcContractServiceRepository ocContractServiceRepository;

    protected String getContext() {
        return "auction";
    }

    @RequestMapping(value={"saveAuction.json"}, name="\u589e\u52a0\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveAuction(HttpServletRequest request, AtAuctionDomain atAuctionDomain) {
        long start = System.currentTimeMillis();
        String flag = this.dataCollation(request, atAuctionDomain);
        this.logger.error("atAuctionDomain=====", (Object)atAuctionDomain.toString());
        this.logger.error(CODE + ".saveAuction.json.dataCollation\u8017\u65f6\uff1a", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        if ("error".equals(flag)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
        }
        HtmlJsonReBean htmlJsonReBean = this.atAuctionServiceRepository.saveatAuction(atAuctionDomain);
        this.logger.error(CODE + ".saveAuction.json.saveatAuction\u8017\u65f6\uff1a", (Object)(System.currentTimeMillis() - start));
        return htmlJsonReBean;
    }

    @RequestMapping(value={"saveAuctionByJson.json"}, name="\u589e\u52a0\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveAuctionByJson(HttpServletRequest request, String atAuctionDomainStr) {
        if (StringUtils.isBlank((String)atAuctionDomainStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null");
        }
        AtAuctionDomain atAuctionDomain = (AtAuctionDomain)JsonUtil.buildNormalBinder().getJsonToObject(atAuctionDomainStr, AtAuctionDomain.class);
        String flag = this.dataCollation(request, atAuctionDomain);
        if ("error".equals(flag)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
        }
        return this.atAuctionServiceRepository.saveatAuction(atAuctionDomain);
    }

    @RequestMapping(value={"getAuction.json"}, name="\u83b7\u53d6\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public AtAuctionReDomain getAuction(Integer auctionId) {
        if (StringUtils.isBlank((Integer)auctionId)) {
            this.logger.error(CODE + ".getAuction", (Object)"auctionId is null");
            return null;
        }
        return this.atAuctionServiceRepository.getatAuction(auctionId);
    }

    @RequestMapping(value={"updateAuction.json"}, name="\u66f4\u65b0\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateAuction(HttpServletRequest request, AtAuctionDomain atAuctionDomain) {
        String flag = this.dataCollation(request, atAuctionDomain);
        if ("error".equals(flag)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
        }
        return this.atAuctionServiceRepository.updateatAuction(atAuctionDomain);
    }

    @RequestMapping(value={"updateAuctionByJson.json"}, name="\u66f4\u65b0\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateAuctionByJson(HttpServletRequest request, String atAuctionDomainStr) {
        if (StringUtils.isBlank((String)atAuctionDomainStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null");
        }
        AtAuctionDomain atAuctionDomain = (AtAuctionDomain)JsonUtil.buildNormalBinder().getJsonToObject(atAuctionDomainStr, AtAuctionDomain.class);
        String flag = this.dataCollation(request, atAuctionDomain);
        if ("error".equals(flag)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
        }
        return this.atAuctionServiceRepository.updateatAuction(atAuctionDomain);
    }

    @RequestMapping(value={"deleteAuction.json"}, name="\u5220\u9664\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteAuction(String auctionId) {
        String[] auctions;
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionId.split(",")) {
            AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            this.atAuctionServiceRepository.deleteatAuction(Integer.valueOf(str));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"deleteAuctionRevoke.json"}, name="\u64a4\u9500")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionRevoke(String auctionId) {
        AtAuctionReDomain atAuctionReDomain;
        String[] auctions;
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"auctionId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionId.split(",")) {
            atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            if (atAuctionReDomain.getDataState() == 1 || atAuctionReDomain.getDataState() == 0) continue;
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9009\u53d6\u53ea\u80fd\u4e3a\u65b0\u589e\u7684\u4fe1\u606f");
        }
        for (String str : auctions) {
            atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(str), Integer.valueOf(3), atAuctionReDomain.getDataState(), null);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"deleteAuctionByCode.json"}, name="\u6839\u636ecode\u5220\u9664\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteAuction(HttpServletRequest request, String auctionCode) {
        if (StringUtils.isBlank((String)auctionCode)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"auctionCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuctionByCode(this.getTenantCode(request), auctionCode);
        if (atAuctionReDomain.getDataState() != 2) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53ea\u80fd\u5728\u7ec8\u6b62\u72b6\u6001\u624d\u80fd\u5220\u9664");
        }
        return this.atAuctionServiceRepository.deleteatAuctionByCode(this.getTenantCode(request), auctionCode);
    }

    @RequestMapping(value={"queryAuctionPage.json"}, name="\u67e5\u8be2\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("fuzzy", true);
        }
        param.put("order", true);
        String auctionType = (String)param.get("auctionType");
        if ("01".equals(auctionType)) {
            param.put("orderStr", "AUCTION_EDATE DESC");
        }
        SupQueryResult atAuctionReDomainSupQueryResult = this.atAuctionServiceRepository.queryatAuctionPage(param);
        return atAuctionReDomainSupQueryResult;
    }

    @RequestMapping(value={"queryAuctionPageForAt.json"}, name="\u67e5\u8be2\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f\u5206\u9875\u5217\u8868-\u81ea\u5df1\u770b\u81ea\u5df1")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPageForAt(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("fuzzy", true);
        }
        param.put("order", true);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        param.put("memberCode", userSession.getUserPcode());
        SupQueryResult atAuctionReDomainSupQueryResult = this.atAuctionServiceRepository.queryatAuctionPage(param);
        return atAuctionReDomainSupQueryResult;
    }

    @RequestMapping(value={"updateAuctionState.json"}, name="\u66f4\u65b0\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAuctionState(String auctionId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.atAuctionServiceRepository.updateatAuctionFileState(Integer.valueOf(auctionId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryAuctionMemPage.json"}, name="\u67e5\u8be2\u5206\u7ec4\u4fe1\u606f")
    @ResponseBody
    public SupQueryResult<AtAuctionMemReDomain> queryAuctionMemPage(HttpServletRequest request, String auctionCode) {
        if (StringUtils.isBlank((String)auctionCode)) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.atAuctionServiceRepository.queryatAuctionMemPage(param);
    }

    @RequestMapping(value={"updateAcutionRelease.json"}, name="\u91cd\u65b0\u53d1\u5e03")
    @ResponseBody
    public HtmlJsonReBean updateAcutionRelease(String auctionId) {
        if (StringUtils.isBlank((String)auctionId)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "auctionId is null");
        }
        return this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(auctionId), Integer.valueOf(0), Integer.valueOf(2), null);
    }

    @RequestMapping(value={"queryAuctionPageNotice.json"}, name="\u53ea\u67e5\u8be2\u9884\u544a\u4fe1\u606f\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPageNotice(HttpServletRequest request) {
        UserSession userSession;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("auctionType", "00");
            param.put("dataState", "0");
        }
        if (null == (userSession = this.getUserSession(request))) {
            return null;
        }
        if (StringUtils.isBlank((String)((String)param.get("memberCode")))) {
            param.put("memberCode", userSession.getUserPcode());
        }
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"deleteAuctions.json"}, name="\u5220\u9664\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteAuctions(String auctionId) {
        String[] auctions;
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionId.split(",")) {
            AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            this.atAuctionServiceRepository.deleteatAuction(Integer.valueOf(str));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateAuctionTermination.json"}, name="\u64a4\u9500--\u516c\u544a")
    @ResponseBody
    public HtmlJsonReBean updateAuctionTermination(String auctionId) {
        AtAuctionReDomain atAuctionReDomain;
        String[] auctions;
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"auctionId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionId.split(",")) {
            atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            if (atAuctionReDomain.getDataState() == 0) continue;
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u65b0\u589e\u72b6\u6001\u624d\u80fd\u64a4\u9500");
        }
        for (String str : auctions) {
            atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(str), Integer.valueOf(3), atAuctionReDomain.getDataState(), null);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateAuctionTerminationForAt.json"}, name="\u7ec8\u6b62-\u516c\u544a")
    @ResponseBody
    public HtmlJsonReBean updateAuctionTerminationForAt(String auctionStr) {
        String[] auctions;
        if (StringUtils.isBlank((String)auctionStr)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"auctionId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ArrayList<AtAuctionReDomain> atAuctionReDomains = new ArrayList<AtAuctionReDomain>();
        for (String str : auctions = auctionStr.split(",")) {
            AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            Date date = new Date();
            if (atAuctionReDomain.getAuctionSdate().getTime() > date.getTime()) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53ea\u80fd\u5728\u516c\u544a\u5f00\u59cb\u7684\u65f6\u5019\u624d\u80fd\u7ec8\u6b62\uff01");
            }
            atAuctionReDomains.add(atAuctionReDomain);
        }
        for (AtAuctionReDomain atAuctionReDomain : atAuctionReDomains) {
            this.atAuctionServiceRepository.updateatAuctionState(atAuctionReDomain.getAuctionId(), Integer.valueOf(2), atAuctionReDomain.getDataState(), null);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"saveAuctionGinfo.json"}, name="\u4fdd\u5b58\u5305\u88f9\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveAuctionGinfo(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "paramStr is null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        AtAuctionGoodsDomain atAuctionGoodsDomain = null;
        ArrayList<AtAuctionGoodsDomain> atAuctionGoodsList = null;
        HashMap<String, String> map = null;
        List AtAuctionGinfoDomain2 = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, AtAuctionGinfoDomain.class);
        for (AtAuctionGinfoDomain atAuctionGinfoDomain : AtAuctionGinfoDomain2) {
            atAuctionGinfoDomain.setMemberCode(userSession.getUserPcode());
            atAuctionGinfoDomain.setMemberName(userSession.getUserName());
            atAuctionGinfoDomain.setTenantCode(this.getTenantCode(request));
            String[] skuCode = atAuctionGinfoDomain.getAtAuctionGoodsJson().split(",");
            atAuctionGoodsList = new ArrayList<AtAuctionGoodsDomain>();
            for (String str : skuCode) {
                atAuctionGoodsDomain = new AtAuctionGoodsDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)atAuctionGoodsDomain, (Object)atAuctionGinfoDomain);
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".saveatAuctionGinfoBatch", (Throwable)e);
                }
                HashMap<String, String> maps = new HashMap<String, String>();
                maps.put("goodsCode", str);
                maps.put("tenantCode", atAuctionGinfoDomain.getTenantCode());
                maps.put("unwantedRelatedData", "unwantedRelatedData");
                RsResourceGoodsReDomain resourceGoods = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(maps);
                if (null == resourceGoods) continue;
                map = new HashMap<String, String>();
                map.put("goodsCode", resourceGoods.getGoodsCode());
                map.put("tenantCode", atAuctionGinfoDomain.getTenantCode());
                RsSkuDomain rsSkuDomain = this.rsSkuServiceRepository.getSkuDomainByCode(map);
                if (null == rsSkuDomain) continue;
                try {
                    BeanUtils.copyAllPropertys((Object)atAuctionGoodsDomain, (Object)rsSkuDomain);
                    atAuctionGoodsDomain.setWarehouseCode(resourceGoods.getWarehouseCode());
                    atAuctionGoodsDomain.setWarehouseName(resourceGoods.getWarehouseName());
                    atAuctionGoodsDomain.setGoodsSupplyweight(rsSkuDomain.getGoodsSupplyweight());
                    atAuctionGoodsDomain.setGoodsSpec(rsSkuDomain.getSkuName());
                    atAuctionGoodsDomain.setGoodsProperty5(resourceGoods.getGoodsProperty5());
                    atAuctionGoodsDomain.setGoodsRemark(resourceGoods.getGoodsRemark());
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".saveatAuctionGinfoBatch", (Throwable)e);
                }
                atAuctionGoodsList.add(atAuctionGoodsDomain);
            }
            this.calculation(atAuctionGinfoDomain, atAuctionGoodsList);
            atAuctionGinfoDomain.setGinfofalg(Boolean.valueOf(false));
            atAuctionGinfoDomain.setAtAuctionGoodsDomain(atAuctionGoodsList);
        }
        return this.atAuctionServiceRepository.saveatAuctionGinfoBatch(AtAuctionGinfoDomain2);
    }

    @RequestMapping(value={"getAuctionGinfo.json"}, name="\u83b7\u53d6\u5305\u88f9\u4fe1\u606f")
    @ResponseBody
    public AtAuctionGinfoReDomain getAuctionGinfo(HttpServletRequest request, String auctionGinfCode) {
        if (StringUtils.isBlank((String)auctionGinfCode)) {
            this.logger.error(CODE + ".getAuctionGinfo", (Object)"auctionId is null");
            return null;
        }
        return this.atAuctionServiceRepository.getatAuctionGinfoByCode(this.getTenantCode(request), auctionGinfCode);
    }

    @RequestMapping(value={"queryAuctionGinfo.json"}, name="\u67e5\u770b\u7ade\u4ef7\u8be6\u60c5--\u516c\u544a\u9875\u9762")
    @ResponseBody
    public SupQueryResult<AtAuctionGinfoReDomain> queryAuctionGinfo(HttpServletRequest request, String auctionCode) {
        if (StringUtils.isBlank((String)auctionCode)) {
            this.logger.error(CODE + ".queryAuctionGinfo", (Object)"auctionId is null");
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("auctionCode", auctionCode);
            param.put("tenantCode", this.getTenantCode(request));
            param.put("order", true);
            param.put("orderStr", "GOODS_SORT ASC");
        }
        SupQueryResult<AtAuctionGinfoReDomain> atAuctionGinfoReDomainSupQueryResult = this.getAtAuctionGinfoReDomainSupQueryResult(param);
        return atAuctionGinfoReDomainSupQueryResult;
    }

    private SupQueryResult<AtAuctionGinfoReDomain> getAtAuctionGinfoReDomainSupQueryResult(Map<String, Object> map) {
        SupQueryResult atAuctionGinfoReDomainSupQueryResult = this.atAuctionServiceRepository.queryatAuctionGinfoPage(map);
        for (AtAuctionGinfoReDomain atAuctionGinfoReDomain : atAuctionGinfoReDomainSupQueryResult.getList()) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("auctionCode", atAuctionGinfoReDomain.getAuctionCode());
            param.put("tenantCode", atAuctionGinfoReDomain.getTenantCode());
            param.put("auctionEnrollQstate", 1);
            param.put("auctionEnrollDstate", 1);
            SupQueryResult atAuctionEnrollReDomainSupQueryResult = this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
            if (ListUtil.isNotEmpty((Collection)atAuctionEnrollReDomainSupQueryResult.getList())) {
                atAuctionGinfoReDomain.setEnrollSum(Integer.valueOf(atAuctionEnrollReDomainSupQueryResult.getList().size()));
            }
            if (atAuctionGinfoReDomain.getDataState() == 2) continue;
            StringBuffer auctionGinfoMemname = new StringBuffer();
            String auctionGinfoMemname1 = atAuctionGinfoReDomain.getAuctionGinfoMemname();
            int length = 0;
            if (StringUtils.isNotBlank((String)auctionGinfoMemname1)) {
                length = auctionGinfoMemname1.length();
            }
            for (int i = 0; i <= length; ++i) {
                auctionGinfoMemname.append("*");
            }
            atAuctionGinfoReDomain.setAuctionGinfoMemname(auctionGinfoMemname.toString());
        }
        return atAuctionGinfoReDomainSupQueryResult;
    }

    @RequestMapping(value={"queryAuctionGinfoExport.json"}, name="\u5bfc\u51fa\u67e5\u770b\u7ade\u4ef7\u8be6\u60c5--\u516c\u544a\u9875\u9762")
    @ResponseBody
    public HtmlJsonReBean queryAuctionGinfoExport(HttpServletRequest request, String auctionCode, HttpServletResponse response) {
        return this.queryAuctionGinfoExport(request, response, auctionCode);
    }

    public HtmlJsonReBean queryAuctionGinfoExport(HttpServletRequest request, HttpServletResponse response, String auctionCode) {
        SupQueryResult<AtAuctionGinfoReDomain> atAuctionGinfoReDomainSupQueryResult;
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("\u8d44\u6e90\u5217\u8868");
        sheet.setDefaultRowHeight((short)512);
        sheet.setDefaultColumnWidth(25);
        HSSFRow row = sheet.createRow(0);
        HSSFCellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeightInPoints((short)14);
        style.setFont(font);
        HSSFCell cell = row.createCell(0);
        cell.setCellValue("\u516c\u544a\u6807\u9898");
        cell.setCellStyle(style);
        cell = row.createCell(1);
        cell.setCellValue("\u7ade\u4ef7\u65f6\u95f4");
        cell.setCellStyle(style);
        cell = row.createCell(2);
        cell.setCellValue("\u5305\u88f9\u540d\u79f0");
        cell.setCellStyle(style);
        cell = row.createCell(3);
        cell.setCellValue("\u5305\u88f9\u7f16\u53f7");
        cell.setCellStyle(style);
        cell = row.createCell(4);
        cell.setCellValue("\u5305\u88f9\u5747\u4ef7");
        cell.setCellStyle(style);
        cell = row.createCell(5);
        cell.setCellValue("\u5305\u88f9\u91cd\u91cf");
        cell.setCellStyle(style);
        cell = row.createCell(6);
        cell.setCellValue("\u7ade\u4ef7\u7ed3\u679c");
        cell.setCellStyle(style);
        cell = row.createCell(7);
        cell.setCellValue("\u4e2d\u6807\u516c\u53f8");
        cell.setCellStyle(style);
        cell = row.createCell(8);
        cell.setCellValue("\u6210\u4ea4\u5355\u4ef7");
        cell.setCellStyle(style);
        cell = row.createCell(9);
        cell.setCellValue("\u6210\u4ea4\u91d1\u989d");
        cell = row.createCell(15);
        cell.setCellValue("\u5356\u5bb6");
        cell = row.createCell(16);
        cell.setCellValue("\u573a\u6b21\u53f7");
        cell = row.createCell(17);
        cell.setCellValue("\u62a5\u540d\u622a\u6b62\u65f6\u95f4");
        cell.setCellStyle(style);
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (ListUtil.isNotEmpty((Collection)(atAuctionGinfoReDomainSupQueryResult = this.getAtAuctionGinfoReDomainSupQueryResult(param)).getList())) {
            for (AtAuctionGinfoReDomain atAuctionGinfoReDomain : atAuctionGinfoReDomainSupQueryResult.getList()) {
                AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuctionByCode(atAuctionGinfoReDomain.getTenantCode(), atAuctionGinfoReDomain.getAuctionCode());
                atAuctionGinfoReDomain.setAtAuctionReDomain(atAuctionReDomain);
            }
        }
        if (null == atAuctionGinfoReDomainSupQueryResult) {
            return null;
        }
        int i = 0;
        String vdType = "";
        HSSFCellStyle hssfCellStyleDate = wb.createCellStyle();
        HSSFDataFormat df = wb.createDataFormat();
        hssfCellStyleDate.setDataFormat(df.getFormat("yyyy-MM-dd HH:mm:ss"));
        hssfCellStyleDate.setFont(font);
        for (AtAuctionGinfoReDomain atAuctionGinfoReDomain : atAuctionGinfoReDomainSupQueryResult.getList()) {
            AtAuctionReDomain atAuctionReDomainStr = atAuctionGinfoReDomain.getAtAuctionReDomain();
            row = sheet.createRow(++i);
            HSSFCell cell10 = row.createCell(0);
            HSSFCell cell11 = row.createCell(1);
            HSSFCell cell12 = row.createCell(2);
            HSSFCell cell13 = row.createCell(3);
            HSSFCell cell14 = row.createCell(4);
            HSSFCell cell15 = row.createCell(5);
            HSSFCell cell16 = row.createCell(6);
            HSSFCell cell17 = row.createCell(7);
            HSSFCell cell18 = row.createCell(8);
            HSSFCell cell19 = row.createCell(9);
            HSSFCell cell25 = row.createCell(15);
            HSSFCell cell26 = row.createCell(16);
            HSSFCell cell27 = row.createCell(17);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            if (atAuctionReDomainStr != null) {
                cell25.setCellValue(atAuctionReDomainStr.getMemberName());
                cell10.setCellValue(atAuctionReDomainStr.getAuctionName());
                cell26.setCellValue(atAuctionReDomainStr.getAuctionCode());
                Date gmtCreate = atAuctionReDomainStr.getAuctionSdate();
                Date gmtCreate1 = atAuctionReDomainStr.getAuctionAdate();
                if (gmtCreate == null) {
                    cell11.setCellValue("");
                } else {
                    cell11.setCellValue(sdf.format(gmtCreate));
                }
                if (gmtCreate1 == null) {
                    cell27.setCellValue("");
                } else {
                    cell27.setCellValue(sdf.format(gmtCreate1));
                }
            } else {
                cell25.setCellValue("");
                cell10.setCellValue("");
                cell26.setCellValue("");
                cell11.setCellValue("");
                cell27.setCellValue("");
            }
            cell12.setCellValue(atAuctionGinfoReDomain.getAuctionGinfoName());
            cell13.setCellValue(atAuctionGinfoReDomain.getAuctionGinfoCode());
            if (atAuctionGinfoReDomain.getPricesetNprice() == null) {
                atAuctionGinfoReDomain.setPricesetNprice(BigDecimal.ZERO);
            }
            cell14.setCellValue(atAuctionGinfoReDomain.getPricesetNprice().toString());
            if (atAuctionGinfoReDomain.getGoodsOneweight() == null) {
                atAuctionGinfoReDomain.setGoodsOneweight(BigDecimal.ZERO);
            }
            cell15.setCellValue(atAuctionGinfoReDomain.getGoodsOneweight().toString());
            cell17.setCellValue(atAuctionGinfoReDomain.getAuctionGinfoMemname());
            String ginfoName = "";
            if (atAuctionGinfoReDomain.getAuctionGinfoPrice() == null) {
                atAuctionGinfoReDomain.setAuctionGinfoPrice(BigDecimal.ZERO);
            }
            cell18.setCellValue(atAuctionGinfoReDomain.getAuctionGinfoPrice().toString());
            if (atAuctionGinfoReDomain.getAuctionGinfoMoney() == null) {
                atAuctionGinfoReDomain.setAuctionGinfoMoney(BigDecimal.ZERO);
            }
            cell19.setCellValue(atAuctionGinfoReDomain.getAuctionGinfoMoney().toString());
            cell10.setCellStyle(style);
            cell11.setCellStyle(style);
            cell12.setCellStyle(style);
            cell13.setCellStyle(style);
            cell14.setCellStyle(style);
            cell15.setCellStyle(style);
            cell16.setCellStyle(style);
            cell17.setCellStyle(style);
            cell18.setCellStyle(style);
            cell19.setCellStyle(style);
            cell25.setCellStyle(style);
            cell26.setCellStyle(style);
            cell27.setCellStyle(style);
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String dateStr = simpleDateFormat.format(new Date());
            String filename = "\u5bfc\u51fa\u7ed3\u679c(" + dateStr + ").xls";
            response.setHeader("Content-Type", "application/vnd.ms-excel;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + filename);
            ServletOutputStream out = response.getOutputStream();
            wb.write((OutputStream)out);
            out.close();
        }
        catch (IOException e) {
            this.logger.error(CODE + ".queryAuctionGinfoExport.json", (Throwable)e);
        }
        return new HtmlJsonReBean((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"updateAuctionDtRange.json"}, name="\u4fee\u6539\u5168\u573a\u4fdd\u8bc1\u91d1\u8303\u56f4")
    @ResponseBody
    public HtmlJsonReBean updateAuctionDtRange(AtAuctionDomain atAuctionDomain) {
        if (null == atAuctionDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.atAuctionServiceRepository.updateatAuction(atAuctionDomain);
    }

    @RequestMapping(value={"updateAuctionGinfoDtRange.json"}, name="\u4fee\u6539\u5305\u88f9\u4fdd\u8bc1\u91d1\u8303\u56f4")
    @ResponseBody
    public HtmlJsonReBean updateAuctionGinfoDtRange(String paramStr) {
        if (StringUtils.isNotBlank((String)paramStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        List atAuctionGinfoDomains = (List)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, AtAuctionGinfoDomain.class);
        if (ListUtil.isNotEmpty((Collection)atAuctionGinfoDomains)) {
            for (AtAuctionGinfoDomain atAuctionGinfoDomain : atAuctionGinfoDomains) {
                this.atAuctionServiceRepository.updateatAuctionGinfo(atAuctionGinfoDomain);
            }
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateAcutionReleases.json"}, name="\u91cd\u65b0\u53d1\u5e03--\u516c\u544a")
    @ResponseBody
    public HtmlJsonReBean updateAcutionReleases(String auctionId) {
        if (StringUtils.isBlank((String)auctionId)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "auctionId is null");
        }
        AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(auctionId));
        if (atAuctionReDomain.getDataState() == 3) {
            AtAuctionReDomain auctionReDomain = new AtAuctionReDomain();
            try {
                BeanUtils.copyAllPropertysNotNull((Object)auctionReDomain, (Object)atAuctionReDomain);
                auctionReDomain.setAuctionId(null);
                auctionReDomain.setAuctionCode(null);
                auctionReDomain.setAuctionAudit(null);
                auctionReDomain.setDataState(Integer.valueOf(0));
            }
            catch (Exception e) {
                this.logger.error(CODE + "updateAcutionReleases", (Throwable)e);
            }
            this.logger.error(CODE + ".updateAcutionReleases.json:atAuctionReDomain=", (Object)JsonUtil.buildNormalBinder().toJson((Object)atAuctionReDomain));
            List atAuctionFileDomainList = atAuctionReDomain.getAtAuctionFileDomainList();
            if (ListUtil.isNotEmpty((Collection)atAuctionFileDomainList)) {
                for (AtAuctionFileDomain atAuctionFileDomain1 : atAuctionFileDomainList) {
                    atAuctionFileDomain1.setAuctionFileId(null);
                    atAuctionFileDomain1.setAuctionFileCode(null);
                }
            }
            auctionReDomain.setAtAuctionFileDomainList(atAuctionFileDomainList);
            ArrayList<AtAuctionMemDomain> atAuctionMemDomains = new ArrayList<AtAuctionMemDomain>();
            for (AtAuctionMemDomain atAuctionMemDomain : atAuctionReDomain.getAtAuctionMemDomainList()) {
                atAuctionMemDomain.setAuctionMemCode(null);
                atAuctionMemDomain.setAuctionMemId(null);
                atAuctionMemDomains.add(atAuctionMemDomain);
            }
            auctionReDomain.setAtAuctionMemDomainList(atAuctionMemDomains);
            ArrayList<AtAuctionGinfoReDomain> auctionGinfoReDomainLists = new ArrayList<AtAuctionGinfoReDomain>();
            List auctionGinfoReDomainList = atAuctionReDomain.getAuctionGinfoReDomainList();
            for (AtAuctionGinfoReDomain atAuctionGinfoReDomain : auctionGinfoReDomainList) {
                ArrayList<AtAuctionGoodsDomain> atAuctionGoodsDomains = new ArrayList<AtAuctionGoodsDomain>();
                for (AtAuctionGoodsDomain atAuctionGoodsReDomain : atAuctionGinfoReDomain.getAtAuctionGoodsDomain()) {
                    String goodsCode = atAuctionGoodsReDomain.getGoodsCode();
                    String tenantCode = atAuctionGoodsReDomain.getTenantCode();
                    HashMap<String, Object> maps = new HashMap<String, Object>();
                    maps.put("goodsCode", goodsCode);
                    maps.put("tenantCode", tenantCode);
                    maps.put("unwantedRelatedData", "unwantedRelatedData");
                    maps.put("dataState", 2);
                    RsResourceGoodsReDomain resourceGoods = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(maps);
                    if (null == resourceGoods || !StringUtils.isBlank((String)resourceGoods.getGinfoCode())) continue;
                    atAuctionGoodsReDomain.setAuctionGoodsId(null);
                    atAuctionGoodsReDomain.setAuctionGoodsCode(null);
                    atAuctionGoodsDomains.add(atAuctionGoodsReDomain);
                }
                atAuctionGinfoReDomain.setDataState(Integer.valueOf(0));
                atAuctionGinfoReDomain.setAuctionGinfoId(null);
                atAuctionGinfoReDomain.setAuctionGinfoCode(null);
                atAuctionGinfoReDomain.setAuctionGinfoMoney(null);
                atAuctionGinfoReDomain.setAuctionGinfoMem(null);
                atAuctionGinfoReDomain.setAuctionGinfoMemname(null);
                atAuctionGinfoReDomain.setAuctionGinfoPrice(null);
                atAuctionGinfoReDomain.setGinfofalg(Boolean.valueOf(true));
                atAuctionGinfoReDomain.setAtAuctionGoodsDomain(atAuctionGoodsDomains);
                if (atAuctionGoodsDomains.size() == 0) continue;
                auctionGinfoReDomainLists.add(atAuctionGinfoReDomain);
            }
            auctionReDomain.setAuctionGinfoReDomainList(auctionGinfoReDomainLists);
            this.atAuctionServiceRepository.saveatAuction((AtAuctionDomain)auctionReDomain);
        }
        return new HtmlJsonReBean((Object)"success");
    }

    @RequestMapping(value={"saveAuctionItems.json"}, name="\u589e\u52a0\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveAuctionItems(HttpServletRequest request, AtAuctionDomain atAuctionDomain) {
        if (null == atAuctionDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7ade\u4ef7\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)atAuctionDomain.getAuctionGinfoStr())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7ade\u4ef7\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        List<AtAuctionDomain> atAuctionDomains = this.dataCollationWithItem(atAuctionDomain);
        this.logger.error("atAuctionDomain===", (Object)atAuctionDomain);
        this.logger.error("atAuctionDomains===", (Object)atAuctionDomains.toString());
        if (ListUtil.isEmpty(atAuctionDomains)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u6574\u7406\u5f02\u5e38");
        }
        for (AtAuctionDomain auctionDomain : atAuctionDomains) {
            this.dataCollation(request, auctionDomain);
            auctionDomain.setAuctionruleScope("1");
        }
        this.logger.error("atAuctionDomains===", (Object)JsonUtil.buildNormalBinder().toJson(atAuctionDomains));
        return this.atAuctionServiceRepository.saveatAuctionBatch(atAuctionDomains);
    }

    @RequestMapping(value={"updateAuctionItems.json"}, name="\u66f4\u65b0\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateAuctionItems(HttpServletRequest request, AtAuctionDomain atAuctionDomain) {
        List<AtAuctionDomain> atAuctionDomains = this.dataCollationWithItem(atAuctionDomain);
        if (ListUtil.isEmpty(atAuctionDomains)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u6574\u7406\u5f02\u5e38");
        }
        String flag = this.dataCollation(request, atAuctionDomains.get(0));
        if ("error".equals(flag)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
        }
        return this.atAuctionServiceRepository.updateatAuction(atAuctionDomains.get(0));
    }

    @RequestMapping(value={"getAuctionItems.json"}, name="\u83b7\u53d6\u5355\u54c1")
    @ResponseBody
    public AtAuctionReDomain getAuctionItems(Integer auctionId) {
        if (StringUtils.isBlank((Integer)auctionId)) {
            this.logger.error(CODE + ".getAuctionItems", (Object)"auctionId is null");
            return null;
        }
        return this.atAuctionServiceRepository.getatAuction(auctionId);
    }

    @RequestMapping(value={"deleteAuctionsItems.json"}, name="\u5220\u9664\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionsItems(String auctionId) {
        String[] auctions;
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionId.split(",")) {
            AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            if (atAuctionReDomain.getDataState() != 2) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53ea\u80fd\u5728\u7ec8\u6b62\u72b6\u6001\u624d\u80fd\u5220\u9664");
            }
            this.atAuctionServiceRepository.deleteatAuction(Integer.valueOf(str));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateAcutionReleasesItems.json"}, name="\u91cd\u65b0\u53d1\u5e03-\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateAcutionReleasesItems(String auctionId) {
        if (StringUtils.isBlank((String)auctionId)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "auctionId is null");
        }
        return this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(auctionId), Integer.valueOf(0), Integer.valueOf(2), null);
    }

    @RequestMapping(value={"updateAcutionUp.json"}, name="\u91cd\u65b0\u4e0a\u67b6-\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateAcutionUp(String auctionId) {
        if (StringUtils.isBlank((String)auctionId)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "auctionId is null");
        }
        AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(auctionId));
        return this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(auctionId), Integer.valueOf(1), atAuctionReDomain.getDataState(), null);
    }

    @RequestMapping(value={"updateAcutionGinfoUp.json"}, name="\u91cd\u65b0\u4e0a\u67b6-\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateAcutionGinfoUp(String auctionGinfoId) {
        if (StringUtils.isBlank((String)auctionGinfoId)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "auctionId is null");
        }
        AtAuctionGinfoReDomain atAuctionGinfoReDomain = this.atAuctionServiceRepository.getatAuctionGinfo(Integer.valueOf(auctionGinfoId));
        return this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(auctionGinfoId), Integer.valueOf(1), atAuctionGinfoReDomain.getDataState(), null);
    }

    @RequestMapping(value={"queryAuctionGinfoItems.json"}, name="\u67e5\u770b\u7ade\u4ef7\u8be6\u60c5--\u5355\u54c1\u9875\u9762")
    @ResponseBody
    public SupQueryResult<AtAuctionGinfoReDomain> queryAuctionGinfoItems(HttpServletRequest request, String auctionCode) {
        if (StringUtils.isBlank((String)auctionCode)) {
            this.logger.error(CODE + ".queryAuctionGinfoItems", (Object)"auctionId is null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auctionCode", auctionCode);
        map.put("tenantCode", this.getTenantCode(request));
        SupQueryResult atAuctionGinfoReDomainSupQueryResult = this.atAuctionServiceRepository.queryatAuctionGinfoPage(map);
        return atAuctionGinfoReDomainSupQueryResult;
    }

    @RequestMapping(value={"queryAuctionPageItems.json"}, name="\u53ea\u67e5\u8be2\u5355\u54c1\u4fe1\u606f\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPageItems(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("auctionType", "02");
        param.put("auctionruleScope", "1");
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"queryAuctionGinfoPageItems.json"}, name="\u53ea\u67e5\u8be2\u5355\u54c1\u4fe1\u606f\u5217\u8868")
    @ResponseBody
    public List<AtAuctionGinfoReDomain> queryAuctionGinfoPageItems(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        String tenantCode = this.getTenantCode(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("auctionType", "02");
        param.put("auctionruleScope", "1");
        ArrayList<AtAuctionGinfoReDomain> atAuctionGinfoReDomains = new ArrayList<AtAuctionGinfoReDomain>();
        HashMap<String, String> map = new HashMap<String, String>();
        List list = this.atAuctionServiceRepository.queryatAuctionPage(param).getList();
        for (AtAuctionReDomain atAuctionReDomain : list) {
            map.put("auctionCode", atAuctionReDomain.getAuctionCode());
            map.put("tenantCode", atAuctionReDomain.getTenantCode());
            List auctionGinfoReDomains = this.atAuctionServiceRepository.queryatAuctionGinfoPage(map).getList();
            atAuctionGinfoReDomains.addAll(auctionGinfoReDomains);
        }
        return atAuctionGinfoReDomains;
    }

    @RequestMapping(value={"queryAuctionGinfoPageItemsNew.json"}, name="\u67e5\u8be2\u5355\u54c1\u4fe1\u606f\u5217\u8868(\u5206\u9875)")
    @ResponseBody
    public SupQueryResult<AtAuctionGinfoReDomain> queryAuctionGinfoPageItemsNew(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        String tenantCode = this.getTenantCode(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("auctionruleScope", "1");
            param.put("tenantCode", tenantCode);
        }
        SupQueryResult auctionGinfoPageResult = this.atAuctionServiceRepository.queryatAuctionGinfoPage(param);
        List auctionGinfoPageList = auctionGinfoPageResult.getList();
        if (auctionGinfoPageResult.getTotal() > 0L) {
            for (AtAuctionGinfoReDomain auctionGinfoReDomain : auctionGinfoPageList) {
                AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuctionByCode(tenantCode, auctionGinfoReDomain.getAuctionCode());
                if (null != atAuctionReDomain) {
                    auctionGinfoReDomain.setAuctionAudit(atAuctionReDomain.getAuctionAudit());
                    auctionGinfoReDomain.setAtAuctionReDomain(atAuctionReDomain);
                }
                HashMap<String, String> parMap = new HashMap<String, String>();
                parMap.put("goodsCode", ((AtAuctionGoodsDomain)auctionGinfoReDomain.getAtAuctionGoodsDomain().get(0)).getGoodsCode());
                parMap.put("tenantCode", tenantCode);
                List skuReDomains = this.rsSkuServiceRepository.querySkuPage(parMap).getList();
                if (!ListUtil.isNotEmpty((Collection)skuReDomains)) continue;
                auctionGinfoReDomain.setSkuList(skuReDomains);
            }
        }
        return auctionGinfoPageResult;
    }

    @RequestMapping(value={"saveAuctionEnrollItem.json"}, name="\u53c2\u4e0e\u5355\u54c1\u8d2d\u4e70\u62a5\u540d")
    @ResponseBody
    public HtmlJsonReBean saveAuctionEnrollItem(HttpServletRequest request, String auctionGinfoCode) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean("error", "session is null");
        }
        String memberBcode = userSession.getUserPcode();
        String tenantCode = userSession.getTenantCode();
        AtAuctionGinfoReDomain atAuctionGinfoReDomain = this.atAuctionServiceRepository.getatAuctionGinfoByCode(tenantCode, auctionGinfoCode);
        AtAuctionEnrollDomain atAuctionEnrollDomain = new AtAuctionEnrollDomain();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)atAuctionEnrollDomain, (Object)atAuctionGinfoReDomain);
        }
        catch (Exception e) {
            // empty catch block
        }
        atAuctionEnrollDomain.setAuctionEnrollType("2");
        atAuctionEnrollDomain.setMemberBcode(memberBcode);
        atAuctionEnrollDomain.setMemberBname(userSession.getMerberCompname());
        return this.atAuctionEnrollServiceRepository.saveatAuctionEnroll(atAuctionEnrollDomain);
    }

    @RequestMapping(value={"updateAuctionGinfoItems.json"}, name="\u66f4\u65b0\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateAuctionGinfoItems(AtAuctionGinfoDomain atAuctionGinfoDomain) {
        if (null == atAuctionGinfoDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u6709\u8bef");
        }
        this.atAuctionServiceRepository.deleteatAuctionGinfo(atAuctionGinfoDomain.getAuctionGinfoId());
        AtAuctionGoodsDomain atAuctionGoodsDomain = null;
        ArrayList<AtAuctionGoodsDomain> atAuctionGoodsList = null;
        HashMap<String, String> map = null;
        String[] goodsCode = atAuctionGinfoDomain.getAtAuctionGoodsJson().split(",");
        atAuctionGoodsList = new ArrayList<AtAuctionGoodsDomain>();
        for (String str : goodsCode) {
            atAuctionGoodsDomain = new AtAuctionGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)atAuctionGoodsDomain, (Object)atAuctionGinfoDomain);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".saveAuction:2", (Throwable)e);
            }
            map = new HashMap<String, String>();
            map.put("goodsCode", str);
            map.put("tenantCode", atAuctionGinfoDomain.getTenantCode());
            map.put("unwantedRelatedData", "unwantedRelatedData");
            RsResourceGoodsReDomain resourceGoods = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
            try {
                BeanUtils.copyAllPropertys((Object)atAuctionGoodsDomain, (Object)resourceGoods);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".saveAuction:3", (Throwable)e);
            }
            atAuctionGoodsList.add(atAuctionGoodsDomain);
        }
        this.calculation(atAuctionGinfoDomain, atAuctionGoodsList);
        atAuctionGinfoDomain.setAtAuctionGoodsDomain(atAuctionGoodsList);
        ArrayList<AtAuctionGinfoDomain> atAuctionGinfoDomainList = new ArrayList<AtAuctionGinfoDomain>();
        atAuctionGinfoDomainList.add(atAuctionGinfoDomain);
        return this.atAuctionServiceRepository.saveatAuctionGinfoBatch(atAuctionGinfoDomainList);
    }

    @RequestMapping(value={"deleteAuctionGinfoItems.json"}, name="\u5220\u9664\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionGinfoItems(String auctionGinfoId) {
        String[] auctions;
        if (StringUtils.isBlank((String)auctionGinfoId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionGinfoId.split(",")) {
            this.atAuctionServiceRepository.deleteatAuctionGinfo(Integer.valueOf(str));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"queryAuctionPagePC.json"}, name="\u67e5\u8be2\u516c\u544a\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPagePC(HttpServletRequest request) {
        UserSession userSession;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("auctionType", "01");
            param.put("auctionAudit", "1");
        }
        if (null == (userSession = this.getUserSession(request))) {
            return null;
        }
        String memberCode = userSession.getUserPcode();
        SupQueryResult atAuctionReDomainSupQueryResult = this.atAuctionServiceRepository.queryatAuctionPage(param);
        HashMap<String, String> maps = null;
        HashMap<String, Object> memMap = new HashMap<String, Object>();
        ArrayList<String> memStr = new ArrayList<String>();
        ArrayList atAuctionReDomains = new ArrayList();
        for (AtAuctionReDomain atAuctionReDomain : atAuctionReDomainSupQueryResult.getList()) {
            maps = new HashMap<String, String>();
            maps.put("auctionCode", atAuctionReDomain.getAuctionCode());
            maps.put("tenantCode", this.getTenantCode(request));
            List list = this.atAuctionServiceRepository.queryatAuctionMemPage(maps).getList();
            if (ListUtil.isEmpty((Collection)list)) {
                return null;
            }
            Boolean falg = false;
            for (AtAuctionMemReDomain atAuctionMemReDomain : list) {
                if ("all".equals(atAuctionMemReDomain.getAuctionMemOpcode())) continue;
                memStr.add(atAuctionMemReDomain.getAuctionMemOpcode());
                falg = true;
            }
            if (!falg.booleanValue()) continue;
            memMap.put("memStr", memStr);
            memMap.put("tenantCode", this.getTenantCode(request));
            memMap.put("group", "GROUP BY USERINFO_CODE");
            List list1 = this.umGroupServiceRepository.queryGroupListPage(memMap).getList();
            if (ListUtil.isEmpty((Collection)list1)) {
                return null;
            }
            for (UmGroupListReDomain umGroupListReDomain : list1) {
                if (umGroupListReDomain.getUserinfoCode().equals(memberCode)) continue;
                atAuctionReDomainSupQueryResult.getList().remove((Object)this);
            }
        }
        atAuctionReDomainSupQueryResult.setList(atAuctionReDomains);
        return atAuctionReDomainSupQueryResult;
    }

    @RequestMapping(value={"queryAuctionPageNoticePc.json"}, name="\u67e5\u8be2\u9884\u544a\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPageNoticePc(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("auctionType", "00");
            param.put("auctionAudit", "1");
        }
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"getAuctionPC.json"}, name="\u83b7\u53d6\u516c\u544a\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public AtAuctionReDomain getAuctionPC(Integer auctionId) throws Exception {
        if (StringUtils.isBlank((Integer)auctionId)) {
            this.logger.error(CODE + ".getAuctionPC", (Object)"auctionId is null");
            return null;
        }
        AtAuctionReDomain atAuctionReDomain = this.getAtAuctionReDomain(auctionId);
        if (atAuctionReDomain == null) {
            return null;
        }
        return atAuctionReDomain;
    }

    @RequestMapping(value={"getAuctionNotice.json"}, name="\u83b7\u53d6\u516c\u544a\u8be6\u7ec6\u4fe1\u606f")
    @ResponseBody
    public AtAuctionReDomain getAuctionNotice(Integer auctionId) throws Exception {
        this.logger.error("auctionId", (Object)auctionId);
        if (StringUtils.isBlank((Integer)auctionId)) {
            this.logger.error(CODE + ".getAuctionNotice", (Object)"auctionId is null");
            return null;
        }
        AtAuctionReDomain atAuctionReDomain = this.getAtAuctionReDomain(auctionId);
        this.logger.error("atAuctionReDomain=============", (Object)atAuctionReDomain);
        if (atAuctionReDomain == null) {
            return null;
        }
        return atAuctionReDomain;
    }

    private AtAuctionReDomain getAtAuctionReDomain(Integer auctionId) throws ParseException {
        AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(auctionId);
        if (null == atAuctionReDomain) {
            this.logger.error(CODE + ".getAuctionPC", (Object)auctionId);
            return null;
        }
        String date = "";
        Date auctionEdate1 = null;
        for (AtAuctionGinfoReDomain atAuctionGinfoReDomain : atAuctionReDomain.getAuctionGinfoReDomainList()) {
            atAuctionReDomain.setDelayedFlag(Boolean.valueOf(false));
            atAuctionReDomain.setDelayedFlag(Boolean.valueOf(true));
            auctionEdate1 = atAuctionGinfoReDomain.getAuctionEdate();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            String auctionginfoEdate = sdf.format(atAuctionGinfoReDomain.getAuctionEdate());
            String auctionEdate = sdf.format(atAuctionReDomain.getAuctionEdate());
            long longMS = sdf.parse(auctionginfoEdate).getTime() - sdf.parse(auctionEdate).getTime();
            long minutes = longMS % 3600000L / 60000L;
            long seconds = longMS % 60000L / 1000L;
            date = minutes + "\u5206\u949f" + seconds + "\u79d2";
        }
        atAuctionReDomain.setDelayedDate(date);
        return atAuctionReDomain;
    }

    @RequestMapping(value={"getAuctionNoticePc.json"}, name="\u83b7\u53d6\u9884\u544a\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public AtAuctionReDomain getAuctionNoticePc(Integer auctionId) {
        if (StringUtils.isBlank((Integer)auctionId)) {
            this.logger.error(CODE + ".getAuctionNoticePc", (Object)"auctionId is null");
            return null;
        }
        return this.atAuctionServiceRepository.getatAuction(auctionId);
    }

    @RequestMapping(value={"queryAuctionPC.json"}, name="\u67e5\u8be2\u516c\u544a\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPC(HttpServletRequest request, String classtreeCodeStr) {
        Map param = this.assemMapParam(request);
        param.remove("classtreeCodeStr");
        List classtreeCode = (List)JsonUtil.buildNormalBinder().getJsonToList(classtreeCodeStr, String.class);
        ArrayList<String> auctionCodeStr = new ArrayList<String>();
        if (ListUtil.isNotEmpty((Collection)classtreeCode)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("order", true);
            map.put("fuzzy", true);
            map.put("classtreeCodeStr", classtreeCode);
            List list = this.atAuctionServiceRepository.queryatAuctionGoodsPage(map).getList();
            if (ListUtil.isEmpty((Collection)list)) {
                return null;
            }
            for (AtAuctionGoodsReDomain atAuctionGoodsReDomain : list) {
                auctionCodeStr.add(atAuctionGoodsReDomain.getAuctionCode());
            }
        }
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("auctionType", "01");
            param.put("auctionAudit", "1");
            param.put("orderStr", "AUCTION_EDATE DESC");
            param.put("dataStateStr", "0,1,2");
        }
        if (ListUtil.isNotEmpty(auctionCodeStr)) {
            param.put("auctionCodeStr", auctionCodeStr);
        }
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"queryAuctionNoticePC.json"}, name="\u67e5\u8be2\u9884\u544a\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionNoticePC(HttpServletRequest request, String classtreeCodeStr) {
        Map param = this.assemMapParam(request);
        param.remove("classtreeCodeStr");
        List classtreeCode = (List)JsonUtil.buildNormalBinder().getJsonToList(classtreeCodeStr, String.class);
        ArrayList<String> auctionCodeStr = new ArrayList<String>();
        if (ListUtil.isNotEmpty((Collection)classtreeCode)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("order", true);
            map.put("fuzzy", true);
            param.put("auctionAudit", "1");
            param.put("dataStateStr", "0,1");
            map.put("classtreeCodeStr", classtreeCode);
            List list = this.atAuctionServiceRepository.queryatAuctionGoodsPage(map).getList();
            if (ListUtil.isEmpty((Collection)list)) {
                return null;
            }
            for (AtAuctionGoodsReDomain atAuctionGoodsReDomain : list) {
                auctionCodeStr.add(atAuctionGoodsReDomain.getAuctionCode());
            }
        }
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("auctionType", "00");
            param.put("auctionAudit", "1");
            param.put("dataStateStr", "0,1");
        }
        if (ListUtil.isNotEmpty(auctionCodeStr)) {
            param.put("auctionCodeStr", auctionCodeStr);
        }
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"updateAuctionAuditPaas.json"}, name="\u5e73\u53f0\u5ba1\u6838--\u516c\u544a")
    @ResponseBody
    public HtmlJsonReBean updateAuctionAuditPaas(HttpServletRequest request, String auctionId, Integer auctionAudit, Integer oldauctionAudit, String auctionAuremark) {
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auctionAuremark", auctionAuremark);
        map.put("userCode", userSession.getUserPcode());
        map.put("userName", userSession.getUserName());
        return this.atAuctionServiceRepository.updateAuctionAuctionAudit(Integer.valueOf(auctionId), auctionAudit, oldauctionAudit, map);
    }

    @RequestMapping(value={"queryAuctionPagePaas.json"}, name="\u67e5\u8be2\u516c\u544a\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPagePaas(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("auctionType", "01");
        }
        param.put("dataStateStr", "0,1,2");
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"queryAuctionGinfoPaas.json"}, name="\u67e5\u770b\u7ade\u4ef7\u8be6\u60c5--\u516c\u544a\u9875\u9762")
    @ResponseBody
    public SupQueryResult<AtAuctionGinfoReDomain> queryAuctionGinfoPaas(HttpServletRequest request, String auctionCode) {
        if (StringUtils.isBlank((String)auctionCode)) {
            this.logger.error(CODE + ".queryAuctionGinfoPaas", (Object)"auctionId is null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auctionCode", auctionCode);
        map.put("tenantCode", this.getTenantCode(request));
        SupQueryResult atAuctionGinfoReDomainSupQueryResult = this.atAuctionServiceRepository.queryatAuctionGinfoPage(map);
        return atAuctionGinfoReDomainSupQueryResult;
    }

    @RequestMapping(value={"updateAuctionTrailerAudit.json"}, name="\u5e73\u53f0\u5ba1\u6838--\u9884\u544a")
    @ResponseBody
    public HtmlJsonReBean updateAuctionTrailerAudit(HttpServletRequest request, String auctionId, Integer auctionAudit, Integer oldauctionAudit, String auctionAuremark) {
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auctionAuremark", auctionAuremark);
        map.put("userCode", userSession.getUserPcode());
        map.put("userName", userSession.getUserName());
        return this.atAuctionServiceRepository.updateAuctionAuctionAudit(Integer.valueOf(auctionId), auctionAudit, oldauctionAudit, map);
    }

    @RequestMapping(value={"queryAuctionPageTrailer.json"}, name="\u67e5\u8be2\u9884\u544a\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPageTrailer(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("auctionType", "00");
        }
        String memberCodeStr = null;
        for (int i = 0; i < 5; ++i) {
            if (null == param.get("colValue" + i) || !"memberCode".equals(param.get("colValue" + i).toString())) continue;
            memberCodeStr = param.get("colName" + i).toString();
        }
        if (StringUtils.isNotBlank(memberCodeStr)) {
            param.put("memberCodeStr", memberCodeStr);
        }
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"updateAuctionItemAudit.json"}, name="\u5e73\u53f0\u5ba1\u6838--\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateAuctionItemAudit(HttpServletRequest request, String auctionId, Integer auctionAudit, Integer oldauctionAudit, String auctionAuremark) {
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auctionAuremark", auctionAuremark);
        map.put("userCode", userSession.getUserPcode());
        map.put("userName", userSession.getUserName());
        return this.atAuctionServiceRepository.updateAuctionAuctionAudit(Integer.valueOf(auctionId), auctionAudit, oldauctionAudit, map);
    }

    @RequestMapping(value={"queryAuctionPageItem.json"}, name="\u67e5\u8be2\u5355\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPageItem(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        String memberCodeStr = null;
        for (int i = 0; i < 5; ++i) {
            if (null == param.get("colValue" + i) || !"memberCode".equals(param.get("colValue" + i).toString())) continue;
            memberCodeStr = param.get("colName" + i).toString();
        }
        if (StringUtils.isNotBlank(memberCodeStr)) {
            param.put("memberCodeStr", memberCodeStr);
        }
        param.put("auctionType", "02");
        param.put("auctionruleScope", "1");
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    private String dataCollation(HttpServletRequest request, AtAuctionDomain atAuctionDomain) {
        if (null == atAuctionDomain) {
            this.logger.error(CODE + ".saveAuction", (Object)"atAuctionDomain is null");
            return "error";
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveAuction", (Object)"userSession is null");
            return "error";
        }
        if (StringUtils.isBlank((String)atAuctionDomain.getMemberCcode())) {
            atAuctionDomain.setMemberCcode(userSession.getUserPcode());
            atAuctionDomain.setMemberCname(userSession.getMerberCompname());
        }
        if (StringUtils.isBlank((String)atAuctionDomain.getMemberCode())) {
            atAuctionDomain.setMemberCode(atAuctionDomain.getMemberCcode());
            atAuctionDomain.setMemberName(atAuctionDomain.getMemberCname());
        }
        if (StringUtils.isNotBlank((String)atAuctionDomain.getAtAuctionFileStr())) {
            AtAuctionFileDomain atAuctionFileDomain = (AtAuctionFileDomain)JsonUtil.buildNormalBinder().getJsonToObject(atAuctionDomain.getAtAuctionFileStr(), AtAuctionFileDomain.class);
            atAuctionDomain.setAtAuctionFileDomain(atAuctionFileDomain);
        }
        if (StringUtils.isNotBlank((String)atAuctionDomain.getAtAuctionMemStr())) {
            List atAuctionMemDomain = (List)JsonUtil.buildNormalBinder().getJsonToList(atAuctionDomain.getAtAuctionMemStr(), AtAuctionMemDomain.class);
            atAuctionDomain.setAtAuctionMemDomainList(atAuctionMemDomain);
        }
        if (StringUtils.isNotBlank((String)atAuctionDomain.getAuctionGinfoStr())) {
            List atAuctionGinfoReDomainListStr = (List)JsonUtil.buildNormalBinder().getJsonToList(atAuctionDomain.getAuctionGinfoStr(), AtAuctionGinfoReDomain.class);
            atAuctionDomain.setAuctionGinfoReDomainList(atAuctionGinfoReDomainListStr);
        }
        AtAuctionGoodsDomain atAuctionGoodsDomain = null;
        ArrayList<AtAuctionGoodsDomain> atAuctionGoodsList = null;
        HashMap<String, String> map = null;
        if (ListUtil.isNotEmpty((Collection)atAuctionDomain.getAuctionGinfoReDomainList())) {
            BigDecimal goodsWeight = new BigDecimal(0);
            ArrayList<AtAuctionGinfoReDomain> atAuctionGinfoReDomainList = new ArrayList<AtAuctionGinfoReDomain>();
            for (AtAuctionGinfoReDomain atAuctionGinfoDomain : atAuctionDomain.getAuctionGinfoReDomainList()) {
                if (null != atAuctionGinfoDomain.getAuctionGinfoId()) {
                    AtAuctionGinfoReDomain atAuctionGinfoReDomain = this.atAuctionServiceRepository.getatAuctionGinfo(atAuctionGinfoDomain.getAuctionGinfoId());
                    try {
                        BeanUtils.copyAllPropertysNotNull((Object)atAuctionGinfoDomain, (Object)atAuctionGinfoReDomain);
                    }
                    catch (Exception e) {
                        this.logger.error(CODE + ".saveAuction:1", (Throwable)e);
                    }
                    atAuctionGinfoDomain.setMemberCode(atAuctionDomain.getMemberCode());
                    atAuctionGinfoDomain.setMemberName(atAuctionDomain.getMemberName());
                    atAuctionGinfoDomain.setMemberCcode(atAuctionDomain.getMemberCcode());
                    atAuctionGinfoDomain.setMemberCname(atAuctionDomain.getMemberCname());
                    atAuctionGinfoDomain.setAuctionruleDelaysum(atAuctionDomain.getAuctionruleDelaysum());
                    atAuctionGinfoDomain.setAuctionruleDelayflag(atAuctionDomain.getAuctionruleDelayflag());
                    atAuctionGinfoDomain.setAuctionruleDelay(atAuctionDomain.getAuctionruleDelay());
                    atAuctionGinfoDomain.setAuctionruleType(atAuctionDomain.getAuctionruleType());
                    atAuctionGinfoDomain.setMemberContactPhone(atAuctionDomain.getMemberContactPhone());
                    atAuctionGinfoDomain.setGoodsNum(new BigDecimal(atAuctionGinfoReDomain.getAtAuctionGoodsDomain().size()));
                } else {
                    atAuctionGoodsList = new ArrayList<AtAuctionGoodsDomain>();
                    if (ListUtil.isNotEmpty((Collection)atAuctionGinfoDomain.getAtAuctionGoodsDomain())) {
                        for (AtAuctionGoodsDomain goodsDomain : atAuctionGinfoDomain.getAtAuctionGoodsDomain()) {
                            HashMap<String, String> maps = new HashMap<String, String>();
                            maps.put("goodsCode", goodsDomain.getGoodsCode());
                            maps.put("tenantCode", goodsDomain.getTenantCode());
                            maps.put("unwantedRelatedData", "unwantedRelatedData");
                            RsResourceGoodsReDomain resourceGoods = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(maps);
                            goodsDomain.setWarehouseCode(resourceGoods.getWarehouseCode());
                            goodsDomain.setWarehouseName(resourceGoods.getWarehouseName());
                            goodsDomain.setGoodsProperty5(resourceGoods.getGoodsProperty5());
                            goodsDomain.setGoodsRemark(resourceGoods.getGoodsRemark());
                        }
                    } else {
                        String[] goodsCode;
                        for (String str : goodsCode = atAuctionGinfoDomain.getAtAuctionGoodsJson().split(",")) {
                            atAuctionGoodsDomain = new AtAuctionGoodsDomain();
                            atAuctionGinfoDomain.setTenantCode(this.getTenantCode(request));
                            try {
                                BeanUtils.copyAllPropertysNotNull((Object)atAuctionGoodsDomain, (Object)atAuctionGinfoDomain);
                            }
                            catch (Exception e) {
                                this.logger.error(CODE + ".saveAuction:2", (Throwable)e);
                            }
                            map = new HashMap<String, String>();
                            map.put("skuCode", str);
                            map.put("tenantCode", atAuctionGinfoDomain.getTenantCode());
                            RsSkuDomain rsSkuDomain = this.rsSkuServiceRepository.getSkuDomainByCode(map);
                            this.logger.error(CODE + "dataCollation.getSkuDomainByCode()", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsSkuDomain));
                            if (null == rsSkuDomain) continue;
                            HashMap<String, String> maps = new HashMap<String, String>();
                            maps.put("goodsCode", rsSkuDomain.getGoodsCode());
                            maps.put("tenantCode", atAuctionGinfoDomain.getTenantCode());
                            maps.put("unwantedRelatedData", "unwantedRelatedData");
                            RsResourceGoodsReDomain resourceGoods = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(maps);
                            if (null == resourceGoods) continue;
                            this.logger.error(CODE + "dataCollation.getResourceGoodsByCode()", (Object)JsonUtil.buildNormalBinder().toJson((Object)resourceGoods));
                            try {
                                BeanUtils.copyAllPropertysNotNull((Object)atAuctionGoodsDomain, (Object)rsSkuDomain);
                                atAuctionGoodsDomain.setWarehouseCode(resourceGoods.getWarehouseCode());
                                atAuctionGoodsDomain.setWarehouseName(resourceGoods.getWarehouseName());
                                atAuctionGoodsDomain.setGoodsSupplyweight(rsSkuDomain.getGoodsSupplyweight());
                                atAuctionGoodsDomain.setGoodsSpec(rsSkuDomain.getSkuName());
                                atAuctionGoodsDomain.setGoodsProperty5(resourceGoods.getGoodsProperty5());
                                atAuctionGoodsDomain.setGoodsRemark(resourceGoods.getGoodsRemark());
                                atAuctionGoodsDomain.setAppmanageIcode(this.getProappCode(request));
                            }
                            catch (Exception e) {
                                this.logger.error(CODE + ".saveatAuctionGinfoBatch", (Throwable)e);
                            }
                            atAuctionGoodsList.add(atAuctionGoodsDomain);
                        }
                        this.logger.error(CODE + "dataCollation.atAuctionGoodsList.size()", (Object)atAuctionGoodsList.size());
                        atAuctionGinfoDomain.setAtAuctionGoodsDomain(atAuctionGoodsList);
                    }
                    atAuctionGinfoDomain.setGoodsSupplyweight(new BigDecimal(0));
                    this.calculation((AtAuctionGinfoDomain)atAuctionGinfoDomain, atAuctionGinfoDomain.getAtAuctionGoodsDomain());
                    atAuctionGinfoDomain.setAtAuctionGoodsDomain(atAuctionGinfoDomain.getAtAuctionGoodsDomain());
                    atAuctionGinfoDomain.setAuctionruleDelaysum(atAuctionDomain.getAuctionruleDelaysum());
                    atAuctionGinfoDomain.setAuctionruleDelayflag(atAuctionDomain.getAuctionruleDelayflag());
                    atAuctionGinfoDomain.setAuctionruleDelay(atAuctionDomain.getAuctionruleDelay());
                    atAuctionGinfoDomain.setAuctionSdate(atAuctionDomain.getAuctionSgdate());
                    atAuctionGinfoDomain.setAuctionEdate(atAuctionDomain.getAuctionEdate());
                    atAuctionGinfoDomain.setGoodsNum(new BigDecimal(atAuctionGoodsList.size()));
                    atAuctionGinfoDomain.setMemberCode(atAuctionDomain.getMemberCode());
                    atAuctionGinfoDomain.setMemberName(atAuctionDomain.getMemberName());
                    atAuctionGinfoDomain.setMemberCcode(atAuctionDomain.getMemberCcode());
                    atAuctionGinfoDomain.setMemberCname(atAuctionDomain.getMemberCname());
                    atAuctionGinfoDomain.setAuctionruleType(atAuctionDomain.getAuctionruleType());
                    atAuctionGinfoDomain.setAuctionruleScope(atAuctionDomain.getAuctionruleScope());
                    atAuctionGinfoDomain.setMemberContactPhone(atAuctionDomain.getMemberContactPhone());
                    this.logger.error("dataCollation:001", (Object)atAuctionGinfoDomain.getGoodsSupplyweight());
                    goodsWeight = goodsWeight.add(atAuctionGinfoDomain.getGoodsSupplyweight());
                }
                atAuctionGinfoDomain.setGoodsNum(new BigDecimal(atAuctionGinfoDomain.getAtAuctionGoodsDomain().size()));
                atAuctionGinfoDomain.setGinfofalg(Boolean.valueOf(true));
                atAuctionGinfoDomain.setAppmanageIcode(this.getProappCode(request));
                atAuctionGinfoReDomainList.add(atAuctionGinfoDomain);
            }
            atAuctionDomain.setGoodsWeight(goodsWeight);
            atAuctionDomain.setAuctionGinfoReDomainList(atAuctionGinfoReDomainList);
        }
        atAuctionDomain.setTenantCode(this.getTenantCode(request));
        atAuctionDomain.setAppmanageIcode(this.getProappCode(request));
        return "success";
    }

    private List<AtAuctionDomain> dataCollationWithItem(AtAuctionDomain atAuctionDomain) {
        AtAuctionGinfoReDomain[] auctionGinfoReDomains = (AtAuctionGinfoReDomain[])JsonUtil.buildNormalBinder().getJsonToArray(atAuctionDomain.getAuctionGinfoStr(), AtAuctionGinfoReDomain.class);
        List atAuctionGinfoReDomainslist = (List)JsonUtil.buildNormalBinder().getJsonToList(atAuctionDomain.getAuctionGinfoStr(), AtAuctionGinfoReDomain.class);
        ArrayList<AtAuctionDomain> atAuctionDomains = new ArrayList<AtAuctionDomain>();
        this.logger.error("atAuctionGinfoReDomainslist+++" + JsonUtil.buildNormalBinder().toJson((Object)atAuctionGinfoReDomainslist));
        for (AtAuctionGinfoReDomain auctionGinfoReDomain : atAuctionGinfoReDomainslist) {
            this.logger.error("auctionGinfoReDomain++" + JsonUtil.buildNormalBinder().toJson((Object)auctionGinfoReDomain));
            String auctionGinfoJson = JsonUtil.buildNormalBinder().toJson((Object)auctionGinfoReDomain);
            AtAuctionDomain auctionDomain = new AtAuctionDomain();
            try {
                BeanUtils.copyAllPropertys((Object)auctionDomain, (Object)atAuctionDomain);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".dataCollationWithItem", (Throwable)e);
            }
            auctionDomain.setAuctionGcode(auctionGinfoReDomain.getGoodsNo());
            auctionDomain.setMschannelCode(auctionGinfoReDomain.getGoodsName());
            auctionDomain.setMschannelName(auctionGinfoReDomain.getWarehouseName());
            auctionDomain.setAuctionGinfoStr(Arrays.asList(auctionGinfoJson).toString());
            auctionDomain.setAuctionruleReply(auctionGinfoReDomain.getAuctionruleReply());
            auctionDomain.setAuctionruleReplynum(auctionGinfoReDomain.getAuctionruleReplynum());
            atAuctionDomains.add(auctionDomain);
        }
        return atAuctionDomains;
    }

    private void calculation(AtAuctionGinfoDomain atAuctionGinfoDomain, List<AtAuctionGoodsDomain> atAuctionGoodsList) {
        if (ListUtil.isEmpty(atAuctionGoodsList)) {
            this.logger.error("calculation", (Object)"param is null");
            return;
        }
        BigDecimal goodsnpirce = new BigDecimal(0);
        BigDecimal goodsweight = new BigDecimal(0);
        BigDecimal goodsprice = new BigDecimal(0);
        String partsnameWeightunit = null;
        for (AtAuctionGoodsDomain atAuctionGoodsDomain : atAuctionGoodsList) {
            goodsprice = goodsprice.add(atAuctionGoodsDomain.getGoodsSupplyweight().multiply(atAuctionGoodsDomain.getPricesetNprice()));
            goodsweight = goodsweight.add(atAuctionGoodsDomain.getGoodsSupplyweight());
            partsnameWeightunit = atAuctionGoodsDomain.getPartsnameWeightunit();
        }
        goodsnpirce = goodsnpirce.add(goodsprice.divide(goodsweight, 3, 0)).setScale(3, 0);
        atAuctionGinfoDomain.setPricesetNprice(goodsnpirce);
        atAuctionGinfoDomain.setGoodsSupplyweight(goodsweight);
        atAuctionGinfoDomain.setPricesetPrefprice(goodsprice);
        atAuctionGinfoDomain.setPartsnameWeightunit(partsnameWeightunit);
        this.logger.error("dataCollation:000", (Object)atAuctionGinfoDomain.getGoodsSupplyweight());
    }

    @RequestMapping(value={"saveAuctionForPaas.json"}, name="\u589e\u52a0\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveAuctionForPaas(HttpServletRequest request, AtAuctionDomain atAuctionDomain) {
        String flag = this.dataCollation(request, atAuctionDomain);
        if ("error".equals(flag)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
        }
        return this.atAuctionServiceRepository.saveatAuction(atAuctionDomain);
    }

    @RequestMapping(value={"getAuctionForPaas.json"}, name="\u83b7\u53d6\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public AtAuctionReDomain getAuctionForPaas(Integer auctionId) {
        if (StringUtils.isBlank((Integer)auctionId)) {
            this.logger.error(CODE + ".getAuctionForPaas", (Object)"auctionId is null");
            return null;
        }
        return this.atAuctionServiceRepository.getatAuction(auctionId);
    }

    @RequestMapping(value={"updateAuctionForPaas.json"}, name="\u66f4\u65b0\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateAuctionForPaas(HttpServletRequest request, AtAuctionDomain atAuctionDomain) {
        String flag = this.dataCollation(request, atAuctionDomain);
        if ("error".equals(flag)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
        }
        return this.atAuctionServiceRepository.updateatAuction(atAuctionDomain);
    }

    @RequestMapping(value={"deleteAuctionForPaas.json"}, name="\u5220\u9664\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionForPaas(String auctionId) {
        String[] auctions;
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionId.split(",")) {
            AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            if (atAuctionReDomain.getDataState() != 2) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53ea\u80fd\u5728\u7ec8\u6b62\u72b6\u6001\u624d\u80fd\u5220\u9664");
            }
            this.atAuctionServiceRepository.deleteatAuction(Integer.valueOf(str));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"deleteAuctionRevokeForPaas.json"}, name="\u64a4\u9500")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionRevokeForPaas(String auctionId) {
        AtAuctionReDomain atAuctionReDomain;
        String[] auctions;
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"auctionId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionId.split(",")) {
            atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            if (atAuctionReDomain.getDataState() == 0) continue;
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9009\u53d6\u53ea\u80fd\u4e3a\u65b0\u589e\u548c\u5df2\u53d1\u5e03\u7684\u4fe1\u606f");
        }
        for (String str : auctions) {
            atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(str), Integer.valueOf(3), atAuctionReDomain.getDataState(), null);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"queryAuctionPageForPaas.json"}, name="\u67e5\u8be2\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPageForPaas(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"updateAuctionStateForPaas.json"}, name="\u66f4\u65b0\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAuctionStateForPaas(String auctionId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.atAuctionServiceRepository.updateatAuctionFileState(Integer.valueOf(auctionId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"updateAcutionReleaseForPaas.json"}, name="\u91cd\u65b0\u53d1\u5e03")
    @ResponseBody
    public HtmlJsonReBean updateAcutionReleaseForPaas(String auctionId) {
        if (StringUtils.isBlank((String)auctionId)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "auctionId is null");
        }
        return this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(auctionId), Integer.valueOf(0), Integer.valueOf(2), null);
    }

    @RequestMapping(value={"queryAuctionPageNoticeForPaas.json"}, name="\u53ea\u67e5\u8be2\u9884\u544a\u4fe1\u606f\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPageNoticeForPaas(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("auctionType", "00");
        }
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"deleteAuctionsForPaas.json"}, name="\u5220\u9664\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionsForPaas(String auctionId) {
        String[] auctions;
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionId.split(",")) {
            AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            if (atAuctionReDomain.getDataState() != 2) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53ea\u80fd\u5728\u7ec8\u6b62\u72b6\u6001\u624d\u80fd\u5220\u9664");
            }
            this.atAuctionServiceRepository.deleteatAuction(Integer.valueOf(str));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateAuctionTerminationForPaas.json"}, name="\u64a4\u9500--\u516c\u544a")
    @ResponseBody
    public HtmlJsonReBean updateAuctionTerminationForPaas(String auctionId) {
        AtAuctionReDomain atAuctionReDomain;
        String[] auctions;
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"auctionId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionId.split(",")) {
            atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            if (atAuctionReDomain.getDataState() == 0) continue;
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53d1\u5e03\uff0c\u65b0\u589e\u72b6\u6001\u624d\u80fd\u64a4\u9500");
        }
        for (String str : auctions) {
            atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(str), Integer.valueOf(3), atAuctionReDomain.getDataState(), null);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateAuctionTerminationForAtPaas.json"}, name="\u7ec8\u6b62-\u516c\u544a")
    @ResponseBody
    public HtmlJsonReBean updateAuctionTerminationForAtPaas(String auctionStr) {
        String[] auctions;
        if (StringUtils.isBlank((String)auctionStr)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"auctionId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ArrayList<AtAuctionReDomain> atAuctionReDomains = new ArrayList<AtAuctionReDomain>();
        for (String str : auctions = auctionStr.split(",")) {
            AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            Date date = new Date();
            if (atAuctionReDomain.getAuctionSdate().getTime() > date.getTime()) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53ea\u80fd\u5728\u516c\u544a\u5f00\u59cb\u7684\u65f6\u5019\u624d\u80fd\u7ec8\u6b62\uff01");
            }
            atAuctionReDomains.add(atAuctionReDomain);
        }
        for (AtAuctionReDomain atAuctionReDomain : atAuctionReDomains) {
            this.atAuctionServiceRepository.updateatAuctionState(atAuctionReDomain.getAuctionId(), Integer.valueOf(2), atAuctionReDomain.getDataState(), null);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"saveAuctionGinfoForPaas.json"}, name="\u4fdd\u5b58\u5305\u88f9\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveAuctionGinfoForPaas(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "paramStr is null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        AtAuctionGoodsDomain atAuctionGoodsDomain = null;
        ArrayList<AtAuctionGoodsDomain> atAuctionGoodsList = null;
        HashMap<String, String> map = null;
        List AtAuctionGinfoDomain2 = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, AtAuctionGinfoDomain.class);
        for (AtAuctionGinfoDomain atAuctionGinfoDomain : AtAuctionGinfoDomain2) {
            atAuctionGinfoDomain.setMemberCode(userSession.getUserPcode());
            atAuctionGinfoDomain.setMemberName(userSession.getUserName());
            atAuctionGinfoDomain.setTenantCode(this.getTenantCode(request));
            String[] goodsCode = atAuctionGinfoDomain.getAtAuctionGoodsJson().split(",");
            atAuctionGoodsList = new ArrayList<AtAuctionGoodsDomain>();
            for (String str : goodsCode) {
                atAuctionGoodsDomain = new AtAuctionGoodsDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)atAuctionGoodsDomain, (Object)atAuctionGinfoDomain);
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".saveatAuctionGinfoBatch", (Throwable)e);
                }
                map = new HashMap<String, String>();
                map.put("goodsCode", str);
                map.put("tenantCode", atAuctionGinfoDomain.getTenantCode());
                map.put("unwantedRelatedData", "unwantedRelatedData");
                RsResourceGoodsReDomain resourceGoods = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
                try {
                    BeanUtils.copyAllPropertys((Object)atAuctionGoodsDomain, (Object)resourceGoods);
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".saveatAuctionGinfoBatch", (Throwable)e);
                }
                atAuctionGoodsList.add(atAuctionGoodsDomain);
            }
            this.calculation(atAuctionGinfoDomain, atAuctionGoodsList);
            atAuctionGinfoDomain.setAtAuctionGoodsDomain(atAuctionGoodsList);
        }
        return this.atAuctionServiceRepository.saveatAuctionGinfoBatch(AtAuctionGinfoDomain2);
    }

    @RequestMapping(value={"getAuctionGinfoForPaasForPaas.json"}, name="\u83b7\u53d6\u5305\u88f9\u4fe1\u606f")
    @ResponseBody
    public AtAuctionGinfoReDomain getAuctionGinfoForPaas(HttpServletRequest request, String auctionGinfCode) {
        if (StringUtils.isBlank((String)auctionGinfCode)) {
            this.logger.error(CODE + ".getAuctionGinfoForPaasForPaas", (Object)"auctionId is null");
            return null;
        }
        return this.atAuctionServiceRepository.getatAuctionGinfoByCode(this.getTenantCode(request), auctionGinfCode);
    }

    @RequestMapping(value={"queryAuctionGinfoForPaas.json"}, name="\u67e5\u770b\u7ade\u4ef7\u8be6\u60c5--\u516c\u544a\u9875\u9762")
    @ResponseBody
    public SupQueryResult<AtAuctionGinfoReDomain> queryAuctionGinfoForPaas(HttpServletRequest request, String auctionCode) {
        if (StringUtils.isBlank((String)auctionCode)) {
            this.logger.error(CODE + ".queryAuctionGinfoForPaas", (Object)"auctionId is null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auctionCode", auctionCode);
        map.put("tenantCode", this.getTenantCode(request));
        SupQueryResult atAuctionGinfoReDomainSupQueryResult = this.atAuctionServiceRepository.queryatAuctionGinfoPage(map);
        return atAuctionGinfoReDomainSupQueryResult;
    }

    @RequestMapping(value={"updateAcutionReleasesForPaas.json"}, name="\u91cd\u65b0\u53d1\u5e03--\u516c\u544a")
    @ResponseBody
    public HtmlJsonReBean updateAcutionReleasesForPaas(String auctionId) {
        if (StringUtils.isBlank((String)auctionId)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "auctionId is null");
        }
        return this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(auctionId), Integer.valueOf(0), Integer.valueOf(2), null);
    }

    @RequestMapping(value={"saveAuctionItemsForPaas.json"}, name="\u589e\u52a0\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveAuctionItemsForPaas(HttpServletRequest request, AtAuctionDomain atAuctionDomain) {
        atAuctionDomain.setAuctionruleScope("1");
        String flag = this.dataCollation(request, atAuctionDomain);
        if ("error".equals(flag)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
        }
        return this.atAuctionServiceRepository.saveatAuction(atAuctionDomain);
    }

    @RequestMapping(value={"updateAuctionItemsForPaas.json"}, name="\u66f4\u65b0\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateAuctionItemsForPaas(HttpServletRequest request, AtAuctionDomain atAuctionDomain) {
        String flag = this.dataCollation(request, atAuctionDomain);
        if ("error".equals(flag)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
        }
        return this.atAuctionServiceRepository.updateatAuction(atAuctionDomain);
    }

    @RequestMapping(value={"getAuctionItemsForPaas.json"}, name="\u83b7\u53d6\u5355\u54c1")
    @ResponseBody
    public AtAuctionReDomain getAuctionItemsForPaas(Integer auctionId) {
        if (StringUtils.isBlank((Integer)auctionId)) {
            this.logger.error(CODE + ".getAuctionItemsForPaas", (Object)"auctionId is null");
            return null;
        }
        return this.atAuctionServiceRepository.getatAuction(auctionId);
    }

    @RequestMapping(value={"deleteAuctionsItemsForPaas.json"}, name="\u5220\u9664\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionsItemsForPaas(String auctionId) {
        String[] auctions;
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionId.split(",")) {
            AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            if (atAuctionReDomain.getDataState() != 2) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53ea\u80fd\u5728\u7ec8\u6b62\u72b6\u6001\u624d\u80fd\u5220\u9664");
            }
            this.atAuctionServiceRepository.deleteatAuction(Integer.valueOf(str));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateAcutionReleasesItemsForPaas.json"}, name="\u91cd\u65b0\u53d1\u5e03-\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateAcutionReleasesItemsForPaas(String auctionId) {
        if (StringUtils.isBlank((String)auctionId)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "auctionId is null");
        }
        return this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(auctionId), Integer.valueOf(0), Integer.valueOf(2), null);
    }

    @RequestMapping(value={"updateAcutionUpForPaas.json"}, name="\u91cd\u65b0\u4e0a\u67b6-\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateAcutionUpForPaas(String auctionId) {
        if (StringUtils.isBlank((String)auctionId)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "auctionId is null");
        }
        AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(auctionId));
        return this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(auctionId), Integer.valueOf(1), atAuctionReDomain.getDataState(), null);
    }

    @RequestMapping(value={"queryAuctionGinfoItemsForPaas.json"}, name="\u67e5\u770b\u7ade\u4ef7\u8be6\u60c5--\u5355\u54c1\u9875\u9762")
    @ResponseBody
    public SupQueryResult<AtAuctionGinfoReDomain> queryAuctionGinfoItemsForPaas(HttpServletRequest request, String auctionCode) {
        if (StringUtils.isBlank((String)auctionCode)) {
            this.logger.error(CODE + ".queryAuctionGinfoItemsForPaas", (Object)"auctionId is null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auctionCode", auctionCode);
        map.put("tenantCode", this.getTenantCode(request));
        SupQueryResult atAuctionGinfoReDomainSupQueryResult = this.atAuctionServiceRepository.queryatAuctionGinfoPage(map);
        return atAuctionGinfoReDomainSupQueryResult;
    }

    @RequestMapping(value={"queryAuctionGinfoPageItemsForPaas.json"}, name="\u53ea\u67e5\u8be2\u5355\u54c1\u4fe1\u606f\u5217\u8868")
    @ResponseBody
    public List<AtAuctionGinfoReDomain> queryAuctionGinfoPageItemsForPaas(HttpServletRequest request) {
        return this.queryAuctionGinfoPageItemsCom(request);
    }

    private List<AtAuctionGinfoReDomain> queryAuctionGinfoPageItemsCom(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("auctionType", "02");
        param.put("auctionruleScope", "1");
        ArrayList<AtAuctionGinfoReDomain> atAuctionGinfoReDomains = new ArrayList<AtAuctionGinfoReDomain>();
        HashMap<String, String> map = new HashMap<String, String>();
        List list = this.atAuctionServiceRepository.queryatAuctionPage(param).getList();
        for (AtAuctionReDomain atAuctionReDomain : list) {
            map.put("auctionCode", atAuctionReDomain.getAuctionCode());
            map.put("tenantCode", atAuctionReDomain.getTenantCode());
            List auctionGinfoReDomains = this.atAuctionServiceRepository.queryatAuctionGinfoPage(map).getList();
            atAuctionGinfoReDomains.addAll(auctionGinfoReDomains);
        }
        return atAuctionGinfoReDomains;
    }

    @RequestMapping(value={"updateAuctionGinfoItemsForPaas.json"}, name="\u66f4\u65b0\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateAuctionGinfoItemsForPaas(AtAuctionGinfoDomain atAuctionGinfoDomain) {
        if (null == atAuctionGinfoDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u6709\u8bef");
        }
        this.atAuctionServiceRepository.deleteatAuctionGinfo(atAuctionGinfoDomain.getAuctionGinfoId());
        AtAuctionGoodsDomain atAuctionGoodsDomain = null;
        ArrayList<AtAuctionGoodsDomain> atAuctionGoodsList = null;
        HashMap<String, String> map = null;
        String[] goodsCode = atAuctionGinfoDomain.getAtAuctionGoodsJson().split(",");
        atAuctionGoodsList = new ArrayList<AtAuctionGoodsDomain>();
        for (String str : goodsCode) {
            atAuctionGoodsDomain = new AtAuctionGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)atAuctionGoodsDomain, (Object)atAuctionGinfoDomain);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".saveAuction:2", (Throwable)e);
            }
            map = new HashMap<String, String>();
            map.put("goodsCode", str);
            map.put("tenantCode", atAuctionGinfoDomain.getTenantCode());
            map.put("unwantedRelatedData", "unwantedRelatedData");
            RsResourceGoodsReDomain resourceGoods = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
            try {
                BeanUtils.copyAllPropertys((Object)atAuctionGoodsDomain, (Object)resourceGoods);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".saveAuction:3", (Throwable)e);
            }
            atAuctionGoodsList.add(atAuctionGoodsDomain);
        }
        this.calculation(atAuctionGinfoDomain, atAuctionGoodsList);
        atAuctionGinfoDomain.setAtAuctionGoodsDomain(atAuctionGoodsList);
        ArrayList<AtAuctionGinfoDomain> atAuctionGinfoDomainList = new ArrayList<AtAuctionGinfoDomain>();
        atAuctionGinfoDomainList.add(atAuctionGinfoDomain);
        return this.atAuctionServiceRepository.saveatAuctionGinfoBatch(atAuctionGinfoDomainList);
    }

    @RequestMapping(value={"deleteAuctionGinfoItemsForPaas.json"}, name="\u5220\u9664\u5355\u54c1")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionGinfoItemsForPaas(String auctionGinfoId) {
        String[] auctions;
        if (StringUtils.isBlank((String)auctionGinfoId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionGinfoId.split(",")) {
            this.atAuctionServiceRepository.deleteatAuctionGinfo(Integer.valueOf(str));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"getAuctionById.json"}, name="\u53ea\u67e5\u8be2\u5f53\u524d\u573a\u6b21\u4fe1\u606f")
    @ResponseBody
    public AtAuctionReDomain getAuctionById(HttpServletRequest request, String auctionId) {
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".getAuctionById", (Object)"auctionId is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memberBcode", userSession.getUserPcode());
        map.put("tenantCode", this.getTenantCode(request));
        AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuctionById(Integer.valueOf(auctionId));
        SupQueryResult atAuctionEnrollReDomainSupQueryResult = this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(map);
        if (ListUtil.isEmpty((Collection)atAuctionEnrollReDomainSupQueryResult.getList())) {
            return null;
        }
        for (AtAuctionEnrollReDomain atAuctionEnrollReDomain : atAuctionEnrollReDomainSupQueryResult.getList()) {
            if (!atAuctionEnrollReDomain.getAuctionCode().equals(atAuctionReDomain.getAuctionCode()) || atAuctionEnrollReDomain.getDataState() != 0 && atAuctionEnrollReDomain.getDataState() != 2) continue;
            return null;
        }
        atAuctionReDomain.setUserSessionCode(userSession.getUserPcode());
        return atAuctionReDomain;
    }

    @RequestMapping(value={"getAuctionByCode.json"}, name="\u53ea\u67e5\u8be2\u5f53\u524d\u573a\u6b21\u4fe1\u606f")
    @ResponseBody
    public AtAuctionReDomain getAuctionByCode(HttpServletRequest request, String auctionCode) {
        if (StringUtils.isBlank((String)auctionCode)) {
            this.logger.error(CODE + ".getAuctionByCode", (Object)"auctionCode is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memberBcode", userSession.getUserPcode());
        map.put("tenantCode", this.getTenantCode(request));
        map.put("auctionCode", auctionCode);
        map.put("auctionEnrollType", "1");
        AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuctionByCode(this.getTenantCode(request), auctionCode);
        map.put("dataStateNot", "2");
        SupQueryResult atAuctionEnrollReDomainSupQueryResult = this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(map);
        if (ListUtil.isEmpty((Collection)atAuctionEnrollReDomainSupQueryResult.getList())) {
            return null;
        }
        AtAuctionEnrollReDomain atAuctionEnrollReDomain = (AtAuctionEnrollReDomain)atAuctionEnrollReDomainSupQueryResult.getList().get(0);
        if (atAuctionEnrollReDomain.getDataState() == 2) {
            return null;
        }
        atAuctionReDomain.setUserSessionCode(userSession.getUserPcode());
        atAuctionReDomain.setAuctionRemark(null);
        return atAuctionReDomain;
    }

    @RequestMapping(value={"queryAuctionGinfoByCode.json"}, name="\u53ea\u67e5\u8be2\u5f53\u524d\u573a\u6b21\u4e0b\u7684\u5305\u88f9\u4fe1\u606f")
    @ResponseBody
    public SupQueryResult<AtAuctionGinfoReDomain> queryAuctionGinfoByCode(HttpServletRequest request, String auctionCode) {
        if (StringUtils.isBlank((String)auctionCode)) {
            this.logger.error(CODE + ".queryAuctionGinfoByCode", (Object)"auctionCode is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        String memberCode = userSession.getUserPcode();
        String tenantCode = this.getTenantCode(request);
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("auctionCode", auctionCode);
            param.put("memberBcode", memberCode);
            param.put("tenantCode", tenantCode);
        }
        SupQueryResult atAuctionGinfoReDomainSupQueryResult = this.atAuctionServiceRepository.queryAuctionGinfoByCodePageNew(param);
        HashMap<String, String> map = new HashMap<String, String>();
        for (AtAuctionGinfoReDomain atAuctionGinfoReDomain : atAuctionGinfoReDomainSupQueryResult.getList()) {
            map.put("auctionGinfoCode", atAuctionGinfoReDomain.getAuctionGinfoCode());
            map.put("tenantCode", atAuctionGinfoReDomain.getTenantCode());
            List list = this.atAuctionServiceRepository.queryatAuctionGoodsPage(map).getList();
            atAuctionGinfoReDomain.setAtAuctionGoodsReDomainList(list);
            atAuctionGinfoReDomain.setAuctionGinfoMem(null);
            atAuctionGinfoReDomain.setAuctionGinfoMemname(null);
        }
        return atAuctionGinfoReDomainSupQueryResult;
    }

    @RequestMapping(value={"queryAuctionGoodsByCode.json"}, name="\u5355\u67e5\u8be2\u5f53\u524d\u5305\u88f9\u4e0b\u7684\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public SupQueryResult<AtAuctionGoodsReDomain> queryAuctionGoodsByCode(HttpServletRequest request, String auctionGinfoCode) {
        if (StringUtils.isBlank((String)auctionGinfoCode)) {
            this.logger.error(CODE + ".queryAuctionGoodsByCode", (Object)"auctionGinfoCode is null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auctionGinfoCode", auctionGinfoCode);
        map.put("tenantCode", this.getTenantCode(request));
        return this.atAuctionServiceRepository.queryatAuctionGoodsPage(map);
    }

    @RequestMapping(value={"getMyPrice.json"}, name="\u83b7\u53d6\u6211\u7684\u6700\u65b0\u51fa\u4ef7\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean getMyPrice(HttpServletRequest request, String auctionGinfoCode) {
        String[] ste;
        if (StringUtils.isBlank((String)auctionGinfoCode)) {
            this.logger.error(CODE + ".getMyPrice", (Object)"auctionGinfoCode is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".getMyPrice", (Object)"userSession is null");
            return null;
        }
        Map<Object, Object> parma = new HashMap();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, List<AtAuctionPriceReDomain>> ginfoCodeVsPriceListMap = new HashMap<String, List<AtAuctionPriceReDomain>>();
        String[] ginfoCodeArray = ste = auctionGinfoCode.split(",");
        String auctionGinfoCodesStr = auctionGinfoCode;
        map.put("auctionGinfoCodesStr", auctionGinfoCodesStr);
        map.put("tenantCode", this.getTenantCode(request));
        map.put("memberBcode", userSession.getUserPcode());
        map.put("order", true);
        SupQueryResult atAuctionPriceReDomainSupQueryResult = this.atAuctionPriceServiceRepository.queryatAuctionPricePage(map);
        List atAuctionPriceReDomainlist = atAuctionPriceReDomainSupQueryResult.getList();
        for (String ginfoCode : ginfoCodeArray) {
            ArrayList<AtAuctionPriceReDomain> priceListBelongCode = new ArrayList<AtAuctionPriceReDomain>();
            ginfoCodeVsPriceListMap.put(ginfoCode, priceListBelongCode);
            for (AtAuctionPriceReDomain auctionPriceReDomain : atAuctionPriceReDomainlist) {
                if (!ginfoCode.equals(auctionPriceReDomain.getAuctionGinfoCode())) continue;
                priceListBelongCode.add(auctionPriceReDomain);
            }
        }
        parma = this.getMypriceGroupByGinfoCode(ginfoCodeVsPriceListMap);
        return new HtmlJsonReBean(parma);
    }

    @RequestMapping(value={"queryAuctionGinfoBean.json"}, name="\u67e5\u8be2\u5237\u65b0\u4fe1\u606f")
    @ResponseBody
    public List<AuctionGinfoBean> queryAuctionGinfoBean(HttpServletRequest request, String auctionGinfoStr) {
        if (StringUtils.isBlank((String)auctionGinfoStr)) {
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        String memberCode = userSession.getUserPcode();
        String tenantCode = this.getTenantCode(request);
        String[] auctionGinfos = auctionGinfoStr.split(",");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("auctionginfoCodeStr", auctionGinfos);
        map.put("tenantCode", tenantCode);
        HashMap param = new HashMap();
        map.put("memberBcode", memberCode);
        map.put("tenantCode", tenantCode);
        List auctionGinfoBeans = this.atAuctionServiceRepository.queryAuctionGinfoBean(map, param);
        if (ListUtil.isEmpty((Collection)auctionGinfoBeans)) {
            return null;
        }
        for (AuctionGinfoBean auctionGinfoBean : auctionGinfoBeans) {
            String auctionGinfoMem = auctionGinfoBean.getAuctionGinfoMem();
            if (StringUtils.isBlank((String)auctionGinfoMem)) continue;
            if (auctionGinfoMem.equals(memberCode)) {
                auctionGinfoBean.setFlag(Boolean.valueOf(true));
            } else {
                auctionGinfoBean.setFlag(Boolean.valueOf(false));
            }
            if (auctionGinfoBean.getAuctionruleType().equals("0")) {
                auctionGinfoBean.setAtauctionprice(null);
                auctionGinfoBean.setAuctionGinfoPrice(null);
                auctionGinfoBean.setAuctionGinfoMoney(null);
            }
            if (auctionGinfoBean.getDataState().equals("2")) {
                if (memberCode.equals(auctionGinfoBean.getAuctionGinfoMem())) {
                    auctionGinfoBean.setEndFlag(Boolean.valueOf(true));
                } else {
                    auctionGinfoBean.setEndFlag(Boolean.valueOf(false));
                }
            }
            auctionGinfoBean.setAuctionGinfoMem(null);
            auctionGinfoBean.setAuctionGinfoMemname(null);
            auctionGinfoBean.setDataState(null);
        }
        return auctionGinfoBeans;
    }

    @RequestMapping(value={"queryMyAuction.json"}, name="\u67e5\u8be2\u6211\u7684\u7ade\u62cd")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryMyAuction(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryMyAuction.json", (Object)"userSession is null");
            return null;
        }
        String memberBcode = userSession.getUserPcode();
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memberBcode", memberBcode);
        map.put("tenantCode", tenantCode);
        List list = this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(map).getList();
        if (ListUtil.isEmpty((Collection)list)) {
            this.logger.error(CODE + ".queryMyAuction.json", map);
            return null;
        }
        ArrayList<String> auctionStrs = new ArrayList<String>();
        for (AtAuctionEnrollReDomain atAuctionEnrollReDomain : list) {
            auctionStrs.add(atAuctionEnrollReDomain.getAuctionCode());
        }
        HashMap<String, Object> auctionMap = new HashMap<String, Object>();
        auctionMap.put("auctionCodeStr", auctionStrs);
        auctionMap.put("tenantCode", tenantCode);
        auctionMap.put("order", true);
        return this.atAuctionServiceRepository.queryatAuctionPage(auctionMap);
    }

    @RequestMapping(value={"getMyAuctionInfo.json"}, name="\u6211\u7684\u7ade\u62cd\u8be6\u60c5")
    @ResponseBody
    public AtAuctionReDomain getMyAuctionInfo(HttpServletRequest request, String auctionCode, Integer auctionEnrollDtType) {
        SupQueryResult auctionGinfoPageResult;
        Map param;
        if (StringUtils.isBlank((String)auctionCode)) {
            this.logger.error(CODE + ".getMyAuctionInfo.json", (Object)"auctionCode is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".getMyAuctionInfo.json", (Object)"userSession is null");
            return null;
        }
        String memberBcode = userSession.getUserPcode();
        String tenantCode = this.getTenantCode(request);
        AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuctionByCodeNew(tenantCode, auctionCode);
        if (atAuctionReDomain == null) {
            return null;
        }
        HashMap<String, Object> mapStr = new HashMap<String, Object>();
        mapStr.put("tenantCode", tenantCode);
        mapStr.put("auctionCode", auctionCode);
        mapStr.put("memberBcode", memberBcode);
        mapStr.put("fuzzy", true);
        mapStr.put("dataStateNot", "2");
        SupQueryResult atAuctionEnrollResult = this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(mapStr);
        boolean flag = false;
        if (ListUtil.isNotEmpty((Collection)atAuctionEnrollResult.getList())) {
            AtAuctionEnrollReDomain atAuctionEnrollReDomain = (AtAuctionEnrollReDomain)atAuctionEnrollResult.getList().get(0);
            atAuctionReDomain.setAtauctionDate(atAuctionEnrollReDomain.getAtauctionDate());
            if (atAuctionEnrollReDomain.getDataState() == 0 && atAuctionEnrollReDomain.getAuctionEnrollDstate() != -1) {
                flag = true;
            }
        }
        if (null != (param = this.assemMapParam(request))) {
            param.put("auctionCode", auctionCode);
            param.put("memberBcode", memberBcode);
            param.put("tenantCode", tenantCode);
        }
        if (null == (auctionGinfoPageResult = this.atAuctionServiceRepository.queryAuctionGinfoByCodePageNew(param))) {
            return null;
        }
        SupPageTools pageTools = auctionGinfoPageResult.getPageTools();
        atAuctionReDomain.setTotal(Integer.valueOf(pageTools.getRecordCount()));
        List list = auctionGinfoPageResult.getList();
        ArrayList<AtAuctionGinfoReDomain> atAuctionGinfoReDomains = new ArrayList<AtAuctionGinfoReDomain>();
        HashMap<String, String> map = null;
        for (AtAuctionGinfoReDomain atAuctionGinfoReDomain : list) {
            String auctionGinfoCode = atAuctionGinfoReDomain.getAuctionGinfoCode();
            map = new HashMap<String, String>();
            map.put("tenantCode", tenantCode);
            map.put("memberBcode", memberBcode);
            if (auctionEnrollDtType == 1) {
                map.put("auctionDtRemark", auctionGinfoCode);
            }
            map.put("auctionCode", atAuctionGinfoReDomain.getAuctionCode());
            List atAuctiondtReDomains = this.atAuctiondtServiceRepository.queryAuctiondtPage(map).getList();
            if (ListUtil.isEmpty((Collection)atAuctiondtReDomains)) {
                atAuctionGinfoReDomain.setDtDateState(Integer.valueOf(-1));
                atAuctionGinfoReDomain.setAuctionGinfoPrice(null);
                atAuctionGinfoReDomain.setAuctionGinfoMoney(null);
            } else if (((AtAuctiondtReDomain)atAuctiondtReDomains.get(0)).getDataState() == 0) {
                atAuctionGinfoReDomain.setDtDateState(Integer.valueOf(0));
                atAuctionGinfoReDomain.setAuctionGinfoPrice(null);
                atAuctionGinfoReDomain.setAuctionGinfoMoney(null);
            } else if (((AtAuctiondtReDomain)atAuctiondtReDomains.get(0)).getDataState() == 2) {
                atAuctionGinfoReDomain.setDtDateState(Integer.valueOf(2));
            } else {
                atAuctionGinfoReDomain.setDtDateState(Integer.valueOf(1));
            }
            if (atAuctionGinfoReDomain.getDataState() == 2) {
                if (atAuctionGinfoReDomain.getAuctionGinfoMem().equals(memberBcode)) {
                    atAuctionGinfoReDomain.setWinFlag(Boolean.valueOf(true));
                } else {
                    atAuctionGinfoReDomain.setWinFlag(Boolean.valueOf(false));
                }
            }
            if (atAuctionGinfoReDomain.getAuctionruleType().equals("0") && atAuctionGinfoReDomain.getDataState() == 1) {
                atAuctionGinfoReDomain.setAuctionGinfoPrice(null);
                atAuctionGinfoReDomain.setAuctionGinfoMoney(null);
            }
            if (flag) {
                atAuctionGinfoReDomain.setDataState(null);
            }
            if (ListUtil.isNotEmpty((Collection)atAuctiondtReDomains)) {
                atAuctionGinfoReDomains.add(atAuctionGinfoReDomain);
            }
            HashMap<String, Object> maps = new HashMap<String, Object>();
            maps.put("auctionGinfoCode", atAuctionGinfoReDomain.getAuctionGinfoCode());
            maps.put("tenantCode", tenantCode);
            maps.put("memberBcode", memberBcode);
            maps.put("order", true);
            SupQueryResult atAuctionPriceReDomainSupQueryResult = this.atAuctionPriceServiceRepository.queryatAuctionPricePage(maps);
            List atAuctionPriceReDomains = atAuctionPriceReDomainSupQueryResult.getList();
            if (ListUtil.isEmpty((Collection)atAuctionPriceReDomains)) {
                atAuctionGinfoReDomain.setMyPrice(null);
                continue;
            }
            AtAuctionPriceReDomain atAuctionPriceReDomain = (AtAuctionPriceReDomain)atAuctionPriceReDomains.get(0);
            atAuctionGinfoReDomain.setMyPrice(atAuctionPriceReDomain.getAuctionPriceAmount().add(atAuctionGinfoReDomain.getPricesetNprice()));
        }
        atAuctionReDomain.setAuctionGinfoReDomainList(atAuctionGinfoReDomains);
        return atAuctionReDomain;
    }

    @RequestMapping(value={"queryAuctionGinfoPageItemsForPcAt.json"}, name="pc\u9996\u9875\u67e5\u8be2\u5355\u54c1\u4fe1\u606f\u5217\u8868")
    @ResponseBody
    public List<AtAuctionGinfoReDomain> queryAuctionGinfoPageItemsForPcAt(HttpServletRequest request) {
        return this.queryAuctionGinfoPageItemsCom(request);
    }

    @RequestMapping(value={"queryAuctionGinfoPageItemsForAtPc.json"}, name="pc\u9996\u9875\u67e5\u8be2\u5355\u54c1\u4fe1\u606f\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionGinfoReDomain> queryAuctionGinfoPageItemsForAtPc(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("auctionType", "02");
        param.put("auctionruleScope", "1");
        return this.atAuctionServiceRepository.queryatAuctionGinfoPage(param);
    }

    @RequestMapping(value={"queryAuctionGinfoDetails.json"}, name="\u7ade\u4ef7\u4fe1\u606f\u5217\u8868\u8be6\u60c5")
    @ResponseBody
    public SupQueryResult<AtAuctionGinfoReDomain> queryAuctionGinfoDetails(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        SupQueryResult atAuctionGinfoReDomainSupQueryResult = null;
        ArrayList<AtAuctionGinfoReDomain> atAuctionGinfoReDomainList = new ArrayList<AtAuctionGinfoReDomain>();
        SupQueryResult atAuctionGoodsReDomainSupQueryResult = this.atAuctionServiceRepository.queryatAuctionGoodsPage(param);
        if (ListUtil.isNotEmpty((Collection)atAuctionGoodsReDomainSupQueryResult.getList())) {
            HashMap<String, String> paramStr = new HashMap<String, String>();
            for (AtAuctionGoodsReDomain atAuctionGoodsReDomain : atAuctionGoodsReDomainSupQueryResult.getList()) {
                String goodsNo = atAuctionGoodsReDomain.getGoodsNo();
                paramStr.put("tenantCode", this.getTenantCode(request));
                paramStr.put("auctionGinfoCode", atAuctionGoodsReDomain.getAuctionGinfoCode());
                atAuctionGinfoReDomainSupQueryResult = this.atAuctionServiceRepository.queryatAuctionGinfoPage(paramStr);
                if (!ListUtil.isNotEmpty((Collection)atAuctionGinfoReDomainSupQueryResult.getList())) continue;
                HashMap<String, String> paramStr1 = new HashMap<String, String>();
                for (AtAuctionGinfoReDomain atAuctionGinfoReDomain : atAuctionGinfoReDomainSupQueryResult.getList()) {
                    paramStr1.put("tenantCode", this.getTenantCode(request));
                    paramStr1.put("goodsNo", goodsNo);
                    SupQueryResult ocContractGoodsReDomainSupQueryResult = this.ocContractServiceRepository.queryContractGoodsPage(paramStr1);
                    if (ListUtil.isNotEmpty((Collection)ocContractGoodsReDomainSupQueryResult.getList())) {
                        atAuctionGinfoReDomain.setOcContractGoodsReDomainList(ocContractGoodsReDomainSupQueryResult.getList());
                    }
                    atAuctionGinfoReDomainList.add(atAuctionGinfoReDomain);
                }
            }
            if (ListUtil.isNotEmpty(atAuctionGinfoReDomainList)) {
                atAuctionGinfoReDomainSupQueryResult.setRows(atAuctionGinfoReDomainList);
                atAuctionGinfoReDomainSupQueryResult.setList(atAuctionGinfoReDomainList);
            }
        }
        return atAuctionGinfoReDomainSupQueryResult;
    }

    @RequestMapping(value={"getAuctionGinfoPageItemsForPcAt.json"}, name="\u5355\u54c1\u4fe1\u606f\u8be6\u60c5")
    @ResponseBody
    public AtAuctionGinfoReDomain getAuctionGinfoPageItemsForPcAt(HttpServletRequest request, String atauctionGinfoId) {
        if (StringUtils.isBlank((String)atauctionGinfoId)) {
            this.logger.error(CODE + "getAuctionGinfoPageItemsForPcAt", (Object)"atauctionId is null");
            return null;
        }
        return this.atAuctionServiceRepository.getatAuctionGinfo(Integer.valueOf(atauctionGinfoId));
    }

    @RequestMapping(value={"queryAuctionPageComForPcAt.json"}, name="pc\u9996\u9875\u67e5\u8be2\u516c\u544a\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPageComForPcAt(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("auctionType", "01");
            param.put("auctionAudit", "1");
            param.put("orderStr", "AUCTION_EDATE DESC");
            param.put("dataStateStr", "0,1,2");
        }
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"queryAuctionPageTrailerForPcAt.json"}, name="pc\u9996\u9875\u67e5\u8be2\u9884\u544a\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPageTrailerForPcAt(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("auctionType", "00");
            param.put("auctionAudit", "1");
            param.put("dataStateStr", "0,1");
        }
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"queryAuctionGinfoWin.json"}, name="\u67e5\u8be2\u6210\u4ea4\u52a8\u6001")
    @ResponseBody
    public SupQueryResult<AtAuctionGinfoReDomain> queryAuctionGinfoWin(HttpServletRequest request) {
        Map params = this.assemMapParam(request);
        Map param = this.assemMapParam(request);
        params.put("flagSettingCode", "dateTime");
        List list = this.atAuctionServiceRepository.queryFalgSettingPage(params).getList();
        if (ListUtil.isNotEmpty((Collection)list)) {
            DdFalgSettingReDomain ddFalgSettingReDomain = (DdFalgSettingReDomain)list.get(0);
            String flagSettingPro = ddFalgSettingReDomain.getFlagSettingPro();
            String flagSettingPro1 = ddFalgSettingReDomain.getFlagSettingPro1();
            param.put("startDate", flagSettingPro);
            param.put("endDate", flagSettingPro1);
        }
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("auctionType", "01");
        }
        param.put("dataState", 2);
        return this.atAuctionServiceRepository.queryatAuctionGinfoPage(param);
    }

    @RequestMapping(value={"querySysDate.json"}, name="\u83b7\u53d6\u670d\u52a1\u5668\u65f6\u95f4")
    @ResponseBody
    public HtmlJsonReBean querySysDate() {
        HtmlJsonReBean sysDate = this.atAuctionServiceRepository.getSysDate();
        String dataObj = (String)sysDate.getDataObj();
        if (StringUtils.isBlank((String)dataObj)) {
            this.logger.error(CODE + "querySysDate", (Object)("dataObj====" + dataObj));
            return null;
        }
        Date parse = new Date();
        try {
            parse = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dataObj);
        }
        catch (Exception e) {
            // empty catch block
        }
        return new HtmlJsonReBean((Object)parse.getTime());
    }

    @RequestMapping(value={"queryAuctionBuyBid.json"}, name="\u67e5\u770b\u516c\u544a--\u51fa\u4ef7\u8be6\u60c5\u9875\u9762")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionBuyBid(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("fuzzy", true);
            param.put("order", true);
        }
        param.put("dataStateStr", "1,2");
        param.put("auctionAudit", "1");
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"queryAuctionGinfoSignByCode.json"}, name="\u67e5\u8be2\u5355\u54c1\u573a\u6b21\u5305\u88f9\u4fe1\u606f")
    @ResponseBody
    public SupQueryResult<AtAuctionGinfoReDomain> queryAuctionGinfoSignByCode(HttpServletRequest request, String auctionCode) {
        if (StringUtils.isBlank((String)auctionCode)) {
            this.logger.error(CODE + ".queryAuctionGinfoSignByCode", (Object)"auctionCode is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        String memberCode = userSession.getUserPcode();
        this.logger.error(CODE + ".queryAuctionGinfoByCode\u53ea\u67e5\u8be2\u5f53\u524d\u573a\u6b21\u4e0b\u7684\u5305\u88f9\u4fe1\u606f", (Object)("userSession:" + JsonUtil.buildNormalBinder().toJson((Object)userSession)));
        this.logger.error(CODE + ".queryAuctionGinfoByCode\u53ea\u67e5\u8be2\u5f53\u524d\u573a\u6b21\u4e0b\u7684\u5305\u88f9\u4fe1\u606f", (Object)("memberCode:" + memberCode));
        SupQueryResult atAuctionGinfoReDomainSupQueryResult = this.atAuctionServiceRepository.queryAuctionGinfoByCodeNew(auctionCode, this.getTenantCode(request), memberCode, "2");
        HashMap<String, String> map = new HashMap<String, String>();
        for (AtAuctionGinfoReDomain atAuctionGinfoReDomain : atAuctionGinfoReDomainSupQueryResult.getList()) {
            map.put("auctionGinfoCode", atAuctionGinfoReDomain.getAuctionGinfoCode());
            map.put("tenantCode", atAuctionGinfoReDomain.getTenantCode());
            List list = this.atAuctionServiceRepository.queryatAuctionGoodsPage(map).getList();
            atAuctionGinfoReDomain.setAtAuctionGoodsReDomainList(list);
            atAuctionGinfoReDomain.setAuctionGinfoMem(null);
            atAuctionGinfoReDomain.setAuctionGinfoMemname(null);
        }
        return atAuctionGinfoReDomainSupQueryResult;
    }

    public static void main(String[] args) {
        AtAuctionEnrollReDomain atAuctionEnrollReDomain = new AtAuctionEnrollReDomain();
        atAuctionEnrollReDomain.setDataState(Integer.valueOf(0));
        atAuctionEnrollReDomain.setAuctionEnrollDstate(Integer.valueOf(0));
        if (atAuctionEnrollReDomain.getDataState() == 0 && atAuctionEnrollReDomain.getAuctionEnrollDstate() != -1) {
            System.out.println("=========");
        }
    }

    private Map<String, BigDecimal> getMypriceGroupByGinfoCode(Map<String, List<AtAuctionPriceReDomain>> ginfoCodeVsPriceListMap) {
        HashMap<String, BigDecimal> ginfoCodeVsMoney = new HashMap<String, BigDecimal>();
        if (!ginfoCodeVsPriceListMap.isEmpty()) {
            for (Map.Entry<String, List<AtAuctionPriceReDomain>> entry : ginfoCodeVsPriceListMap.entrySet()) {
                String ginfoCode = entry.getKey();
                List<AtAuctionPriceReDomain> auctionPriceReDomainList = entry.getValue();
                AtAuctionPriceReDomain latestPriceInfo = this.getMaxOneByBubbleSort(auctionPriceReDomainList);
                BigDecimal money = null;
                if (null != latestPriceInfo) {
                    money = latestPriceInfo.getAuctionPriceAmount();
                }
                ginfoCodeVsMoney.put(ginfoCode, money);
            }
        }
        return ginfoCodeVsMoney;
    }

    private AtAuctionPriceReDomain getMaxOneByBubbleSort(List<AtAuctionPriceReDomain> auctionPriceReDomainsList) {
        AtAuctionPriceReDomain atAuctionPriceReDomain = null;
        if (CollectionUtils.isNotEmpty(auctionPriceReDomainsList)) {
            for (int i = 0; i < auctionPriceReDomainsList.size() - 1; ++i) {
                for (int j = 1; j < auctionPriceReDomainsList.size() - i; ++j) {
                    if (auctionPriceReDomainsList.get(j - 1).getGmtCreate().compareTo(auctionPriceReDomainsList.get(j).getGmtCreate()) <= 0) continue;
                    AtAuctionPriceReDomain temp = auctionPriceReDomainsList.get(j - 1);
                    auctionPriceReDomainsList.set(j - 1, auctionPriceReDomainsList.get(j));
                    auctionPriceReDomainsList.set(j, temp);
                }
            }
            int maxOneIndex = auctionPriceReDomainsList.size() - 1;
            atAuctionPriceReDomain = auctionPriceReDomainsList.get(maxOneIndex);
        }
        return atAuctionPriceReDomain;
    }
}

