/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.at.controller;

import Utils.ObjectUtils;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.core.util.HtmlUtil;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionEnrollDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionEnrollReDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionEnrollfileDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionGinfoReDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionMemReDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionReDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionUserginfoReDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionWinReDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctiondtReDomain;
import com.qjsoft.laser.controller.facade.at.repository.AtAuctionEnrollServiceRepository;
import com.qjsoft.laser.controller.facade.at.repository.AtAuctionServiceRepository;
import com.qjsoft.laser.controller.facade.at.repository.AtAuctionUserginfoServiceRepository;
import com.qjsoft.laser.controller.facade.at.repository.AtAuctionWinServiceRepository;
import com.qjsoft.laser.controller.facade.at.repository.AtAuctiondtServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmMemoauthReDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UmMemoauthServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.facade.vd.domain.VdFaccountInfo;
import com.qjsoft.laser.controller.facade.vd.domain.VdFaccountOuterSubsetDomain;
import com.qjsoft.laser.controller.facade.vd.repository.VdFaccountOuterServiceRepository;
import com.qjsoft.laser.controller.facade.vd.repository.VdFaccountServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/at/auctionEnroll"}, name="\u7ade\u4ef7\u62a5\u540d")
public class AuctionEnrollCon
extends SpringmvcController {
    private static String CODE = "at.auctionEnroll.con";
    @Autowired
    private AtAuctionEnrollServiceRepository atAuctionEnrollServiceRepository;
    @Autowired
    private AtAuctiondtServiceRepository atAuctiondtServiceRepository;
    @Autowired
    private AtAuctionServiceRepository atAuctionServiceRepository;
    @Autowired
    private AtAuctionUserginfoServiceRepository atAuctionUserginfoServiceRepository;
    @Autowired
    private AtAuctionWinServiceRepository atAuctionWinServiceRepository;
    @Autowired
    private VdFaccountOuterServiceRepository vdFaccountOuterServiceRepository;
    @Autowired
    private UmMemoauthServiceRepository umMemoauthServiceRepository;
    @Autowired
    private VdFaccountServiceRepository vdFaccountServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;

    protected String getContext() {
        return "auctionEnroll";
    }

    @RequestMapping(value={"saveAuctionEnroll.json"}, name="\u589e\u52a0\u7ade\u4ef7\u62a5\u540d")
    @ResponseBody
    public HtmlJsonReBean saveAuctionEnroll(HttpServletRequest request, AtAuctionEnrollDomain atAuctionEnrollDomain) {
        if (null == atAuctionEnrollDomain) {
            this.logger.error(CODE + ".saveAuctionEnroll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean("error", "session is null");
        }
        String tenantCode = userSession.getTenantCode();
        String memberBcode = userSession.getUserPcode();
        String memberBname = userSession.getMerberCompname();
        String auctionCode = atAuctionEnrollDomain.getAuctionCode();
        if (StringUtils.isEmpty((String)auctionCode)) {
            return new HtmlJsonReBean("error", "auctionCode is null");
        }
        AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuctionByCode(tenantCode, auctionCode);
        if (null == atAuctionReDomain) {
            return new HtmlJsonReBean("error", "auction is null");
        }
        if (!this.checkUserinfoTypePermis(userSession, tenantCode, auctionCode, atAuctionReDomain)) {
            return new HtmlJsonReBean("error", "\u62b1\u6b49,\u60a8\u6682\u65e0\u53c2\u52a0\u8be5\u573a\u6b21\u6743\u9650\uff01");
        }
        if (!this.permisAuction(memberBcode, auctionCode, tenantCode)) {
            return new HtmlJsonReBean("error", "\u62b1\u6b49,\u60a8\u6682\u65e0\u53c2\u52a0\u8be5\u573a\u6b21\u6743\u9650\uff01");
        }
        Date date = new Date();
        Date auctionADate = atAuctionReDomain.getAuctionAdate();
        Date auctionAGDate = atAuctionReDomain.getAuctionAgdate();
        if ("0".equals(atAuctionEnrollDomain.getAuctionEnrollType())) {
            if (date.compareTo(auctionAGDate) > 0) {
                return new HtmlJsonReBean("error", "\u770b\u8d27\u65f6\u95f4\u5df2\u622a\u6b62");
            }
        } else if ("1".equals(atAuctionEnrollDomain.getAuctionEnrollType()) && date.compareTo(auctionADate) > 0) {
            return new HtmlJsonReBean("error", "\u7ade\u4ef7\u65f6\u95f4\u5df2\u622a\u6b62");
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)atAuctionEnrollDomain, (Object)atAuctionReDomain);
        }
        catch (Exception e) {
            // empty catch block
        }
        atAuctionEnrollDomain.setTenantCode(tenantCode);
        atAuctionEnrollDomain.setMemberBcode(memberBcode);
        atAuctionEnrollDomain.setMemberBname(memberBname);
        atAuctionEnrollDomain.setAuctionQutinfo(atAuctionReDomain.getAuctionQutinfo());
        return this.atAuctionEnrollServiceRepository.saveatAuctionEnroll(atAuctionEnrollDomain);
    }

    private boolean checkUserinfoTypePermis(UserSession userSession, String tenantCode, String auctionCode, AtAuctionReDomain atAuctionReDomain) {
        String auctionMemType;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("auctionCode", auctionCode);
        SupQueryResult atAuctionMemResult = this.atAuctionServiceRepository.queryatAuctionMemPage(map);
        if (ListUtil.isNotEmpty((Collection)atAuctionMemResult.getList()) && !"0".equals(auctionMemType = ((AtAuctionMemReDomain)atAuctionMemResult.getList().get(0)).getAuctionMemType()) && !auctionMemType.equals(userSession.getUserinfoType())) {
            return false;
        }
        return !userSession.getUserPcode().equals(atAuctionReDomain.getMemberCcode());
    }

    @RequestMapping(value={"getAuctionEnroll.json"}, name="\u83b7\u53d6\u7ade\u4ef7\u62a5\u540d\u4fe1\u606f")
    @ResponseBody
    public AtAuctionEnrollReDomain getAuctionEnroll(Integer auctionEnrollfileId) {
        if (StringUtils.isBlank((Integer)auctionEnrollfileId)) {
            this.logger.error(CODE + ".getAuctionEnroll", (Object)"param is null");
            return null;
        }
        return this.atAuctionEnrollServiceRepository.getatAuctionEnroll(auctionEnrollfileId);
    }

    @RequestMapping(value={"updateAuctionEnroll.json"}, name="\u66f4\u65b0\u7ade\u4ef7\u62a5\u540d")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnroll(HttpServletRequest request, AtAuctionEnrollDomain atAuctionEnrollDomain) {
        if (null == atAuctionEnrollDomain) {
            this.logger.error(CODE + ".updateAuctionEnroll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        atAuctionEnrollDomain.setTenantCode(this.getTenantCode(request));
        return this.atAuctionEnrollServiceRepository.updateatAuctionEnroll(atAuctionEnrollDomain);
    }

    @RequestMapping(value={"updateAuctionEnrollToSubmit.json"}, name="\u66f4\u65b0\u7ade\u4ef7\u62a5\u540d")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollToSubmit(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".updateAuctionEnrollToSubmit", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List atAuctionEnrollfileDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, AtAuctionEnrollfileDomain.class);
        if (ListUtil.isEmpty((Collection)atAuctionEnrollfileDomainList)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "list is null");
        }
        AtAuctionEnrollReDomain atAuctionEnrollDomain = this.atAuctionEnrollServiceRepository.getatAuctionEnrollByCode(this.getTenantCode(request), ((AtAuctionEnrollfileDomain)atAuctionEnrollfileDomainList.get(0)).getAuctionEnrollCode());
        if (null == atAuctionEnrollDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u62a5\u540d\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (2 == atAuctionEnrollDomain.getAuctionEnrollDstate()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4fdd\u8bc1\u91d1\u5ba1\u6838\u5931\u8d25,\u6682\u65e0\u8d44\u683c\u91cd\u65b0\u63d0\u4ea4");
        }
        atAuctionEnrollDomain.setAtAuctionEnrollfileDomainList(atAuctionEnrollfileDomainList);
        atAuctionEnrollDomain.setAuctionEnrollQstate(Integer.valueOf(0));
        atAuctionEnrollDomain.setDataState(Integer.valueOf(0));
        return this.atAuctionEnrollServiceRepository.updateatAuctionEnroll((AtAuctionEnrollDomain)atAuctionEnrollDomain);
    }

    @RequestMapping(value={"deleteAuctionEnroll.json"}, name="\u5220\u9664\u7ade\u4ef7\u62a5\u540d")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionEnroll(Integer auctionEnrollfileId) {
        if (StringUtils.isBlank((Integer)auctionEnrollfileId)) {
            this.logger.error(CODE + ".deleteAuctionEnroll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.atAuctionEnrollServiceRepository.deleteatAuctionEnroll(auctionEnrollfileId);
    }

    @RequestMapping(value={"queryAuctionEnrollPage.json"}, name="\u67e5\u8be2\u7ade\u4ef7\u62a5\u540d\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionEnrollPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
    }

    @RequestMapping(value={"updateAuctionEnrollState.json"}, name="\u66f4\u65b0\u7ade\u4ef7\u62a5\u540d\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollState(String auctionEnrollfileId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)auctionEnrollfileId)) {
            this.logger.error(CODE + ".updateAuctionEnrollState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.atAuctionEnrollServiceRepository.updateatAuctionEnrollState(Integer.valueOf(auctionEnrollfileId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryAuctionEnrollForAt.json"}, name="\u770b\u8d27\u62a5\u540d\u5206\u9875\u5217\u8868-\u516c\u544a")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionEnrollForAt(HttpServletRequest request, String auctionCode) {
        if (null == auctionCode) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("auctionCode", auctionCode);
        param.put("auctionType", "01");
        return this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
    }

    @RequestMapping(value={"queryAuctionBiddingEnrollForAt.json"}, name="\u7ade\u4ef7\u62a5\u540d\u5206\u9875\u5217\u8868-\u516c\u544a")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionBiddingEnrollForAt(HttpServletRequest request, String auctionCode) {
        if (null == auctionCode) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("auctionCode", auctionCode);
        param.put("auctionType", "01");
        param.put("auctionEnrollType", "1");
        return this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
    }

    @RequestMapping(value={"saveAuctionEnrollByStr.json"}, name="\u589e\u52a0\u7ade\u4ef7\u62a5\u540d")
    @ResponseBody
    public HtmlJsonReBean saveAuctionEnrollByStr(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "paramStr is null");
        }
        AtAuctionEnrollDomain atAuctionEnrollDomain = (AtAuctionEnrollDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, AtAuctionEnrollDomain.class);
        if (null == atAuctionEnrollDomain) {
            this.logger.error(CODE + ".saveAuctionEnroll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean("error", "session is null");
        }
        String tenantCode = userSession.getTenantCode();
        String memberBcode = userSession.getUserPcode();
        String memberBname = userSession.getMerberCompname();
        String auctionCode = atAuctionEnrollDomain.getAuctionCode();
        Integer ruleDpType = atAuctionEnrollDomain.getAuctionruleDptype();
        if (StringUtils.isEmpty((String)auctionCode)) {
            return new HtmlJsonReBean("error", "auctionCode is null");
        }
        AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuctionByCode(tenantCode, auctionCode);
        if (null == atAuctionReDomain) {
            return new HtmlJsonReBean("error", "auction is null");
        }
        if (!this.checkUserinfoTypePermis(userSession, tenantCode, auctionCode, atAuctionReDomain)) {
            return new HtmlJsonReBean("error", "\u62b1\u6b49,\u60a8\u6682\u65e0\u53c2\u52a0\u8be5\u573a\u6b21\u6743\u9650\uff01");
        }
        if (!this.permisAuction(memberBcode, auctionCode, tenantCode)) {
            return new HtmlJsonReBean("error", "\u62b1\u6b49,\u60a8\u6682\u65e0\u53c2\u52a0\u8be5\u573a\u6b21\u6743\u9650\uff01");
        }
        Date date = new Date();
        Date auctionADate = atAuctionReDomain.getAuctionAdate();
        Date auctionAGDate = atAuctionReDomain.getAuctionAgdate();
        if ("0".equals(atAuctionEnrollDomain.getAuctionEnrollType())) {
            if (date.compareTo(auctionAGDate) > 0) {
                return new HtmlJsonReBean("error", "\u770b\u8d27\u65f6\u95f4\u5df2\u622a\u6b62");
            }
        } else if ("1".equals(atAuctionEnrollDomain.getAuctionEnrollType()) && date.compareTo(auctionADate) > 0) {
            return new HtmlJsonReBean("error", "\u7ade\u4ef7\u65f6\u95f4\u5df2\u622a\u6b62");
        }
        if ("01".equals(atAuctionReDomain.getAuctionType()) && 2 == atAuctionReDomain.getDataState()) {
            return new HtmlJsonReBean("error", "\u7ade\u4ef7\u573a\u6b21\u5df2\u7ed3\u675f\uff01");
        }
        if ("02".equals(atAuctionReDomain.getAuctionType())) {
            HashMap<String, Object> parMap = new HashMap<String, Object>();
            parMap.put("auctionCode", auctionCode);
            parMap.put("tenantCode", tenantCode);
            parMap.put("fuzzy", true);
            List ginfoReDomains = this.atAuctionServiceRepository.queryatAuctionGinfoPage(parMap).getList();
            if (ListUtil.isEmpty((Collection)ginfoReDomains)) {
                return new HtmlJsonReBean("error", "\u5305\u88f9\u4fe1\u606f\u5f02\u5e38\uff01");
            }
            Integer gInfoDataState = ((AtAuctionGinfoReDomain)ginfoReDomains.get(0)).getDataState();
            if (2 == atAuctionReDomain.getDataState() && 2 == gInfoDataState) {
                return new HtmlJsonReBean("error", "\u7ade\u4ef7\u573a\u6b21\u5df2\u7ed3\u675f\uff01");
            }
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)atAuctionEnrollDomain, (Object)atAuctionReDomain);
        }
        catch (Exception e) {
            // empty catch block
        }
        atAuctionEnrollDomain.setTenantCode(tenantCode);
        atAuctionEnrollDomain.setMemberBcode(memberBcode);
        atAuctionEnrollDomain.setAuctionQutinfo(atAuctionReDomain.getAuctionQutinfo());
        atAuctionEnrollDomain.setMemberBname(memberBname);
        atAuctionEnrollDomain.setAuctionruleDptype(ruleDpType);
        atAuctionEnrollDomain.setDataState(Integer.valueOf(0));
        return this.atAuctionEnrollServiceRepository.saveatAuctionEnroll(atAuctionEnrollDomain);
    }

    @RequestMapping(value={"queryAuctionEnrollForPaas.json"}, name="\u770b\u8d27\u62a5\u540d\u5206\u9875\u5217\u8868-\u5e73\u53f0\u62a5\u540d\u5ba1\u6838")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionEnrollForPaas(HttpServletRequest request, String auctionCode) {
        if (null == auctionCode) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("auctionCode", auctionCode);
        param.put("auctionType", "01");
        param.put("auctionEnrollType", "0");
        return this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
    }

    @RequestMapping(value={"updateAuctionEnrollAuditQstate.json"}, name="\u5ba1\u6838\u8d44\u8d28")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollAuditQstate(HttpServletRequest request, String auctionEnrollfileId, Integer dataState, Integer oldDataState, String auctionAuremark) {
        if (StringUtils.isBlank((String)auctionEnrollfileId)) {
            this.logger.error(CODE + ".updateAuctionEnrollState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        AtAuctionEnrollReDomain atAuctionEnrollReDomain = this.atAuctionEnrollServiceRepository.getatAuctionEnroll(Integer.valueOf(auctionEnrollfileId));
        if (null == atAuctionEnrollReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u62a5\u540d\u4fe1\u606f\u4e3a\u7a7a");
        }
        AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuctionByCode(this.getTenantCode(request), atAuctionEnrollReDomain.getAuctionCode());
        if (null == atAuctionReDomain || 3 == atAuctionReDomain.getDataState()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u516c\u544a\u4fe1\u606f\u6216\u88ab\u64a4\u9500\uff0c\u7ec8\u6b62\u5ba1\u6838\u8bf7\u6c42\uff01");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auctionAuremark", auctionAuremark);
        map.put("userCode", userSession.getUserPcode());
        map.put("userName", userSession.getUserName());
        return this.atAuctionEnrollServiceRepository.updateAuctionEnrollAuditQstateNew(Integer.valueOf(auctionEnrollfileId), dataState, oldDataState, map);
    }

    @RequestMapping(value={"updateAuctionEnrollAuditDstateByTrans.json"}, name="\u5ba1\u6838\u4fdd\u8bc1\u91d1\u901a\u8fc7")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollAuditDstateByTrans(HttpServletRequest request, String auctionEnrollfileId, Integer dataState, Integer oldDataState, String auctionAuremark, String auctionDtId, String phone) {
        String tenantCode;
        String userCode;
        if (StringUtils.isEmpty((String)auctionEnrollfileId) || null == dataState || null == oldDataState || StringUtils.isEmpty((String)auctionDtId) || StringUtils.isEmpty((String)phone)) {
            return new HtmlJsonReBean("error", "param is null");
        }
        AtAuctionEnrollReDomain atAuctionEnrollReDomain = this.atAuctionEnrollServiceRepository.getatAuctionEnroll(Integer.valueOf(auctionEnrollfileId));
        if (null == atAuctionEnrollReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u62a5\u540d\u4fe1\u606f\u4e3a\u7a7a");
        }
        AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuctionByCode(this.getTenantCode(request), atAuctionEnrollReDomain.getAuctionCode());
        if (null == atAuctionReDomain || 3 == atAuctionReDomain.getDataState()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u516c\u544a\u4fe1\u606f\u6216\u88ab\u64a4\u9500\uff0c\u7ec8\u6b62\u5ba1\u6838\u8bf7\u6c42\uff01");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean("error", "session is null");
        }
        String userName = userSession.getUserName();
        HtmlJsonReBean htmlJsonReBean = this.atAuctionEnrollServiceRepository.sendUpdateAuctionEnrollAuditByTransLoad(auctionEnrollfileId, auctionAuremark, auctionDtId, phone, userName, userCode = userSession.getUserPcode(), tenantCode = this.getTenantCode(request));
        if (null == htmlJsonReBean.getDataObj()) {
            return new HtmlJsonReBean("error", "\u5ba1\u6838\u5931\u8d25");
        }
        if ("\u8d26\u6237\u5f02\u5e38\u6216\u53ef\u7528\u4f59\u989d\u4e0d\u8db3".equals(htmlJsonReBean.getDataObj())) {
            return new HtmlJsonReBean("error", "\u8d26\u6237\u5f02\u5e38\u6216\u53ef\u7528\u4f59\u989d\u4e0d\u8db3");
        }
        return new HtmlJsonReBean((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"updateAuctionEnrollAuditByReturn.json"}, name="\u5ba1\u6838\u4fdd\u8bc1\u91d1\u91ca\u653e")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollAuditByReturn(HttpServletRequest request, String auctionDtId) {
        Map map = this.assemMapParam(request);
        String memo = map.get("memo").toString();
        return this.updateAuctionEnrollAuditByReturCom(request, auctionDtId, null, memo);
    }

    @RequestMapping(value={"updateAuctionEnrollAuditByReturnFail.json"}, name="\u5ba1\u6838\u4fdd\u8bc1\u91d1\u91ca\u653e\u5931\u8d25")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollAuditByReturnFail(HttpServletRequest request, String auctionDtId) {
        Map map = this.assemMapParam(request);
        String memo = map.get("memo").toString();
        return this.updateAuctionEnrollAuditByReturCom(request, auctionDtId, "returnFail", memo);
    }

    private HtmlJsonReBean updateAuctionEnrollAuditByReturCom(HttpServletRequest request, String auctionDtId, String phone, String memo) {
        if (StringUtils.isEmpty((String)auctionDtId) || StringUtils.isEmpty((String)auctionDtId)) {
            return new HtmlJsonReBean("error", "param is null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean("error", "session is null");
        }
        String userName = userSession.getUserName();
        String userCode = userSession.getUserPcode();
        String tenantCode = this.getTenantCode(request);
        return this.atAuctionEnrollServiceRepository.updateAuctionEnrollAuditByReturn(auctionDtId, phone, userName, userCode, tenantCode, memo);
    }

    @RequestMapping(value={"updateAuctionEnrollAuditDstateFail.json"}, name="\u5ba1\u6838\u4fdd\u8bc1\u91d1\u5931\u8d25")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollAuditDstateFail(HttpServletRequest request, String auctionEnrollfileId, Integer dataState, Integer oldDataState, String auctionAuremark, String auctionDtId) {
        if (StringUtils.isEmpty((String)auctionEnrollfileId) || null == dataState || null == oldDataState) {
            return new HtmlJsonReBean("error", "param is null");
        }
        AtAuctionEnrollReDomain atAuctionEnrollReDomain = this.atAuctionEnrollServiceRepository.getatAuctionEnroll(Integer.valueOf(auctionEnrollfileId));
        if (null == atAuctionEnrollReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u62a5\u540d\u4fe1\u606f\u4e3a\u7a7a");
        }
        AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuctionByCode(this.getTenantCode(request), atAuctionEnrollReDomain.getAuctionCode());
        if (null == atAuctionReDomain || 3 == atAuctionReDomain.getDataState()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u516c\u544a\u4fe1\u606f\u6216\u88ab\u64a4\u9500\uff0c\u7ec8\u6b62\u5ba1\u6838\u8bf7\u6c42\uff01");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateAuctionEnrollAuditDstateFail", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        String userName = userSession.getUserName();
        String userCode = userSession.getUserPcode();
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isNotBlank((String)auctionDtId) && "auctionDtId".equals(auctionDtId)) {
            atAuctionEnrollReDomain.setAuctionEnrollQstate(Integer.valueOf(2));
            atAuctionEnrollReDomain.setAuctionEnrollDstate(Integer.valueOf(2));
            atAuctionEnrollReDomain.setDataState(Integer.valueOf(2));
            atAuctionEnrollReDomain.setUserCode(userCode);
            atAuctionEnrollReDomain.setUserName(userName);
            return this.atAuctionEnrollServiceRepository.updateatAuctionEnroll((AtAuctionEnrollDomain)atAuctionEnrollReDomain);
        }
        if (dataState == 2 && oldDataState == 0) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("auctionCode", atAuctionEnrollReDomain.getAuctionCode());
            paramMap.put("memberBcode", atAuctionEnrollReDomain.getMemberBcode());
            paramMap.put("tenantCode", atAuctionEnrollReDomain.getTenantCode());
            List atAuctiondtReDomains = this.atAuctiondtServiceRepository.queryAuctiondtPage(paramMap).getList();
            if (ListUtil.isEmpty((Collection)atAuctiondtReDomains)) {
                this.logger.error(CODE + ".updateAuctionEnrollAuditDstateFail", (Object)"atAuctiondtReDomains is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "atAuctiondtReDomains is null");
            }
            paramMap.remove("auctionCode");
            paramMap.remove("memberBcode");
            paramMap.remove("tenantCode");
            paramMap.put("userCode", userCode);
            paramMap.put("userName", userName);
            for (AtAuctiondtReDomain atAuctiondtReDomain : atAuctiondtReDomains) {
                if (atAuctiondtReDomain.getDataState() != 0) continue;
                this.atAuctiondtServiceRepository.updateAuctiondtState(atAuctiondtReDomain.getAuctionDtId(), Integer.valueOf(2), Integer.valueOf(0), paramMap);
            }
            atAuctionEnrollReDomain.setAuctionEnrollQstate(Integer.valueOf(2));
            atAuctionEnrollReDomain.setAuctionEnrollDstate(Integer.valueOf(2));
            atAuctionEnrollReDomain.setDataState(Integer.valueOf(2));
            atAuctionEnrollReDomain.setUserCode(userCode);
            atAuctionEnrollReDomain.setUserName(userName);
            return this.atAuctionEnrollServiceRepository.updateatAuctionEnroll((AtAuctionEnrollDomain)atAuctionEnrollReDomain);
        }
        return this.atAuctionEnrollServiceRepository.sendUpdateAuctionEnrollAuditByTransLoad(auctionEnrollfileId, auctionAuremark, auctionDtId, null, userName, userCode, tenantCode);
    }

    @RequestMapping(value={"getAuctionEnrollForPaasAt.json"}, name="\u7ade\u4ef7\u5ba1\u6838\u9875\u9762")
    @ResponseBody
    public AtAuctionEnrollReDomain getAuctionEnrollForPaasAt(String auctionEnrollId) {
        if (null == auctionEnrollId) {
            return null;
        }
        AtAuctionEnrollReDomain atAuctionEnrollReDomain = this.atAuctionEnrollServiceRepository.getatAuctionEnroll(Integer.valueOf(auctionEnrollId));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auctionCode", atAuctionEnrollReDomain.getAuctionCode());
        map.put("memberBcode", atAuctionEnrollReDomain.getMemberBcode());
        map.put("tenantCode", atAuctionEnrollReDomain.getTenantCode());
        map.put("auctionDtType", "0,1");
        map.put("auctionEnrollCode", atAuctionEnrollReDomain.getAuctionEnrollCode());
        atAuctionEnrollReDomain.setAtAuctiondtReDomainList(this.atAuctiondtServiceRepository.queryAuctiondtPage(map).getList());
        return atAuctionEnrollReDomain;
    }

    @RequestMapping(value={"queryAuctionEnrollForAtPaas.json"}, name="\u770b\u8d27\u62a5\u540d\u5206\u9875\u5217\u8868-\u516c\u544a\u7ed9\u5e73\u53f0")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionEnrollForAtPaas(HttpServletRequest request, String auctionCode) {
        if (null == auctionCode) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("auctionCode", auctionCode);
        param.put("auctionType", "01");
        return this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
    }

    @RequestMapping(value={"checkEnrollAndDt.json"}, name="\u68c0\u67e5\u662f\u5426\u62a5\u540d")
    @ResponseBody
    public HtmlJsonReBean checkEnrollAndDt(HttpServletRequest request, String auctionCode) {
        UserSession userSession = this.getUserSession(request);
        String tenantCode = userSession.getTenantCode();
        if (null == userSession) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("auctionCode", auctionCode);
        map.put("memberBcode", userSession.getUserPcode());
        SupQueryResult atAuctionEnrollResult = this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(map);
        SupQueryResult atAuctiondtResult = this.atAuctiondtServiceRepository.queryAuctiondtPage(map);
        boolean checkEnroll = false;
        boolean checkDt = false;
        if (ListUtil.isNotEmpty((Collection)atAuctionEnrollResult.getList())) {
            checkEnroll = true;
        }
        if (ListUtil.isNotEmpty((Collection)atAuctiondtResult.getList())) {
            checkDt = true;
        }
        return new HtmlJsonReBean((Object)("checkEnroll:" + checkEnroll + "," + "checkDt:" + checkDt));
    }

    @RequestMapping(value={"checkEnrollAtSign.json"}, name="\u68c0\u67e5\u662f\u5426\u62a5\u540d(\u5355\u54c1)")
    @ResponseBody
    public HtmlJsonReBean checkEnrollAtSign(HttpServletRequest request, String auctionCode) {
        UserSession userSession = this.getUserSession(request);
        String tenantCode = userSession.getTenantCode();
        if (null == userSession) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionCode", auctionCode);
        map.put("memberBcode", userSession.getUserPcode());
        map.put("fuzzy", true);
        SupQueryResult atAuctionEnrollResult = this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(map);
        boolean checkEnroll = false;
        this.logger.error(CODE + ".updateAuctionState.\u68c0\u67e5\u662f\u5426\u62a5\u540d(\u5355\u54c1)atAuctionEnrollResult\uff1a", (Object)(atAuctionEnrollResult.getTotal() + "," + map));
        if (ListUtil.isNotEmpty((Collection)atAuctionEnrollResult.getList())) {
            checkEnroll = true;
        }
        return new HtmlJsonReBean((Object)("checkEnroll:" + checkEnroll));
    }

    @RequestMapping(value={"getEnrollTypeAndDt.json"}, name="\u83b7\u53d6\u7528\u6237\u62a5\u540dcheck\u4fe1\u606f")
    @ResponseBody
    public AtAuctionEnrollReDomain checkEnrollTypeAndDt(HttpServletRequest request, String auctionCode, String auctionEnrollType) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"userSession is null");
            return null;
        }
        String tenantCode = userSession.getTenantCode();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("auctionCode", auctionCode);
        map.put("memberBcode", userSession.getUserPcode());
        map.put("auctionEnrollType", auctionEnrollType);
        AtAuctionEnrollReDomain atAuctionEnrollReDomain = new AtAuctionEnrollReDomain();
        atAuctionEnrollReDomain.setCheckDt(false);
        atAuctionEnrollReDomain.setCheckEnroll(false);
        map.put("dataStateNot", "2");
        SupQueryResult atAuctionEnrollResult = this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(map);
        map.remove("dataStateNot");
        SupQueryResult atAuctiondtResult = this.atAuctiondtServiceRepository.queryAuctiondtPage(map);
        if (ListUtil.isNotEmpty((Collection)atAuctionEnrollResult.getList())) {
            atAuctionEnrollReDomain = this.atAuctionEnrollServiceRepository.getatAuctionEnroll(((AtAuctionEnrollReDomain)atAuctionEnrollResult.getList().get(0)).getAuctionEnrollId());
            atAuctionEnrollReDomain.setCheckEnroll(true);
        }
        if (ListUtil.isNotEmpty((Collection)atAuctiondtResult.getList())) {
            atAuctionEnrollReDomain.setCheckDt(true);
        }
        return atAuctionEnrollReDomain;
    }

    @RequestMapping(value={"queryAuctionEnrollForPaasAt.json"}, name="\u5e73\u53f0\u62a5\u540d\u5ba1\u6838\u5217\u8868\u9875\u9762")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionEnrollForPaasAt(HttpServletRequest request) {
        String memberCodeStr;
        List umMemoauthReDomainList;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
        }
        param.put("auctionType", "01");
        param.put("auctionEnrollType", "1");
        param.put("tenantCode", this.getTenantCode(request));
        SupQueryResult umMemoauthReDomainSupQueryResult = null;
        ArrayList<String> memberCodes = new ArrayList<String>();
        this.logger.error("queryAuctionEnrollForPaasAt.json\u7ade\u4ef7\u62a5\u540d\u5ba1\u6838\u5217\u8868-------------param\u5185\u5bb9\uff1a" + JsonUtil.buildNormalBinder().toJson((Object)param));
        HashMap<String, Object> um_param = new HashMap<String, Object>();
        if (null != param.get("theMemberType") && org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{param.get("theMemberType").toString()})) {
            String opdatascsType = param.get("theMemberType").toString();
            System.out.println("------------\u7ade\u4ef7\u62a5\u540d\u5ba1\u6838\u5217\u8868\uff1atheMemberType:" + opdatascsType);
            if (opdatascsType.equals("at_auction_mem")) {
                um_param.put("tenantCode", param.get("tenantCode").toString());
                Map<String, Object> myParam = this.getMapParamFromOpdatascsType(request, opdatascsType);
                this.logger.error("queryAuctionEnrollForPaasAt.json\u7ade\u4ef7\u62a5\u540d\u5ba1\u6838\u5217\u8868-------------myParam\u5185\u5bb9\uff1a" + JsonUtil.buildNormalBinder().toJson(myParam));
                um_param.put("order", true);
                um_param.put("dataState", 1);
                um_param.put("colName0", "member_Code");
                if (null != myParam.get("colValue0")) {
                    um_param.put("colValue0", myParam.get("colValue0").toString());
                }
                umMemoauthReDomainSupQueryResult = this.umMemoauthServiceRepository.queryMemoauthPage(um_param);
            }
        }
        this.logger.error("-------------\u7ade\u4ef7\u62a5\u540d\u5ba1\u6838\u5217\u8868\uff1aum_param\uff1a" + JsonUtil.buildNormalBinder().toJson(um_param));
        if (null != umMemoauthReDomainSupQueryResult && CollectionUtils.isNotEmpty((Collection)(umMemoauthReDomainList = umMemoauthReDomainSupQueryResult.getList()))) {
            this.logger.error("-------------\u7ade\u4ef7\u62a5\u540d\u5ba1\u6838\u5217\u8868\uff1aumMemoauthReDomainList.size\uff1a" + umMemoauthReDomainList.size());
            for (UmMemoauthReDomain umMemoauthReDomain : umMemoauthReDomainList) {
                memberCodes.add("'" + umMemoauthReDomain.getMemberCode() + "'");
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{memberCodeStr = ObjectUtils.listToString(memberCodes, ",")})) {
            param.put("memberCodeStr", memberCodeStr);
        }
        this.logger.error("-----------\u7ade\u4ef7\u62a5\u540d\u5ba1\u6838\u5217\u8868memberCodeStr\uff1a" + memberCodeStr);
        return this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
    }

    @RequestMapping(value={"queryMyAuctionEnroll.json"}, name="\u6211\u7684\u7ade\u4ef7")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryMyAuctionEnroll(HttpServletRequest request) {
        UserSession userSession;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
        }
        if (null == (userSession = this.getUserSession(request))) {
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        param.put("auctionType", "01");
        param.put("memberBcode", userSession.getUserPcode());
        param.put("auctionEnrollType", "1");
        param.put("tenantCode", tenantCode);
        param.put("EnrollQstateNot", 2);
        param.put("EnrollDstateNot", 2);
        return this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
    }

    private SupQueryResult<AtAuctionEnrollReDomain> getAtAuctionEnrollReDomainSupQueryResult(Map<String, Object> param, String tenantCode) {
        SupQueryResult atAuctionEnrollResult = this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
        if (ListUtil.isEmpty((Collection)atAuctionEnrollResult.getList())) {
            return null;
        }
        for (AtAuctionEnrollReDomain atAuctionEnrollReDomain : atAuctionEnrollResult.getList()) {
            HashMap<String, Object> mapp = new HashMap<String, Object>();
            AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuctionByCode(atAuctionEnrollReDomain.getTenantCode(), atAuctionEnrollReDomain.getAuctionCode());
            atAuctionEnrollReDomain.setMemo(atAuctionReDomain.getDataState().toString());
            String memberBcode = atAuctionEnrollReDomain.getMemberBcode();
            String auctionCode = atAuctionEnrollReDomain.getAuctionCode();
            mapp.put("memberBcode", memberBcode);
            mapp.put("auctionCode", auctionCode);
            mapp.put("tenantCode", tenantCode);
            mapp.put("auctionEnrollCode", atAuctionEnrollReDomain.getAuctionEnrollCode());
            SupQueryResult atAuctiondtResult = this.atAuctiondtServiceRepository.queryAuctiondtPage(mapp);
            mapp.put("dataState", 1);
            SupQueryResult atAuctionUserginfoResult = this.atAuctionUserginfoServiceRepository.queryatAuctionUserginfoPage(mapp);
            mapp.remove("auctionEnrollCode");
            mapp.remove("dataState");
            atAuctionEnrollReDomain.setWinResult("weizhongbiao");
            if (ListUtil.isNotEmpty((Collection)atAuctionUserginfoResult.getList())) {
                for (AtAuctionUserginfoReDomain atAuctionUserginfo : atAuctionUserginfoResult.getList()) {
                    mapp.put("auctionGinfoCode", atAuctionUserginfo.getAuctionGinfoCode());
                    SupQueryResult atAuctionWinResult = this.atAuctionWinServiceRepository.queryatAuctionWinPage(mapp);
                    if (!ListUtil.isNotEmpty((Collection)atAuctionWinResult.getList())) continue;
                    atAuctionEnrollReDomain.setWinResult("zhongbiao");
                    break;
                }
            }
            if (ListUtil.isEmpty((Collection)atAuctiondtResult.getList())) {
                atAuctionEnrollReDomain.setReadyTopay(Integer.valueOf(0));
                continue;
            }
            if (atAuctionUserginfoResult.getList().size() == atAuctiondtResult.getList().size()) {
                atAuctionEnrollReDomain.setReadyTopay(Integer.valueOf(1));
                continue;
            }
            atAuctionEnrollReDomain.setReadyTopay(Integer.valueOf(2));
        }
        return atAuctionEnrollResult;
    }

    private SupQueryResult<AtAuctionEnrollReDomain> getAtAuctionEnrollReDomain(Map<String, Object> param) {
        if (null == param) {
            this.logger.error(CODE + ".getAtAuctionEnrollReDomain", (Object)("\u67e5\u8be2\u7528\u6237\u62a5\u540d\u4fe1\u606f-param:" + param));
            return null;
        }
        String memberBcode = (String)param.get("memberBcode");
        String tenantCode = (String)param.get("tenantCode");
        SupQueryResult atAuctionEnrollResult = this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
        List auctionEnrollResultList = atAuctionEnrollResult.getList();
        if (ListUtil.isEmpty((Collection)auctionEnrollResultList)) {
            this.logger.error(CODE + ".getAtAuctionEnrollReDomain", (Object)("\u67e5\u8be2\u7528\u6237\u62a5\u540d\u4fe1\u606f\u5f02\u5e38" + param));
            return null;
        }
        HashMap<String, String> parMap = new HashMap<String, String>();
        parMap.put("memberBcode", memberBcode);
        parMap.put("tenantCode", tenantCode);
        List winReDomains = this.atAuctionWinServiceRepository.queryatAuctionWinPage(parMap).getList();
        if (ListUtil.isEmpty((Collection)winReDomains)) {
            this.logger.error(CODE + ".getAtAuctionEnrollReDomain", (Object)("\u67e5\u8be2\u7528\u6237\u4e2d\u6807\u4fe1\u606f" + parMap));
        }
        for (AtAuctionEnrollReDomain atAuctionEnrollReDomain : auctionEnrollResultList) {
            String auctionCode = atAuctionEnrollReDomain.getAuctionCode();
            String auctionEnrollCode = atAuctionEnrollReDomain.getAuctionEnrollCode();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("auctionCode", auctionCode);
            paramMap.put("auctionEnrollCode", auctionEnrollCode);
            paramMap.put("memberBcode", memberBcode);
            paramMap.put("tenantCode", tenantCode);
            int countAuctiondtNum = this.atAuctiondtServiceRepository.countAuctiondtNum(paramMap);
            List userginfos = this.atAuctionUserginfoServiceRepository.queryatAuctionUserginfoPage(paramMap).getList();
            if (ListUtil.isEmpty((Collection)userginfos)) {
                this.logger.error(CODE + ".getAtAuctionEnrollReDomain", (Object)("\u67e5\u8be2\u7528\u6237\u5173\u6ce8\u5305\u88f9\u4fe1\u606f\u5f02\u5e38:" + paramMap));
                return null;
            }
            paramMap.remove("auctionEnrollCode");
            paramMap.remove("memberBcode");
            paramMap.put("flag", "true");
            List ginfoReDomains = this.atAuctionServiceRepository.queryatAuctionGinfoPage(paramMap).getList();
            if (ListUtil.isEmpty((Collection)ginfoReDomains)) {
                this.logger.error(CODE + ".getAtAuctionEnrollReDomain", (Object)("\u67e5\u8be2\u573a\u6b21\u5305\u88f9\u4fe1\u606f\u5f02\u5e38:" + paramMap));
                return null;
            }
            atAuctionEnrollReDomain.setWinResult("weizhongbiao");
            for (AtAuctionUserginfoReDomain userginfo : userginfos) {
                boolean temp = false;
                for (AtAuctionWinReDomain winReDomain : winReDomains) {
                    if (!userginfo.getAuctionGinfoCode().equals(winReDomain.getAuctionGinfoCode()) || !memberBcode.equals(winReDomain.getMemberBcode()) || !auctionCode.equals(winReDomain.getAuctionCode())) continue;
                    atAuctionEnrollReDomain.setWinResult("zhongbiao");
                    temp = true;
                    break;
                }
                if (!temp) continue;
                break;
            }
            AtAuctionGinfoReDomain auctionGinfoReDomain = (AtAuctionGinfoReDomain)ginfoReDomains.get(0);
            for (AtAuctionWinReDomain winReDomain : winReDomains) {
                if (!auctionGinfoReDomain.getAuctionGinfoCode().equals(winReDomain.getAuctionGinfoCode()) || !memberBcode.equals(winReDomain.getMemberBcode()) || !auctionCode.equals(winReDomain.getAuctionCode())) continue;
                atAuctionEnrollReDomain.setWinResult("zhongbiao");
                break;
            }
            if (countAuctiondtNum == 0) {
                atAuctionEnrollReDomain.setReadyTopay(Integer.valueOf(0));
                continue;
            }
            if (countAuctiondtNum == userginfos.size()) {
                atAuctionEnrollReDomain.setReadyTopay(Integer.valueOf(1));
                continue;
            }
            atAuctionEnrollReDomain.setReadyTopay(Integer.valueOf(2));
        }
        return atAuctionEnrollResult;
    }

    @RequestMapping(value={"queryMyAuctionEnrollItems.json"}, name="\u6211\u7684\u5355\u54c1\u7ade\u4ef7")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryMyAuctionEnrollItems(HttpServletRequest request) {
        UserSession userSession;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (userSession = this.getUserSession(request))) {
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        param.put("auctionType", "02");
        param.put("memberBcode", userSession.getUserPcode());
        param.put("auctionEnrollType", "2");
        param.put("tenantCode", tenantCode);
        SupQueryResult enrollPageResult = this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
        if (enrollPageResult.getTotal() > 0L) {
            HashMap<String, String> parMap = new HashMap<String, String>();
            for (AtAuctionEnrollReDomain atAuctionEnrollReDomain : enrollPageResult.getList()) {
                parMap.put("auctionCode", atAuctionEnrollReDomain.getAuctionCode());
                param.put("tenantCode", tenantCode);
                SupQueryResult ginfoPageResult = this.atAuctionServiceRepository.queryatAuctionGinfoPage(parMap);
                if (ginfoPageResult.getTotal() <= 0L) continue;
                AtAuctionGinfoReDomain auctionGinfoReDomain = (AtAuctionGinfoReDomain)ginfoPageResult.getList().get(0);
                atAuctionEnrollReDomain.setAuctionGinfoReDomain(auctionGinfoReDomain);
            }
        }
        return enrollPageResult;
    }

    @RequestMapping(value={"queryMyAuctionEnrollReadToPay.json"}, name="\u67e5\u8be2\u6211\u7684\u7ade\u4ef7\u62a5\u540d\u4ea4\u4fdd\u72b6\u6001")
    @ResponseBody
    public List<AtAuctionEnrollReDomain> queryMyAuctionEnrollReadToPay(HttpServletRequest request, String readyTopay) {
        UserSession userSession;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (userSession = this.getUserSession(request))) {
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        param.put("memberBcode", userSession.getUserPcode());
        param.put("tenantCode", tenantCode);
        ArrayList<AtAuctionEnrollReDomain> atAuctionEnrollReDomains = new ArrayList<AtAuctionEnrollReDomain>();
        SupQueryResult atAuctionEnrollResult = this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
        if (ListUtil.isEmpty((Collection)atAuctionEnrollResult.getList())) {
            return null;
        }
        for (AtAuctionEnrollReDomain atAuctionEnrollReDomain : atAuctionEnrollResult.getList()) {
            HashMap<String, String> mapp = new HashMap<String, String>();
            String memberBcode = atAuctionEnrollReDomain.getMemberBcode();
            String auctionCode = atAuctionEnrollReDomain.getAuctionCode();
            mapp.put("memberBcode", memberBcode);
            mapp.put("auctionCode", auctionCode);
            mapp.put("tenantCode", tenantCode);
            SupQueryResult atAuctiondtResult = this.atAuctiondtServiceRepository.queryAuctiondtPage(mapp);
            SupQueryResult atAuctionUserginfoResult = this.atAuctionUserginfoServiceRepository.queryatAuctionUserginfoPage(mapp);
            boolean flag = false;
            switch (readyTopay) {
                case "0": {
                    if (!ListUtil.isNotEmpty((Collection)atAuctiondtResult.getList())) break;
                    flag = true;
                    break;
                }
                case "1": {
                    if (atAuctionUserginfoResult.getList().size() == atAuctiondtResult.getList().size()) break;
                    flag = true;
                    break;
                }
                case "2": {
                    if (!ListUtil.isEmpty((Collection)atAuctiondtResult.getList()) && atAuctionUserginfoResult.getList().size() != atAuctiondtResult.getList().size()) break;
                    flag = true;
                }
            }
            if (flag) continue;
            atAuctionEnrollReDomains.add(atAuctionEnrollReDomain);
        }
        return atAuctionEnrollReDomains;
    }

    @RequestMapping(value={"queryAuctionEnrollItemByMem.json"}, name="\u67e5\u8be2\u6211\u7684\u5355\u54c1\u8d2d\u4e70\u62a5\u540d\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionEnrollItemByMem(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        String memberBcode = userSession.getUserPcode();
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberBcode", memberBcode);
        param.put("auctionEnrollType", "2");
        return this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
    }

    private boolean permisAuction(String memberBcode, String auctionCode, String tenantCode) {
        boolean flag = false;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auctionCode", auctionCode);
        map.put("tenantCode", tenantCode);
        SupQueryResult atAuctionMemResult = this.atAuctionServiceRepository.queryatAuctionMemPage(map);
        if (ListUtil.isNotEmpty((Collection)atAuctionMemResult.getList())) {
            String memListStr = "";
            for (AtAuctionMemReDomain atAuctionMem : atAuctionMemResult.getList()) {
                String groupCode = atAuctionMem.getAuctionMemOpcode();
                if ("all".equals(groupCode) || !"0".equals(atAuctionMem.getAuctionMemType())) {
                    flag = true;
                    break;
                }
                String listStr = SupDisUtil.getMap((String)"UmGroup-groupCode", (String)("groupList-" + groupCode + "-" + tenantCode));
                if (StringUtils.isNotBlank((String)memListStr)) {
                    memListStr = memListStr + ",";
                }
                if (!StringUtils.isNotBlank((String)listStr)) continue;
                memListStr = memListStr + listStr;
            }
            if (memListStr.contains(memberBcode)) {
                flag = true;
            }
        } else {
            flag = true;
        }
        return flag;
    }

    @RequestMapping(value={"getauctionNum.json"}, name="\u83b7\u53d6\u5f00\u59cb\u7ade\u4ef7\u7684\u6570\u636e")
    @ResponseBody
    public HtmlJsonReBean getauctionNum(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".getauctionNum.json", (Object)"userssion is null");
            return null;
        }
        String memberCode = userSession.getUserPcode();
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("memberBcode", memberCode);
        maps.put("tenantCode", tenantCode);
        maps.put("dataState", "3");
        SupQueryResult atAuctionEnrollReDomainSupQueryResult = this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(maps);
        if (ListUtil.isEmpty((Collection)atAuctionEnrollReDomainSupQueryResult.getList())) {
            return new HtmlJsonReBean((Object)0);
        }
        return new HtmlJsonReBean((Object)atAuctionEnrollReDomainSupQueryResult.getList().size());
    }

    private SupQueryResult<UmUserinfoReDomainBean> changeUserInfoBasicResultCom(SupQueryResult<UmUserinfoReDomainBean> umUserinfoReDomainBeanSupQueryResult, String ftype) {
        if (ListUtil.isEmpty((Collection)umUserinfoReDomainBeanSupQueryResult.getList())) {
            return null;
        }
        String memberCode = null;
        String type = null;
        String basic = null;
        String frozen = null;
        String jifen = null;
        String tenantCode = null;
        Map<String, VdFaccountInfo> vd = null;
        List basics = null;
        List frozens = null;
        List jifens = null;
        for (UmUserinfoReDomainBean umUserinfoReDomainBean : umUserinfoReDomainBeanSupQueryResult.getList()) {
            BigDecimal vdSum;
            memberCode = umUserinfoReDomainBean.getUserinfoCode();
            type = memberCode.substring(0, 1);
            basic = "101";
            frozen = "102";
            jifen = "103";
            if ("2".equals(type)) {
                basic = "201";
                frozen = "202";
                jifen = "203";
            }
            if (!MapUtil.isNotEmpty(vd = this.getVd(memberCode, tenantCode = umUserinfoReDomainBean.getTenantCode(), null))) continue;
            if (StringUtils.isBlank((String)ftype)) {
                if (null == vd.get(basic) || null == vd.get(frozen)) continue;
                basics = vd.get(basic).getSubsetList();
                frozens = vd.get(frozen).getSubsetList();
                if (ListUtil.isEmpty((Collection)basics) || ListUtil.isEmpty((Collection)frozens)) continue;
                vdSum = new BigDecimal(0);
                BigDecimal frozenSum = new BigDecimal(0);
                for (VdFaccountOuterSubsetDomain vdFaccountOuterSubsetDomain : basics) {
                    if (!"01".equals(vdFaccountOuterSubsetDomain.getFundType()) || null == vdFaccountOuterSubsetDomain.getFaccountAmount()) continue;
                    vdSum = vdSum.add(vdFaccountOuterSubsetDomain.getFaccountAmount());
                }
                for (VdFaccountOuterSubsetDomain vdFaccountOuterSubsetDomain : frozens) {
                    if (!"02".equals(vdFaccountOuterSubsetDomain.getFundType())) continue;
                    if (null != vdFaccountOuterSubsetDomain.getFaccountAmount()) {
                        vdSum = vdSum.add(vdFaccountOuterSubsetDomain.getFaccountAmount());
                    }
                    if (null == vdFaccountOuterSubsetDomain.getFaccountAmount()) continue;
                    frozenSum = frozenSum.add(vdFaccountOuterSubsetDomain.getFaccountAmount());
                }
                umUserinfoReDomainBean.setVdSum(vdSum);
                umUserinfoReDomainBean.setVdFaccountInfoMap(vd);
                umUserinfoReDomainBean.setVdFrozenSum(frozenSum);
                continue;
            }
            if (null == vd.get(jifen) || ListUtil.isEmpty((Collection)(jifens = vd.get(jifen).getSubsetList()))) continue;
            vdSum = new BigDecimal(0);
            for (VdFaccountOuterSubsetDomain vdFaccountOuterSubsetDomain : jifens) {
                if (!"01".equals(vdFaccountOuterSubsetDomain.getFundType()) || null == vdFaccountOuterSubsetDomain.getFaccountAmount()) continue;
                vdSum = vdSum.add(vdFaccountOuterSubsetDomain.getFaccountAmount());
            }
            umUserinfoReDomainBean.setVdjifenSum(vdSum);
            umUserinfoReDomainBean.setVdFaccountInfoMap(vd);
        }
        return umUserinfoReDomainBeanSupQueryResult;
    }

    private Map<String, VdFaccountInfo> getVd(String memberCode, String tenantCode, String faccountType) {
        List vdList = this.vdFaccountServiceRepository.queryOuterFaccount(memberCode, faccountType, tenantCode);
        HashMap<String, VdFaccountInfo> account = new HashMap<String, VdFaccountInfo>();
        if (null != vdList && !vdList.isEmpty()) {
            for (VdFaccountInfo v : vdList) {
                account.put(v.getFaccountType(), v);
            }
        }
        return account;
    }

    @RequestMapping(value={"queryAuctionEnrollInformation.json"}, name="\u7ade\u4ef7\u4fe1\u606f")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionEnrollInformation(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        String tenantCode = this.getTenantCode(request);
        SupQueryResult atAuctionEnrollResult = this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
        if (ListUtil.isEmpty((Collection)atAuctionEnrollResult.getList())) {
            return null;
        }
        block0: for (AtAuctionEnrollReDomain atAuctionEnrollReDomain : atAuctionEnrollResult.getList()) {
            SupQueryResult atAuctiondtResult;
            SupQueryResult<UmUserinfoReDomainBean> umUserinfoReDomainBeanSupQueryResult1;
            HashMap<String, String> mapp = new HashMap<String, String>();
            HashMap<String, String> paramStr = new HashMap<String, String>();
            AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuctionByCode(atAuctionEnrollReDomain.getTenantCode(), atAuctionEnrollReDomain.getAuctionCode());
            if (null != atAuctionReDomain) {
                atAuctionEnrollReDomain.setMemo(atAuctionReDomain.getDataState().toString());
                atAuctionEnrollReDomain.setAtAuctionReDomain(atAuctionReDomain);
            }
            String memberBcode = atAuctionEnrollReDomain.getMemberBcode();
            String auctionCode = atAuctionEnrollReDomain.getAuctionCode();
            mapp.put("memberBcode", memberBcode);
            mapp.put("auctionCode", auctionCode);
            mapp.put("tenantCode", tenantCode);
            mapp.put("auctionEnrollCode", atAuctionEnrollReDomain.getAuctionEnrollCode());
            paramStr.put("userinfoCode", memberBcode);
            paramStr.put("tenantCode", tenantCode);
            SupQueryResult umUserinfoReDomainBeanSupQueryResult = this.userServiceRepository.queryUserinfoPage(paramStr);
            if (ListUtil.isNotEmpty((Collection)umUserinfoReDomainBeanSupQueryResult.getList()) && ListUtil.isNotEmpty((Collection)(umUserinfoReDomainBeanSupQueryResult1 = this.changeUserInfoBasicResultCom((SupQueryResult<UmUserinfoReDomainBean>)umUserinfoReDomainBeanSupQueryResult, null)).getList())) {
                atAuctionEnrollReDomain.setUmUserinfoReDomainBean((UmUserinfoReDomainBean)umUserinfoReDomainBeanSupQueryResult1.getList().get(0));
            }
            if (ListUtil.isNotEmpty((Collection)(atAuctiondtResult = this.atAuctiondtServiceRepository.queryAuctiondtPage(mapp)).getList())) {
                atAuctionEnrollReDomain.setAtAuctiondtReDomainList(atAuctiondtResult.getList());
            }
            SupQueryResult atAuctionUserginfoResult = this.atAuctionUserginfoServiceRepository.queryatAuctionUserginfoPage(mapp);
            mapp.remove("auctionEnrollCode");
            atAuctionEnrollReDomain.setWinResult("weizhongbiao");
            if (!ListUtil.isNotEmpty((Collection)atAuctionUserginfoResult.getList())) continue;
            for (AtAuctionUserginfoReDomain atAuctionUserginfo : atAuctionUserginfoResult.getList()) {
                mapp.put("auctionGinfoCode", atAuctionUserginfo.getAuctionGinfoCode());
                SupQueryResult atAuctionWinResult = this.atAuctionWinServiceRepository.queryatAuctionWinPage(mapp);
                if (!ListUtil.isNotEmpty((Collection)atAuctionWinResult.getList())) continue;
                atAuctionEnrollReDomain.setWinResult("zhongbiao");
                continue block0;
            }
        }
        return atAuctionEnrollResult;
    }

    private Map<String, Object> getMapParamFromOpdatascsType(HttpServletRequest request, String opdatascsType) {
        HashMap<String, Object> resultMap = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null == resultMap) {
            resultMap = new HashMap<String, Object>();
        }
        resultMap.put("opdatascsType", opdatascsType);
        this.setMap(resultMap, request);
        resultMap.put("tenantCode", this.getTenantCode(request));
        return resultMap;
    }
}

