/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.basicsetting.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.bs.domain.BsRoadDomain;
import com.qjsoft.laser.controller.facade.bs.domain.BsRoadReDomain;
import com.qjsoft.laser.controller.facade.bs.repository.BsRoadServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/bs/road"}, name="\u8857\u9053\u670d\u52a1")
public class RoadCon
extends SpringmvcController {
    private static String CODE = "bs.road.con";
    @Autowired
    private BsRoadServiceRepository bsRoadServiceRepository;

    protected String getContext() {
        return "road";
    }

    @RequestMapping(value={"saveRoad.json"}, name="\u589e\u52a0\u8857\u9053\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveRoad(HttpServletRequest request, BsRoadDomain bsRoadDomain) {
        if (null == bsRoadDomain) {
            this.logger.error(CODE + ".saveRoad", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        bsRoadDomain.setTenantCode(this.getTenantCode(request));
        return this.bsRoadServiceRepository.saveRoad(bsRoadDomain);
    }

    @RequestMapping(value={"getRoad.json"}, name="\u83b7\u53d6\u8857\u9053\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public BsRoadReDomain getRoad(Integer roadId) {
        if (StringUtils.isBlank((Integer)roadId)) {
            this.logger.error(CODE + ".getRoad", (Object)"param is null");
            return null;
        }
        return this.bsRoadServiceRepository.getRoad(roadId);
    }

    @RequestMapping(value={"updateRoad.json"}, name="\u66f4\u65b0\u8857\u9053\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateRoad(HttpServletRequest request, BsRoadDomain bsRoadDomain) {
        if (null == bsRoadDomain) {
            this.logger.error(CODE + ".updateRoad", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        bsRoadDomain.setTenantCode(this.getTenantCode(request));
        return this.bsRoadServiceRepository.updateRoad(bsRoadDomain);
    }

    @RequestMapping(value={"deleteRoad.json"}, name="\u5220\u9664\u8857\u9053\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteRoad(Integer roadId) {
        if (StringUtils.isBlank((Integer)roadId)) {
            this.logger.error(CODE + ".deleteRoad", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.bsRoadServiceRepository.deleteRoad(roadId);
    }

    @RequestMapping(value={"queryRoadPage.json"}, name="\u67e5\u8be2\u8857\u9053\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<BsRoadReDomain> queryRoadPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.bsRoadServiceRepository.queryRoadPage(param);
    }

    @RequestMapping(value={"updateRoadState.json"}, name="\u66f4\u65b0\u8857\u9053\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateRoadState(String roadId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)roadId)) {
            this.logger.error(CODE + ".updateRoadState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.bsRoadServiceRepository.updateRoadState(Integer.valueOf(roadId), dataState, oldDataState);
    }
}

