/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.basicsetting.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.core.util.HtmlUtil;
import com.qjsoft.laser.controller.facade.bs.domain.BsAreaDomain;
import com.qjsoft.laser.controller.facade.bs.domain.BsAreaReDomain;
import com.qjsoft.laser.controller.facade.bs.domain.BsProvinceDomain;
import com.qjsoft.laser.controller.facade.bs.domain.BsProvinceReDomain;
import com.qjsoft.laser.controller.facade.bs.repository.BsAreaServiceRepository;
import com.qjsoft.laser.controller.facade.bs.repository.BsProvinceServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/bs/area"}, name="\u5730\u533a\u670d\u52a1")
public class AreaCon
extends SpringmvcController {
    private static String CODE = "bs.area.con";
    @Autowired
    private BsAreaServiceRepository bsAreaServiceRepository;
    @Autowired
    private BsProvinceServiceRepository bsProvinceServiceRepository;

    protected String getContext() {
        return "area";
    }

    @RequestMapping(value={"saveArea.json"}, name="\u589e\u52a0\u5730\u533a\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveArea(HttpServletRequest request, BsAreaDomain bsAreaDomain) {
        if (null == bsAreaDomain) {
            this.logger.error(CODE + ".saveArea", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        bsAreaDomain.setTenantCode(this.getTenantCode(request));
        return this.bsAreaServiceRepository.saveArea(bsAreaDomain);
    }

    @RequestMapping(value={"getArea.json"}, name="\u83b7\u53d6\u5730\u533a\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public BsAreaReDomain getArea(String areaId) {
        if (StringUtils.isBlank((String)areaId)) {
            this.logger.error(CODE + ".getArea", (Object)"param is null");
            return null;
        }
        return this.bsAreaServiceRepository.getArea(Integer.valueOf(areaId));
    }

    @RequestMapping(value={"updateArea.json"}, name="\u66f4\u65b0\u5730\u533a\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateArea(HttpServletRequest request, BsAreaDomain bsAreaDomain) {
        if (null == bsAreaDomain) {
            this.logger.error(CODE + ".updateArea", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        bsAreaDomain.setTenantCode(this.getTenantCode(request));
        return this.bsAreaServiceRepository.updateArea(bsAreaDomain);
    }

    @RequestMapping(value={"deleteArea.json"}, name="\u5220\u9664\u5730\u533a\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteArea(String areaId) {
        if (StringUtils.isBlank((String)areaId)) {
            this.logger.error(CODE + ".deleteArea", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.bsAreaServiceRepository.deleteArea(Integer.valueOf(areaId));
    }

    @RequestMapping(value={"queryAreaPage.json"}, name="\u67e5\u8be2\u5730\u533a\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<BsAreaReDomain> queryAreaPage(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.bsAreaServiceRepository.queryAreaPage(param);
    }

    @RequestMapping(value={"updateAreaState.json"}, name="\u66f4\u65b0\u5730\u533a\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAreaState(String areaId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)areaId)) {
            this.logger.error(CODE + ".updateAreaState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.bsAreaServiceRepository.updateAreaState(Integer.valueOf(areaId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryAreaPageByTenantCode.json"}, name="\u67e5\u8be2\u5730\u533a\u670d\u52a1\u5206\u9875\u5217\u8868\uff08\u8fc7\u6ee4\u5f53\u524d\u79df\u6237\uff09")
    @ResponseBody
    public SupQueryResult<BsAreaReDomain> queryAreaPageByTenantCode(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        param.put("tenantCode", this.getTenantCode(request));
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.bsAreaServiceRepository.queryAreaPage(param);
    }

    @RequestMapping(value={"saveAreaByTenantCode.json"}, name="\u589e\u52a0\u5730\u533a\u670d\u52a1(\u5f53\u524d\u79df\u6237)")
    @ResponseBody
    public HtmlJsonReBean saveArea(HttpServletRequest request, String areaId) {
        if (StringUtils.isBlank((String)areaId)) {
            this.logger.error(CODE + ".saveArea", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        BsAreaReDomain area = this.bsAreaServiceRepository.getArea(Integer.valueOf(areaId));
        if (null == area) {
            return new HtmlJsonReBean((Object)"\u6ca1\u6709\u6570\u636e");
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantCode", this.getTenantCode(request));
        param.put("provinceCode", area.getProvinceCode());
        BsProvinceReDomain bsProvinceReDomain = this.bsProvinceServiceRepository.getProvinceByCode(param);
        this.logger.error(CODE + ".saveAreaByTenantCode.bsProvinceReDomainSupQueryResult", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)bsProvinceReDomain));
        if (null == bsProvinceReDomain) {
            param.remove("tenantCode");
            BsProvinceReDomain newBsProvinceReDomain = this.bsProvinceServiceRepository.getProvinceByCode(param);
            if (null == newBsProvinceReDomain) {
                return new HtmlJsonReBean((Object)"\u6ca1\u6709\u6570\u636e1");
            }
            newBsProvinceReDomain.setTenantCode(this.getTenantCode(request));
            newBsProvinceReDomain.setProvinceId(null);
            this.bsProvinceServiceRepository.saveProvince((BsProvinceDomain)newBsProvinceReDomain);
        }
        area.setAreaId(null);
        area.setTenantCode(this.getTenantCode(request));
        return this.bsAreaServiceRepository.saveArea((BsAreaDomain)area);
    }
}

