/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.cd.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.cd.domain.CdCardpDomain;
import com.qjsoft.laser.controller.facade.cd.domain.CdCardpReDomain;
import com.qjsoft.laser.controller.facade.cd.repository.CdCardpServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/cd/cardp"}, name="\u5361\u5bc6\u670d\u52a1")
public class CardpCon
extends SpringmvcController {
    private static String CODE = "cd.cardp.con";
    @Autowired
    private CdCardpServiceRepository cdCardpServiceRepository;

    protected String getContext() {
        return "cardp";
    }

    @RequestMapping(value={"saveCardp.json"}, name="\u589e\u52a0\u5361\u5bc6\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveCardp(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveGift", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveGift", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        CdCardpDomain cdCardpDomain = (CdCardpDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, CdCardpDomain.class);
        cdCardpDomain.setMemberCode(userSession.getUserPcode());
        cdCardpDomain.setMemberName(userSession.getUserName());
        cdCardpDomain.setTenantCode(this.getTenantCode(request));
        return this.cdCardpServiceRepository.saveCardp(cdCardpDomain);
    }

    @RequestMapping(value={"getCardp.json"}, name="\u83b7\u53d6\u5361\u5bc6\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public CdCardpReDomain getCardp(Integer cardpId) {
        if (StringUtils.isBlank((Integer)cardpId)) {
            this.logger.error(CODE + ".getCardp", (Object)"param is null");
            return null;
        }
        return this.cdCardpServiceRepository.getCardp(cardpId);
    }

    @RequestMapping(value={"updateCardp.json"}, name="\u66f4\u65b0\u5361\u5bc6\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateCardp(HttpServletRequest request, CdCardpDomain cdCardpDomain) {
        if (null == cdCardpDomain) {
            this.logger.error(CODE + ".updateCardp", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        cdCardpDomain.setTenantCode(this.getTenantCode(request));
        return this.cdCardpServiceRepository.updateCardp(cdCardpDomain);
    }

    @RequestMapping(value={"deleteCardp.json"}, name="\u5220\u9664\u5361\u5bc6\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteCardp(Integer cardpId) {
        if (StringUtils.isBlank((Integer)cardpId)) {
            this.logger.error(CODE + ".deleteCardp", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cdCardpServiceRepository.deleteCardp(cardpId);
    }

    @RequestMapping(value={"queryCardpPage.json"}, name="\u67e5\u8be2\u5361\u5bc6\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CdCardpReDomain> queryCardpPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.cdCardpServiceRepository.queryCardpPage(param);
    }

    @RequestMapping(value={"updateCardpState.json"}, name="\u66f4\u65b0\u5361\u5bc6\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateCardpState(String cardpId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)cardpId)) {
            this.logger.error(CODE + ".updateCardpState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cdCardpServiceRepository.updateCardpState(Integer.valueOf(cardpId), dataState, oldDataState);
    }
}

