/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.cms.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.cms.domain.CmsTginfoDomain;
import com.qjsoft.laser.controller.facade.cms.domain.CmsTginfoMenuDomain;
import com.qjsoft.laser.controller.facade.cms.domain.CmsTginfoReDomain;
import com.qjsoft.laser.controller.facade.cms.repository.CmsTginfoMenuServiceRepository;
import com.qjsoft.laser.controller.facade.cms.repository.CmsTginfoServiceRepository;
import com.qjsoft.laser.controller.facade.fm.domain.FmFileReDomainBean;
import com.qjsoft.laser.controller.facade.fm.repository.FileServiceRepository;
import com.qjsoft.laser.controller.facade.tm.domain.TmProappMenuReDomain;
import com.qjsoft.laser.controller.facade.tm.domain.TmProappReDomain;
import com.qjsoft.laser.controller.facade.tm.repository.TmProappServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/web/cms/tginfoBusiness"}, name="\u95e8\u6237\u4e3b\u4f53\u4fe1\u606f\u670d\u52a1")
public class TginfoBusCon
extends SpringmvcController {
    private static String CODE = "cms.tginfo.con";
    @Autowired
    private CmsTginfoServiceRepository cmsTginfoServiceRepository;
    @Autowired
    private CmsTginfoMenuServiceRepository cmsTginfoMenuServiceRepository;
    @Autowired
    private TmProappServiceRepository tmProappServiceRepository;
    @Autowired
    private FileServiceRepository fileServiceRepository;

    protected String getContext() {
        return "tginfo";
    }

    @RequestMapping(value={"uploadPic.json"}, name="\u4e0a\u4f20\u56fe\u7247")
    @ResponseBody
    public FmFileReDomainBean uploadGoodsFile(HttpServletRequest request, MultipartFile file, String fileSort) {
        if (null == file) {
            this.logger.error(CODE + ".uploadPic", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.fileServiceRepository.saveFile(file, tenantCode, fileSort);
    }

    @RequestMapping(value={"saveTginfo.json"}, name="\u589e\u52a0\u95e8\u6237\u4e3b\u4f53\u4fe1\u606f\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveTginfo(HttpServletRequest request, CmsTginfoDomain cmsTginfoDomain) {
        if (null == cmsTginfoDomain) {
            this.logger.error(CODE + ".saveTginfo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (this.checkName(request, cmsTginfoDomain, ".saveTginfo", "\u7ad9\u70b9\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u6dfb\u52a0")) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7ad9\u70b9\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u6dfb\u52a0");
        }
        UserSession userSession = this.getUserSession(request);
        String memberCode = userSession.getUserPcode();
        String memberName = userSession.getMerberCompname();
        String tenantCode = this.getTenantCode(request);
        String proappCode = cmsTginfoDomain.getProappCode();
        cmsTginfoDomain.setTenantCode(tenantCode);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("proappCode", proappCode);
        param.put("tenantCode", "00000000");
        TmProappReDomain tmProappReDomain = this.tmProappServiceRepository.getProappByCode(param);
        if (null == tmProappReDomain) {
            this.logger.error(CODE + ".saveTginfo", (Object)"\u4ea7\u54c1code\u9519\u8bef");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4ea7\u54c1code\u9519\u8bef.");
        }
        String oauthEnvCode = null;
        oauthEnvCode = tmProappReDomain.getOauthEnvCode();
        cmsTginfoDomain.setOauthEnvCode(oauthEnvCode);
        cmsTginfoDomain.setMemberCode(memberCode);
        cmsTginfoDomain.setMemberName(memberName);
        HtmlJsonReBean jsonReBean = this.cmsTginfoServiceRepository.saveTginfo(cmsTginfoDomain);
        String tginfoCode = String.valueOf(jsonReBean.getDataObj());
        List menulist = this.tmProappServiceRepository.queryMenuByProapp(proappCode, tenantCode);
        List<TmProappMenuReDomain> tmProappMenuReDomains = this.parseTree(menulist);
        for (TmProappMenuReDomain tmProappMenuReDomain : tmProappMenuReDomains) {
            String pcode = this.insert(tmProappMenuReDomain, tginfoCode, tenantCode, "-1");
            if (null == tmProappMenuReDomain.getChildren() || tmProappMenuReDomain.getChildren().size() <= 0) continue;
            this.insertTginfoMenu(tmProappMenuReDomain.getChildren(), tginfoCode, tenantCode, pcode);
        }
        return jsonReBean;
    }

    private void insertTginfoMenu(List<TmProappMenuReDomain> tmProappMenuReDomains, String tginfoCode, String tenantCode, String pcode) {
        for (TmProappMenuReDomain tmProappMenuReDomain : tmProappMenuReDomains) {
            String parentCode = this.insert(tmProappMenuReDomain, tginfoCode, tenantCode, pcode);
            if (null == tmProappMenuReDomain.getChildren() || tmProappMenuReDomain.getChildren().size() <= 0) continue;
            this.insertTginfoMenu(tmProappMenuReDomain.getChildren(), tginfoCode, tenantCode, parentCode);
        }
    }

    @RequestMapping(value={"getTginfo.json"}, name="\u83b7\u53d6\u95e8\u6237\u4e3b\u4f53\u4fe1\u606f\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public CmsTginfoReDomain getTginfo(Integer tginfoId) {
        if (StringUtils.isBlank((Integer)tginfoId)) {
            this.logger.error(CODE + ".getTginfo", (Object)"param is null");
            return null;
        }
        return this.cmsTginfoServiceRepository.getTginfo(tginfoId);
    }

    @RequestMapping(value={"updateTginfo.json"}, name="\u66f4\u65b0\u95e8\u6237\u4e3b\u4f53\u4fe1\u606f\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateTginfo(HttpServletRequest request, CmsTginfoDomain cmsTginfoDomain) {
        if (null == cmsTginfoDomain) {
            this.logger.error(CODE + ".updateTginfo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (this.checkName(request, cmsTginfoDomain, ".updateTginfo", "\u7ad9\u70b9\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u66f4\u65b0")) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7ad9\u70b9\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        String tenantCode = this.getTenantCode(request);
        String proappCode = cmsTginfoDomain.getProappCode();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("proappCode", proappCode);
        param.put("tenantCode", "00000000");
        SupQueryResult result = this.tmProappServiceRepository.queryProappPage(param);
        List list = result.getList();
        String oauthEnvCode = null;
        if (null == list || list.size() != 1) {
            this.logger.error(CODE + ".updateTginfo", (Object)"\u4ea7\u54c1code\u9519\u8bef");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4ea7\u54c1code\u9519\u8bef.");
        }
        oauthEnvCode = ((TmProappReDomain)list.get(0)).getOauthEnvCode();
        cmsTginfoDomain.setOauthEnvCode(oauthEnvCode);
        cmsTginfoDomain.setTenantCode(tenantCode);
        return this.cmsTginfoServiceRepository.updateTginfo(cmsTginfoDomain);
    }

    @RequestMapping(value={"deleteTginfo.json"}, name="\u5220\u9664\u95e8\u6237\u4e3b\u4f53\u4fe1\u606f\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteTginfo(Integer tginfoId) {
        if (StringUtils.isBlank((Integer)tginfoId)) {
            this.logger.error(CODE + ".deleteTginfo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        CmsTginfoReDomain tginfo = this.cmsTginfoServiceRepository.getTginfo(tginfoId);
        String tginfoCode = tginfo.getTginfoCode();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tginfoCode", tginfoCode);
        SupQueryResult result = this.cmsTginfoMenuServiceRepository.queryTginfoMenuPage(param);
        List list = result.getList();
        if (list != null && list.size() > 0) {
            this.logger.error(CODE + ".deleteTginfo", (Object)"\u7ad9\u70b9\u5df2\u7ed1\u5b9a\u680f\u76ee,\u65e0\u6cd5\u5220\u9664");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7ad9\u70b9\u5df2\u7ed1\u5b9a\u680f\u76ee,\u65e0\u6cd5\u5220\u9664");
        }
        return this.cmsTginfoServiceRepository.deleteTginfo(tginfoId);
    }

    @RequestMapping(value={"queryTginfoPage.json"}, name="\u67e5\u8be2\u95e8\u6237\u4e3b\u4f53\u4fe1\u606f\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CmsTginfoReDomain> queryTginfoPage(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.cmsTginfoServiceRepository.queryTginfoPage(param);
    }

    @RequestMapping(value={"queryTginfoPageForCm.json"}, name="\u67e5\u8be2\u95e8\u6237\u4e3b\u4f53\u4fe1\u606f\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CmsTginfoReDomain> queryTginfoPageForCm(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.cmsTginfoServiceRepository.queryTginfoPage(param);
    }

    @RequestMapping(value={"updateTginfoState.json"}, name="\u66f4\u65b0\u95e8\u6237\u4e3b\u4f53\u4fe1\u606f\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateTginfoState(String tginfoId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)tginfoId)) {
            this.logger.error(CODE + ".updateTginfoState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cmsTginfoServiceRepository.updateTginfoState(Integer.valueOf(tginfoId), dataState, oldDataState);
    }

    private boolean checkName(HttpServletRequest request, CmsTginfoDomain cmsTginfoDomain, String s, String s2) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tginfoName", cmsTginfoDomain.getTginfoName());
        param.put("tenantCode", this.getTenantCode(request));
        SupQueryResult result = this.cmsTginfoServiceRepository.queryTginfoPage(param);
        List list = result.getList();
        if (list != null && list.size() > 0) {
            for (CmsTginfoReDomain cmsTginfoReDomain : list) {
                if (null == cmsTginfoDomain.getTginfoId()) continue;
                return !cmsTginfoReDomain.getTginfoId().equals(cmsTginfoDomain.getTginfoId());
            }
            this.logger.error(CODE + s, (Object)s2);
            return true;
        }
        return false;
    }

    private List<TmProappMenuReDomain> parseTree(List<TmProappMenuReDomain> list) {
        ArrayList<TmProappMenuReDomain> newList = new ArrayList<TmProappMenuReDomain>();
        for (TmProappMenuReDomain tmProappMenuReDomain : list) {
            boolean mark = false;
            for (TmProappMenuReDomain menuReDomain : list) {
                if ("-1".equals(tmProappMenuReDomain.getProappMenuPcode()) || !tmProappMenuReDomain.getProappMenuPcode().equals(menuReDomain.getProappMenuCode())) continue;
                mark = true;
                if (menuReDomain.getChildren() == null) {
                    menuReDomain.setChildren(new ArrayList());
                }
                menuReDomain.getChildren().add(tmProappMenuReDomain);
                break;
            }
            if (mark) continue;
            newList.add(tmProappMenuReDomain);
        }
        return newList;
    }

    private String insert(TmProappMenuReDomain tmProappMenuReDomain, String tginfoCode, String tenantCode, String pcode) {
        CmsTginfoMenuDomain cmsTginfoMenuDomain = new CmsTginfoMenuDomain();
        cmsTginfoMenuDomain.setMenuCode(tmProappMenuReDomain.getMenuCode());
        cmsTginfoMenuDomain.setTginfoMenuPcode(pcode);
        cmsTginfoMenuDomain.setTginfoCode(tginfoCode);
        cmsTginfoMenuDomain.setTginfoMenuName(tmProappMenuReDomain.getProappMenuName());
        cmsTginfoMenuDomain.setTginfoMenuOrder(tmProappMenuReDomain.getProappMenuOrder());
        cmsTginfoMenuDomain.setTginfoMenuRemark(tmProappMenuReDomain.getProappMenuRemark());
        cmsTginfoMenuDomain.setMenuIndexCode(tmProappMenuReDomain.getMenuIndexCode());
        cmsTginfoMenuDomain.setMenuDetailsCode(tmProappMenuReDomain.getMenuDetailsCode());
        cmsTginfoMenuDomain.setMenuAction(tmProappMenuReDomain.getMenuAction());
        cmsTginfoMenuDomain.setMenuJspath(tmProappMenuReDomain.getMenuJspath());
        cmsTginfoMenuDomain.setMenuOpcode(tmProappMenuReDomain.getMenuOpcode());
        cmsTginfoMenuDomain.setTenantCode(tenantCode);
        HtmlJsonReBean htmlJsonReBean = this.cmsTginfoMenuServiceRepository.saveTginfoMenu(cmsTginfoMenuDomain);
        return String.valueOf(htmlJsonReBean.getDataObj());
    }

    @RequestMapping(value={"enableTginfoState.json"}, name="\u542f\u7528\u7ad9\u70b9\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean enableTginfoState(String tginfoId) {
        if (StringUtils.isBlank((String)tginfoId)) {
            this.logger.error(CODE + ".enableTginfoState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cmsTginfoServiceRepository.updateTginfoState(Integer.valueOf(tginfoId), Integer.valueOf(2), Integer.valueOf(0));
    }

    @RequestMapping(value={"disableTginfoState.json"}, name="\u505c\u7528\u7ad9\u70b9\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean disableTginfoState(String tginfoId) {
        if (StringUtils.isBlank((String)tginfoId)) {
            this.logger.error(CODE + ".disableTginfoState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cmsTginfoServiceRepository.updateTginfoState(Integer.valueOf(tginfoId), Integer.valueOf(0), Integer.valueOf(2));
    }

    @RequestMapping(value={"getTginfoByUrl.json"}, name="\u6839\u636eURL\u83b7\u53d6\u7ad9\u70b9\u4fe1\u606f")
    @ResponseBody
    public CmsTginfoReDomain getTginfoByUrl(HttpServletRequest request, String tginfoCompanyurl) {
        if (StringUtils.isBlank((String)tginfoCompanyurl)) {
            return null;
        }
        Map param = this.assemMapMemberParam(request);
        param.put("tginfoCompanyurl", tginfoCompanyurl);
        SupQueryResult cmsTginfoReDomainSupQueryResult = this.cmsTginfoServiceRepository.queryTginfoPage(param);
        if (null == cmsTginfoReDomainSupQueryResult || ListUtil.isEmpty((Collection)cmsTginfoReDomainSupQueryResult.getList())) {
            return null;
        }
        return (CmsTginfoReDomain)cmsTginfoReDomainSupQueryResult.getList().get(0);
    }
}

