/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.cms.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.cms.domain.CmsDoclistDomainBean;
import com.qjsoft.laser.controller.facade.cms.domain.CmsDoclistReDomainBean;
import com.qjsoft.laser.controller.facade.cms.domain.CmsTginfoMenuReDomain;
import com.qjsoft.laser.controller.facade.cms.repository.CmsDoclistServiceRepository;
import com.qjsoft.laser.controller.facade.cms.repository.CmsTginfoMenuServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/cms/doclistBusiness"}, name="\u6587\u6863\u670d\u52a1")
public class DoclistBusCon
extends SpringmvcController {
    private static String CODE = "cms.doclist.con";
    @Autowired
    private CmsDoclistServiceRepository cmsDoclistServiceRepository;
    @Autowired
    private CmsTginfoMenuServiceRepository cmsTginfoMenuServiceRepository;

    protected String getContext() {
        return "doclist";
    }

    @RequestMapping(value={"saveDoclist.json"}, name="\u589e\u52a0\u6587\u6863\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveDoclist(HttpServletRequest request, CmsDoclistDomainBean cmsDoclistDomainBean) {
        if (null == cmsDoclistDomainBean) {
            this.logger.error(CODE + ".saveDoclist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (!StringUtils.isEmpty((String)cmsDoclistDomainBean.getTginfoMenuCode())) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("menuOpcode", cmsDoclistDomainBean.getTginfoMenuCode());
            param.put("tenantCode", this.getTenantCode(request));
            SupQueryResult result = this.cmsTginfoMenuServiceRepository.queryTginfoMenuPage(param);
            if (null == result.getList() || result.getList().size() == 0) {
                this.logger.error(CODE + ".saveAdvertise", (Object)"\u680f\u76ee\u4e0d\u5b58\u5728\uff01");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u680f\u76ee\u4e0d\u5b58\u5728\uff01");
            }
        }
        cmsDoclistDomainBean.setTenantCode(this.getTenantCode(request));
        return this.cmsDoclistServiceRepository.saveDoclist(cmsDoclistDomainBean);
    }

    @RequestMapping(value={"getDoclist.json"}, name="\u83b7\u53d6\u6587\u6863\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public CmsDoclistReDomainBean getDoclist(Integer doclistId) {
        if (StringUtils.isBlank((Integer)doclistId)) {
            this.logger.error(CODE + ".getDoclist", (Object)"param is null");
            return null;
        }
        return this.cmsDoclistServiceRepository.getDoclist(doclistId);
    }

    @RequestMapping(value={"updateDoclist.json"}, name="\u66f4\u65b0\u6587\u6863\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateDoclist(HttpServletRequest request, CmsDoclistDomainBean cmsDoclistDomainBean) {
        if (null == cmsDoclistDomainBean) {
            this.logger.error(CODE + ".updateDoclist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        cmsDoclistDomainBean.setTenantCode(this.getTenantCode(request));
        return this.cmsDoclistServiceRepository.updateDoclist(cmsDoclistDomainBean);
    }

    @RequestMapping(value={"deleteDoclist.json"}, name="\u5220\u9664\u6587\u6863\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteDoclist(Integer doclistId) {
        if (StringUtils.isBlank((Integer)doclistId)) {
            this.logger.error(CODE + ".deleteDoclist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cmsDoclistServiceRepository.deleteDoclist(doclistId);
    }

    @RequestMapping(value={"queryDoclistPage.json"}, name="\u67e5\u8be2\u6587\u6863\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CmsDoclistReDomainBean> queryDoclistPage(HttpServletRequest request) {
        SupQueryResult result;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("orderStr", "DOCLIST_ORDER ASC");
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null != (result = this.cmsDoclistServiceRepository.queryDoclistPage(param)).getList() && result.getList().size() > 0) {
            String tenantCode = this.getTenantCode(request);
            for (CmsDoclistReDomainBean cmsDoclistReDomainBean : result.getList()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("tenantCode", tenantCode);
                map.put("menuOpcode", cmsDoclistReDomainBean.getTginfoMenuCode());
                List menuList = this.cmsTginfoMenuServiceRepository.queryTginfoMenuPage(map).getList();
                CmsTginfoMenuReDomain menu = new CmsTginfoMenuReDomain();
                if (menuList.size() > 0) {
                    menu = (CmsTginfoMenuReDomain)menuList.get(0);
                }
                if (null == menu || null == menu.getTginfoMenuName()) continue;
                cmsDoclistReDomainBean.setTginfoMenuName(menu.getTginfoMenuName());
                cmsDoclistReDomainBean.setTginfoCode(menu.getTginfoCode());
            }
        }
        return result;
    }

    @RequestMapping(value={"updateDoclistState.json"}, name="\u66f4\u65b0\u6587\u6863\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateDoclistState(String doclistId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)doclistId)) {
            this.logger.error(CODE + ".updateDoclistState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cmsDoclistServiceRepository.updateDoclistState(Integer.valueOf(doclistId), dataState, oldDataState);
    }

    @RequestMapping(value={"updateReleaseDoclist.json"}, name="\u53d1\u5e03\u6587\u6863\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateReleaseDoclist(HttpServletRequest request, String doclistId) {
        if (StringUtils.isBlank((String)doclistId)) {
            this.logger.error(CODE + ".updateDoclistState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String userCode = this.getUserInfo(request).getUserCode();
        return this.cmsDoclistServiceRepository.updateReleaseDoclist(Integer.valueOf(doclistId), userCode, Integer.valueOf(2));
    }

    @RequestMapping(value={"disableDoclistState.json"}, name="\u505c\u7528\u6587\u6863\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean disableDoclistState(String doclistId) {
        if (StringUtils.isBlank((String)doclistId)) {
            this.logger.error(CODE + ".disableTginfoState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cmsDoclistServiceRepository.updateDoclistState(Integer.valueOf(doclistId), Integer.valueOf(0), Integer.valueOf(2));
    }

    @RequestMapping(value={"queryDoclistPageByTginfoMenuCode.json"}, name="\u6839\u636emenuCode\u67e5\u8be2\u6240\u6709\u5df2\u53d1\u5e03\u7684\u6587\u7ae0")
    @ResponseBody
    public SupQueryResult<CmsDoclistReDomainBean> queryDoclistPageByTginfoMenuCode(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("dataState", 2);
        }
        return this.cmsDoclistServiceRepository.queryDoclistPage(param);
    }
}

