/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.common.service;

import com.qjsoft.laser.controller.common.bean.FmFileDomainBean;
import com.qjsoft.laser.controller.common.bean.FmFileReDomainBean;
import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.common.service.ExcelIService;
import com.qjsoft.laser.controller.common.service.HtmlIBaseService;
import com.qjsoft.laser.controller.common.util.ExportExcelUtlis;
import com.qjsoft.laser.controller.core.service.HtmlServiceImpl;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.file.FileBean;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;

public class ExcelService
extends HtmlServiceImpl
implements ExcelIService {
    private static final String sys_code = "com.common.ExcelService.";
    @Autowired
    private HtmlIBaseService htmlIBaseService;

    @Override
    public void exportExcel(Map<String, Object> paramMap, String apiRouter) {
        if (MapUtil.isEmpty(paramMap) || StringUtils.isBlank((String)apiRouter)) {
            this.logger.error("com.common.ExcelService.intoParam.null", (Object)("paramMap:" + paramMap + ",apiRouter:" + apiRouter));
            return;
        }
        String fileName = MapUtils.getString(paramMap, (Object)"fileName");
        String tenantCode = MapUtils.getString(paramMap, (Object)"tenantCode");
        Object condition = paramMap.get("condition");
        this.logger.error("com.common.ExcelService.param", (Object)("paramMap:" + paramMap));
        ArrayList<String> excelHeader = new ArrayList<String>();
        Object headMap = paramMap.get("headMap");
        List headMapList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNonDefaultBinder().toJson(headMap), Map.class);
        for (Map map : headMapList) {
            String showName = map.get("showName").toString();
            excelHeader.add(showName);
        }
        String[] arrString = excelHeader.toArray(new String[excelHeader.size()]);
        int row = 100;
        int page = 1;
        int index = 0;
        Map conditionMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson(condition), String.class, Object.class);
        conditionMap.put("tenantCode", tenantCode);
        conditionMap.put("row", row);
        conditionMap.put("page", page);
        this.logger.error("com.common.ExcelService.queryparam", (Object)("conditionMap:" + conditionMap));
        List<Map<String, Object>> fromDataList = this.getExportData(apiRouter, conditionMap);
        if (ListUtil.isEmpty(fromDataList)) {
            return;
        }
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        ArrayList<String> data = null;
        for (Map<String, Object> map : fromDataList) {
            data = new ArrayList<String>();
            for (Map map1 : headMapList) {
                String beanName = map1.get("dataName").toString();
                String value = map.get(beanName).toString();
                data.add(value);
            }
            String[] array = data.toArray(new String[data.size()]);
            dataList.add(array);
        }
        try {
            HSSFWorkbook hssfWorkbook = ExportExcelUtlis.exportExcel(fileName, arrString, dataList, "yyyy-MM-dd HH:mm:ss", index);
            this.logger.error("com.common.ExcelService..exportExcel.hssfWorkbook", (Object)("hssfWorkbook:" + hssfWorkbook.getBytes()));
            this.saveExcel(hssfWorkbook, fileName, tenantCode);
        }
        catch (Exception e) {
            this.logger.error("com.common.ExcelService.exportExcel", (Object)"exportExcelException", (Throwable)e);
            return;
        }
        index += dataList.size();
        ++page;
    }

    private void saveExcel(HSSFWorkbook hssfWorkbook, String fileName, String tenantCode) {
        FmFileReDomainBean fmFileReDomainBean = new FmFileReDomainBean();
        fmFileReDomainBean.setFileName(fileName);
        fmFileReDomainBean.setFileType("0");
        fmFileReDomainBean.setFileContext(hssfWorkbook.getBytes());
        FileBean fileBean = new FileBean();
        fileBean.setBytes(hssfWorkbook.getBytes());
        fileBean.setFileType("xlsx");
        fileBean.setOriginalFilename(fileName);
        this.logger.error("com.common.ExcelService..saveExcel.FmFileReDomainBean", (Object)("FmFileReDomainBean:" + JsonUtil.buildNormalBinder().toJson((Object)fmFileReDomainBean)));
        this.logger.error("com.common.ExcelService..saveExcel.FileBean", (Object)("FileBean:" + JsonUtil.buildNormalBinder().toJson((Object)fileBean)));
        FmFileReDomainBean file_01 = this.saveFile(fileBean, tenantCode, "FILE_01", fmFileReDomainBean);
    }

    private List<Map<String, Object>> getExportData(String apiRouter, Map<String, Object> map) {
        PostParamMap<String, Object> pmap = new PostParamMap<String, Object>(apiRouter);
        pmap.putParamToJson("map", map);
        SupQueryResult supQueryResult = this.htmlIBaseService.sendReSupObject(pmap, Object.class);
        List datalist = supQueryResult.getList();
        return this.covertExportData(datalist);
    }

    public List<Map<String, Object>> covertExportData(List<?> datalist) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (Object o : datalist) {
            String substring = o.toString().substring(1, o.toString().length() - 1);
            String[] split = substring.split(",");
            HashMap<String, String> map = new HashMap<String, String>();
            for (String s : split) {
                String[] split1 = s.split("=");
                map.put(split1[0], split1[1]);
            }
            mapList.add(map);
        }
        return mapList;
    }

    private FmFileReDomainBean saveFile(FileBean fileBean, String tenantCode, String fileSort, FmFileDomainBean FmFileDomainBeanBean) {
        if (null == FmFileDomainBeanBean || null == fileBean) {
            return null;
        }
        FmFileReDomainBean fmFileReDomainBean = null;
        try {
            String fileUrl;
            PostParamMap<String, Object> pmap = new PostParamMap<String, Object>("fm.file.saveFile");
            FmFileDomainBeanBean.setFileType("0");
            FmFileDomainBeanBean.setFileSort(StringUtils.isBlank((String)fileSort) ? "FILE_02" : fileSort);
            FmFileDomainBeanBean.setTenantCode(tenantCode);
            FmFileDomainBeanBean.setRootPath(tenantCode + "/");
            ArrayList<FileBean> fileBeanList = new ArrayList<FileBean>();
            fileBeanList.add(fileBean);
            pmap.putParamToJson("fmFileDomainBean", FmFileDomainBeanBean);
            pmap.putParamToJson("fileBeanList", fileBeanList);
            String key = "filePath";
            String settingType = "0";
            fmFileReDomainBean = (FmFileReDomainBean)this.htmlIBaseService.senReObject(pmap, FmFileReDomainBean.class);
            String httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-" + settingType + "-" + key));
            if (StringUtils.isBlank((String)httpPath)) {
                httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)("00000000-" + settingType + "-" + key));
            }
            if (StringUtils.isNotBlank((String)(fileUrl = fmFileReDomainBean.getFileUrl()))) {
                String separator = System.getProperties().getProperty("file.separator");
                if (fileUrl.startsWith("/") || fileUrl.startsWith("\\")) {
                    separator = "";
                }
                fmFileReDomainBean.setFileUrl(httpPath + separator + fileUrl);
            }
            fmFileReDomainBean.setRootPath(fileUrl);
        }
        catch (Exception e) {
            // empty catch block
        }
        return fmFileReDomainBean;
    }

    public static void main(String[] args) {
        String json = "{\"headMap\":[{\"showName\":\"\u59d3\u540d\",\"dataName\":\"username\"},{\"showName\":\"\u5e74\u9f84\",\"dataName\":\"userage\"}],\"condition\":{\"rows\":\"1\"},\"fileName\":\"\u6587\u4ef6\"}";
        Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        ExcelService excelService = new ExcelService();
        excelService.exportExcel(map, "2");
    }
}

