/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.common.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.common.service.HtmlIBaseService;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.core.router.HtmlRouter;
import com.qjsoft.laser.controller.core.service.HtmlServiceImpl;
import com.yqbsoft.laser.service.suppercore.SupperSysException;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult2;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;

public class HtmlBaseService
extends HtmlServiceImpl
implements HtmlIBaseService {
    private static final String sys_code = "HtmlBaseService";
    @Autowired
    private HtmlRouter htmlRouter;
    private static final ExecutorService pool = Executors.newFixedThreadPool(2);

    @Override
    public HtmlJsonReBean sendMesReBean(PostParamMap<String, Object> pmap) {
        try {
            OutMessage om = this.send(pmap);
            if (null == om) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u64cd\u4f5c\u5f02\u5e38");
            }
            if (om.isSuccess()) {
                return new HtmlJsonReBean(om.getReObj());
            }
            return new HtmlJsonReBean(om.getOpErrorCode(), om.getMsg());
        }
        catch (Exception e) {
            if (e instanceof SupperSysException) {
                SupperSysException exe = (SupperSysException)e;
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, HtmlBaseService.parseErrorMsg(exe.getErrMsg()));
            }
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u64cd\u4f5c\u5f02\u5e381");
        }
    }

    private static String parseErrorMsg(String errMsg) {
        int tagIndex = errMsg.lastIndexOf(":");
        if (tagIndex >= 0) {
            return errMsg.substring(tagIndex + 1);
        }
        return errMsg;
    }

    @Override
    public boolean sendMesReState(PostParamMap<String, Object> pmap) {
        OutMessage om = this.send(pmap);
        if (null == om) {
            return false;
        }
        return om.isSuccess();
    }

    @Override
    public Object sendMes(PostParamMap<String, Object> pmap, Class sz) {
        OutMessage om = this.send(pmap);
        if (null == om || null == om.getReObj()) {
            return null;
        }
        Object ob = JsonUtil.buildNormalBinder().getJsonToObject((String)om.getReObj(), sz);
        return ob;
    }

    @Override
    public String sendMesReJson(PostParamMap<String, Object> pmap) {
        OutMessage om = this.send(pmap);
        if (null == om || null == om.getReObj()) {
            return null;
        }
        return (String)om.getReObj();
    }

    @Override
    public <T> Object senBySupRq(PostParamMap<String, Object> pmap, T type) {
        String json = this.sendMesReJson(pmap);
        if (StringUtils.isNotBlank((String)json)) {
            return JsonUtil.buildNormalBinder().getJsonToObject(json, new TypeReference<T>(){});
        }
        return null;
    }

    @Override
    public SupQueryResult sendReSupObject(PostParamMap<String, Object> pmap, Class cls) {
        String json = this.sendMesReJson(pmap);
        if (StringUtils.isNotBlank((String)json)) {
            SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, SupQueryResult.class);
            List list = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), cls);
            supQueryResult.setList(list);
            return supQueryResult;
        }
        return null;
    }

    @Override
    public <T> SupQueryResult2<T> getForQueryResult2(PostParamMap<String, Object> paramMap, Class<T> clzz) {
        String json = this.sendMesReJson(paramMap);
        return (SupQueryResult2)JsonUtil.buildNormalBinder().getJsonToObject(json, SupQueryResult2.class);
    }

    @Override
    public Object senReList(PostParamMap<String, Object> pmap, Class sz) {
        String json = this.sendMesReJson(pmap);
        if (StringUtils.isNotBlank((String)json)) {
            List list = (List)JsonUtil.buildNormalBinder().getJsonToList(json, sz);
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public Object senReObject(PostParamMap<String, Object> pmap, Class sz) {
        OutMessage om = this.send(pmap);
        if (null == om || null == om.getReObj()) {
            return null;
        }
        if (null == sz) {
            return om.getReObj();
        }
        String cname = sz.getName();
        if (null == cname) {
            return om.getReObj();
        }
        if (cname.indexOf("java.lang") == 0) {
            return om.getReObj();
        }
        String json = (String)om.getReObj();
        if (StringUtils.isNotBlank((String)json)) {
            return JsonUtil.buildNormalBinder().getJsonToObject(json, sz);
        }
        return null;
    }

    private OutMessage send(PostParamMap<String, Object> pmap) {
        if (null == pmap || StringUtils.isBlank((String)pmap.getAppApiCode())) {
            this.logger.error("HtmlBaseService.send.pnull", (Object)"param is null");
            return null;
        }
        OutMessage om = this.htmlRouter.inInvokeOutMessage(pmap.getAppApiCode(), pmap.getAppVersion(), pmap.getApiRouter(), pmap.getParam());
        if (null == om) {
            throw new SupperSysException("HtmlBaseService.send.omnull", "OutMessage is null");
        }
        if (!om.isOpSuccess()) {
            throw new SupperSysException(om.getOpErrorCode(), om.getOpErrorMsg());
        }
        if (om.isError()) {
            throw new SupperSysException(om.getErrorCode(), om.getMsg());
        }
        return om;
    }

    @Override
    public void sendMesReBeanInAsync(final PostParamMap<String, Object> pmap) {
        pool.execute(new Runnable(){

            @Override
            public void run() {
                HtmlBaseService.this.send(pmap);
            }
        });
    }

    @Override
    public void put(PostParamMap<String, Object> paramMap) {
        this.send(paramMap);
    }

    @Override
    public <T> List<T> getForList(PostParamMap<String, Object> pmap, Class<T> clzz) {
        return (List)this.senReList(pmap, clzz);
    }
}

