/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.common.util;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;

public class ExportExcelUtlis {
    public static HSSFWorkbook exportExcel(String fileName, String[] headers, List<Object[]> dataset, String pattern, int index) throws IOException {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(fileName);
        HSSFRow row = sheet.createRow(0);
        for (short i = 0; i < headers.length; i = (short)(i + 1)) {
            HSSFCell cell = row.createCell(i);
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
        }
        Iterator<Object[]> it = dataset.iterator();
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            Object[] obj = it.next();
            for (short i = 0; i < obj.length; i = (short)(i + 1)) {
                HSSFCell cell = row.createCell(i);
                Object value = obj[i];
                String textValue = null;
                if (!"".equals(value) && value != null) {
                    if (value instanceof Integer) {
                        int intValue = (Integer)value;
                        cell.setCellValue((double)intValue);
                        continue;
                    }
                    if (value instanceof Float) {
                        float fValue = ((Float)value).floatValue();
                        cell.setCellValue((double)fValue);
                        continue;
                    }
                    if (value instanceof Double) {
                        double dValue = (Double)value;
                        cell.setCellValue(dValue);
                        continue;
                    }
                    if (value instanceof Long) {
                        long longValue = (Long)value;
                        cell.setCellValue((double)longValue);
                        continue;
                    }
                    if (value instanceof Date) {
                        Date date = (Date)value;
                        if (null == pattern || pattern.equals("")) {
                            pattern = "yyyy-MM-dd";
                        }
                        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
                        textValue = sdf.format(date);
                        cell.setCellValue(textValue);
                        continue;
                    }
                    textValue = value.toString();
                    cell.setCellValue(textValue);
                    continue;
                }
                cell.setCellValue("");
            }
        }
        for (int colNum = 0; colNum < headers.length; ++colNum) {
            int columnWidth = sheet.getColumnWidth(colNum) / 256;
            for (int rowNum = 0; rowNum < sheet.getLastRowNum(); ++rowNum) {
                int length;
                HSSFCell currentCell;
                HSSFRow currentRow = sheet.getRow(rowNum) == null ? sheet.createRow(rowNum) : sheet.getRow(rowNum);
                if (currentRow.getCell(colNum) == null || (currentCell = currentRow.getCell(colNum)).getCellType() != 1) continue;
                int n = length = currentCell.getStringCellValue() != null ? currentCell.getStringCellValue().getBytes().length : 10;
                if (columnWidth >= length) continue;
                columnWidth = length;
            }
            if (colNum == 0) {
                sheet.setColumnWidth(colNum, (columnWidth - 2) * 256);
                continue;
            }
            sheet.setColumnWidth(colNum, (columnWidth + 4) * 256);
        }
        return workbook;
    }
}

