/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.cp.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.cp.bean.PayChannel;
import com.qjsoft.laser.controller.facade.cp.domain.CpRechargeDomain;
import com.qjsoft.laser.controller.facade.cp.domain.CpRechargeReDomain;
import com.qjsoft.laser.controller.facade.cp.repository.CpRechargeServiceRepository;
import com.qjsoft.laser.controller.facade.fm.domain.FmFileReDomainBean;
import com.qjsoft.laser.controller.facade.fm.repository.FileServiceRepository;
import com.qjsoft.laser.controller.facade.pte.domain.PtePtfchannelReDomain;
import com.qjsoft.laser.controller.facade.pte.repository.PtePtfchannelServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.facade.vd.domain.VdFaccountInfo;
import com.qjsoft.laser.controller.facade.vd.repository.VdFaccountServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.qjsoft.laser.controller.springmvc.bean.TmProappEnv;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/web/cp/recharge"}, name="\u5145\u503c")
public class RechargeCon
extends SpringmvcController {
    private static String CODE = "cp.recharge.con";
    @Autowired
    private CpRechargeServiceRepository cpRechargeServiceRepository;
    @Autowired
    private PtePtfchannelServiceRepository ptePtfchannelServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private FileServiceRepository fileServiceRepository;
    @Autowired
    private VdFaccountServiceRepository vdFaccountServiceRepository;

    protected String getContext() {
        return "recharge";
    }

    @RequestMapping(value={"saveRecharge.json"}, name="\u5145\u503c\u65b0\u589e")
    @ResponseBody
    public HtmlJsonReBean saveRecharge(HttpServletRequest request, CpRechargeDomain cpRechargeDomain) {
        if (null == cpRechargeDomain) {
            this.logger.error(CODE + ".saveRecharge", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        cpRechargeDomain.setTenantCode(this.getTenantCode(request));
        return this.cpRechargeServiceRepository.saveRecharge(cpRechargeDomain);
    }

    @RequestMapping(value={"getRecharge.json"}, name="\u6839\u636eID\u83b7\u53d6\u5145\u503c")
    @ResponseBody
    public CpRechargeReDomain getRecharge(Integer rechargeId) {
        if (StringUtils.isBlank((Integer)rechargeId)) {
            this.logger.error(CODE + ".getRecharge", (Object)"param is null");
            return null;
        }
        return this.cpRechargeServiceRepository.getRecharge(rechargeId);
    }

    @RequestMapping(value={"updateRecharge.json"}, name="\u5145\u503c\u4fee\u6539")
    @ResponseBody
    public HtmlJsonReBean updateRecharge(HttpServletRequest request, CpRechargeDomain cpRechargeDomain) {
        if (null == cpRechargeDomain) {
            this.logger.error(CODE + ".updateRecharge", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        cpRechargeDomain.setTenantCode(this.getTenantCode(request));
        return this.cpRechargeServiceRepository.updateRecharge(cpRechargeDomain);
    }

    @RequestMapping(value={"deleteRecharge.json"}, name="\u6839\u636eID\u5220\u9664\u5145\u503c")
    @ResponseBody
    public HtmlJsonReBean deleteRecharge(Integer rechargeId) {
        if (StringUtils.isBlank((Integer)rechargeId)) {
            this.logger.error(CODE + ".deleteRecharge", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cpRechargeServiceRepository.deleteRecharge(rechargeId);
    }

    @RequestMapping(value={"queryRechargePage.json"}, name="\u5145\u503c\u5206\u9875\u67e5\u8be2")
    @ResponseBody
    public SupQueryResult<CpRechargeReDomain> queryRechargePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.cpRechargeServiceRepository.queryRechargePage(param);
    }

    @RequestMapping(value={"updateRechargeState.json"}, name="\u5145\u503c\u72b6\u6001\u66f4\u65b0")
    @ResponseBody
    public HtmlJsonReBean updateRechargeState(String rechargeId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)rechargeId)) {
            this.logger.error(CODE + ".updateRechargeState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cpRechargeServiceRepository.updateRechargeState(Integer.valueOf(rechargeId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"blessingPointRecharge.json"}, name="\u7ebf\u4e0b\u5145\u503c\u65b0\u589e")
    @ResponseBody
    public HtmlJsonReBean blessingPointRecharge(HttpServletRequest request, CpRechargeDomain cpRechargeDomain) {
        return this.blessingPointRechargeCom(request, cpRechargeDomain);
    }

    @RequestMapping(value={"queryBlessingPointPage.json"}, name="\u798f\u70b9\u5217\u8868\u5206\u9875\u67e5\u8be2")
    @ResponseBody
    public SupQueryResult<CpRechargeReDomain> queryBlessingPointPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.cpRechargeServiceRepository.queryRechargePage(param);
    }

    @RequestMapping(value={"queryBlessingPointDataStatePage.json"}, name="\u798f\u70b9\u72b6\u6001\u5217\u8868\u5206\u9875\u67e5\u8be2")
    @ResponseBody
    public SupQueryResult<CpRechargeReDomain> queryBlessingPointDataStatePage(HttpServletRequest request, Integer dataState) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("dataState", dataState);
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.cpRechargeServiceRepository.queryRechargePage(param);
    }

    @RequestMapping(value={"submissionExamine.json"}, name="\u5145\u503c\u63d0\u4ea4\u5ba1\u6838")
    @ResponseBody
    public HtmlJsonReBean submissionExamine(HttpServletRequest request, Integer rechargeId) {
        if (StringUtils.isBlank((Integer)rechargeId)) {
            this.logger.error(CODE + ".submissionExamine", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cpRechargeServiceRepository.updateRechargeState(rechargeId, Integer.valueOf(1), Integer.valueOf(0), null);
    }

    @RequestMapping(value={"examineBlessingPointSuccess.json"}, name="\u5145\u503c\u5ba1\u6838\u6210\u529f")
    @ResponseBody
    public HtmlJsonReBean examineBlessingPointSuccess(HttpServletRequest request, Integer rechargeId, String memo) {
        if (StringUtils.isBlank((Integer)rechargeId)) {
            this.logger.error(CODE + ".examineBlessingPoint", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        String userCode = userSession.getUserCode();
        String userName = userSession.getUserName();
        Map<String, Object> map = this.getEnvMap(request);
        if (null == map) {
            map = new HashMap<String, Object>();
        }
        map.put("rechargeUcode", userCode);
        map.put("rechargeUname", userName);
        map.put("memo", memo);
        return this.cpRechargeServiceRepository.updateRechargeState(rechargeId, Integer.valueOf(2), Integer.valueOf(1), map);
    }

    @RequestMapping(value={"examineBlessingPointFail.json"}, name="\u798f\u70b9\u5145\u503c\u5ba1\u6838\u5931\u8d25")
    @ResponseBody
    public HtmlJsonReBean examineBlessingPointFail(HttpServletRequest request, Integer rechargeId, String memo) {
        UserSession userSession = this.getUserSession(request);
        String userCode = userSession.getUserCode();
        String userName = userSession.getUserName();
        Map<String, Object> map = this.getEnvMap(request);
        if (null == map) {
            map = new HashMap<String, Object>();
        }
        map.put("rechargeUcode", userCode);
        map.put("rechargeUname", userName);
        map.put("memo", memo);
        return this.cpRechargeServiceRepository.updateRechargeState(rechargeId, Integer.valueOf(-1), Integer.valueOf(1), map);
    }

    @RequestMapping(value={"checkBlessingPoint.json"}, name="\u798f\u70b9\u5145\u503c\u6267\u884c")
    @ResponseBody
    public HtmlJsonReBean checkBlessingPoint(HttpServletRequest request, Integer rechargeId) {
        if (StringUtils.isBlank((Integer)rechargeId)) {
            this.logger.error(CODE + ".checkBlessingPoint", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cpRechargeServiceRepository.updateRechargeState(rechargeId, Integer.valueOf(3), Integer.valueOf(2), null);
    }

    @RequestMapping(value={"updateBlessingPoint.json"}, name="\u5145\u503c\u7f16\u8f91\u4fee\u6539")
    @ResponseBody
    public HtmlJsonReBean updateBlessingPoint(HttpServletRequest request, CpRechargeDomain cpRechargeDomain) {
        if (null == cpRechargeDomain) {
            this.logger.error(CODE + ".updateBlessingPoint", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        cpRechargeDomain.setTenantCode(this.getTenantCode(request));
        return this.cpRechargeServiceRepository.updateRecharge(cpRechargeDomain);
    }

    @RequestMapping(value={"uploadRechargeFile.json"}, name="\u4e0a\u4f20\u5408\u540c\u51ed\u8bc1")
    @ResponseBody
    public FmFileReDomainBean uploadRechargeFile(HttpServletRequest request, MultipartFile file, String fileSort) {
        if (null == file) {
            this.logger.error(CODE + ".uploadRechargeFile", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.fileServiceRepository.saveFile(file, tenantCode, fileSort, null);
    }

    public Map<String, PtePtfchannelReDomain> queryChannel(String fchannelPmodeCode, String tenantCode, String fchannelDr) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fchannelPmodeCode", fchannelPmodeCode);
        map.put("tenantCode", tenantCode);
        map.put("fchannelDr", fchannelDr);
        List list = this.ptePtfchannelServiceRepository.queryPtfchannelReList(map);
        if (null == list || list.isEmpty()) {
            return null;
        }
        HashMap<String, PtePtfchannelReDomain> channelmap = new HashMap<String, PtePtfchannelReDomain>();
        for (PtePtfchannelReDomain ptePtfchannelReDomain : list) {
            channelmap.put(ptePtfchannelReDomain.getFchannelCode(), ptePtfchannelReDomain);
        }
        return channelmap;
    }

    @RequestMapping(value={"queryChannel.json"}, name="\u83b7\u53d6\u5145\u503c\u6e20\u9053")
    @ResponseBody
    public List<PayChannel> queryChannel(HttpServletRequest request) {
        String oauthEnvCode = this.getOauthEnvCode(request);
        if (StringUtils.isBlank((String)oauthEnvCode)) {
            this.logger.error(CODE + ".queryChannel.oauthEnvCode", (Object)"oauthEnvCode is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryChannel.userSession", (Object)"userSession is null");
            return null;
        }
        return this.queryPayChannel(userSession.getUserPcode(), oauthEnvCode, this.getTenantCode(request), "IN");
    }

    public Map<String, Object> getEnvMap(HttpServletRequest request) {
        UserSession userSession;
        String userAgent;
        HashMap<String, Object> envmap = new HashMap<String, Object>();
        String proappCode = this.getProappCode(request);
        String oauthEnvCode = this.getOauthEnvCode(request);
        if ("app".equals(oauthEnvCode) && StringUtils.isNotBlank((String)(userAgent = request.getHeader("User-Agent")))) {
            if (userAgent.contains("qj-ios")) {
                oauthEnvCode = "ios";
            } else if (userAgent.contains("qj-android")) {
                oauthEnvCode = "android";
            }
        }
        envmap.put("client_ip", this.getClientIp(request));
        envmap.put("wap_type", this.getOauthEnvCode(request));
        envmap.put("wap_name", proappCode);
        TmProappEnv tmProappEnv = (TmProappEnv)SupDisUtil.getMapJson((String)"TmProappEnv-tenant-ProappCode", (String)(this.getTenantCode(request) + "-" + proappCode), TmProappEnv.class);
        if (null != tmProappEnv) {
            envmap.put("wap_url", tmProappEnv.getProappEnvDomain());
            if (StringUtils.isNotBlank((String)tmProappEnv.getProappEnvDes())) {
                envmap.put("wap_name", tmProappEnv.getProappEnvDes());
            }
        }
        if (null != (userSession = this.getUserSession(request))) {
            envmap.put("openId", userSession.getOpenId());
        }
        return envmap;
    }

    public List<PayChannel> queryPayChannel(String memberCode, String fchannelPmodeCode, String tenantCode, String fchannelDr) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)fchannelPmodeCode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)fchannelDr)) {
            return null;
        }
        String type = memberCode.substring(0, 1);
        String faccountType = "101";
        if ("2".equals(type)) {
            faccountType = "201";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fchannelPmodeCode", fchannelPmodeCode);
        map.put("tenantCode", tenantCode);
        map.put("fchannelDr", fchannelDr);
        List qlist = this.ptePtfchannelServiceRepository.queryPtfchannelReList(map);
        if (null == qlist || qlist.isEmpty()) {
            this.logger.error(CODE + ".getPayChannel.null", (Object)((Object)map).toString());
            return null;
        }
        Map<String, VdFaccountInfo> account = this.getVd(memberCode, tenantCode, faccountType);
        ArrayList<PayChannel> channelList = new ArrayList<PayChannel>();
        for (PtePtfchannelReDomain ptePtfchannelReDomain : qlist) {
            PayChannel payChannel;
            if ("BANK".equals(ptePtfchannelReDomain.getDicActorCode())) {
                payChannel = new PayChannel();
                try {
                    BeanUtils.copyAllPropertys((Object)payChannel, (Object)ptePtfchannelReDomain);
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".getPayChannel.e", (Throwable)e);
                }
                channelList.add(payChannel);
                continue;
            }
            if (!faccountType.equals(ptePtfchannelReDomain.getFchannelType())) {
                Map<String, VdFaccountInfo> naccount = this.getVd(memberCode, tenantCode, ptePtfchannelReDomain.getFchannelType());
                if (null == naccount || naccount.isEmpty()) continue;
                account.putAll(naccount);
            }
            payChannel = new PayChannel();
            try {
                BeanUtils.copyAllPropertys((Object)payChannel, (Object)ptePtfchannelReDomain);
                VdFaccountInfo v = account.get(ptePtfchannelReDomain.getFchannelType());
                if (null != v) {
                    BeanUtils.copyAllPropertys((Object)payChannel, (Object)v);
                }
            }
            catch (Exception e) {
                this.logger.error(CODE + ".getPayChannel.e1", (Throwable)e);
            }
            channelList.add(payChannel);
        }
        return channelList;
    }

    private Map<String, VdFaccountInfo> getVd(String memberCode, String tenantCode, String faccountType) {
        List vdList = this.vdFaccountServiceRepository.queryOuterFaccount(memberCode, faccountType, tenantCode);
        HashMap<String, VdFaccountInfo> account = new HashMap<String, VdFaccountInfo>();
        if (null != vdList && !vdList.isEmpty()) {
            for (VdFaccountInfo v : vdList) {
                account.put(v.getFaccountType(), v);
            }
        }
        return account;
    }

    @RequestMapping(value={"blessingPointRechargeForAt.json"}, name="\u7ebf\u4e0b\u5145\u503c\u65b0\u589e--\u7ade\u62cd")
    @ResponseBody
    public HtmlJsonReBean blessingPointRechargeForAt(HttpServletRequest request, CpRechargeDomain cpRechargeDomain) {
        return this.blessingPointRecharge(request, cpRechargeDomain);
    }

    @RequestMapping(value={"examineBlessingPointSuccessForAt.json"}, name="\u5145\u503c\u5ba1\u6838\u6210\u529f--\u7ade\u62cd")
    @ResponseBody
    public HtmlJsonReBean examineBlessingPointSuccessForAt(HttpServletRequest request, Integer rechargeId, String memo) {
        if (StringUtils.isBlank((Integer)rechargeId)) {
            this.logger.error(CODE + ".examineBlessingPoint", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        String userCode = userSession.getUserCode();
        String userName = userSession.getUserName();
        Map<String, Object> map = this.getEnvMap(request);
        if (null == map) {
            map = new HashMap<String, Object>();
        }
        map.put("rechargeUcode", userCode);
        map.put("rechargeUname", userName);
        map.put("memo", memo);
        return this.cpRechargeServiceRepository.updateRechargeState(rechargeId, Integer.valueOf(2), Integer.valueOf(0), map);
    }

    @RequestMapping(value={"examineBlessingPointFailForAt.json"}, name="\u5145\u503c\u5ba1\u6838\u5931\u8d25--\u7ade\u62cd")
    @ResponseBody
    public HtmlJsonReBean examineBlessingPointFailForAt(HttpServletRequest request, Integer rechargeId, String memo) {
        UserSession userSession = this.getUserSession(request);
        String userCode = userSession.getUserCode();
        String userName = userSession.getUserName();
        Map<String, Object> map = this.getEnvMap(request);
        if (null == map) {
            map = new HashMap<String, Object>();
        }
        map.put("rechargeUcode", userCode);
        map.put("rechargeUname", userName);
        map.put("memo", memo);
        return this.cpRechargeServiceRepository.updateRechargeState(rechargeId, Integer.valueOf(-1), Integer.valueOf(0), map);
    }

    @RequestMapping(value={"getRechargeForAt.json"}, name="\u6839\u636eID\u83b7\u53d6\u5145\u503c--\u7ade\u62cd")
    @ResponseBody
    public CpRechargeReDomain getRechargeForAt(Integer rechargeId) {
        if (StringUtils.isBlank((Integer)rechargeId)) {
            this.logger.error(CODE + ".getRecharge", (Object)"param is null");
            return null;
        }
        return this.cpRechargeServiceRepository.getRecharge(rechargeId);
    }

    @RequestMapping(value={"queryRechargePageForAt.json"}, name="\u5145\u503c\u5206\u9875\u67e5\u8be2--\u7ade\u62cd")
    @ResponseBody
    public SupQueryResult<CpRechargeReDomain> queryRechargePageForAt(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.cpRechargeServiceRepository.queryRechargePage(param);
    }

    @RequestMapping(value={"queryJifenRechargePageForAt.json"}, name="\u5145\u503c\u5206\u9875\u67e5\u8be2--\u7ade\u62cd")
    @ResponseBody
    public SupQueryResult<CpRechargeReDomain> queryJifenRechargePageForAt(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("fchannelCode", "03");
        return this.cpRechargeServiceRepository.queryRechargePage(param);
    }

    @RequestMapping(value={"blessingPointRechargeForAtBatch.json"}, name="\u6279\u91cf\u7ebf\u4e0b\u5145\u503c\u65b0\u589e--\u7ade\u62cd")
    @ResponseBody
    public HtmlJsonReBean blessingPointRechargeForAtBatch(HttpServletRequest request, String paramStr) {
        List cpRechargeDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, CpRechargeDomain.class);
        if (ListUtil.isEmpty((Collection)cpRechargeDomainList)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "list is null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String tenantCode = this.getTenantCode(request);
        map.put("tenantCode", tenantCode);
        String basic = "101";
        for (CpRechargeDomain cpRechargeDomain : cpRechargeDomainList) {
            List vdFaccountInfos;
            map.put("userinfoCompname", cpRechargeDomain.getUserinfoName());
            SupQueryResult umUserinfoReDomainBeanSupQueryResult = this.userServiceRepository.queryUserinfoPage(map);
            if (ListUtil.isEmpty((Collection)umUserinfoReDomainBeanSupQueryResult.getList())) continue;
            cpRechargeDomain.setTenantCode(tenantCode);
            String userinfoCode = ((UmUserinfoReDomainBean)umUserinfoReDomainBeanSupQueryResult.getList().get(0)).getUserinfoCode();
            cpRechargeDomain.setUserinfoCode(userinfoCode);
            String type = userinfoCode.substring(0, 1);
            if ("2".equals(type)) {
                basic = "201";
            }
            if (ListUtil.isEmpty((Collection)(vdFaccountInfos = this.vdFaccountServiceRepository.queryOuterFaccount(userinfoCode, basic, tenantCode)))) {
                return new HtmlJsonReBean("error", "\u57fa\u672c\u6237\u4fe1\u606f\u4e3a\u7a7a");
            }
            cpRechargeDomain.setFaccountId(((VdFaccountInfo)vdFaccountInfos.get(0)).getFaccountOuterNo());
            cpRechargeDomain.setRechargeMode("1");
            this.blessingPointRechargeCom(request, cpRechargeDomain);
        }
        return new HtmlJsonReBean((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"integralRechargeForAtBatch.json"}, name="\u6279\u91cf\u79ef\u5206\u5145\u503c\u65b0\u589e--\u7ade\u62cd")
    @ResponseBody
    public HtmlJsonReBean integralRechargeForAtBatch(HttpServletRequest request, String paramStr) {
        List cpRechargeDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, CpRechargeDomain.class);
        if (ListUtil.isEmpty((Collection)cpRechargeDomainList)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "list is null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String tenantCode = this.getTenantCode(request);
        map.put("tenantCode", tenantCode);
        String basic = "103";
        for (CpRechargeDomain cpRechargeDomain : cpRechargeDomainList) {
            List vdFaccountInfos;
            SupQueryResult umUserinfoReDomainBeanSupQueryResult;
            if (StringUtils.isBlank((String)cpRechargeDomain.getUserinfoCode()) && StringUtils.isBlank((String)cpRechargeDomain.getUserinfoName())) continue;
            if (StringUtils.isNotBlank((String)cpRechargeDomain.getUserinfoCode())) {
                map.put("userinfoCode", cpRechargeDomain.getUserinfoCode());
            }
            if (StringUtils.isNotBlank((String)cpRechargeDomain.getUserinfoName())) {
                map.put("userinfoCompname", cpRechargeDomain.getUserinfoName());
            }
            if (ListUtil.isEmpty((Collection)(umUserinfoReDomainBeanSupQueryResult = this.userServiceRepository.queryUserinfoPage(map)).getList())) continue;
            UmUserinfoReDomainBean umUserinfoReDomainBean = (UmUserinfoReDomainBean)umUserinfoReDomainBeanSupQueryResult.getList().get(0);
            cpRechargeDomain.setTenantCode(tenantCode);
            String userinfoCode = umUserinfoReDomainBean.getUserinfoCode();
            cpRechargeDomain.setUserinfoCode(userinfoCode);
            String type = userinfoCode.substring(0, 1);
            if ("2".equals(type)) {
                basic = "203";
            }
            if (ListUtil.isEmpty((Collection)(vdFaccountInfos = this.vdFaccountServiceRepository.queryOuterFaccount(userinfoCode, basic, tenantCode)))) {
                return new HtmlJsonReBean("error", "\u79ef\u5206\u8d26\u6237\u4fe1\u606f\u4e3a\u7a7a");
            }
            String faccountOuterNo = ((VdFaccountInfo)vdFaccountInfos.get(0)).getFaccountOuterNo();
            cpRechargeDomain.setFaccountId(faccountOuterNo);
            cpRechargeDomain.setRechargeMode("1");
            cpRechargeDomain.setUserbankName("\u79ef\u5206\u8d26\u6237");
            cpRechargeDomain.setUserbankNo(faccountOuterNo);
            cpRechargeDomain.setBankcodeName("\u79ef\u5206\u5546\u57ce");
            cpRechargeDomain.setRechargeOpcode(faccountOuterNo);
            cpRechargeDomain.setFchannelCode("03");
            this.blessingPointRechargeCom(request, cpRechargeDomain);
        }
        return new HtmlJsonReBean((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    private HtmlJsonReBean blessingPointRechargeCom(HttpServletRequest request, CpRechargeDomain cpRechargeDomain) {
        UmUserinfoReDomainBean umUserinfoReDomainBean;
        if (null == cpRechargeDomain) {
            this.logger.error(CODE + ".blessingPointRecharge", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (StringUtils.isBlank((String)cpRechargeDomain.getUserinfoCode()) || StringUtils.isBlank((String)cpRechargeDomain.getFchannelCode())) {
            this.logger.error(CODE + ".blessingPointRecharge", (Object)"UserinfoCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "UserinfoCode FchannelCode");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".blessingPointRecharge", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession");
        }
        String userCode = userSession.getUserCode();
        String userName = userSession.getUserName();
        cpRechargeDomain.setUserCode(userCode);
        cpRechargeDomain.setUserName(userName);
        cpRechargeDomain.setRechargeCategory(cpRechargeDomain.getUserinfoCode().substring(0, 1));
        if (StringUtils.isBlank((String)cpRechargeDomain.getRechargeType())) {
            cpRechargeDomain.setRechargeType("01");
        }
        if (StringUtils.isBlank((String)cpRechargeDomain.getRechargeMode())) {
            cpRechargeDomain.setRechargeMode("1");
        }
        if (null == (umUserinfoReDomainBean = this.userServiceRepository.getUserinfoByCode(cpRechargeDomain.getUserinfoCode(), this.getTenantCode(request)))) {
            this.logger.error(CODE + ".blessingPointRecharge", (Object)"umUserinfoReDomainBean is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "umUserinfoReDomainBean");
        }
        cpRechargeDomain.setUserinfoName(umUserinfoReDomainBean.getUserinfoCompname());
        cpRechargeDomain.setFchannelPmodeCode(this.getOauthEnvCode(request));
        cpRechargeDomain.setTenantCode(this.getTenantCode(request));
        CpRechargeDomain cpRechargeDomainNew = new CpRechargeDomain();
        if (StringUtils.isNotBlank((String)cpRechargeDomain.getFchannelCode())) {
            Map<String, PtePtfchannelReDomain> channelMap = this.queryChannel(this.getOauthEnvCode(request), this.getTenantCode(request), "IN");
            if (null == channelMap || channelMap.isEmpty()) {
                return null;
            }
            PtePtfchannelReDomain ptePtfchannelReDomain = channelMap.get(cpRechargeDomain.getFchannelCode());
            if (null == ptePtfchannelReDomain) {
                return new HtmlJsonReBean(CODE + ".blessingPointRecharge.ptePtfchannelReDomain", "\u6570\u636e\u4e3a\u7a7a");
            }
            try {
                BeanUtils.copyAllPropertys((Object)cpRechargeDomainNew, (Object)ptePtfchannelReDomain);
                BeanUtils.copyAllPropertys((Object)cpRechargeDomainNew, (Object)cpRechargeDomain);
                cpRechargeDomain.setFchannelClassifyCode(ptePtfchannelReDomain.getFchannelType());
            }
            catch (Exception e) {
                this.logger.error(CODE + ".blessingPointRecharge.e", (Throwable)e);
                return new HtmlJsonReBean(CODE + ".blessingPointRecharge.e", "\u6570\u636e\u4e3a\u7a7a");
            }
        }
        if (StringUtils.isBlank((String)cpRechargeDomainNew.getUserbankName())) {
            cpRechargeDomainNew.setUserbankName("\u57fa\u672c\u6237");
        }
        return this.cpRechargeServiceRepository.saveRecharge(cpRechargeDomainNew);
    }

    @RequestMapping(value={"queryRechargePageForAtByMem.json"}, name="\u5145\u503c\u5206\u9875\u67e5\u8be2\u5f53\u524d\u767b\u9646\u8005")
    @ResponseBody
    public SupQueryResult<CpRechargeReDomain> queryRechargePageForAtByMem(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("userinfoCode", userSession.getUserPcode());
        return this.cpRechargeServiceRepository.queryRechargePage(param);
    }
}

