/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.cp.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.cp.Test.DmUtil;
import com.qjsoft.laser.controller.cp.Test.HttpClentUtil;
import com.qjsoft.laser.controller.facade.cp.domain.CpUserbankDomain;
import com.qjsoft.laser.controller.facade.cp.domain.CpUserbankReDomain;
import com.qjsoft.laser.controller.facade.cp.repository.CpUserbankServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/cp/userbank"}, name="\u7528\u6237\u94f6\u884c\u8d26\u6237")
public class UserbankCon
extends SpringmvcController {
    private static String CODE = "cp.userbank.con";
    @Autowired
    private CpUserbankServiceRepository cpUserbankServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;

    protected String getContext() {
        return "userbank";
    }

    @RequestMapping(value={"saveUserbank.json"}, name="\u589e\u52a0\u7528\u6237\u94f6\u884c\u8d26\u6237")
    @ResponseBody
    public HtmlJsonReBean saveUserbank(HttpServletRequest request, CpUserbankDomain cpUserbankDomain) {
        if (null == cpUserbankDomain) {
            this.logger.error(CODE + ".saveUserbank", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".getPayChannel.userSession", (Object)"userSession is null");
            return null;
        }
        if (StringUtils.isEmpty((String)cpUserbankDomain.getUserCode())) {
            cpUserbankDomain.setUserCode(userSession.getUserPcode());
        }
        if (StringUtils.isEmpty((String)cpUserbankDomain.getUserName())) {
            cpUserbankDomain.setUserName(userSession.getMerberCompname());
        }
        cpUserbankDomain.setTenantCode(this.getTenantCode(request));
        return this.cpUserbankServiceRepository.saveUserbank(cpUserbankDomain);
    }

    @RequestMapping(value={"getUserbank.json"}, name="\u83b7\u53d6\u7528\u6237\u94f6\u884c\u8d26\u6237\u4fe1\u606f")
    @ResponseBody
    public CpUserbankReDomain getUserbank(Integer userbankId) {
        if (StringUtils.isBlank((Integer)userbankId)) {
            this.logger.error(CODE + ".getUserbank", (Object)"param is null");
            return null;
        }
        return this.cpUserbankServiceRepository.getUserbank(userbankId);
    }

    @RequestMapping(value={"updateUserbank.json"}, name="\u66f4\u65b0\u7528\u6237\u94f6\u884c\u8d26\u6237")
    @ResponseBody
    public HtmlJsonReBean updateUserbank(HttpServletRequest request, CpUserbankDomain cpUserbankDomain) {
        if (null == cpUserbankDomain) {
            this.logger.error(CODE + ".updateUserbank", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        cpUserbankDomain.setTenantCode(this.getTenantCode(request));
        return this.cpUserbankServiceRepository.updateUserbank(cpUserbankDomain);
    }

    @RequestMapping(value={"deleteUserbank.json"}, name="\u5220\u9664\u7528\u6237\u94f6\u884c\u8d26\u6237")
    @ResponseBody
    public HtmlJsonReBean deleteUserbank(Integer userbankId) {
        if (StringUtils.isBlank((Integer)userbankId)) {
            this.logger.error(CODE + ".deleteUserbank", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cpUserbankServiceRepository.deleteUserbank(userbankId);
    }

    @RequestMapping(value={"queryUserbankPage.json"}, name="\u67e5\u8be2\u7528\u6237\u94f6\u884c\u8d26\u6237\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CpUserbankReDomain> queryUserbankPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.cpUserbankServiceRepository.queryUserbankPage(param);
    }

    @RequestMapping(value={"queryUserbankByUser.json"}, name="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u94f6\u884c\u8d26\u6237\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CpUserbankReDomain> queryUserbankByUser(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryUserbankByUser.userSession", (Object)"userSession is null");
            return null;
        }
        if (null != param) {
            param.put("order", true);
            param.put("userCode", userSession.getUserCode());
        }
        SupQueryResult qcpUserBank = this.cpUserbankServiceRepository.queryUserbankPage(param);
        String bigdataFlag = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(this.getTenantCode(request) + "-cpBankCard-autoinsert"));
        if (null == bigdataFlag) {
            bigdataFlag = "";
        }
        if ((null == qcpUserBank || null == qcpUserBank.getList() || qcpUserBank.getList().size() == 0) && "1".equals(bigdataFlag)) {
            CpUserbankReDomain cpUserbankDomain = new CpUserbankReDomain();
            cpUserbankDomain.setAppmanageIcode(this.getProappCode(request));
            cpUserbankDomain.setTenantCode(this.getTenantCode(request));
            cpUserbankDomain.setBankCode("flj");
            cpUserbankDomain.setUserbankNo(userSession.getUserPcode());
            cpUserbankDomain.setUserbankName(userSession.getMerberCompname());
            cpUserbankDomain.setUserbankType("0");
            cpUserbankDomain.setUserbankPhone(userSession.getUserPhone());
            cpUserbankDomain.setUserCode(userSession.getUserCode());
            cpUserbankDomain.setUserName(userSession.getMerberCompname());
            HtmlJsonReBean htmlJsonReBean = this.cpUserbankServiceRepository.saveUserbank((CpUserbankDomain)cpUserbankDomain);
            if (null == htmlJsonReBean || StringUtils.isBlank((String)((String)htmlJsonReBean.getDataObj()))) {
                return null;
            }
            cpUserbankDomain.setUserbankCode((String)htmlJsonReBean.getDataObj());
            qcpUserBank = new SupQueryResult();
            ArrayList<CpUserbankReDomain> list = new ArrayList<CpUserbankReDomain>();
            list.add(cpUserbankDomain);
            qcpUserBank.setList(list);
        }
        return qcpUserBank;
    }

    @RequestMapping(value={"updateUserbankState.json"}, name="\u66f4\u65b0\u7528\u6237\u94f6\u884c\u8d26\u6237\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateUserbankState(String userbankId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)userbankId)) {
            this.logger.error(CODE + ".updateUserbankState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cpUserbankServiceRepository.updateUserbankState(Integer.valueOf(userbankId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryDmUserbankState.json"}, name="\u67e5\u8be2\u4e1c\u76df\u94f6\u884c\u8d26\u6237")
    @ResponseBody
    public HtmlJsonReBean queryDmUserbankState(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        String url = DmUtil.getUrl(this.getTenantCode(request), "dmUrl", "url");
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryDmUserbankState.userSession", (Object)"userSession is null");
            return null;
        }
        if (StringUtils.isBlank((String)url) || MapUtil.isEmpty(map)) {
            this.logger.error(CODE + ".queryDmUserbankState.queryDmUserbankState.url", (Object)("url" + url + "map" + map));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "url\u4e0d\u5b58\u5728");
        }
        String token = "";
        map.put("partnerMemberId", userSession.getUserPcode());
        UmUserinfoReDomainBean userinfoReDomainBean = this.userServiceRepository.getUserinfoAndQuaByCode(userSession.getUserPcode(), this.getTenantCode(request));
        if (null != userinfoReDomainBean) {
            if (userinfoReDomainBean.getUserinfoQuality().equals("buy")) {
                map.put("origin", "buyer");
            } else {
                map.put("origin", "seller");
            }
        }
        this.logger.error(CODE + ".queryDmUserbankState.accessToken", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        token = this.getToken(map, url);
        this.logger.error(CODE + ".httpInvoke.token", (Object)JsonUtil.buildNormalBinder().toJson((Object)token));
        if (StringUtils.isBlank((String)token)) {
            this.logger.error(CODE + ".queryDmUserbankState.queryDmUserbankState", (Object)("url" + url + "map" + JsonUtil.buildNormalBinder().toJson(map)));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u4e0d\u5b58\u5728");
        }
        String urlStr = DmUtil.getUrl(this.getTenantCode(request), "zhurl", "zhurl");
        if (StringUtils.isBlank((String)urlStr)) {
            this.logger.error(CODE + ".queryDmUserbankState.queryDmUserbankState.urlStr", (Object)("urlStr" + urlStr));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "urlStr\u4e0d\u5b58\u5728");
        }
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("url", urlStr + token);
        return new HtmlJsonReBean(mapStr);
    }

    public String getToken(Map<String, Object> mapStr, String UrlStr) {
        Map data;
        Map jsonToMap;
        String url = null;
        String partnerMemberId = (String)mapStr.get("partnerMemberId");
        String origin = (String)mapStr.get("origin");
        String partnerName = (String)mapStr.get("partnerName");
        String phone = (String)mapStr.get("phone");
        if (StringUtils.isBlank((String)partnerMemberId) || StringUtils.isBlank((String)partnerName) || StringUtils.isBlank((String)phone)) {
            return null;
        }
        url = UrlStr + "/dmfreshpay/dmapi/logininfo";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("requestId", this.createUUIDString());
        map.put("partnerMemberId", partnerMemberId);
        map.put("partnerName", partnerName);
        map.put("phone", phone);
        map.put("origin", origin);
        String jsonStr = JsonUtil.buildNonEmptyBinder().toJson(map);
        String result = HttpClentUtil.httpPostByJson(url, jsonStr);
        String tokenStr = null;
        if (StringUtils.isNotBlank((String)result) && MapUtil.isNotEmpty((Map)(jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(result, String.class, Object.class))) && jsonToMap.get("code").toString().equals("200") && MapUtil.isNotEmpty((Map)(data = (Map)jsonToMap.get("data")))) {
            tokenStr = (String)data.get("token");
        }
        return tokenStr;
    }

    public static String getAccessToken(String appid, String secret, String accessTokenStr) {
        String key = appid + "-" + secret;
        String accessToken = SupDisUtil.getRemot((String)key);
        if (StringUtils.isNotBlank((String)accessTokenStr)) {
            SupDisUtil.set((String)key, (String)accessTokenStr, (int)36000);
            accessToken = accessTokenStr;
        }
        return accessToken;
    }

    public static void main(String[] args) {
        String url = "http://117.71.55.33:9090/manage";
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("partnerMemberId", "TEST_2105181720");
        mapStr.put("phone", "15715601115");
        mapStr.put("partnerName", "\u8d75\u519b\u8f89");
        String jsonStr = JsonUtil.buildNonEmptyBinder().toJson(mapStr);
        String result = HttpClentUtil.httpPostByJson(url, jsonStr);
        System.out.println(result);
    }
}

