/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.crms.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.crms.controller.CrmsConstants;
import com.qjsoft.laser.controller.facade.crms.domain.CrmsSOrderDomain;
import com.qjsoft.laser.controller.facade.crms.domain.CrmsSOrderGoodsReDomain;
import com.qjsoft.laser.controller.facade.crms.domain.CrmsSOrderReDomain;
import com.qjsoft.laser.controller.facade.crms.domain.CrmsURechargeReDomain;
import com.qjsoft.laser.controller.facade.crms.domain.OcContractGoodsDomain;
import com.qjsoft.laser.controller.facade.crms.domain.PackageDomain;
import com.qjsoft.laser.controller.facade.crms.repository.CrmsSOrderGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.crms.repository.CrmsSOrderServiceRepository;
import com.qjsoft.laser.controller.facade.crms.repository.CrmsURechargeServiceRepository;
import com.qjsoft.laser.controller.facade.ct.domain.CtCustrelEmpReDomain;
import com.qjsoft.laser.controller.facade.ct.domain.CtCustrelReDomain;
import com.qjsoft.laser.controller.facade.ct.repository.CtCustrelServiceRepository;
import com.qjsoft.laser.controller.facade.dd.domain.DdFalgSettingReDomain;
import com.qjsoft.laser.controller.facade.dd.repository.DdFalgSettingServiceRepository;
import com.qjsoft.laser.controller.facade.org.domain.OrgEmployeeReDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgUserBean;
import com.qjsoft.laser.controller.facade.org.repository.OrgCompanyServiceRepository;
import com.qjsoft.laser.controller.facade.org.repository.OrgEmployeeServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmAddressReDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoQuaReDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UmAddressServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UmUserinfoQuaServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.json.JSONArray;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/crms/sorder"}, name="\u670d\u52a1\u5355")
public class SOrderCon
extends SpringmvcController {
    private static String CODE = "crms.sorder.con";
    @Autowired
    private CrmsSOrderServiceRepository crmsSOrderServiceRepository;
    @Autowired
    private OrgCompanyServiceRepository orgCompanyServiceRepository;
    @Autowired
    private CtCustrelServiceRepository ctCustrelServiceRepository;
    @Autowired
    private CrmsSOrderGoodsServiceRepository crmsSOrderGoodsServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private DdFalgSettingServiceRepository ddFalgSettingServiceRepository;
    @Autowired
    private OrgEmployeeServiceRepository orgEmployeeServiceRepository;
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private UmUserinfoQuaServiceRepository umUserinfoQuaServiceRepository;
    @Autowired
    private CrmsURechargeServiceRepository crmsURechargeServiceRepository;
    @Autowired
    private UmAddressServiceRepository umAddressServiceRepository;

    protected String getContext() {
        return "sorder";
    }

    @RequestMapping(value={"saveSOrder.json"}, name="\u589e\u52a0\u670d\u52a1\u5355")
    @ResponseBody
    public HtmlJsonReBean saveSOrder(HttpServletRequest request, String orderDomainStr, String memberBcode) {
        if (StringUtils.isBlank((String)memberBcode) || StringUtils.isBlank((String)orderDomainStr)) {
            this.logger.error(CODE + ".saveSOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.createOrder(request, orderDomainStr, "00", memberBcode, "1");
    }

    protected HtmlJsonReBean createOrder(HttpServletRequest request, String orderDomainStr, String contractType, String memberBcode, String contractProperty) {
        if (StringUtils.isBlank((String)orderDomainStr)) {
            this.logger.error(CODE + ".createOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List orderDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(orderDomainStr, CrmsSOrderDomain.class);
        this.logger.error(CODE + ".createOrder:orderDomainList", (Object)JsonUtil.buildNormalBinder().jsonObject(orderDomainList));
        if (null == orderDomainList || orderDomainList.isEmpty()) {
            this.logger.error(CODE + ".createOrder", (Object)"orderDomainStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".createOrder", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OrgUserBean orgUserBean = null;
        orgUserBean = StringUtils.isNotBlank((String)memberBcode) ? this.getOrgUserBean(memberBcode, userSession, this.getCompanyCode(request), userSession.getTenantCode()) : this.getOrgUserBean(userSession.getUserPcode(), userSession, null, userSession.getTenantCode());
        if (StringUtils.isNotBlank((String)((CrmsSOrderDomain)orderDomainList.get(0)).getEmployeeCode())) {
            orgUserBean.setEmployeeCode(((CrmsSOrderDomain)orderDomainList.get(0)).getEmployeeCode());
            orgUserBean.setEmployeeName(((CrmsSOrderDomain)orderDomainList.get(0)).getEmployeeName());
        }
        if (StringUtils.isNotBlank((String)((CrmsSOrderDomain)orderDomainList.get(0)).getDepartCode())) {
            orgUserBean.setDepartCode(((CrmsSOrderDomain)orderDomainList.get(0)).getDepartCode());
            orgUserBean.setDepartShortname(((CrmsSOrderDomain)orderDomainList.get(0)).getDepartShortname());
        }
        if (StringUtils.isNotBlank((String)((CrmsSOrderDomain)orderDomainList.get(0)).getCompanyCode())) {
            orgUserBean.setCompanyCode(((CrmsSOrderDomain)orderDomainList.get(0)).getCompanyCode());
            orgUserBean.setCompanyShortname(((CrmsSOrderDomain)orderDomainList.get(0)).getCompanyShortname());
        }
        this.makeChannel(orderDomainList, request);
        return this.crmsSOrderServiceRepository.createOrder(orderDomainList, contractType, userSession, this.getProappCode(request), this.getOauthEnvCode(request), orgUserBean, contractProperty);
    }

    private boolean matcherNumber(String number) {
        boolean flag;
        try {
            Integer.valueOf(number);
            flag = true;
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    private boolean checkDate(String dateStr) {
        boolean flag;
        try {
            new Date(dateStr);
            flag = true;
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    private Map<String, Object> checkParams(JSONArray goodsArray) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<JSONObject> errorList = new ArrayList<JSONObject>();
        ArrayList<JSONObject> successList = new ArrayList<JSONObject>();
        ArrayList<String> exceptionBillCode = new ArrayList<String>();
        for (JSONObject jsonObject : goodsArray) {
            StringBuilder sb = new StringBuilder();
            if (jsonObject.getString("contractBillcode") == null) {
                sb.append("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (jsonObject.getString("skuNo") == null) {
                sb.append("\u4e0b\u5355BOM\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (jsonObject.getString("memberBname") == null) {
                sb.append("\u5546\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (jsonObject.getString("goodsProperty2") == null) {
                sb.append("\u5546\u54c1\u5236\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (jsonObject.getString("goodsProperty3") == null) {
                sb.append("\u5546\u54c1\u80fd\u8017\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (jsonObject.getString("goodsSupplierName") == null) {
                sb.append("\u5408\u540c\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (jsonObject.getString("fchannelCode") == null) {
                sb.append("\u501f\u8d27\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (jsonObject.getString("faccountName") == null) {
                sb.append("\u53d1\u8d27\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (jsonObject.getString("warehouseName") == null) {
                sb.append("\u4ed3\u5e93\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (jsonObject.getString("contractInvstate") == null) {
                sb.append("\u6838\u9500\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!");
            } else {
                String contractInvstate;
                switch (contractInvstate = jsonObject.getString("contractInvstate")) {
                    case "\u8f6c\u9500\u552e": {
                        jsonObject.put("contractInvstate", (Object)CrmsConstants.SettleType.SETTLE_TYPE_SALE.getValue());
                        break;
                    }
                    case "\u8f6c\u9000\u8d27": {
                        jsonObject.put("contractInvstate", (Object)CrmsConstants.SettleType.SETTLE_TYPE_RETURN.getValue());
                        break;
                    }
                    default: {
                        sb.append("\u6838\u9500\u65b9\u5f0f:\u53ea\u80fd\u9009\u62e9 [\u8f6c\u9500\u552e,\u8f6c\u9000\u8d27]!");
                    }
                }
            }
            if (jsonObject.getString("contractPumode") == null) {
                sb.append("\u53d1\u8d27\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!");
            } else {
                String contractPumode;
                switch (contractPumode = jsonObject.getString("contractPumode")) {
                    case "\u6d77\u8fd0": {
                        jsonObject.put("contractPumode", (Object)CrmsConstants.LogisticsType.SEND_TYPE_SEA.getValue());
                        break;
                    }
                    case "\u7a7a\u8fd0": {
                        jsonObject.put("contractPumode", (Object)CrmsConstants.LogisticsType.SEND_TYPE_SKY.getValue());
                        break;
                    }
                    case "\u9646\u8fd0": {
                        jsonObject.put("contractPumode", (Object)CrmsConstants.LogisticsType.SEND_TYPE_LAND.getValue());
                        break;
                    }
                    case "\u81ea\u53d6": {
                        jsonObject.put("contractPumode", (Object)CrmsConstants.LogisticsType.SEND_TYPE_SELF.getValue());
                        break;
                    }
                    case "\u5feb\u9012": {
                        jsonObject.put("contractPumode", (Object)CrmsConstants.LogisticsType.SEND_TYPE_EXPRESS.getValue());
                        break;
                    }
                    default: {
                        sb.append("\u53d1\u8d27\u65b9\u5f0f:\u53ea\u80fd\u9009\u62e9 [\u6d77\u8fd0,\u7a7a\u8fd0,\u9646\u8fd0,\u81ea\u53d6,\u5feb\u9012]!");
                    }
                }
            }
            if (jsonObject.getString("contractAppraise") == null) {
                sb.append("\u662f\u5426\u6258\u76d8\u4e0d\u80fd\u4e3a\u7a7a!");
            } else {
                String contractAppraise;
                switch (contractAppraise = jsonObject.getString("contractAppraise")) {
                    case "\u662f": {
                        jsonObject.put("contractAppraise", (Object)CrmsConstants.FlagStock.STOCK_TRUE.getValue());
                        break;
                    }
                    case "\u5426": {
                        jsonObject.put("contractAppraise", (Object)CrmsConstants.FlagStock.STOCK_FALSE.getValue());
                        break;
                    }
                    default: {
                        sb.append("\u662f\u5426\u6258\u76d8:\u53ea\u80fd\u9009\u62e9 [\u662f,\u5426]!");
                    }
                }
            }
            if (jsonObject.getString("gmtCreate") == null) {
                sb.append("\u4e0b\u5355\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!");
            } else if (!this.checkDate(jsonObject.getString("gmtCreate"))) {
                sb.append("\u4e0b\u5355\u65e5\u671f\u683c\u5f0f\u4e0d\u5bf9!");
            }
            if (jsonObject.getString("contractPaydate") == null) {
                sb.append("\u8981\u8d27\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!");
            } else if (!this.checkDate(jsonObject.getString("contractPaydate"))) {
                sb.append("\u8981\u8d27\u65e5\u671f\u683c\u5f0f\u4e0d\u5bf9!");
            }
            if (jsonObject.getString("contractValidate") == null) {
                sb.append("\u9884\u8ba1\u6838\u9500\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!");
            } else if (!this.checkDate(jsonObject.getString("contractValidate"))) {
                sb.append("\u9884\u8ba1\u6838\u9500\u65f6\u95f4\u683c\u5f0f\u4e0d\u5bf9!");
            }
            if (jsonObject.getString("goodsCamount") == null) {
                sb.append("\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a!");
            } else {
                String goodsCamount = jsonObject.getString("goodsCamount");
                if (!this.matcherNumber(goodsCamount)) {
                    sb.append("\u5546\u54c1\u6570\u91cf\u53ea\u80fd\u662f\u6b63\u6574\u6570!");
                } else if (Integer.valueOf(goodsCamount) < 0) {
                    sb.append("\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0!");
                }
            }
            if (jsonObject.getString("goodsSpec1") == null) {
                sb.append("\u5546\u54c1\u7ef4\u4fdd\u5e74\u9650\u4e0d\u80fd\u4e3a\u7a7a!");
            } else {
                String goodsSpec1 = jsonObject.getString("goodsSpec1");
                if (!this.matcherNumber(goodsSpec1)) {
                    sb.append("\u5546\u54c1\u7ef4\u4fdd\u5e74\u9650\u53ea\u80fd\u662f\u6b63\u6574\u6570!");
                } else {
                    if (Integer.valueOf(goodsSpec1) > 5) {
                        sb.append("\u5546\u54c1\u7ef4\u4fdd\u5e74\u9650\u4e0d\u80fd\u5927\u4e8e5\u5e74!");
                    }
                    if (Integer.valueOf(goodsSpec1) < 0) {
                        sb.append("\u5546\u54c1\u7ef4\u4fdd\u5e74\u9650\u4e0d\u80fd\u5c0f\u4e8e0!");
                    }
                }
            }
            if (sb.toString().length() > 0) {
                exceptionBillCode.add(jsonObject.getString(jsonObject.getString("contractBillcode")));
                jsonObject.put("errorMsg", (Object)sb.toString());
                errorList.add(jsonObject);
                continue;
            }
            if (exceptionBillCode.contains(jsonObject.getString("contractBillcode"))) continue;
            successList.add(jsonObject);
        }
        result.put("errorList", errorList);
        result.put("successList", successList);
        return result;
    }

    private void checkContractBillCode(Map<String, Object> map) {
        ArrayList<JSONObject> successListNew = new ArrayList<JSONObject>();
        ArrayList<String> contractBillCodeList = new ArrayList<String>();
        ArrayList<String> contractBillCodeHaveList = new ArrayList<String>();
        StringBuilder contractBillCodeStr = new StringBuilder();
        List successList = (List)map.get("successList");
        List errorList = (List)map.get("errorList");
        if (successList.isEmpty()) {
            return;
        }
        for (JSONObject jsonObject : successList) {
            String contractBillCode = jsonObject.getString("contractBillcode");
            if (contractBillCodeList.contains(contractBillCode)) continue;
            contractBillCodeList.add(contractBillCode);
            contractBillCodeStr.append(contractBillCode).append(",");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("contractBillcode", contractBillCodeStr);
        params.put("tenantCode", map.get("tenantCode"));
        SupQueryResult queryResult = this.crmsSOrderServiceRepository.querySOrderPage(params);
        for (CrmsSOrderReDomain crmsSOrderReDomain : queryResult.getList()) {
            if (!contractBillCodeList.contains(crmsSOrderReDomain.getContractBillcode()) || contractBillCodeHaveList.contains(crmsSOrderReDomain.getContractBillcode())) continue;
            contractBillCodeHaveList.add(crmsSOrderReDomain.getContractBillcode());
        }
        for (JSONObject jsonObject : successList) {
            String contractBillCode = jsonObject.getString("contractBillcode");
            if (contractBillCodeHaveList.contains(contractBillCode)) {
                jsonObject.put("errorMsg", (Object)"\u6b64\u501f\u8d27\u5355\u5df2\u5bfc\u5165!");
                errorList.add(jsonObject);
                continue;
            }
            successListNew.add(jsonObject);
        }
        map.put("errorList", errorList);
        map.put("successList", successListNew);
    }

    private SupQueryResult<CtCustrelReDomain> queryExportCustomer(List<JSONObject> successList, String tenantCode) {
        ArrayList<String> customerNameList = new ArrayList<String>();
        StringBuilder customerNameStr = new StringBuilder();
        if (successList.isEmpty()) {
            return null;
        }
        for (JSONObject jsonObject : successList) {
            String memberBname = jsonObject.getString("memberBname");
            if (customerNameList.contains(memberBname)) continue;
            customerNameList.add(memberBname);
            customerNameStr.append(memberBname).append(",");
        }
        HashMap<String, CharSequence> params = new HashMap<String, CharSequence>();
        params.put("custrelName", customerNameStr);
        params.put("tenantCode", tenantCode);
        this.logger.error(CODE + ".queryExportCustomer params{params}=====", (Object)JsonUtil.buildNormalBinder().toJson(params));
        return this.ctCustrelServiceRepository.queryCustrelPage(params);
    }

    private void checkCustomer(Map<String, Object> map) {
        this.logger.error(CODE + ".checkCustomer params{\u6821\u9a8c\u5ba2\u6237\u5f00\u59cb}=====");
        this.logger.error(CODE + ".checkCustomer params{map}=====", (Object)JsonUtil.buildNormalBinder().toJson(map));
        ArrayList<JSONObject> successListNew = new ArrayList<JSONObject>();
        ArrayList<String> customerNameList = new ArrayList<String>();
        ArrayList<String> customerNameHaveList = new ArrayList<String>();
        ArrayList<String> customerNameMoreList = new ArrayList<String>();
        ArrayList<String> exceptionBillCode = new ArrayList<String>();
        List successList = (List)map.get("successList");
        List errorList = (List)map.get("errorList");
        if (successList.isEmpty()) {
            return;
        }
        for (JSONObject jsonObject : successList) {
            String memberBname = jsonObject.getString("memberBname");
            if (customerNameList.contains(memberBname)) continue;
            customerNameList.add(memberBname);
        }
        SupQueryResult<CtCustrelReDomain> queryResult = this.queryExportCustomer(successList, map.get("tenantCode").toString());
        this.logger.error(CODE + ".checkCustomer params{size}=====", (Object)queryResult.getList().size());
        if (queryResult == null || queryResult.getList().isEmpty()) {
            for (JSONObject jsonObject : successList) {
                exceptionBillCode.add(jsonObject.getString("contractBillcode"));
                jsonObject.put("errorMsg", (Object)"\u67e5\u4e0d\u5230\u6b64\u5ba2\u6237!");
                errorList.add(jsonObject);
            }
        } else {
            for (CtCustrelReDomain ctCustrelReDomain : queryResult.getList()) {
                if (customerNameList.contains(ctCustrelReDomain.getCustrelName())) {
                    if (!customerNameHaveList.contains(ctCustrelReDomain.getCustrelName())) {
                        customerNameHaveList.add(ctCustrelReDomain.getCustrelName());
                    } else {
                        customerNameMoreList.add(ctCustrelReDomain.getCustrelName());
                    }
                }
                for (JSONObject jsonObject : successList) {
                    if (!jsonObject.getString("memberBname").equals(ctCustrelReDomain.getCustrelName())) continue;
                    jsonObject.put("memberBcode", (Object)ctCustrelReDomain.getUserinfoCode());
                }
            }
            for (JSONObject jsonObject : successList) {
                String memberBname = jsonObject.getString("memberBname");
                if (!customerNameHaveList.contains(memberBname)) {
                    exceptionBillCode.add(jsonObject.getString("contractBillcode"));
                    jsonObject.put("errorMsg", (Object)"\u67e5\u4e0d\u5230\u6b64\u5ba2\u6237!");
                    errorList.add(jsonObject);
                    continue;
                }
                if (customerNameMoreList.contains(memberBname)) {
                    exceptionBillCode.add(jsonObject.getString("contractBillcode"));
                    jsonObject.put("errorMsg", (Object)"\u5ba2\u6237\u540d\u79f0\u67e5\u51fa\u591a\u4e2a\u5ba2\u6237!");
                    errorList.add(jsonObject);
                    continue;
                }
                if (exceptionBillCode.contains(jsonObject.getString("contractBillcode"))) continue;
                successListNew.add(jsonObject);
            }
        }
        map.put("errorList", errorList);
        map.put("successList", successListNew);
    }

    private void checkCustomerAudit(Map<String, Object> map, UserSession userSession) {
        this.logger.error(CODE + ".checkCustomerAudit params{\u6821\u9a8c\u5ba2\u6237\u6743\u9650\u5f00\u59cb}=====");
        this.logger.error(CODE + ".checkCustomerAudit params{map}=====", (Object)JsonUtil.buildNormalBinder().toJson(map));
        ArrayList<JSONObject> successListNew = new ArrayList<JSONObject>();
        ArrayList<String> customerNameList = new ArrayList<String>();
        ArrayList<String> customerNameHaveList = new ArrayList<String>();
        StringBuilder customerNameStr = new StringBuilder();
        ArrayList<String> exceptionBillCode = new ArrayList<String>();
        List successList = (List)map.get("successList");
        List errorList = (List)map.get("errorList");
        if (successList.isEmpty()) {
            return;
        }
        for (JSONObject jsonObject : successList) {
            String memberBname = jsonObject.getString("memberBname");
            if (customerNameList.contains(memberBname)) continue;
            customerNameList.add(memberBname);
            customerNameStr.append(memberBname).append(",");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("custrelName", customerNameStr);
        params.put("userCode", userSession.getUserCode());
        params.put("tenantCode", map.get("tenantCode"));
        this.logger.error(CODE + ".checkCustomerAudit params{params}=====", (Object)JsonUtil.buildNormalBinder().toJson(params));
        SupQueryResult queryResult = this.ctCustrelServiceRepository.queryCustrelPage(params);
        this.logger.error(CODE + ".checkCustomerAudit params{size}=====", (Object)queryResult.getList().size());
        if (queryResult == null || queryResult.getList().isEmpty()) {
            for (JSONObject jsonObject : successList) {
                exceptionBillCode.add(jsonObject.getString("contractBillcode"));
                jsonObject.put("errorMsg", (Object)"\u65e0\u6b64\u5ba2\u6237\u6743\u9650!");
                errorList.add(jsonObject);
            }
        } else {
            for (CtCustrelReDomain ctCustrelReDomain : queryResult.getList()) {
                if (!customerNameList.contains(ctCustrelReDomain.getCustrelName()) || customerNameHaveList.contains(ctCustrelReDomain.getCustrelName())) continue;
                customerNameHaveList.add(ctCustrelReDomain.getCustrelName());
            }
            for (JSONObject jsonObject : successList) {
                String memberBname = jsonObject.getString("memberBname");
                if (!customerNameHaveList.contains(memberBname)) {
                    exceptionBillCode.add(jsonObject.getString("contractBillcode"));
                    jsonObject.put("errorMsg", (Object)"\u65e0\u6b64\u5ba2\u6237\u6743\u9650!");
                    errorList.add(jsonObject);
                    continue;
                }
                if (exceptionBillCode.contains(jsonObject.getString("contractBillcode"))) continue;
                successListNew.add(jsonObject);
            }
        }
        map.put("errorList", errorList);
        map.put("successList", successListNew);
    }

    private void checkGoods(Map<String, Object> map) {
        this.logger.error(CODE + ".checkGoods params{\u6821\u9a8c\u5546\u54c1\u5f00\u59cb}=====");
        this.logger.error(CODE + ".checkGoods params{map}=====", (Object)JsonUtil.buildNormalBinder().toJson(map));
        ArrayList<JSONObject> successListNew = new ArrayList<JSONObject>();
        ArrayList<String> skuNoList = new ArrayList<String>();
        ArrayList<String> skuNoHaveList = new ArrayList<String>();
        StringBuilder skuNoStr = new StringBuilder();
        ArrayList<String> exceptionBillCode = new ArrayList<String>();
        List successList = (List)map.get("successList");
        List errorList = (List)map.get("errorList");
        if (successList.isEmpty()) {
            return;
        }
        for (JSONObject jsonObject : successList) {
            String skuNo = jsonObject.getString("skuNo");
            if (skuNoList.contains(skuNo)) continue;
            skuNoList.add(skuNo);
            skuNoStr.append(skuNo).append(",");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("skuNo", skuNoStr);
        params.put("tenantCode", map.get("tenantCode"));
        this.logger.error(CODE + ".checkGoods params{params}=====", params);
        SupQueryResult queryResult = this.rsSkuServiceRepository.querySkuOnePage(params);
        this.logger.error(CODE + ".checkGoods params{size}=====", (Object)queryResult.getList().size());
        if (queryResult == null || queryResult.getList().isEmpty()) {
            for (JSONObject jsonObject : successList) {
                exceptionBillCode.add(jsonObject.getString("contractBillcode"));
                jsonObject.put("errorMsg", (Object)"\u65e0\u6b64\u5546\u54c1!");
                errorList.add(jsonObject);
            }
        } else {
            for (RsSkuReDomain rsSkuReDomain : queryResult.getList()) {
                if (!skuNoList.contains(rsSkuReDomain.getSkuNo()) || skuNoHaveList.contains(rsSkuReDomain.getSkuNo())) continue;
                skuNoHaveList.add(rsSkuReDomain.getSkuNo());
            }
        }
        for (JSONObject jsonObject : successList) {
            String skuNo = jsonObject.getString("skuNo");
            if (!skuNoHaveList.contains(skuNo)) {
                exceptionBillCode.add(jsonObject.getString("contractBillcode"));
                jsonObject.put("errorMsg", (Object)"\u65e0\u6b64\u5546\u54c1!");
                errorList.add(jsonObject);
                continue;
            }
            if (exceptionBillCode.contains(jsonObject.getString("contractBillcode"))) continue;
            successListNew.add(jsonObject);
        }
        map.put("errorList", errorList);
        map.put("successList", successListNew);
    }

    private SupQueryResult<RsSkuReDomain> queryExportGoods(List<JSONObject> successList, String tenantCode) {
        if (successList.isEmpty()) {
            return null;
        }
        ArrayList<String> skuNoList = new ArrayList<String>();
        StringBuilder skuNoStr = new StringBuilder();
        StringBuilder customerNameStr = new StringBuilder();
        StringBuilder customerCodeStr = new StringBuilder();
        for (JSONObject jsonObject : successList) {
            String skuNo = jsonObject.getString("skuNo");
            String memberBname = jsonObject.getString("memberBname");
            if (skuNoList.contains(skuNo)) continue;
            skuNoList.add(skuNo);
            skuNoStr.append(skuNo).append(",");
            customerNameStr.append(memberBname).append(",");
            customerCodeStr.append(jsonObject.getString("memberBcode")).append(",");
        }
        HashMap<String, CharSequence> params = new HashMap<String, CharSequence>();
        params.put("skuNo", skuNoStr);
        params.put("memberBcode", customerCodeStr);
        params.put("tenantCode", tenantCode);
        this.logger.error(CODE + ".queryExportGoods params{params}=====", params);
        return this.rsSkuServiceRepository.querySkuPage(params);
    }

    private SupQueryResult<RsResourceGoodsReDomain> queryExportRsGoods(List<JSONObject> successList, String tenantCode) {
        if (successList.isEmpty()) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("goodsShowno", this.getListStrByKey(successList, "skuNo"));
        params.put("memberBcode", this.getListStrByKey(successList, "memberBcode"));
        params.put("tenantCode", tenantCode);
        this.logger.error(CODE + ".queryExportGoods params{params}=====", params);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(params);
    }

    private void checkGoodsAudit(Map<String, Object> map) {
        this.logger.error(CODE + ".checkGoodsAudit params{\u6821\u9a8c\u5546\u54c1\u6743\u9650\u5f00\u59cb}=====");
        this.logger.error(CODE + ".checkGoodsAudit params{map}=====", (Object)JsonUtil.buildNormalBinder().toJson(map));
        ArrayList<JSONObject> successListNew = new ArrayList<JSONObject>();
        ArrayList<String> exceptionBillCode = new ArrayList<String>();
        List successList = (List)map.get("successList");
        List errorList = (List)map.get("errorList");
        if (successList.isEmpty()) {
            return;
        }
        SupQueryResult<RsSkuReDomain> queryResult = this.queryExportGoods(successList, map.get("tenantCode").toString());
        this.logger.error(CODE + ".checkGoods params{size}=====", (Object)queryResult.getList().size());
        if (queryResult == null || queryResult.getList().isEmpty()) {
            for (JSONObject jsonObject : successList) {
                exceptionBillCode.add(jsonObject.getString("contractBillcode"));
                jsonObject.put("errorMsg", (Object)"\u65e0\u6b64\u5546\u54c1\u6216\u6ca1\u6709\u6743\u9650!");
                errorList.add(jsonObject);
            }
        } else {
            for (JSONObject jsonObject : successList) {
                String skuNo = jsonObject.getString("skuNo");
                String memberBname = jsonObject.getString("memberBname");
                BigDecimal goodsCamount = new BigDecimal(jsonObject.getString("goodsCamount"));
                String warehouseName = jsonObject.getString("warehouseName");
                StringBuilder sb = new StringBuilder();
                boolean flagUp = false;
                boolean flagApprove = false;
                boolean flagStore = false;
                for (RsSkuReDomain rsSkuReDomain : queryResult.getList()) {
                    if (!rsSkuReDomain.getSkuNo().equals(skuNo) || !rsSkuReDomain.getMemberBname().equals(memberBname)) continue;
                    if (rsSkuReDomain.getChannelTver() == 1) {
                        flagApprove = true;
                    }
                    if (rsSkuReDomain.getDataOpbillstate() == 1) {
                        flagUp = true;
                    }
                    if (!warehouseName.equals("\u676d\u5dde")) {
                        if (rsSkuReDomain.getGoodsSupplynum().compareTo(goodsCamount) >= 0) {
                            flagStore = true;
                        }
                    } else {
                        flagStore = true;
                    }
                    if (!flagApprove || !flagUp || !flagStore) continue;
                    jsonObject.put("pricesetNprice", (Object)rsSkuReDomain.getPricesetNprice());
                    break;
                }
                if (!flagUp) {
                    sb.append("\u5546\u54c1\u5df2\u4e0b\u67b6!");
                }
                if (!flagApprove) {
                    sb.append("\u5546\u54c1\u672a\u7279\u4ef7\u5ba1\u6279!");
                }
                if (!flagStore) {
                    sb.append("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3!");
                }
                if (sb.toString().length() > 0) {
                    exceptionBillCode.add(jsonObject.getString("contractBillcode"));
                    jsonObject.put("errorMsg", (Object)sb.toString());
                    errorList.add(jsonObject);
                    continue;
                }
                if (exceptionBillCode.contains(jsonObject.getString("contractBillcode"))) continue;
                successListNew.add(jsonObject);
            }
        }
        map.put("errorList", errorList);
        map.put("successList", successListNew);
    }

    private String getListStrByKey(List<JSONObject> successList, String key) {
        StringBuilder strTemp = new StringBuilder();
        for (JSONObject jsonObject : successList) {
            strTemp.append(jsonObject.getString(key)).append(",");
        }
        return strTemp.substring(0, strTemp.length() - 1);
    }

    private void checkBanShiChu(Map<String, Object> map) {
        this.logger.error(CODE + ".checkBanShiChu params{\u6821\u9a8c\u529e\u4e8b\u5904\u5f00\u59cb}=====");
        this.logger.error(CODE + ".checkBanShiChu params{map}=====", (Object)JsonUtil.buildNormalBinder().toJson(map));
        ArrayList<JSONObject> successListNew = new ArrayList<JSONObject>();
        StringBuilder departCodeStr = new StringBuilder();
        HashMap<String, String> memberDepart = new HashMap<String, String>();
        ArrayList memberDepartChargeHaveList = new ArrayList();
        ArrayList<String> exceptionBillCode = new ArrayList<String>();
        List successList = (List)map.get("successList");
        List errorList = (List)map.get("errorList");
        if (successList.isEmpty()) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userinfoQuaKey", "depName");
        params.put("tenantCode", map.get("tenantCode"));
        params.put("userinfoCode", this.getListStrByKey(successList, "memberBcode"));
        this.logger.error(CODE + ".checkBanShiChu params{params}=====", params);
        SupQueryResult queryResult = this.umUserinfoQuaServiceRepository.queryUserinfoQuaPage(params);
        this.logger.error(CODE + ".checkBanShiChu params{size}=====", (Object)queryResult.getList().size());
        if (queryResult == null || queryResult.getList().isEmpty()) {
            for (JSONObject jsonObject : successList) {
                exceptionBillCode.add(jsonObject.getString("contractBillcode"));
                jsonObject.put("errorMsg", (Object)"\u5ba2\u6237\u672a\u67e5\u5230\u4e0a\u7ea7\u7ec4\u7ec7!");
                errorList.add(jsonObject);
            }
        } else {
            for (UmUserinfoQuaReDomain umUserinfoQuaReDomain : queryResult.getList()) {
                departCodeStr.append(umUserinfoQuaReDomain.getUserinfoQuaVaule1()).append(",");
                memberDepart.put(umUserinfoQuaReDomain.getUserinfoQuaVaule1(), umUserinfoQuaReDomain.getUserinfoCompname());
            }
            HashMap<String, Object> paramsCharge = new HashMap<String, Object>();
            paramsCharge.put("userInfoCode", departCodeStr);
            paramsCharge.put("tenantCode", map.get("tenantCode"));
            this.logger.error(CODE + ".checkBanShiChu params{paramsCharge}=====", paramsCharge);
            SupQueryResult departChargeResult = this.crmsURechargeServiceRepository.queryURechargePage(paramsCharge);
            this.logger.error(CODE + ".checkBanShiChu params{size2}=====", (Object)departChargeResult.getList().size());
            if (departChargeResult == null || departChargeResult.getList().isEmpty()) {
                for (JSONObject jsonObject : successList) {
                    exceptionBillCode.add(jsonObject.getString("contractBillcode"));
                    jsonObject.put("errorMsg", (Object)"\u5ba2\u6237\u6240\u5c5e\u529e\u4e8b\u5904\u672a\u521b\u5efa!");
                    errorList.add(jsonObject);
                }
            } else {
                for (CrmsURechargeReDomain crmsURechargeReDomain : departChargeResult.getList()) {
                    if (!memberDepart.containsKey(crmsURechargeReDomain.getUserinfoCode())) continue;
                    memberDepartChargeHaveList.add(memberDepart.get(crmsURechargeReDomain.getUserinfoCode()));
                }
            }
            for (JSONObject jsonObject : successList) {
                String memberBname = jsonObject.getString("memberBname");
                if (!memberDepartChargeHaveList.contains(memberBname)) {
                    exceptionBillCode.add(jsonObject.getString("contractBillcode"));
                    jsonObject.put("errorMsg", (Object)"\u5ba2\u6237\u6240\u5c5e\u529e\u4e8b\u5904\u672a\u521b\u5efa!");
                    errorList.add(jsonObject);
                    continue;
                }
                if (exceptionBillCode.contains(jsonObject.getString("contractBillcode"))) continue;
                successListNew.add(jsonObject);
            }
        }
        map.put("errorList", errorList);
        map.put("successList", successListNew);
    }

    private SupQueryResult<UmAddressReDomain> queryCustomerAddress(List<JSONObject> successList, String tenantCode) {
        if (successList.isEmpty()) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userCode", this.getListStrByKey(successList, "memberBcode"));
        params.put("tenantCode", tenantCode);
        this.logger.error(CODE + ".checkCustomerAddress params{params}=====", params);
        return this.umAddressServiceRepository.queryAddressPage(params);
    }

    private void checkCustomerAddress(Map<String, Object> map) {
        this.logger.error(CODE + ".checkCustomerAddress params{\u6821\u9a8c\u6536\u8d27\u5730\u5740\u5f00\u59cb}=====");
        this.logger.error(CODE + ".checkCustomerAddress params{map}=====", (Object)JsonUtil.buildNormalBinder().toJson(map));
        ArrayList<JSONObject> successListNew = new ArrayList<JSONObject>();
        ArrayList<String> exceptionBillCode = new ArrayList<String>();
        List successList = (List)map.get("successList");
        List errorList = (List)map.get("errorList");
        if (successList.isEmpty()) {
            return;
        }
        SupQueryResult<UmAddressReDomain> queryResult = this.queryCustomerAddress(successList, map.get("tenantCode").toString());
        this.logger.error(CODE + ".checkCustomerAddress params{size}=====", (Object)queryResult.getList().size());
        if (queryResult == null || queryResult.getList().isEmpty()) {
            for (JSONObject jsonObject : successList) {
                exceptionBillCode.add(jsonObject.getString("contractBillcode"));
                jsonObject.put("errorMsg", (Object)"\u5ba2\u6237\u6ca1\u6709\u8bbe\u7f6e\u6536\u8d27\u5730\u5740!");
                errorList.add(jsonObject);
            }
        } else {
            for (JSONObject jsonObject : successList) {
                String customerCode = jsonObject.getString("memberBcode");
                boolean flagAddress = false;
                for (UmAddressReDomain umAddressReDomain : queryResult.getList()) {
                    if (!customerCode.equals(umAddressReDomain.getUserCode())) continue;
                    flagAddress = true;
                    jsonObject.put("goodsReceiptArrdess", (Object)umAddressReDomain.getAddressDetail());
                    jsonObject.put("goodsReceiptPhone", (Object)umAddressReDomain.getAddressPhone());
                    jsonObject.put("goodsReceiptMem", (Object)umAddressReDomain.getAddressMember());
                    if (1 != Integer.valueOf(umAddressReDomain.getAddressDefault())) continue;
                    break;
                }
                if (!flagAddress) {
                    exceptionBillCode.add(jsonObject.getString("contractBillcode"));
                    jsonObject.put("errorMsg", (Object)"\u5ba2\u6237\u6ca1\u6709\u8bbe\u7f6e\u6536\u8d27\u5730\u5740!");
                    errorList.add(jsonObject);
                    continue;
                }
                if (exceptionBillCode.contains(jsonObject.getString("contractBillcode"))) continue;
                successListNew.add(jsonObject);
            }
        }
        map.put("errorList", errorList);
        map.put("successList", successListNew);
    }

    private Map<String, Object> checkSOrderParams(JSONArray goodsArray, UserSession userSession, String tenantCode) {
        this.logger.error(CODE + ".checkSOrderParams params{\u5bfc\u5165\u501f\u8d27\u5355\u6821\u9a8c\u53c2\u6570\u5f00\u59cb}=====");
        Map<Object, Object> result = new HashMap();
        result = this.checkParams(goodsArray);
        result.put("tenantCode", tenantCode);
        this.checkContractBillCode(result);
        this.checkCustomer(result);
        this.checkCustomerAudit(result, userSession);
        this.checkGoodsAudit(result);
        this.checkBanShiChu(result);
        this.checkCustomerAddress(result);
        this.logger.error(CODE + ".checkSOrderParams params{\u5bfc\u5165\u501f\u8d27\u5355\u6821\u9a8c\u53c2\u6570\u7ed3\u675f}=====");
        return result;
    }

    private List<CrmsSOrderDomain> buildSOrderDomain(List<JSONObject> successList, String tenantCode, UserSession userSession, String companyCode) {
        this.logger.error(CODE + ".buildSOrderDomain params{\u5bfc\u5165\u501f\u8d27\u5355\u5c01\u88c5\u53c2\u6570\u5f00\u59cb}=====");
        this.logger.error(CODE + ".buildSOrderDomain params{successList}=====", (Object)JsonUtil.buildNormalBinder().toJson(successList));
        ArrayList<String> contractBillCode = new ArrayList<String>();
        ArrayList<CrmsSOrderDomain> orderDomainList = new ArrayList<CrmsSOrderDomain>();
        ArrayList<OcContractGoodsDomain> ocContractGoodsDomainListTotal = new ArrayList<OcContractGoodsDomain>();
        SupQueryResult<RsSkuReDomain> goodsResult = this.queryExportGoods(successList, tenantCode);
        if (goodsResult == null || goodsResult.getList().isEmpty()) {
            return null;
        }
        SupQueryResult<RsResourceGoodsReDomain> spuGoodsResult = this.queryExportRsGoods(successList, tenantCode);
        if (spuGoodsResult == null || spuGoodsResult.getList().isEmpty()) {
            return null;
        }
        SupQueryResult<CtCustrelReDomain> customerResult = this.queryExportCustomer(successList, tenantCode);
        if (customerResult == null || customerResult.getList().isEmpty()) {
            return null;
        }
        for (JSONObject jsonObject : successList) {
            if (!contractBillCode.contains(jsonObject.getString("contractBillcode"))) {
                CrmsSOrderDomain crmsSOrderDomain = new CrmsSOrderDomain();
                contractBillCode.add(jsonObject.getString("contractBillcode"));
                CtCustrelReDomain ctCustrelDomain = null;
                for (CtCustrelReDomain ctCustrelReDomain : customerResult.getList()) {
                    if (!ctCustrelReDomain.getCustrelName().equals(jsonObject.getString("memberBname"))) continue;
                    ctCustrelDomain = ctCustrelReDomain;
                }
                if (ctCustrelDomain == null) {
                    this.logger.error(CODE + ".buildSOrderDomain", (Object)"ctCustrelDomain.null");
                    return null;
                }
                OrgUserBean orgUserBean = this.getOrgUserBeanRule(ctCustrelDomain.getUserinfoCode(), userSession, companyCode, tenantCode);
                if (orgUserBean != null) {
                    try {
                        BeanUtils.copyAllPropertys((Object)crmsSOrderDomain, (Object)orgUserBean);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                crmsSOrderDomain.setContractBillcode(jsonObject.getString("contractBillcode"));
                crmsSOrderDomain.setMemberBname(jsonObject.getString("memberBname"));
                crmsSOrderDomain.setGoodsSupplierName(jsonObject.getString("goodsSupplierName"));
                crmsSOrderDomain.setFchannelCode(jsonObject.getString("fchannelCode"));
                crmsSOrderDomain.setFaccountName(jsonObject.getString("faccountName"));
                crmsSOrderDomain.setContractPumode(jsonObject.getString("contractPumode"));
                crmsSOrderDomain.setContractInvstate(Integer.valueOf(jsonObject.getString("contractInvstate")));
                crmsSOrderDomain.setContractAppraise(Integer.valueOf(jsonObject.getString("contractAppraise")));
                crmsSOrderDomain.setContractPaydate(new Date(jsonObject.getString("contractPaydate")));
                crmsSOrderDomain.setContractValidate(new Date(jsonObject.getString("contractValidate")));
                crmsSOrderDomain.setContractEffectivedate(new Date(jsonObject.getString("gmtCreate")));
                crmsSOrderDomain.setGoodsReceiptMem(jsonObject.getString("goodsReceiptMem"));
                crmsSOrderDomain.setGoodsReceiptArrdess(jsonObject.getString("goodsReceiptArrdess"));
                crmsSOrderDomain.setGoodsReceiptPhone(jsonObject.getString("goodsReceiptPhone"));
                crmsSOrderDomain.setContractRemark(jsonObject.getString("contractRemark"));
                crmsSOrderDomain.setDdTypeCurrency("USD");
                orderDomainList.add(crmsSOrderDomain);
            }
            OcContractGoodsDomain contractGoodsDomain = new OcContractGoodsDomain();
            contractGoodsDomain.setContractBillcode(jsonObject.getString("contractBillcode"));
            contractGoodsDomain.setSkuNo(jsonObject.getString("skuNo"));
            for (RsSkuReDomain rsSkuReDomain : goodsResult.getList()) {
                if (!rsSkuReDomain.getSkuNo().equals(contractGoodsDomain.getSkuNo()) || !rsSkuReDomain.getMemberBcode().equals(jsonObject.getString("memberBcode"))) continue;
                try {
                    BeanUtils.copyAllPropertys((Object)contractGoodsDomain, (Object)rsSkuReDomain);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (RsResourceGoodsReDomain rsResourceGoodsReDomain : spuGoodsResult.getList()) {
                if (!rsResourceGoodsReDomain.getGoodsShowno().equals(contractGoodsDomain.getSkuNo()) || !rsResourceGoodsReDomain.getMemberBcode().equals(jsonObject.getString("memberBcode"))) continue;
                contractGoodsDomain.setGoodsSpec(rsResourceGoodsReDomain.getGoodsSpec());
                contractGoodsDomain.setGoodsProperty1(rsResourceGoodsReDomain.getGoodsProperty1());
            }
            contractGoodsDomain.setGoodsCamount(new BigDecimal(jsonObject.getString("goodsCamount")));
            contractGoodsDomain.setGoodsNum(new BigDecimal(jsonObject.getString("goodsCamount")));
            contractGoodsDomain.setGoodsSpec1(jsonObject.getString("goodsSpec1"));
            contractGoodsDomain.setGoodsProperty2(jsonObject.getString("goodsProperty2"));
            contractGoodsDomain.setGoodsProperty3(jsonObject.getString("goodsProperty3"));
            contractGoodsDomain.setGoodsProperty4(jsonObject.getString("goodsProperty4"));
            contractGoodsDomain.setGoodsProperty5(jsonObject.getString("goodsProperty5"));
            contractGoodsDomain.setWarehouseName(jsonObject.getString("warehouseName"));
            ocContractGoodsDomainListTotal.add(contractGoodsDomain);
        }
        for (CrmsSOrderDomain crmsSOrderDomain : orderDomainList) {
            ArrayList<PackageDomain> packageList = new ArrayList<PackageDomain>();
            PackageDomain packageDomain = new PackageDomain();
            ArrayList<OcContractGoodsDomain> ocContractGoodsList = new ArrayList<OcContractGoodsDomain>();
            for (OcContractGoodsDomain ocContractGoodsDomain : ocContractGoodsDomainListTotal) {
                if (!ocContractGoodsDomain.getContractBillcode().equals(crmsSOrderDomain.getContractBillcode())) continue;
                ocContractGoodsList.add(ocContractGoodsDomain);
            }
            packageDomain.setContractGoodsList(ocContractGoodsList);
            packageList.add(packageDomain);
            crmsSOrderDomain.setPackageList(packageList);
        }
        this.logger.error(CODE + ".buildSOrderDomain params{size}=====", (Object)orderDomainList.size());
        this.logger.error(CODE + ".buildSOrderDomain params{contractBillCode}=====", contractBillCode);
        this.logger.error(CODE + ".buildSOrderDomain params{\u5bfc\u5165\u501f\u8d27\u5355\u5c01\u88c5\u53c2\u6570\u7ed3\u675f}=====");
        return orderDomainList;
    }

    @RequestMapping(value={"exportSOrderByExcel.json"}, name="\u5bfc\u5165\u501f\u8d27\u5355")
    @ResponseBody
    public HtmlJsonReBean exportShoppingGoodsByExcel(HttpServletRequest request, String orderDomainStr) {
        this.logger.error(CODE + ".exportShoppingGoodsByExcel params{\u5bfc\u5165\u501f\u8d27\u5355\u5f00\u59cb}=====");
        if (StringUtils.isBlank((String)orderDomainStr) || StringUtils.isBlank((String)orderDomainStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u7f3a\u5931\uff01");
        }
        String tenantCode = this.getTenantCode(request);
        UserSession userSession = this.getUserSession(request);
        JSONArray goodsArray = JSONArray.json2array((String)orderDomainStr);
        String companyCode = this.getCompanyCode(request);
        Map<String, Object> result = this.checkSOrderParams(goodsArray, userSession, tenantCode);
        List successList = (List)result.get("successList");
        List errorList = (List)result.get("errorList");
        List<CrmsSOrderDomain> orderDomainList = this.buildSOrderDomain(successList, tenantCode, userSession, companyCode);
        if (null == userSession) {
            this.logger.error(CODE + ".createOrder", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        this.makeChannel(orderDomainList, request);
        if (ListUtil.isNotEmpty((Collection)errorList)) {
            HtmlJsonReBean htmlJsonReBean = this.crmsSOrderServiceRepository.exportOrder(orderDomainList, null, userSession, this.getProappCode(request));
            htmlJsonReBean.setDataObj((Object)errorList);
            htmlJsonReBean.setSysRecode("error");
            htmlJsonReBean.setMsg("\u501f\u8d27\u5355\u5bfc\u5165\u6570\u636e\u5f02\u5e38\uff01");
            return htmlJsonReBean;
        }
        return this.crmsSOrderServiceRepository.exportOrder(orderDomainList, null, userSession, this.getProappCode(request));
    }

    public OrgUserBean getOrgUserBean(String memberBcode, UserSession userSession, String companyCode, String tenantCode) {
        SupQueryResult qcust;
        if (null == userSession || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        OrgUserBean orgUserBean = null;
        String userCode = userSession.getUserCode();
        if (StringUtils.isNotBlank((String)companyCode)) {
            orgUserBean = this.orgCompanyServiceRepository.getEmpByUserCode(userCode, companyCode, tenantCode);
        }
        if (null == orgUserBean) {
            orgUserBean = new OrgUserBean();
        }
        orgUserBean.setMemberBcode(memberBcode);
        if (StringUtils.isNotBlank((String)memberBcode) && null != (qcust = this.ctCustrelServiceRepository.queryCustrelPage(this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{memberBcode, tenantCode}))) && ListUtil.isNotEmpty((Collection)qcust.getList())) {
            CtCustrelReDomain ctustrelReDomain = (CtCustrelReDomain)qcust.getList().get(0);
            orgUserBean.setCustrelCode(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelCode());
            orgUserBean.setMemberBname(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelName());
            orgUserBean.setCompanyCode(ctustrelReDomain.getCompanyCode());
            if (StringUtils.isBlank((String)orgUserBean.getEmployeeCode())) {
                orgUserBean.setEmployeeCode(ctustrelReDomain.getEmployeeCode());
                orgUserBean.setEmployeeName(ctustrelReDomain.getEmployeeName());
            }
            orgUserBean.setDepartCode(ctustrelReDomain.getDepartCode());
            orgUserBean.setDepartShortname(ctustrelReDomain.getDepartName());
            orgUserBean.setCompanyShortname(ctustrelReDomain.getCompanyShortname());
        }
        if (StringUtils.isNotBlank((String)userSession.getCompanyCode()) && !userSession.getCompanyCode().equals(orgUserBean.getCompanyCode())) {
            orgUserBean.setCompanyCode(userSession.getCompanyCode());
            orgUserBean.setCompanyShortname(userSession.getCompanyShortname());
        }
        return orgUserBean;
    }

    private void makeChannel(List<CrmsSOrderDomain> orderDomainList, HttpServletRequest request) {
        if (ListUtil.isEmpty(orderDomainList) || null == request) {
            return;
        }
        for (CrmsSOrderDomain orderDomain : orderDomainList) {
            orderDomain.setChannelCode(this.getNowChannel(request));
            orderDomain.setChannelName(this.getChannelName(orderDomain.getChannelCode(), request));
        }
    }

    @RequestMapping(value={"getSOrder.json"}, name="\u83b7\u53d6\u670d\u52a1\u5355\u4fe1\u606f")
    @ResponseBody
    public CrmsSOrderReDomain getSOrder(Integer sorderId) {
        if (StringUtils.isBlank((Integer)sorderId)) {
            this.logger.error(CODE + ".getSOrder", (Object)"param is null");
            return null;
        }
        return this.crmsSOrderServiceRepository.getSOrder(sorderId);
    }

    @RequestMapping(value={"updateSOrder.json"}, name="\u66f4\u65b0\u670d\u52a1\u5355")
    @ResponseBody
    public HtmlJsonReBean updateSOrder(HttpServletRequest request, String orderDomainStr) {
        if (StringUtils.isBlank((String)orderDomainStr)) {
            this.logger.error(CODE + ".updateSOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        CrmsSOrderDomain crmsSOrderDomain = (CrmsSOrderDomain)JsonUtil.buildNormalBinder().getJsonToObject(orderDomainStr, CrmsSOrderDomain.class);
        crmsSOrderDomain.setTenantCode(this.getTenantCode(request));
        return this.crmsSOrderServiceRepository.updateSOrder(crmsSOrderDomain);
    }

    @RequestMapping(value={"deleteSOrder.json"}, name="\u5220\u9664\u670d\u52a1\u5355")
    @ResponseBody
    public HtmlJsonReBean deleteSOrder(Integer sorderId) {
        if (StringUtils.isBlank((Integer)sorderId)) {
            this.logger.error(CODE + ".deleteSOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.crmsSOrderServiceRepository.deleteSOrder(sorderId);
    }

    @RequestMapping(value={"querySOrderPage.json"}, name="\u67e5\u8be2\u670d\u52a1\u5355\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CrmsSOrderReDomain> querySOrderPage(HttpServletRequest request) {
        List list;
        UserSession userSession;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if ("1200535".equals((userSession = this.getUserSession(request)).getRoleCode())) {
            param.remove("colName0");
            param.remove("colValue0");
        }
        if (ListUtil.isNotEmpty((Collection)(list = this.orgEmployeeServiceRepository.queryEmployeePage(this.getQueryMapParam("userCode,tenantCode", new Object[]{userSession.getUserCode(), userSession.getTenantCode()})).getList()))) {
            OrgEmployeeReDomain orgEmployeeReDomain = (OrgEmployeeReDomain)list.get(0);
            List ctlist = this.ctCustrelServiceRepository.queryCustrelEmpPage(this.getQueryMapParam("employeeCode,tenantCode", new Object[]{orgEmployeeReDomain.getEmployeeCode(), userSession.getTenantCode()})).getList();
            if (ListUtil.isNotEmpty((Collection)ctlist)) {
                StringBuilder builder = new StringBuilder();
                for (CtCustrelEmpReDomain ctCustrelEmpReDomain : ctlist) {
                    builder.append(ctCustrelEmpReDomain.getUserinfoCode() + ",");
                }
                if (param.get("colValue0") != null) {
                    builder.append(param.get("colValue0").toString()).append(",");
                }
                String userinfoCode = builder.substring(0, builder.length() - 1);
                param.remove("colValue0");
                param.remove("colName0");
                param.put("memberBcode", userinfoCode);
            } else if ("1200535".equals(userSession.getRoleCode())) {
                return new SupQueryResult();
            }
        }
        return this.crmsSOrderServiceRepository.querySOrderPage(param);
    }

    @RequestMapping(value={"updateSOrderState.json"}, name="\u66f4\u65b0\u670d\u52a1\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateSOrderState(String sorderId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)sorderId)) {
            this.logger.error(CODE + ".updateSOrderState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.crmsSOrderServiceRepository.updateSOrderState(Integer.valueOf(sorderId), dataState, oldDataState);
    }

    @RequestMapping(value={"querySOrderGoodsPage.json"}, name="\u67e5\u8be2\u670d\u52a1\u5355\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CrmsSOrderGoodsReDomain> querySOrderGoodsPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (param.get("queryType") != null) {
            if ("1".equals(param.get("queryType"))) {
                param.put("contractGoodsRefnumQmin", 0);
            } else if ("2".equals(param.get("queryType"))) {
                param.put("contractGoodsSendnumQmin", 0);
            }
        }
        return this.crmsSOrderGoodsServiceRepository.querySOrderGoodsPage(param);
    }

    @RequestMapping(value={"returnOrderGoods.json"}, name="\u9000\u8fd8/\u8f6c\u9500\u8d27\u7269\u6570\u636e\u53d8\u6362\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean returnOrderGoods(HttpServletRequest request, String orderGoodsDomainStr) {
        Map paramMap = this.assemMapParam(request);
        if (StringUtils.isBlank((String)orderGoodsDomainStr)) {
            this.logger.error(CODE + ".returnOrderGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.crmsSOrderServiceRepository.returnOrderGoods(paramMap, orderGoodsDomainStr);
    }

    @RequestMapping(value={"saveSOrderRule.json"}, name="\u589e\u52a0\u670d\u52a1\u5355")
    @ResponseBody
    public HtmlJsonReBean saveSOrderRule(HttpServletRequest request, String orderDomainStr, String memberBcode) {
        if (StringUtils.isBlank((String)memberBcode) || StringUtils.isBlank((String)orderDomainStr)) {
            this.logger.error(CODE + ".saveSOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.createOrderRule(request, orderDomainStr, "00", memberBcode, "1");
    }

    @RequestMapping(value={"updateSOrderRule.json"}, name="\u4fee\u6539\u501f\u8d27\u5355")
    @ResponseBody
    public HtmlJsonReBean updateSOrderRule(HttpServletRequest request, String orderDomainStr, String memberBcode) {
        this.logger.error("log >>> desc:updateSOrderRule {\u4fee\u6539\u501f\u8d27\u5355\u5f00\u59cb====}");
        Map param = this.assemMapParam(request);
        this.logger.error("log >>> desc:updateSOrderRule {param====}", (Object)param);
        String sorderId = param.get("sorderId").toString();
        return this.updateOrderRule(sorderId);
    }

    private HtmlJsonReBean updateOrderRule(String sorderId) {
        CrmsSOrderReDomain crmsSOrderReDomain = this.crmsSOrderServiceRepository.getSOrder(Integer.valueOf(sorderId));
        CrmsSOrderDomain crmsSOrderDomain = new CrmsSOrderDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crmsSOrderDomain, (Object)crmsSOrderReDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.crmsSOrderServiceRepository.updateSOrder(crmsSOrderDomain);
    }

    protected HtmlJsonReBean updateOrderRule(HttpServletRequest request, String orderDomainStr, String contractType, String memberBcode, String contractProperty) {
        if (StringUtils.isBlank((String)orderDomainStr)) {
            this.logger.error(CODE + ".updateOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List orderDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(orderDomainStr, CrmsSOrderDomain.class);
        this.logger.error(CODE + ".updateOrder:orderDomainList", (Object)JsonUtil.buildNormalBinder().jsonObject(orderDomainList));
        if (null == orderDomainList || orderDomainList.isEmpty()) {
            this.logger.error(CODE + ".updateOrder", (Object)"orderDomainStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateOrder", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OrgUserBean orgUserBean = null;
        orgUserBean = StringUtils.isNotBlank((String)memberBcode) ? this.getOrgUserBeanRule(memberBcode, userSession, this.getCompanyCode(request), userSession.getTenantCode()) : this.getOrgUserBean(userSession.getUserPcode(), userSession, null, userSession.getTenantCode());
        if (StringUtils.isNotBlank((String)((CrmsSOrderDomain)orderDomainList.get(0)).getEmployeeCode())) {
            orgUserBean.setEmployeeCode(((CrmsSOrderDomain)orderDomainList.get(0)).getEmployeeCode());
            orgUserBean.setEmployeeName(((CrmsSOrderDomain)orderDomainList.get(0)).getEmployeeName());
        }
        if (StringUtils.isNotBlank((String)((CrmsSOrderDomain)orderDomainList.get(0)).getDepartCode())) {
            orgUserBean.setDepartCode(((CrmsSOrderDomain)orderDomainList.get(0)).getDepartCode());
            orgUserBean.setDepartShortname(((CrmsSOrderDomain)orderDomainList.get(0)).getDepartShortname());
        }
        if (StringUtils.isNotBlank((String)((CrmsSOrderDomain)orderDomainList.get(0)).getCompanyCode())) {
            orgUserBean.setCompanyCode(((CrmsSOrderDomain)orderDomainList.get(0)).getCompanyCode());
            orgUserBean.setCompanyShortname(((CrmsSOrderDomain)orderDomainList.get(0)).getCompanyShortname());
        }
        this.makeChannel(orderDomainList, request);
        return this.crmsSOrderServiceRepository.updateOrder(orderDomainList, contractType, userSession, this.getProappCode(request), this.getOauthEnvCode(request), orgUserBean, contractProperty);
    }

    protected HtmlJsonReBean createOrderRule(HttpServletRequest request, String orderDomainStr, String contractType, String memberBcode, String contractProperty) {
        if (StringUtils.isBlank((String)orderDomainStr)) {
            this.logger.error(CODE + ".createOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List orderDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(orderDomainStr, CrmsSOrderDomain.class);
        this.logger.error(CODE + ".createOrder:orderDomainList", (Object)JsonUtil.buildNormalBinder().jsonObject(orderDomainList));
        if (null == orderDomainList || orderDomainList.isEmpty()) {
            this.logger.error(CODE + ".createOrder", (Object)"orderDomainStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".createOrder", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OrgUserBean orgUserBean = null;
        orgUserBean = StringUtils.isNotBlank((String)memberBcode) ? this.getOrgUserBeanRule(memberBcode, userSession, this.getCompanyCode(request), userSession.getTenantCode()) : this.getOrgUserBean(userSession.getUserPcode(), userSession, null, userSession.getTenantCode());
        if (StringUtils.isNotBlank((String)((CrmsSOrderDomain)orderDomainList.get(0)).getEmployeeCode())) {
            orgUserBean.setEmployeeCode(((CrmsSOrderDomain)orderDomainList.get(0)).getEmployeeCode());
            orgUserBean.setEmployeeName(((CrmsSOrderDomain)orderDomainList.get(0)).getEmployeeName());
        }
        if (StringUtils.isNotBlank((String)((CrmsSOrderDomain)orderDomainList.get(0)).getDepartCode())) {
            orgUserBean.setDepartCode(((CrmsSOrderDomain)orderDomainList.get(0)).getDepartCode());
            orgUserBean.setDepartShortname(((CrmsSOrderDomain)orderDomainList.get(0)).getDepartShortname());
        }
        if (StringUtils.isNotBlank((String)((CrmsSOrderDomain)orderDomainList.get(0)).getCompanyCode())) {
            orgUserBean.setCompanyCode(((CrmsSOrderDomain)orderDomainList.get(0)).getCompanyCode());
            orgUserBean.setCompanyShortname(((CrmsSOrderDomain)orderDomainList.get(0)).getCompanyShortname());
        }
        this.makeChannel(orderDomainList, request);
        return this.crmsSOrderServiceRepository.createOrder(orderDomainList, contractType, userSession, this.getProappCode(request), this.getOauthEnvCode(request), orgUserBean, contractProperty);
    }

    public OrgUserBean getOrgUserBeanRule(String memberBcode, UserSession userSession, String companyCode, String tenantCode) {
        SupQueryResult qcust;
        UmUserinfoReDomainBean umUserinfoReDomainBean;
        if (null == userSession || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        OrgUserBean orgUserBean = null;
        String userCode = userSession.getUserCode();
        if (StringUtils.isNotBlank((String)companyCode)) {
            orgUserBean = this.orgCompanyServiceRepository.getEmpByUserCode(userCode, companyCode, tenantCode);
        }
        if (null == orgUserBean) {
            orgUserBean = new OrgUserBean();
        }
        orgUserBean.setMemberBcode(memberBcode);
        SupQueryResult umUser = this.userServiceRepository.queryUserinfoPage(this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{memberBcode, userSession.getTenantCode()}));
        if (null != umUser && ListUtil.isNotEmpty((Collection)umUser.getList()) && "1".equals((umUserinfoReDomainBean = (UmUserinfoReDomainBean)umUser.getList().get(0)).getQualityQtypeCode())) {
            HashMap<String, String> ddmap = new HashMap<String, String>();
            ddmap.put("flagSettingCode", "exchangerate");
            SupQueryResult ddFalgSettingReDomainSupQueryResult = this.ddFalgSettingServiceRepository.queryFalgSettingPage(ddmap);
            DdFalgSettingReDomain ddFalgSettingReDomain = (DdFalgSettingReDomain)ddFalgSettingReDomainSupQueryResult.getList().get(0);
            this.logger.error(ddFalgSettingReDomain.toString() + "111222");
            this.logger.error(orgUserBean.toString() + "1111111");
            orgUserBean.setPricesetCurrency(ddFalgSettingReDomain.getFlagSettingPro());
        }
        if (StringUtils.isNotBlank((String)memberBcode) && null != (qcust = this.ctCustrelServiceRepository.queryCustrelPage(this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{memberBcode, tenantCode}))) && ListUtil.isNotEmpty((Collection)qcust.getList())) {
            CtCustrelReDomain ctustrelReDomain = (CtCustrelReDomain)qcust.getList().get(0);
            orgUserBean.setCustrelCode(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelCode());
            orgUserBean.setMemberBname(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelName());
            orgUserBean.setCompanyCode(ctustrelReDomain.getCompanyCode());
            orgUserBean.setEmployeeCode(ctustrelReDomain.getEmployeeCode());
            orgUserBean.setEmployeeName(ctustrelReDomain.getEmployeeName());
            orgUserBean.setDepartCode(ctustrelReDomain.getDepartCode());
            orgUserBean.setDepartShortname(ctustrelReDomain.getDepartName());
            orgUserBean.setCompanyShortname(ctustrelReDomain.getCompanyShortname());
        }
        if (StringUtils.isNotBlank((String)userSession.getCompanyCode()) && !userSession.getCompanyCode().equals(orgUserBean.getCompanyCode())) {
            orgUserBean.setCompanyCode(userSession.getCompanyCode());
            orgUserBean.setCompanyShortname(userSession.getCompanyShortname());
        }
        return orgUserBean;
    }

    @RequestMapping(value={"querySOrderPageRule.json"}, name="\u67e5\u8be2\u670d\u52a1\u5355\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CrmsSOrderReDomain> querySOrderPageRule(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        SupQueryResult ocRefundReDomainSupQueryResult = this.crmsSOrderServiceRepository.querySOrderPage(param);
        List crmsURechargeReDomains = ocRefundReDomainSupQueryResult.getList();
        UserSession userSession = this.getUserSession(request);
        for (CrmsSOrderReDomain oc : crmsURechargeReDomains) {
            UmUserinfoReDomainBean umUserinfoReDomainBean;
            SupQueryResult umUser = this.userServiceRepository.queryUserinfoPage(this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{oc.getMemberBcode(), userSession.getTenantCode()}));
            if (null == umUser || !ListUtil.isNotEmpty((Collection)umUser.getList()) || !"1".equals((umUserinfoReDomainBean = (UmUserinfoReDomainBean)umUser.getList().get(0)).getQualityQtypeCode())) continue;
            HashMap<String, String> ddmap = new HashMap<String, String>();
            ddmap.put("flagSettingCode", "exchangerate");
            SupQueryResult ddFalgSettingReDomainSupQueryResult = this.ddFalgSettingServiceRepository.queryFalgSettingPage(ddmap);
            DdFalgSettingReDomain ddFalgSettingReDomain = (DdFalgSettingReDomain)ddFalgSettingReDomainSupQueryResult.getList().get(0);
            oc.setPricesetCurrency(ddFalgSettingReDomain.getFlagSettingPro());
        }
        return ocRefundReDomainSupQueryResult;
    }

    @RequestMapping(value={"cancelCrmsSOrder.json"}, name="\u53d6\u6d88\u501f\u8d27\u5355")
    @ResponseBody
    public HtmlJsonReBean cancelCrmsSOrder(HttpServletRequest request) {
        Map paramMap = this.assemMapParam(request);
        if (paramMap == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.crmsSOrderServiceRepository.cancelCrmsSOrder(paramMap);
    }

    @RequestMapping(value={"crmsSOrderCT.json"}, name="\u501f\u8d27\u5355\u91cd\u63a8\u8fdbERP")
    @ResponseBody
    public HtmlJsonReBean crmsSOrderCT(HttpServletRequest request) {
        Map paramMap = this.assemMapParam(request);
        if (paramMap == null || paramMap.get("sorderId") == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.crmsSOrderServiceRepository.crmsSOrderCT(Integer.valueOf(Integer.parseInt(paramMap.get("sorderId") + "")));
    }
}

