/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.crp.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.crp.domain.CrpRechargeDomain;
import com.qjsoft.laser.controller.facade.crp.domain.CrpRechargeReDomain;
import com.qjsoft.laser.controller.facade.crp.domain.CrpUrechargeReDomain;
import com.qjsoft.laser.controller.facade.crp.domain.CrpUrechargelistReDomain;
import com.qjsoft.laser.controller.facade.crp.repository.CrpRechargeServiceRepository;
import com.qjsoft.laser.controller.facade.crp.repository.CrpUrechargeServiceRepository;
import com.qjsoft.laser.controller.facade.crp.repository.CrpUrechargelistServiceRepository;
import com.qjsoft.laser.controller.facade.dd.domain.DdFalgSettingReDomain;
import com.qjsoft.laser.controller.facade.dd.repository.DdFalgSettingServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/crp/pcCrpRecharge"}, name="pc\u7528\u6237\u4fe1\u7528\u989d\u5ea6")
public class PcCrpRechargeCon
extends SpringmvcController {
    private static String CODE = "crp.pcCrpRecharge.con";
    @Autowired
    private CrpRechargeServiceRepository crpRechargeServiceRepository;
    @Autowired
    private CrpUrechargeServiceRepository crpUrechargeServiceRepository;
    @Autowired
    private CrpUrechargelistServiceRepository crpUrechargelistServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private DdFalgSettingServiceRepository ddFalgSettingServiceRepository;

    protected String getContext() {
        return "pcCrpRecharge";
    }

    @RequestMapping(value={"applyCrpRecharge.json"}, name="\u7528\u6237\u4fe1\u7528\u989d\u5ea6\u7533\u8bf7")
    @ResponseBody
    public HtmlJsonReBean applyCrpRecharge(HttpServletRequest request, CrpRechargeDomain crpRechargeDomain) {
        if (null == crpRechargeDomain) {
            this.logger.error(CODE + ".applyCrpRecharge", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        crpRechargeDomain.setTenantCode(this.getTenantCode(request));
        UserSession userSession = this.getUserSession(request);
        this.logger.error(CODE + ".applyCrpRecharge", (Object)JsonUtil.buildNormalBinder().toJson((Object)crpRechargeDomain));
        if (StringUtils.isBlank((String)crpRechargeDomain.getUserinfoCode())) {
            crpRechargeDomain.setUserinfoCode(userSession.getUserPcode());
            crpRechargeDomain.setUserinfoName(userSession.getUserName());
        }
        return this.crpRechargeServiceRepository.saveCrpRecharge(crpRechargeDomain);
    }

    @RequestMapping(value={"pcQueryCrpRechargePage.json"}, name="pc\u67e5\u8be2\u7528\u6237\u4fe1\u7528\u989d\u5ea6\u7533\u8bf7\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CrpRechargeReDomain> queryCrpRechargePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (param.get("userinfoCode") != null && StringUtils.isNotBlank((String)param.get("userinfoCode").toString())) {
            param.put("userinfoCode", param.get("userinfoCode"));
        } else {
            UserSession userSession = this.getUserSession(request);
            param.put("userinfoCode", userSession.getUserPcode());
        }
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.crpRechargeServiceRepository.queryPcCrpRechargePage(param);
    }

    @RequestMapping(value={"pcGetCrpRecharge.json"}, name="pc\u6839\u636e\u7f16\u53f7\u83b7\u53d6\u7528\u6237\u4fe1\u7528\u989d\u5ea6\u7533\u8bf7")
    @ResponseBody
    public CrpRechargeReDomain getCrpRecharge(Integer rechargeId) {
        if (StringUtils.isBlank((Integer)rechargeId)) {
            this.logger.error(CODE + ".pcGetCrpRecharge", (Object)"param is null");
            return null;
        }
        return this.crpRechargeServiceRepository.getCrpRecharge(rechargeId);
    }

    @RequestMapping(value={"pcGetCrpURecharge.json"}, name="pc\u6839\u636e\u767b\u5f55\u7528\u6237\u83b7\u53d6\u4fe1\u7528\u989d\u5ea6\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean pcGetCrpURecharge(HttpServletRequest request) {
        String userInfoCode = "";
        Map param = this.assemMapParam(request);
        if (param.get("userinfoCode") != null && StringUtils.isNotBlank((String)param.get("userinfoCode").toString())) {
            userInfoCode = param.get("userinfoCode").toString();
        } else {
            UserSession userSession = this.getUserSession(request);
            if (userSession == null) {
                this.logger.error(CODE + ".pcGetCrpURecharge", (Object)"param is null");
                return null;
            }
            userInfoCode = userSession.getUserPcode();
        }
        List crpRechargeReDomainList = this.queryCrpRechargePage(request).getList();
        if (crpRechargeReDomainList == null || crpRechargeReDomainList.size() == 0) {
            return new HtmlJsonReBean((Object)"0");
        }
        CrpUrechargeReDomain crpUrechargeReDomain = this.crpUrechargeServiceRepository.getCrpUrechargeByUserInfoCode(this.getTenantCode(request), userInfoCode);
        if (crpUrechargeReDomain == null) {
            CrpRechargeReDomain crpRechargeReDomain = (CrpRechargeReDomain)crpRechargeReDomainList.get(0);
            return new HtmlJsonReBean((Object)crpRechargeReDomain.getDataState());
        }
        return new HtmlJsonReBean((Object)crpUrechargeReDomain);
    }

    @RequestMapping(value={"queryCrpURechargeListPage.json"}, name="pc\u67e5\u8be2\u7528\u6237\u4fe1\u7528\u989d\u5ea6\u6d41\u6c34\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CrpUrechargelistReDomain> queryCrpURechargeListPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        UserSession userSession = this.getUserSession(request);
        param.put("userinfoCode", userSession.getUserPcode());
        return this.crpUrechargelistServiceRepository.queryCrpUrechargelistPage(param);
    }

    @RequestMapping(value={"checkCrpRecharge.json"}, name="\u68c0\u67e5\u662f\u5426\u53ef\u4ee5\u7533\u8bf7\u53d8\u66f4\u989d\u5ea6")
    @ResponseBody
    public HtmlJsonReBean checkCrpRecharge(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            this.logger.error(CODE + ".checkCrpRecharge", (Object)"param is null");
            return null;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("userinfoCode", userSession.getUserPcode());
        param.put("dataState", 1);
        List crpRechargeReDomainList = this.crpRechargeServiceRepository.queryPcCrpRechargePage(param).getList();
        if (crpRechargeReDomainList != null && crpRechargeReDomainList.size() > 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5df2\u5b58\u5728\u672a\u5ba1\u6838\u8bb0\u5f55\uff01");
        }
        param = new HashMap();
        param.put("userinfoCode", userSession.getUserPcode());
        List crpUrechargelistReDomainList = this.crpUrechargelistServiceRepository.queryCrpUrechargelistPage(param).getList();
        if (this.handlerData(crpUrechargelistReDomainList).booleanValue()) {
            return new HtmlJsonReBean("-2", "\u5b58\u5728\u903e\u671f\u8bb0\u5f55\uff01");
        }
        return new HtmlJsonReBean((Object)this.crpUrechargeServiceRepository.getCrpUrechargeByUserInfoCode(userSession.getTenantCode(), userSession.getUserPcode()));
    }

    private Boolean handlerData(List<CrpUrechargelistReDomain> crpUrechargelistReDomainList) {
        HashMap resultMap = new HashMap();
        if (crpUrechargelistReDomainList != null) {
            ArrayList<CrpUrechargelistReDomain> reDomainList;
            for (CrpUrechargelistReDomain crpUrechargelistReDomain : crpUrechargelistReDomainList) {
                if (StringUtils.isBlank((String)crpUrechargelistReDomain.getRechargeOpno())) continue;
                if (resultMap.containsKey(crpUrechargelistReDomain.getRechargeOpno())) {
                    ((List)resultMap.get(crpUrechargelistReDomain.getRechargeOpno())).add(crpUrechargelistReDomain);
                    continue;
                }
                reDomainList = new ArrayList<CrpUrechargelistReDomain>();
                reDomainList.add(crpUrechargelistReDomain);
                resultMap.put(crpUrechargelistReDomain.getRechargeOpno(), reDomainList);
            }
            for (String key : resultMap.keySet()) {
                reDomainList = (ArrayList<CrpUrechargelistReDomain>)resultMap.get(key);
                BigDecimal money = BigDecimal.ZERO;
                Boolean flag = false;
                for (CrpUrechargelistReDomain crpUrechargelistReDomain : reDomainList) {
                    if ("3".equals(crpUrechargelistReDomain.getRechargeType())) {
                        Long day = DateUtil.getBetweenDays((Date)crpUrechargelistReDomain.getGmtCreate(), (Date)new Date());
                        Integer rechargePeriod = crpUrechargelistReDomain.getRechargePeriod();
                        if (day.intValue() > rechargePeriod) {
                            flag = true;
                        }
                    }
                    money = money.add(crpUrechargelistReDomain.getRechargeAllmoney());
                }
                if (!flag.booleanValue() || money.compareTo(BigDecimal.ZERO) >= 0) continue;
                return true;
            }
        }
        return false;
    }

    @RequestMapping(value={"applyCrpRechargeRule.json"}, name="\u7528\u6237\u4fe1\u7528\u989d\u5ea6\u7533\u8bf7")
    @ResponseBody
    public HtmlJsonReBean applyCrpRechargeRule(HttpServletRequest request, CrpRechargeDomain CrpRechargeDomain2) {
        UmUserinfoReDomainBean umUserinfoReDomainBean;
        if (null == CrpRechargeDomain2) {
            this.logger.error(CODE + ".applyCrpRecharge", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        CrpRechargeDomain2.setTenantCode(this.getTenantCode(request));
        UserSession userSession = this.getUserSession(request);
        CrpRechargeDomain2.setUserinfoCode(userSession.getUserPcode());
        CrpRechargeDomain2.setUserinfoName(userSession.getUserName());
        SupQueryResult umUser = this.userServiceRepository.queryUserinfoPage(this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{userSession.getUserPcode(), userSession.getTenantCode()}));
        if (null != umUser && ListUtil.isNotEmpty((Collection)umUser.getList()) && "1".equals((umUserinfoReDomainBean = (UmUserinfoReDomainBean)umUser.getList().get(0)).getQualityQtypeCode())) {
            HashMap<String, String> ddmap = new HashMap<String, String>();
            ddmap.put("flagSettingCode", "exchangerate");
            SupQueryResult ddFalgSettingReDomainSupQueryResult = this.ddFalgSettingServiceRepository.queryFalgSettingPage(ddmap);
            DdFalgSettingReDomain ddFalgSettingReDomain = (DdFalgSettingReDomain)ddFalgSettingReDomainSupQueryResult.getList().get(0);
            CrpRechargeDomain2.setRechargeName6(ddFalgSettingReDomain.getFlagSettingPro());
        }
        return this.crpRechargeServiceRepository.saveCrpRecharge(CrpRechargeDomain2);
    }
}

