/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.cs.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.cs.domain.CsConsultDomain;
import com.qjsoft.laser.controller.facade.cs.domain.CsConsultListDomain;
import com.qjsoft.laser.controller.facade.cs.domain.CsConsultReDomain;
import com.qjsoft.laser.controller.facade.cs.repository.CsConsultServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/cs/Consult"}, name="\u54a8\u8be2\u7559\u8a00\u670d\u52a1")
public class ConsultCon
extends SpringmvcController {
    private static String CODE = "cs.Consult.con";
    @Autowired
    private CsConsultServiceRepository csConsultServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;

    protected String getContext() {
        return "Consult";
    }

    @RequestMapping(value={"saveConsult.json"}, name="\u589e\u52a0\u54a8\u8be2\u7559\u8a00\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveConsult(HttpServletRequest request, CsConsultDomain CsConsultDomain2) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == CsConsultDomain2) {
            this.logger.error(CODE + ".saveConsult", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        CsConsultDomain2.setTenantCode(this.getTenantCode(request));
        CsConsultDomain2.setUserCode(userSession.getUserCode());
        CsConsultDomain2.setUserinfoCode(userSession.getUserPcode());
        param.put("userinfoCode", userSession.getUserPcode());
        SupQueryResult umUserinfoReDomainBeanSupQueryResult = this.userServiceRepository.queryUserinfoPage(param);
        List userinfolist = umUserinfoReDomainBeanSupQueryResult.getList();
        if (userinfolist.isEmpty()) {
            this.logger.error(CODE + ".userinfolist", (Object)"userinfolist is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        UmUserinfoReDomainBean umUserinfoReDomainBean = (UmUserinfoReDomainBean)userinfolist.get(0);
        String userinfoCompname = umUserinfoReDomainBean.getUserinfoCompname();
        CsConsultDomain2.setUserinfoCompname(userinfoCompname);
        return this.csConsultServiceRepository.saveConsult(CsConsultDomain2);
    }

    @RequestMapping(value={"saveConsultRep.json"}, name="\u589e\u52a0\u54a8\u8be2\u56de\u590d")
    @ResponseBody
    public HtmlJsonReBean saveConsultRep(HttpServletRequest request, String consultCode, String content) {
        Map param = this.assemMapParam(request);
        if (StringUtils.isBlank((String)consultCode)) {
            this.logger.error(CODE + ".saveEvaluateGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        param.put("tenantCode", tenantCode);
        UserSession userSession = this.getUserSession(request);
        CsConsultReDomain consult = this.csConsultServiceRepository.getConsultByCode(tenantCode, tenantCode);
        CsConsultListDomain csConsultListDomain = new CsConsultListDomain();
        csConsultListDomain.setConsultCode(consultCode);
        csConsultListDomain.setConsultListCont(content);
        csConsultListDomain.setMemberCode(consult.getUserinfoCode());
        csConsultListDomain.setMemberName(consult.getUserinfoCompname());
        csConsultListDomain.setUserCode(userSession.getUserPcode());
        csConsultListDomain.setTenantCode(tenantCode);
        return this.csConsultServiceRepository.saveConsultList(csConsultListDomain);
    }

    @RequestMapping(value={"getConsult.json"}, name="\u83b7\u53d6\u54a8\u8be2\u7559\u8a00\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public CsConsultReDomain getConsult(Integer consultId) {
        if (StringUtils.isBlank((Integer)consultId)) {
            this.logger.error(CODE + ".getConsult", (Object)"param is null");
            return null;
        }
        return this.csConsultServiceRepository.getConsult(consultId);
    }

    @RequestMapping(value={"updateConsult.json"}, name="\u66f4\u65b0\u54a8\u8be2\u7559\u8a00\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateConsult(HttpServletRequest request, CsConsultDomain CsConsultDomain2) {
        if (null == CsConsultDomain2) {
            this.logger.error(CODE + ".updateConsult", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        CsConsultDomain2.setTenantCode(this.getTenantCode(request));
        return this.csConsultServiceRepository.updateConsult(CsConsultDomain2);
    }

    @RequestMapping(value={"deleteConsult.json"}, name="\u5220\u9664\u54a8\u8be2\u7559\u8a00\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteConsult(Integer consultId) {
        if (StringUtils.isBlank((Integer)consultId)) {
            this.logger.error(CODE + ".deleteConsult", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.csConsultServiceRepository.deleteConsult(consultId);
    }

    @RequestMapping(value={"queryConsultPageByOpCode.json"}, name="\u901a\u8fc7\u5546\u54c1\u54a8\u8be2\u7559\u8a00\u670d\u52a1")
    @ResponseBody
    public SupQueryResult<CsConsultReDomain> queryConsultPageByOpCode(HttpServletRequest request, String consultOpcode) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("consultOpcode", consultOpcode);
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.csConsultServiceRepository.queryConsultPage(param);
    }

    @RequestMapping(value={"queryConsultPageByUserCode.json"}, name="\u901a\u8fc7\u7528\u6237\u54a8\u8be2\u7559\u8a00\u670d\u52a1")
    @ResponseBody
    public SupQueryResult<CsConsultReDomain> queryConsultPageByUserCode(HttpServletRequest request, String userinfoCode) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("userinfoCode", userinfoCode);
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.csConsultServiceRepository.queryConsultPage(param);
    }

    @RequestMapping(value={"queryConsultPage.json"}, name="\u67e5\u8be2\u54a8\u8be2\u7559\u8a00\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CsConsultReDomain> queryConsultPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("consultType", 1);
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.csConsultServiceRepository.queryConsultPage(param);
    }

    @RequestMapping(value={"queryConsultPageByType.json"}, name="\u67e5\u8be2\u6587\u7ae0\u7559\u8a00\u670d\u52a1\u5206\u9875\u5217\u8868\uff08\u4e0d\u53ef\u56de\u590d\uff09")
    @ResponseBody
    public SupQueryResult<CsConsultReDomain> queryConsultPageByType(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("consultType", 2);
            param.put("order", true);
            param.put("fuzzy", true);
        }
        SupQueryResult result = this.csConsultServiceRepository.queryConsultPage(param);
        return result;
    }

    @RequestMapping(value={"updateConsultState.json"}, name="\u66f4\u65b0\u54a8\u8be2\u7559\u8a00\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateConsultState(String consultId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)consultId)) {
            this.logger.error(CODE + ".updateConsultState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.csConsultServiceRepository.updateConsultState(Integer.valueOf(consultId), dataState, oldDataState);
    }
}

