/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.ct.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.ct.controller.CtConstants;
import com.qjsoft.laser.controller.facade.ct.domain.CtCustrelLableDomain;
import com.qjsoft.laser.controller.facade.ct.domain.CtCustrelLableReDomain;
import com.qjsoft.laser.controller.facade.ct.repository.CtCustrelLableServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/ct/custrelLable"}, name="\u5ba2\u6237\u6807\u7b7e\u670d\u52a1")
public class CustrelLableCon
extends SpringmvcController {
    private static String CODE = "ct.custrelLable.con";
    @Autowired
    private CtCustrelLableServiceRepository ctCustrelLableServiceRepository;

    protected String getContext() {
        return "custrelLable";
    }

    @RequestMapping(value={"saveCustrelLable.json"}, name="\u589e\u52a0\u5ba2\u6237\u6807\u7b7e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveCustrelLable(HttpServletRequest request, CtCustrelLableDomain custrelLableDomain) {
        if (null == custrelLableDomain) {
            this.logger.error(CODE + ".saveCustrelLable", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        custrelLableDomain.setTenantCode(this.getTenantCode(request));
        return this.ctCustrelLableServiceRepository.saveCustrelLable(custrelLableDomain);
    }

    @RequestMapping(value={"saveCustrelLableBatch.json"}, name="\u6279\u91cf\u589e\u52a0\u5ba2\u6237\u6807\u7b7e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveCustrelLableBatch(HttpServletRequest request, String custrelLableDomainStr) {
        if (null == custrelLableDomainStr) {
            this.logger.error(CODE + ".saveCustrelLableBatch", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List ctCustrelLableDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(custrelLableDomainStr, CtCustrelLableDomain.class);
        String tenantCode = this.getTenantCode(request);
        HtmlJsonReBean htmlJsonReBean = this.checkLabel(ctCustrelLableDomainList);
        if ("error".equals(htmlJsonReBean.getSysRecode())) {
            return htmlJsonReBean;
        }
        for (CtCustrelLableDomain ctCustrelLableDomain : ctCustrelLableDomainList) {
            ctCustrelLableDomain.setTenantCode(tenantCode);
        }
        return this.ctCustrelLableServiceRepository.saveCustrelLableBatch(ctCustrelLableDomainList);
    }

    private HtmlJsonReBean checkLabel(List<CtCustrelLableDomain> ctCustrelLableDomainList) {
        this.logger.error(CODE + ".checkLabel.desc ====\u6821\u9a8c\u6807\u7b7e=====");
        if (ctCustrelLableDomainList == null || ListUtil.isEmpty(ctCustrelLableDomainList)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        String reg = "[^;:]+";
        Pattern pattern = Pattern.compile(reg);
        for (CtCustrelLableDomain ctCustrelLableDomain : ctCustrelLableDomainList) {
            if (StringUtils.isBlank((String)ctCustrelLableDomain.getCustrelLablePropertyValue())) continue;
            String labelValue = ctCustrelLableDomain.getCustrelLablePropertyValue();
            if (ctCustrelLableDomain.getTmpExtend1() != null && labelValue.length() > Integer.valueOf(ctCustrelLableDomain.getTmpExtend1())) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, labelValue + "\u8d85\u8fc7" + ctCustrelLableDomain.getTmpExtend1());
            }
            if (!pattern.matcher(labelValue).matches()) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7981\u6b62\u8f93\u5165\u5b57\u7b26:" + reg);
            }
            if (!StringUtils.isNotBlank((String)ctCustrelLableDomain.getTmpExtend3()) || Integer.valueOf(ctCustrelLableDomain.getTmpExtend3()) > ctCustrelLableDomainList.size()) continue;
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6807\u7b7e\u5c5e\u6027\u503c\u4e0d\u80fd\u8d85\u8fc7:" + ctCustrelLableDomain.getTmpExtend3());
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"getCustrelLable.json"}, name="\u83b7\u53d6\u5ba2\u6237\u6807\u7b7e\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public CtCustrelLableReDomain getCustrelLable(Integer custrelLableId) {
        if (StringUtils.isBlank((Integer)custrelLableId)) {
            this.logger.error(CODE + ".getCustrelLable", (Object)"param is null");
            return null;
        }
        return this.ctCustrelLableServiceRepository.getCustrelLable(custrelLableId);
    }

    @RequestMapping(value={"updateCustrelLable.json"}, name="\u66f4\u65b0\u5ba2\u6237\u6807\u7b7e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateCustrelLable(HttpServletRequest request, CtCustrelLableDomain custrelLableDomain) {
        if (null == custrelLableDomain) {
            this.logger.error(CODE + ".updateCustrelLable", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        custrelLableDomain.setTenantCode(this.getTenantCode(request));
        return this.ctCustrelLableServiceRepository.updateCustrelLable(custrelLableDomain);
    }

    @RequestMapping(value={"updateCustrelLableBatch.json"}, name="\u66f4\u65b0\u5ba2\u6237\u6807\u7b7e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateCustrelLableBatch(HttpServletRequest request, String custrelLableDomainStr) {
        if (null == custrelLableDomainStr) {
            this.logger.error(CODE + ".saveCustrelLableBatch", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List ctCustrelLableDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(custrelLableDomainStr, CtCustrelLableDomain.class);
        HtmlJsonReBean htmlJsonReBean = this.checkLabel(ctCustrelLableDomainList);
        if ("error".equals(htmlJsonReBean.getSysRecode())) {
            return htmlJsonReBean;
        }
        StringBuffer labelValueStr = new StringBuffer();
        for (CtCustrelLableDomain ctCustrelLableDomain : ctCustrelLableDomainList) {
            if (CtConstants.LABEL_TYPE_3.intValue() != ctCustrelLableDomain.getCustrelLableType().intValue()) continue;
            if (StringUtils.isNotBlank((String)labelValueStr.toString())) {
                labelValueStr.append(";");
            }
            labelValueStr.append(ctCustrelLableDomain.getCustrelLablePropertyName()).append(":").append(ctCustrelLableDomain.getCustrelLablePropertyValue());
        }
        for (CtCustrelLableDomain ctCustrelLableDomain : ctCustrelLableDomainList) {
            if (CtConstants.LABEL_TYPE_2.intValue() != ctCustrelLableDomain.getCustrelLableType().intValue()) continue;
            labelValueStr.append(";").append("\u6807\u7b7e\u6a21\u677f\u540d\u79f0:").append(ctCustrelLableDomain.getCustrelLableName());
            ctCustrelLableDomain.setTmpExtend2(labelValueStr.toString());
        }
        for (CtCustrelLableDomain ctCustrelLableDomain : ctCustrelLableDomainList) {
            this.ctCustrelLableServiceRepository.updateCustrelLable(ctCustrelLableDomain);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"deleteCustrelLable.json"}, name="\u5220\u9664\u5ba2\u6237\u6807\u7b7e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteCustrelLable(Integer custrelLableId) {
        if (StringUtils.isBlank((Integer)custrelLableId)) {
            this.logger.error(CODE + ".deleteCustrelLable", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ctCustrelLableServiceRepository.deleteCustrelLable(custrelLableId);
    }

    @RequestMapping(value={"queryCustrelLablePage.json"}, name="\u67e5\u8be2\u5ba2\u6237\u6807\u7b7e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CtCustrelLableReDomain> queryCustrelLablePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("orderStr", "CUSTREL_LABLE_SORT");
        return this.ctCustrelLableServiceRepository.queryCustrelLablePage(param);
    }

    @RequestMapping(value={"updateCustrelLableState.json"}, name="\u66f4\u65b0\u5ba2\u6237\u6807\u7b7e\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateCustrelLableState(String custrelLableId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)custrelLableId)) {
            this.logger.error(CODE + ".updateCustrelLableState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ctCustrelLableServiceRepository.updateCustrelLableState(Integer.valueOf(custrelLableId), dataState, oldDataState, null);
    }
}

