/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.data.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.da.repository.DaOpsumServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.data.domain.DaOpsumDomain;
import com.yqbsoft.laser.service.data.domain.DaOpsumReDomain;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/da/opsum"}, name="\u6c47\u603b\u6570\u636e")
public class OpsumCon
extends SpringmvcController {
    private static String CODE = "da.opsum.con";
    @Autowired
    private DaOpsumServiceRepository daOpsumServiceRepository;

    protected String getContext() {
        return "opsum";
    }

    @RequestMapping(value={"saveOpsum.json"}, name="\u589e\u52a0\u6c47\u603b\u6570\u636e")
    @ResponseBody
    public HtmlJsonReBean saveOpsum(HttpServletRequest request, DaOpsumDomain daOpsumDomain) {
        if (null == daOpsumDomain) {
            this.logger.error(CODE + ".saveOpsum", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        daOpsumDomain.setTenantCode(this.getTenantCode(request));
        return this.daOpsumServiceRepository.saveOpsum(daOpsumDomain);
    }

    @RequestMapping(value={"getOpsum.json"}, name="\u83b7\u53d6\u6c47\u603b\u6570\u636e\u4fe1\u606f")
    @ResponseBody
    public DaOpsumReDomain getOpsum(Integer opsumId) {
        if (StringUtils.isBlank((Integer)opsumId)) {
            this.logger.error(CODE + ".getOpsum", (Object)"param is null");
            return null;
        }
        return this.daOpsumServiceRepository.getOpsum(opsumId);
    }

    @RequestMapping(value={"updateOpsum.json"}, name="\u66f4\u65b0\u6c47\u603b\u6570\u636e")
    @ResponseBody
    public HtmlJsonReBean updateOpsum(HttpServletRequest request, DaOpsumDomain daOpsumDomain) {
        if (null == daOpsumDomain) {
            this.logger.error(CODE + ".updateOpsum", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        daOpsumDomain.setTenantCode(this.getTenantCode(request));
        return this.daOpsumServiceRepository.updateOpsum(daOpsumDomain);
    }

    @RequestMapping(value={"deleteOpsum.json"}, name="\u5220\u9664\u6c47\u603b\u6570\u636e")
    @ResponseBody
    public HtmlJsonReBean deleteOpsum(Integer opsumId) {
        if (StringUtils.isBlank((Integer)opsumId)) {
            this.logger.error(CODE + ".deleteOpsum", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.daOpsumServiceRepository.deleteOpsum(opsumId);
    }

    @RequestMapping(value={"queryOpsumPage.json"}, name="\u67e5\u8be2\u6c47\u603b\u6570\u636e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DaOpsumReDomain> queryOpsumPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.daOpsumServiceRepository.queryOpsumPage(param);
    }

    @RequestMapping(value={"updateOpsumState.json"}, name="\u66f4\u65b0\u6c47\u603b\u6570\u636e\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateOpsumState(String opsumId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)opsumId)) {
            this.logger.error(CODE + ".updateOpsumState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.daOpsumServiceRepository.updateOpsumState(Integer.valueOf(opsumId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryOpsumPageLastForUser.json"}, name="\u67e5\u8be2\u524d\u4e00\u5929\u6c47\u603b\u4f1a\u5458\u589e\u52a0\u91cf")
    @ResponseBody
    public String queryOpsumPageLastForUser(HttpServletRequest request) {
        SupQueryResult result;
        String tenantCode = this.getTenantCode(request);
        Map param = this.assemMapParam(request);
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        date = calendar.getTime();
        String pattern = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String formatDate = sdf.format(date);
        if (null != param) {
            param.put("order", true);
            param.put("tenantCode", tenantCode);
            param.put("opsumCode", formatDate);
        }
        if (0 == (result = this.daOpsumServiceRepository.queryOpsumPage(param)).getList().size()) {
            return "0";
        }
        DaOpsumReDomain daOpsumReDomain = (DaOpsumReDomain)result.getList().get(0);
        String opsumName = daOpsumReDomain.getOpsumName();
        return opsumName;
    }
}

