/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.dis.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.dis.domain.DisChannelReDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisDgoodsDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisDgoodsReDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisDgoodsScopelistDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisDgoodsScopelistReDomain;
import com.qjsoft.laser.controller.facade.dis.repository.DisChannelServiceRepository;
import com.qjsoft.laser.controller.facade.dis.repository.DisDgoodsServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/dis/dgoods"}, name="\u6e20\u9053\u5b9a\u4e49")
public class DgoodsCon
extends SpringmvcController {
    private static String CODE = "dis.dgoods.con";
    @Autowired
    private DisDgoodsServiceRepository disDgoodsServiceRepository;
    @Autowired
    private DisChannelServiceRepository disChannelServiceRepository;

    protected String getContext() {
        return "dgoods";
    }

    @RequestMapping(value={"getDgoodsByChannelId.json"}, name="\u6839\u636e\u6e20\u9053\u83b7\u53d6\u6e20\u9053\u5b9a\u4e49\u4fe1\u606f")
    @ResponseBody
    public DisDgoodsReDomain getDgoodsByChannelId(HttpServletRequest request, Integer channelId) {
        if (StringUtils.isBlank((Integer)channelId)) {
            this.logger.error(CODE + ".getDgoodsByChannelId", (Object)"param is null");
            return null;
        }
        return this.fetchDgoodsByChannel(this.getTenantCode(request), channelId);
    }

    @RequestMapping(value={"getByChannelIdFromZx.json"}, name="\u6839\u636e\u6e20\u9053\u83b7\u53d6\u6e20\u9053\u5b9a\u4e49\u4fe1\u606f-\u76f4\u9500")
    @ResponseBody
    public DisDgoodsReDomain getDgoodsByChannelIdFromZx(HttpServletRequest request, Integer channelId) {
        if (StringUtils.isBlank((Integer)channelId)) {
            this.logger.error(CODE + ".getDgoodsByChannelId", (Object)"param is null");
            return null;
        }
        return this.fetchDgoodsByChannel(this.getTenantCode(request), channelId);
    }

    private DisDgoodsReDomain fetchDgoodsByChannel(String tenantCode, Integer channelId) {
        if (StringUtils.isBlank((Integer)channelId)) {
            this.logger.error(CODE + ".getDgoodsByChannelId", (Object)"param is null");
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelId", channelId);
        SupQueryResult supQueryResult = this.disDgoodsServiceRepository.queryDgoodsPage(map);
        if (null == supQueryResult || null == supQueryResult.getList() || supQueryResult.getList().size() <= 0) {
            return null;
        }
        return (DisDgoodsReDomain)supQueryResult.getList().get(0);
    }

    @RequestMapping(value={"saveDgoods.json"}, name="\u589e\u52a0\u6e20\u9053\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean saveDgoods(HttpServletRequest request, DisDgoodsDomain disDgoodsDomain) {
        if (null == disDgoodsDomain) {
            this.logger.error(CODE + ".saveDgoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveDgoodsMain(this.getTenantCode(request), disDgoodsDomain);
    }

    @RequestMapping(value={"saveDgoodsFromZx.json"}, name="\u589e\u52a0\u6e20\u9053\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean saveDgoodsFromZx(HttpServletRequest request, DisDgoodsDomain disDgoodsDomain) {
        if (null == disDgoodsDomain) {
            this.logger.error(CODE + ".saveDgoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveDgoodsMain(this.getTenantCode(request), disDgoodsDomain);
    }

    private HtmlJsonReBean saveDgoodsMain(String tenantCode, DisDgoodsDomain disDgoodsDomain) {
        if (null == disDgoodsDomain) {
            this.logger.error(CODE + ".saveDgoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (null != disDgoodsDomain.getDgoodsId() && StringUtils.isNotBlank((String)String.valueOf(disDgoodsDomain.getDgoodsId()))) {
            return this.disDgoodsServiceRepository.updateDgoods(disDgoodsDomain);
        }
        DisChannelReDomain disChannelReDomain = this.disChannelServiceRepository.getChannel(disDgoodsDomain.getChannelId());
        disDgoodsDomain.setChannelCode(disChannelReDomain.getChannelCode());
        disDgoodsDomain.setChannelSort(disChannelReDomain.getChannelSort());
        disDgoodsDomain.setMemberCode(disChannelReDomain.getMemberCode());
        disDgoodsDomain.setMemberName(disChannelReDomain.getMemberName());
        disDgoodsDomain.setMemberMcode(disChannelReDomain.getMemberMcode());
        disDgoodsDomain.setMemberMname(disChannelReDomain.getMemberMname());
        disDgoodsDomain.setTenantCode(tenantCode);
        return this.disDgoodsServiceRepository.saveDgoods(disDgoodsDomain);
    }

    @RequestMapping(value={"saveDgoodsScopeList.json"}, name="\u589e\u52a0\u6e20\u9053\u5546\u54c1\u8303\u56f4\u5b9a\u4e49\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean saveDgoodsScopeList(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".save MschannelConfig", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveDgoodsScoListMain(this.getTenantCode(request), paramStr);
    }

    @RequestMapping(value={"saveDgoScoListFromZx.json"}, name="\u589e\u52a0\u6e20\u9053\u5546\u54c1\u8303\u56f4\u5b9a\u4e49\u660e\u7ec6-\u76f4\u9500")
    @ResponseBody
    public HtmlJsonReBean saveDgoScoListFromZx(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".save MschannelConfig", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveDgoodsScoListMain(this.getTenantCode(request), paramStr);
    }

    private HtmlJsonReBean saveDgoodsScoListMain(String tenantCode, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".save MschannelConfig", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, DisDgoodsScopelistDomain.class);
        if (null == list || list.size() <= 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        String dgoodsCode = ((DisDgoodsScopelistDomain)list.get(0)).getDgoodsCode();
        if (null == dgoodsCode || StringUtils.isBlank((String)dgoodsCode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6e20\u9053\u8bbe\u7f6ecode\u4e3a\u7a7a");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("dgoodsCode", dgoodsCode);
        SupQueryResult supQueryResult = this.disDgoodsServiceRepository.queryDgoodsScopelistPage(map);
        if (null != supQueryResult && null != supQueryResult.getList() && supQueryResult.getList().size() > 0) {
            for (DisDgoodsScopelistReDomain dgoodsScopelistReDomain : supQueryResult.getList()) {
                this.disDgoodsServiceRepository.deleteDgoodsScopelist(dgoodsScopelistReDomain.getDgoodsScopelistId());
            }
        }
        HtmlJsonReBean htmlJsonReBean = null;
        for (DisDgoodsScopelistDomain domain : list) {
            domain.setTenantCode(tenantCode);
            htmlJsonReBean = this.disDgoodsServiceRepository.saveDgoodsScopelist(domain);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"queryByDgoodsCode.json"}, name="\u83b7\u53d6\u6e20\u9053\u5546\u54c1\u8303\u56f4\u5b9a\u4e49\u660e\u7ec6")
    @ResponseBody
    public List<DisDgoodsScopelistReDomain> queryDgoodsScopelistByDgoCode(HttpServletRequest request, String dgoodsCode) {
        if (StringUtils.isBlank((String)dgoodsCode)) {
            this.logger.error(CODE + ".queryDgoodsScopelistByDgoCode", (Object)"param is null");
            return null;
        }
        return this.queryDgoScoLisMain(this.getTenantCode(request), dgoodsCode);
    }

    @RequestMapping(value={"queryByDgCodeFromZx.json"}, name="\u83b7\u53d6\u6e20\u9053\u5546\u54c1\u8303\u56f4\u5b9a\u4e49\u660e\u7ec6-\u76f4\u9500")
    @ResponseBody
    public List<DisDgoodsScopelistReDomain> queryDgoScolisByDgCodeFromZx(HttpServletRequest request, String dgoodsCode) {
        if (StringUtils.isBlank((String)dgoodsCode)) {
            this.logger.error(CODE + ".queryDgoodsScopelistByDgoCode", (Object)"param is null");
            return null;
        }
        return this.queryDgoScoLisMain(this.getTenantCode(request), dgoodsCode);
    }

    private List<DisDgoodsScopelistReDomain> queryDgoScoLisMain(String tenantCode, String dgoodsCode) {
        if (StringUtils.isBlank((String)dgoodsCode)) {
            this.logger.error(CODE + ".queryDgoodsScopelistByDgoCode", (Object)"param is null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("dgoodsCode", dgoodsCode);
        map.put("tenantCode", tenantCode);
        SupQueryResult supQueryResult = this.disDgoodsServiceRepository.queryDgoodsScopelistPage(map);
        if (null == supQueryResult || null == supQueryResult.getList() || supQueryResult.getList().size() <= 0) {
            return null;
        }
        return supQueryResult.getList();
    }

    @RequestMapping(value={"getDgoods.json"}, name="\u83b7\u53d6\u6e20\u9053\u5b9a\u4e49\u4fe1\u606f")
    @ResponseBody
    public DisDgoodsReDomain getDgoods(Integer dgoodsId) {
        if (StringUtils.isBlank((Integer)dgoodsId)) {
            this.logger.error(CODE + ".getDgoods", (Object)"param is null");
            return null;
        }
        return this.disDgoodsServiceRepository.getDgoods(dgoodsId);
    }

    @RequestMapping(value={"updateDgoods.json"}, name="\u66f4\u65b0\u6e20\u9053\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean updateDgoods(HttpServletRequest request, DisDgoodsDomain disDgoodsDomain) {
        if (null == disDgoodsDomain) {
            this.logger.error(CODE + ".updateDgoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        disDgoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.disDgoodsServiceRepository.updateDgoods(disDgoodsDomain);
    }

    @RequestMapping(value={"deleteDgoods.json"}, name="\u5220\u9664\u6e20\u9053\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean deleteDgoods(Integer dgoodsId) {
        if (StringUtils.isBlank((Integer)dgoodsId)) {
            this.logger.error(CODE + ".deleteDgoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDgoodsServiceRepository.deleteDgoods(dgoodsId);
    }

    @RequestMapping(value={"queryDgoodsPage.json"}, name="\u67e5\u8be2\u6e20\u9053\u5b9a\u4e49\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisDgoodsReDomain> queryDgoodsPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.disDgoodsServiceRepository.queryDgoodsPage(param);
    }

    @RequestMapping(value={"updateDgoodsState.json"}, name="\u66f4\u65b0\u6e20\u9053\u5b9a\u4e49\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateDgoodsState(String dgoodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)dgoodsId)) {
            this.logger.error(CODE + ".updateDgoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDgoodsServiceRepository.updateDgoodsState(Integer.valueOf(dgoodsId), dataState, oldDataState);
    }
}

