/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.dis.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.dis.domain.DisChannelReDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisDgoodsDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisDgoodsReDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisDgoodsScopelistDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisDgoodsScopelistReDomain;
import com.qjsoft.laser.controller.facade.dis.repository.DisChannelServiceRepository;
import com.qjsoft.laser.controller.facade.dis.repository.DisDgoodsServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/dis/dgoods"}, name="\u6e20\u9053\u5b9a\u4e49")
public class DgoodsCon
extends SpringmvcController {
    private static String CODE = "dis.dgoods.con";
    @Autowired
    private DisDgoodsServiceRepository disDgoodsServiceRepository;
    @Autowired
    private DisChannelServiceRepository disChannelServiceRepository;

    protected String getContext() {
        return "dgoods";
    }

    @RequestMapping(value={"getDgoodsByChannelId.json"}, name="\u6839\u636e\u6e20\u9053\u83b7\u53d6\u6e20\u9053\u5b9a\u4e49\u4fe1\u606f")
    @ResponseBody
    public DisDgoodsReDomain getDgoodsByChannelId(HttpServletRequest request, Integer channelId) {
        if (StringUtils.isBlank((Integer)channelId)) {
            this.logger.error(CODE + ".getDgoodsByChannelId", (Object)"param is null");
            return null;
        }
        return this.fetchDgoodsByChannel(this.getTenantCode(request), channelId);
    }

    @RequestMapping(value={"getDgoodsByChannelIdSale.json"}, name="\u6839\u636e\u9500\u552e\u6e20\u9053\u83b7\u53d6\u6e20\u9053\u5b9a\u4e49\u4fe1\u606f")
    @ResponseBody
    public DisDgoodsReDomain getDgoodsByChannelIdSale(HttpServletRequest request, Integer channelId) {
        if (StringUtils.isBlank((Integer)channelId)) {
            this.logger.error(CODE + ".getDgoodsByChannelId", (Object)"param is null");
            return null;
        }
        return this.fetchDgoodsByChannel(this.getTenantCode(request), channelId);
    }

    @RequestMapping(value={"getDgoodsByChannelIdStore.json"}, name="\u6839\u636e\u95e8\u5e97\u6e20\u9053\u83b7\u53d6\u6e20\u9053\u5b9a\u4e49\u4fe1\u606f")
    @ResponseBody
    public DisDgoodsReDomain getDgoodsByChannelIdStore(HttpServletRequest request, Integer channelId) {
        if (StringUtils.isBlank((Integer)channelId)) {
            this.logger.error(CODE + ".getDgoodsByChannelId", (Object)"param is null");
            return null;
        }
        return this.fetchDgoodsByChannel(this.getTenantCode(request), channelId);
    }

    @RequestMapping(value={"queryDgoScolisByCodeFromRepRel.json"}, name="\u83b7\u53d6\u6e20\u9053\u5546\u54c1\u8303\u56f4\u5b9a\u4e49\u660e\u7ec6-\u5e73\u53f0\u4ee3\u53d1")
    @ResponseBody
    public List<DisDgoodsScopelistReDomain> queryDgoScolisByCodeFromRepRel(HttpServletRequest request) {
        String memberCode = request.getParameter("memberCode");
        String tenantCode = request.getParameter("tenantCode");
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".queryDgoScolisByCode", (Object)"\u53c2\u6570\u7f3a\u5931");
            return null;
        }
        SupQueryResult supQueryResult = this.disChannelServiceRepository.queryChannelPage(this.getQueryMapParam("memberCcode,tenantCode", new Object[]{memberCode, tenantCode}));
        if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
            this.logger.error(CODE + ".queryDgoScolisByCode", (Object)"\u65e0\u6e20\u9053");
            return null;
        }
        DisChannelReDomain disChannelReDomain = (DisChannelReDomain)supQueryResult.getList().get(0);
        SupQueryResult supQueryResult1 = this.disDgoodsServiceRepository.queryDgoodsPage(this.getQueryMapParam("channelCode,tenantCode", new Object[]{disChannelReDomain.getChannelCode(), tenantCode}));
        if (null == supQueryResult1 || ListUtil.isEmpty((Collection)supQueryResult1.getList())) {
            this.logger.error(CODE + ".queryDgoScolisByCode", (Object)"\u65e0\u5546\u54c1\u53d1\u5e03\u8bbe\u7f6e");
            return null;
        }
        DisDgoodsReDomain disDgoodsReDomain = (DisDgoodsReDomain)supQueryResult1.getList().get(0);
        SupQueryResult supQueryResult2 = this.disDgoodsServiceRepository.queryDgoodsScopelistPage(this.getQueryMapParam("dgoodsCode,tenantCode", new Object[]{disDgoodsReDomain.getDgoodsCode(), tenantCode}));
        if (null == supQueryResult2 || ListUtil.isEmpty((Collection)supQueryResult2.getList())) {
            this.logger.error(CODE + ".queryDgoScolisByCode", (Object)"\u6e20\u9053\u5546\u54c1\u8303\u56f4\u672a\u5b9a\u4e49");
            return null;
        }
        return supQueryResult2.getList();
    }

    @RequestMapping(value={"queryDgoScolisByCode.json"}, name="\u83b7\u53d6\u6e20\u9053\u5546\u54c1\u8303\u56f4\u5b9a\u4e49\u660e\u7ec6-\u8fd0\u8425\u4e2d\u53f0\u53d1\u5e03")
    @ResponseBody
    public List<DisDgoodsScopelistReDomain> queryDgoScolisByCode(HttpServletRequest request) {
        String memberCode = this.getMerchantCode(request);
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".queryDgoScolisByCode", (Object)"\u53c2\u6570\u7f3a\u5931");
            return null;
        }
        SupQueryResult supQueryResult = this.disChannelServiceRepository.queryChannelPage(this.getQueryMapParam("memberCcode,tenantCode", new Object[]{memberCode, tenantCode}));
        if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
            this.logger.error(CODE + ".queryDgoScolisByCode", (Object)"\u65e0\u6e20\u9053");
            return null;
        }
        DisChannelReDomain disChannelReDomain = (DisChannelReDomain)supQueryResult.getList().get(0);
        SupQueryResult supQueryResult1 = this.disDgoodsServiceRepository.queryDgoodsPage(this.getQueryMapParam("channelCode,tenantCode", new Object[]{disChannelReDomain.getChannelCode(), tenantCode}));
        if (null == supQueryResult1 || ListUtil.isEmpty((Collection)supQueryResult1.getList())) {
            this.logger.error(CODE + ".queryDgoScolisByCode", (Object)"\u65e0\u5546\u54c1\u53d1\u5e03\u8bbe\u7f6e");
            return null;
        }
        DisDgoodsReDomain disDgoodsReDomain = (DisDgoodsReDomain)supQueryResult1.getList().get(0);
        SupQueryResult supQueryResult2 = this.disDgoodsServiceRepository.queryDgoodsScopelistPage(this.getQueryMapParam("dgoodsCode,tenantCode", new Object[]{disDgoodsReDomain.getDgoodsCode(), tenantCode}));
        if (null == supQueryResult2 || ListUtil.isEmpty((Collection)supQueryResult2.getList())) {
            this.logger.error(CODE + ".queryDgoScolisByCode", (Object)"\u6e20\u9053\u5546\u54c1\u8303\u56f4\u672a\u5b9a\u4e49");
            return null;
        }
        return supQueryResult2.getList();
    }

    @RequestMapping(value={"getDgoodsByChaIdBySer.json"}, name="\u6839\u636e\u6e20\u9053\u83b7\u53d6\u6e20\u9053\u5b9a\u4e49\u4fe1\u606f - \u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public DisDgoodsReDomain getDgoodsByChaIdBySer(HttpServletRequest request, Integer channelId) {
        if (StringUtils.isBlank((Integer)channelId)) {
            this.logger.error(CODE + ".getDgoodsByChaIdBySer", (Object)"param is null");
            return null;
        }
        String tenantCode = request.getParameter("tenantCode") == null ? this.getTenantCode(request) : request.getParameter("tenantCode");
        return this.fetchDgoodsByChannel(tenantCode, channelId);
    }

    @RequestMapping(value={"getByChannelIdFromZx.json"}, name="\u6839\u636e\u6e20\u9053\u83b7\u53d6\u6e20\u9053\u5b9a\u4e49\u4fe1\u606f-\u76f4\u9500")
    @ResponseBody
    public DisDgoodsReDomain getDgoodsByChannelIdFromZx(HttpServletRequest request, Integer channelId) {
        if (StringUtils.isBlank((Integer)channelId)) {
            this.logger.error(CODE + ".getDgoodsByChannelId", (Object)"param is null");
            return null;
        }
        return this.fetchDgoodsByChannel(this.getTenantCode(request), channelId);
    }

    @RequestMapping(value={"getByChaIdFromZxBySer.json"}, name="\u6839\u636e\u6e20\u9053\u83b7\u53d6\u6e20\u9053\u5b9a\u4e49\u4fe1\u606f-\u76f4\u9500 - \u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public DisDgoodsReDomain getByChaIdFromZxBySer(HttpServletRequest request, Integer channelId) {
        if (StringUtils.isBlank((Integer)channelId)) {
            this.logger.error(CODE + ".getByChaIdFromZxBySer", (Object)"param is null");
            return null;
        }
        return this.fetchDgoodsByChannel(this.getTenantCode(request), channelId);
    }

    private DisDgoodsReDomain fetchDgoodsByChannel(String tenantCode, Integer channelId) {
        if (StringUtils.isBlank((Integer)channelId)) {
            this.logger.error(CODE + ".getDgoodsByChannelId", (Object)"param is null");
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelId", channelId);
        SupQueryResult supQueryResult = this.disDgoodsServiceRepository.queryDgoodsPage(map);
        if (null == supQueryResult || null == supQueryResult.getList() || supQueryResult.getList().size() <= 0) {
            return null;
        }
        return (DisDgoodsReDomain)supQueryResult.getList().get(0);
    }

    @RequestMapping(value={"saveDgoods.json"}, name="\u589e\u52a0\u6e20\u9053\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean saveDgoods(HttpServletRequest request, DisDgoodsDomain disDgoodsDomain) {
        if (null == disDgoodsDomain) {
            this.logger.error(CODE + ".saveDgoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveDgoodsMain(this.getTenantCode(request), disDgoodsDomain);
    }

    @RequestMapping(value={"saveDgoodsSale.json"}, name="\u589e\u52a0\u9500\u552e\u6e20\u9053\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean saveDgoodsSale(HttpServletRequest request, DisDgoodsDomain disDgoodsDomain) {
        if (null == disDgoodsDomain) {
            this.logger.error(CODE + ".saveDgoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveDgoodsMain(this.getTenantCode(request), disDgoodsDomain);
    }

    @RequestMapping(value={"saveDgoodsStore.json"}, name="\u589e\u52a0\u95e8\u5e97\u6e20\u9053\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean saveDgoodsStore(HttpServletRequest request, DisDgoodsDomain disDgoodsDomain) {
        if (null == disDgoodsDomain) {
            this.logger.error(CODE + ".saveDgoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveDgoodsMain(this.getTenantCode(request), disDgoodsDomain);
    }

    @RequestMapping(value={"saveDgoodsBySer.json"}, name="\u589e\u52a0\u6e20\u9053\u5b9a\u4e49 - \u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public HtmlJsonReBean saveDgoodsBySer(HttpServletRequest request, DisDgoodsDomain disDgoodsDomain) {
        if (null == disDgoodsDomain) {
            this.logger.error(CODE + ".saveDgoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = disDgoodsDomain.getTenantCode() == null ? this.getTenantCode(request) : disDgoodsDomain.getTenantCode();
        return this.saveDgoodsMain(tenantCode, disDgoodsDomain);
    }

    @RequestMapping(value={"saveDgoodsFromZx.json"}, name="\u589e\u52a0\u6e20\u9053\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean saveDgoodsFromZx(HttpServletRequest request, DisDgoodsDomain disDgoodsDomain) {
        if (null == disDgoodsDomain) {
            this.logger.error(CODE + ".saveDgoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveDgoodsMain(this.getTenantCode(request), disDgoodsDomain);
    }

    @RequestMapping(value={"saveDgoodsFromZxBySer.json"}, name="\u589e\u52a0\u6e20\u9053\u5b9a\u4e49 - \u76f4\u9500 - \u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public HtmlJsonReBean saveDgoodsFromZxBySer(HttpServletRequest request, DisDgoodsDomain disDgoodsDomain) {
        if (null == disDgoodsDomain) {
            this.logger.error(CODE + ".saveDgoodsFromZxBySer", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveDgoodsMain(this.getTenantCode(request), disDgoodsDomain);
    }

    private HtmlJsonReBean saveDgoodsMain(String tenantCode, DisDgoodsDomain disDgoodsDomain) {
        if (null == disDgoodsDomain) {
            this.logger.error(CODE + ".saveDgoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (null != disDgoodsDomain.getDgoodsId() && StringUtils.isNotBlank((String)String.valueOf(disDgoodsDomain.getDgoodsId()))) {
            return this.disDgoodsServiceRepository.updateDgoods(disDgoodsDomain);
        }
        DisChannelReDomain disChannelReDomain = this.disChannelServiceRepository.getChannel(disDgoodsDomain.getChannelId());
        SupQueryResult supQueryResult = this.disDgoodsServiceRepository.queryDgoodsPage(this.getQueryMapParam("channelCode,tenantCode", new Object[]{disChannelReDomain.getChannelCode(), disChannelReDomain.getTenantCode()}));
        if (null != supQueryResult && ListUtil.isNotEmpty((Collection)supQueryResult.getList())) {
            this.logger.error(CODE + ".saveDgoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u64cd\u4f5c\u5df2\u6210\u529f\uff0c \u8bf7\u52ff\u9891\u7e41\u70b9\u51fb\uff01");
        }
        disDgoodsDomain.setChannelCode(disChannelReDomain.getChannelCode());
        disDgoodsDomain.setChannelSort(disChannelReDomain.getChannelSort());
        disDgoodsDomain.setMemberCode(disChannelReDomain.getMemberCode());
        disDgoodsDomain.setMemberName(disChannelReDomain.getMemberName());
        disDgoodsDomain.setMemberMcode(disChannelReDomain.getMemberMcode());
        disDgoodsDomain.setMemberMname(disChannelReDomain.getMemberMname());
        disDgoodsDomain.setTenantCode(tenantCode);
        return this.disDgoodsServiceRepository.saveDgoods(disDgoodsDomain);
    }

    @RequestMapping(value={"saveDgoodsScopeList.json"}, name="\u589e\u52a0\u6e20\u9053\u5546\u54c1\u8303\u56f4\u5b9a\u4e49\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean saveDgoodsScopeList(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".save MschannelConfig", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveDgoodsScoListMain(this.getTenantCode(request), paramStr);
    }

    @RequestMapping(value={"saveDgoodsScopeListSale.json"}, name="\u589e\u52a0\u9500\u552e\u6e20\u9053\u5546\u54c1\u8303\u56f4\u5b9a\u4e49\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean saveDgoodsScopeListSale(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".save MschannelConfig", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveDgoodsScoListMain(this.getTenantCode(request), paramStr);
    }

    @RequestMapping(value={"saveDgoodsScopeListStore.json"}, name="\u589e\u52a0\u95e8\u5e97\u6e20\u9053\u5546\u54c1\u8303\u56f4\u5b9a\u4e49\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean saveDgoodsScopeListStore(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".save MschannelConfig", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveDgoodsScoListMain(this.getTenantCode(request), paramStr);
    }

    @RequestMapping(value={"saveDgoodsScopeListBySer.json"}, name="\u589e\u52a0\u6e20\u9053\u5546\u54c1\u8303\u56f4\u5b9a\u4e49\u660e\u7ec6 - \u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public HtmlJsonReBean saveDgoodsScopeListBySer(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".save saveDgoodsScopeListBySer", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = request.getParameter("tenantCode") == null ? this.getTenantCode(request) : request.getParameter("tenantCode");
        return this.saveDgoodsScoListMain(tenantCode, paramStr);
    }

    @RequestMapping(value={"saveDgoScoListFromZx.json"}, name="\u589e\u52a0\u6e20\u9053\u5546\u54c1\u8303\u56f4\u5b9a\u4e49\u660e\u7ec6-\u76f4\u9500")
    @ResponseBody
    public HtmlJsonReBean saveDgoScoListFromZx(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".save MschannelConfig", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveDgoodsScoListMain(this.getTenantCode(request), paramStr);
    }

    @RequestMapping(value={"saveDgoScoListFromZxBySer.json"}, name="\u589e\u52a0\u6e20\u9053\u5546\u54c1\u8303\u56f4\u5b9a\u4e49\u660e\u7ec6-\u76f4\u9500-\u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public HtmlJsonReBean saveDgoScoListFromZxBySer(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".save saveDgoScoListFromZxBySer", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveDgoodsScoListMain(this.getTenantCode(request), paramStr);
    }

    private HtmlJsonReBean saveDgoodsScoListMain(String tenantCode, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".save MschannelConfig", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, DisDgoodsScopelistDomain.class);
        if (null == list || list.size() <= 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        String dgoodsCode = ((DisDgoodsScopelistDomain)list.get(0)).getDgoodsCode();
        if (null == dgoodsCode || StringUtils.isBlank((String)dgoodsCode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6e20\u9053\u8bbe\u7f6ecode\u4e3a\u7a7a");
        }
        DisDgoodsReDomain disDgoodsReDomain = this.disDgoodsServiceRepository.getDgoodsByCode(tenantCode, dgoodsCode);
        if (null == disDgoodsReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6e20\u9053\u4e0d\u5b58\u5728");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("dgoodsCode", dgoodsCode);
        SupQueryResult supQueryResult = this.disDgoodsServiceRepository.queryDgoodsScopelistPage(map);
        if (null != supQueryResult && null != supQueryResult.getList() && supQueryResult.getList().size() > 0) {
            for (DisDgoodsScopelistReDomain dgoodsScopelistReDomain : supQueryResult.getList()) {
                this.disDgoodsServiceRepository.deleteDgoodsScopelist(dgoodsScopelistReDomain.getDgoodsScopelistId());
            }
        }
        HtmlJsonReBean htmlJsonReBean = null;
        for (DisDgoodsScopelistDomain domain : list) {
            domain.setTenantCode(tenantCode);
            domain.setMemberCode(disDgoodsReDomain.getMemberCode());
            domain.setMemberName(disDgoodsReDomain.getMemberName());
            domain.setMemberMcode(disDgoodsReDomain.getMemberMcode());
            domain.setMemberMname(disDgoodsReDomain.getMemberMname());
            htmlJsonReBean = this.disDgoodsServiceRepository.saveDgoodsScopelist(domain);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"queryByDgoodsCode.json"}, name="\u83b7\u53d6\u6e20\u9053\u5546\u54c1\u8303\u56f4\u5b9a\u4e49\u660e\u7ec6")
    @ResponseBody
    public List<DisDgoodsScopelistReDomain> queryDgoodsScopelistByDgoCode(HttpServletRequest request, String dgoodsCode) {
        if (StringUtils.isBlank((String)dgoodsCode)) {
            this.logger.error(CODE + ".queryByDgoodsCode", (Object)"param is null");
            return null;
        }
        return this.queryDgoScoLisMain(this.getTenantCode(request), dgoodsCode);
    }

    @RequestMapping(value={"queryByDgoodsCodeBySer.json"}, name="\u83b7\u53d6\u6e20\u9053\u5546\u54c1\u8303\u56f4\u5b9a\u4e49\u660e\u7ec6 - \u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public List<DisDgoodsScopelistReDomain> queryByDgoodsCodeBySer(HttpServletRequest request, String dgoodsCode) {
        if (StringUtils.isBlank((String)dgoodsCode)) {
            this.logger.error(CODE + ".queryByDgoodsCodeBySer", (Object)"param is null");
            return null;
        }
        String tenantCode = request.getParameter("tenantCode") == null ? this.getTenantCode(request) : request.getParameter("tenantCode");
        return this.queryDgoScoLisMain(tenantCode, dgoodsCode);
    }

    @RequestMapping(value={"queryByDgCodeFromZx.json"}, name="\u83b7\u53d6\u6e20\u9053\u5546\u54c1\u8303\u56f4\u5b9a\u4e49\u660e\u7ec6-\u76f4\u9500")
    @ResponseBody
    public List<DisDgoodsScopelistReDomain> queryDgoScolisByDgCodeFromZx(HttpServletRequest request, String dgoodsCode) {
        if (StringUtils.isBlank((String)dgoodsCode)) {
            this.logger.error(CODE + ".queryDgoodsScopelistByDgoCode", (Object)"param is null");
            return null;
        }
        return this.queryDgoScoLisMain(this.getTenantCode(request), dgoodsCode);
    }

    @RequestMapping(value={"queryByDgCodeFromSale.json"}, name="\u83b7\u53d6\u6e20\u9053\u5546\u54c1\u8303\u56f4\u5b9a\u4e49\u660e\u7ec6-\u9500\u552e")
    @ResponseBody
    public List<DisDgoodsScopelistReDomain> queryByDgCodeFromSale(HttpServletRequest request, String dgoodsCode) {
        if (StringUtils.isBlank((String)dgoodsCode)) {
            this.logger.error(CODE + ".queryDgoodsScopelistByDgoCode", (Object)"param is null");
            return null;
        }
        return this.queryDgoScoLisMain(this.getTenantCode(request), dgoodsCode);
    }

    @RequestMapping(value={"queryByDgCodeFromStore.json"}, name="\u83b7\u53d6\u6e20\u9053\u5546\u54c1\u8303\u56f4\u5b9a\u4e49\u660e\u7ec6-\u95e8\u5e97")
    @ResponseBody
    public List<DisDgoodsScopelistReDomain> queryByDgCodeFromStore(HttpServletRequest request, String dgoodsCode) {
        if (StringUtils.isBlank((String)dgoodsCode)) {
            this.logger.error(CODE + ".queryDgoodsScopelistByDgoCode", (Object)"param is null");
            return null;
        }
        return this.queryDgoScoLisMain(this.getTenantCode(request), dgoodsCode);
    }

    @RequestMapping(value={"queryByDgCodeFromZxBySer.json"}, name="\u83b7\u53d6\u6e20\u9053\u5546\u54c1\u8303\u56f4\u5b9a\u4e49\u660e\u7ec6-\u76f4\u9500 - \u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public List<DisDgoodsScopelistReDomain> queryByDgCodeFromZxBySer(HttpServletRequest request, String dgoodsCode) {
        if (StringUtils.isBlank((String)dgoodsCode)) {
            this.logger.error(CODE + ".queryByDgCodeFromZxBySer", (Object)"param is null");
            return null;
        }
        return this.queryDgoScoLisMain(this.getTenantCode(request), dgoodsCode);
    }

    private List<DisDgoodsScopelistReDomain> queryDgoScoLisMain(String tenantCode, String dgoodsCode) {
        if (StringUtils.isBlank((String)dgoodsCode)) {
            this.logger.error(CODE + ".queryDgoodsScopelistByDgoCode", (Object)"param is null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("dgoodsCode", dgoodsCode);
        map.put("tenantCode", tenantCode);
        SupQueryResult supQueryResult = this.disDgoodsServiceRepository.queryDgoodsScopelistPage(map);
        if (null == supQueryResult || null == supQueryResult.getList() || supQueryResult.getList().size() <= 0) {
            return null;
        }
        return supQueryResult.getList();
    }

    @RequestMapping(value={"getDgoods.json"}, name="\u83b7\u53d6\u6e20\u9053\u5b9a\u4e49\u4fe1\u606f")
    @ResponseBody
    public DisDgoodsReDomain getDgoods(Integer dgoodsId) {
        if (StringUtils.isBlank((Integer)dgoodsId)) {
            this.logger.error(CODE + ".getDgoods", (Object)"param is null");
            return null;
        }
        return this.disDgoodsServiceRepository.getDgoods(dgoodsId);
    }

    @RequestMapping(value={"updateDgoods.json"}, name="\u66f4\u65b0\u6e20\u9053\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean updateDgoods(HttpServletRequest request, DisDgoodsDomain disDgoodsDomain) {
        if (null == disDgoodsDomain) {
            this.logger.error(CODE + ".updateDgoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        disDgoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.disDgoodsServiceRepository.updateDgoods(disDgoodsDomain);
    }

    @RequestMapping(value={"deleteDgoods.json"}, name="\u5220\u9664\u6e20\u9053\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean deleteDgoods(Integer dgoodsId) {
        if (StringUtils.isBlank((Integer)dgoodsId)) {
            this.logger.error(CODE + ".deleteDgoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDgoodsServiceRepository.deleteDgoods(dgoodsId);
    }

    @RequestMapping(value={"queryDgoodsPage.json"}, name="\u67e5\u8be2\u6e20\u9053\u5b9a\u4e49\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisDgoodsReDomain> queryDgoodsPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.disDgoodsServiceRepository.queryDgoodsPage(param);
    }

    @RequestMapping(value={"updateDgoodsState.json"}, name="\u66f4\u65b0\u6e20\u9053\u5b9a\u4e49\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateDgoodsState(String dgoodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)dgoodsId)) {
            this.logger.error(CODE + ".updateDgoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDgoodsServiceRepository.updateDgoodsState(Integer.valueOf(dgoodsId), dataState, oldDataState);
    }
}

