/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.dis.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.dis.domain.DisStatementDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisStatementReDomain;
import com.qjsoft.laser.controller.facade.dis.repository.DisStatementServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/dis/statement"}, name="\u5bf9\u8d26\u670d\u52a1")
public class StatementCon
extends SpringmvcController {
    private static String CODE = "dis.statement.con";
    @Autowired
    private DisStatementServiceRepository disStatementServiceRepository;

    protected String getContext() {
        return "statement";
    }

    @RequestMapping(value={"saveStatement.json"}, name="\u589e\u52a0\u5bf9\u8d26\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveStatement(HttpServletRequest request, DisStatementDomain disStatementDomain) {
        if (null == disStatementDomain) {
            this.logger.error(CODE + ".saveStatement", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        disStatementDomain.setTenantCode(this.getTenantCode(request));
        return this.disStatementServiceRepository.saveStatement(disStatementDomain);
    }

    @RequestMapping(value={"getStatement.json"}, name="\u83b7\u53d6\u5bf9\u8d26\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public DisStatementReDomain getStatement(Integer statementId) {
        if (StringUtils.isBlank((Integer)statementId)) {
            this.logger.error(CODE + ".getStatement", (Object)"param is null");
            return null;
        }
        return this.disStatementServiceRepository.getStatement(statementId);
    }

    @RequestMapping(value={"updateStatement.json"}, name="\u66f4\u65b0\u5bf9\u8d26\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateStatement(HttpServletRequest request, DisStatementDomain disStatementDomain) {
        if (null == disStatementDomain) {
            this.logger.error(CODE + ".updateStatement", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        disStatementDomain.setTenantCode(this.getTenantCode(request));
        return this.disStatementServiceRepository.updateStatement(disStatementDomain);
    }

    @RequestMapping(value={"deleteStatement.json"}, name="\u5220\u9664\u5bf9\u8d26\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteStatement(Integer statementId) {
        if (StringUtils.isBlank((Integer)statementId)) {
            this.logger.error(CODE + ".deleteStatement", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disStatementServiceRepository.deleteStatement(statementId);
    }

    @RequestMapping(value={"queryStatementPage.json"}, name="\u67e5\u8be2\u5bf9\u8d26\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisStatementReDomain> queryStatementPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.disStatementServiceRepository.queryStatementPage(param);
    }

    @RequestMapping(value={"updateStatementState.json"}, name="\u66f4\u65b0\u5bf9\u8d26\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateStatementState(String statementId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)statementId)) {
            this.logger.error(CODE + ".updateStatementState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disStatementServiceRepository.updateStatementState(Integer.valueOf(statementId), dataState, oldDataState, null);
    }
}

