/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.dis.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.dis.domain.DisRefundDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisRefundReDomain;
import com.qjsoft.laser.controller.facade.dis.repository.DisRefundServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/dis/refund"}, name="\u6e20\u9053\u9000\u6b3e")
public class DisRefundCon
extends SpringmvcController {
    private static String CODE = "dis.refund.con";
    @Autowired
    private DisRefundServiceRepository disRefundServiceRepository;

    protected String getContext() {
        return "refund";
    }

    @RequestMapping(value={"saveRefund.json"}, name="\u589e\u52a0\u6e20\u9053\u9000\u6b3e")
    @ResponseBody
    public HtmlJsonReBean saveRefund(HttpServletRequest request, DisRefundDomain disRefundDomain) {
        if (null == disRefundDomain) {
            this.logger.error(CODE + ".saveRefund", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        disRefundDomain.setTenantCode(this.getTenantCode(request));
        return this.disRefundServiceRepository.saveRefund(disRefundDomain);
    }

    @RequestMapping(value={"getRefund.json"}, name="\u83b7\u53d6\u6e20\u9053\u9000\u6b3e\u4fe1\u606f")
    @ResponseBody
    public DisRefundReDomain getRefund(Integer refundId) {
        if (StringUtils.isBlank((Integer)refundId)) {
            this.logger.error(CODE + ".getRefund", (Object)"param is null");
            return null;
        }
        return this.disRefundServiceRepository.getRefund(refundId);
    }

    @RequestMapping(value={"updateRefund.json"}, name="\u66f4\u65b0\u6e20\u9053\u9000\u6b3e")
    @ResponseBody
    public HtmlJsonReBean updateRefund(HttpServletRequest request, DisRefundDomain disRefundDomain) {
        if (null == disRefundDomain) {
            this.logger.error(CODE + ".updateRefund", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        disRefundDomain.setTenantCode(this.getTenantCode(request));
        return this.disRefundServiceRepository.updateRefund(disRefundDomain);
    }

    @RequestMapping(value={"deleteRefund.json"}, name="\u5220\u9664\u6e20\u9053\u9000\u6b3e")
    @ResponseBody
    public HtmlJsonReBean deleteRefund(Integer refundId) {
        if (StringUtils.isBlank((Integer)refundId)) {
            this.logger.error(CODE + ".deleteRefund", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disRefundServiceRepository.deleteRefund(refundId);
    }

    @RequestMapping(value={"queryRefundPage.json"}, name="\u67e5\u8be2\u6e20\u9053\u9000\u6b3e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisRefundReDomain> queryRefundPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.disRefundServiceRepository.queryRefundPage(param);
    }

    @RequestMapping(value={"updateRefundState.json"}, name="\u66f4\u65b0\u6e20\u9053\u9000\u6b3e\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateRefundState(String refundId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)refundId)) {
            this.logger.error(CODE + ".updateRefundState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disRefundServiceRepository.updateRefundState(Integer.valueOf(refundId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryRefundPageForPalt.json"}, name="\u67e5\u8be2\u6e20\u9053\u9000\u6b3e\u5206\u9875\u5217\u8868-\u5e73\u53f0")
    @ResponseBody
    public SupQueryResult<DisRefundReDomain> queryRefundPageForPalt(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("refundSendstate", "0");
        return this.disRefundServiceRepository.queryRefundReDomainPage(param);
    }

    @RequestMapping(value={"queryRefundPageFoStore.json"}, name="\u67e5\u8be2\u6e20\u9053\u9000\u6b3e\u5206\u9875\u5217\u8868-\u7528\u6237")
    @ResponseBody
    public SupQueryResult<DisRefundReDomain> queryRefundPageFoStore(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberCcode", this.getMerchantCode(request));
        param.put("refundSendstate", "0");
        return this.disRefundServiceRepository.queryRefundReDomainPage(param);
    }

    @RequestMapping(value={"getRefundDomainByCode.json"}, name="\u83b7\u53d6\u6e20\u9053\u9000\u5355\u4fe1\u606f")
    @ResponseBody
    public DisRefundReDomain getRefundDomainByCode(HttpServletRequest request, String refundCode) {
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error(CODE + ".getRefundDomainByCode", (Object)"param is null");
            return null;
        }
        return this.disRefundServiceRepository.getRefundByCode(this.getTenantCode(request), refundCode);
    }
}

