/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.dis.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.dis.domain.DisOauthTokenDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisOauthTokenReDomain;
import com.qjsoft.laser.controller.facade.dis.repository.DisOauthTokenServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/dis/oauthToken"}, name="\u6e20\u9053\u6388\u6743\u7801")
public class OauthTokenCon
extends SpringmvcController {
    private static String CODE = "dis.oauthToken.con";
    @Autowired
    private DisOauthTokenServiceRepository disOauthTokenServiceRepository;

    protected String getContext() {
        return "oauthToken";
    }

    @RequestMapping(value={"saveOauthToken.json"}, name="\u589e\u52a0\u6e20\u9053\u6388\u6743\u7801")
    @ResponseBody
    public HtmlJsonReBean saveOauthToken(HttpServletRequest request, DisOauthTokenDomain disOauthTokenDomain) {
        if (null == disOauthTokenDomain) {
            this.logger.error(CODE + ".saveOauthToken", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        disOauthTokenDomain.setTenantCode(this.getTenantCode(request));
        return this.disOauthTokenServiceRepository.saveOauthToken(disOauthTokenDomain);
    }

    @RequestMapping(value={"getOauthToken.json"}, name="\u83b7\u53d6\u6e20\u9053\u6388\u6743\u7801\u4fe1\u606f")
    @ResponseBody
    public DisOauthTokenReDomain getOauthToken(Integer oauthTokenId) {
        if (StringUtils.isBlank((Integer)oauthTokenId)) {
            this.logger.error(CODE + ".getOauthToken", (Object)"param is null");
            return null;
        }
        return this.disOauthTokenServiceRepository.getOauthToken(oauthTokenId);
    }

    @RequestMapping(value={"updateOauthToken.json"}, name="\u66f4\u65b0\u6e20\u9053\u6388\u6743\u7801")
    @ResponseBody
    public HtmlJsonReBean updateOauthToken(HttpServletRequest request, DisOauthTokenDomain disOauthTokenDomain) {
        if (null == disOauthTokenDomain) {
            this.logger.error(CODE + ".updateOauthToken", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        disOauthTokenDomain.setTenantCode(this.getTenantCode(request));
        return this.disOauthTokenServiceRepository.updateOauthToken(disOauthTokenDomain);
    }

    @RequestMapping(value={"deleteOauthToken.json"}, name="\u5220\u9664\u6e20\u9053\u6388\u6743\u7801")
    @ResponseBody
    public HtmlJsonReBean deleteOauthToken(Integer oauthTokenId) {
        if (StringUtils.isBlank((Integer)oauthTokenId)) {
            this.logger.error(CODE + ".deleteOauthToken", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disOauthTokenServiceRepository.deleteOauthToken(oauthTokenId);
    }

    @RequestMapping(value={"queryOauthTokenPage.json"}, name="\u67e5\u8be2\u6e20\u9053\u6388\u6743\u7801\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisOauthTokenReDomain> queryOauthTokenPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.disOauthTokenServiceRepository.queryOauthTokenPage(param);
    }

    @RequestMapping(value={"updateOauthTokenState.json"}, name="\u66f4\u65b0\u6e20\u9053\u6388\u6743\u7801\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateOauthTokenState(String oauthTokenId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)oauthTokenId)) {
            this.logger.error(CODE + ".updateOauthTokenState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disOauthTokenServiceRepository.updateOauthTokenState(Integer.valueOf(oauthTokenId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"loadCacheDb.json"}, name="\u6388\u6743\u7801")
    @ResponseBody
    public HtmlJsonReBean loadCacheDb() {
        return this.disOauthTokenServiceRepository.loadCacheDb();
    }
}

