/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.dis.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.dis.controller.DisConstants;
import com.qjsoft.laser.controller.facade.dis.domain.DisDpriceReDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisDpriceSubDomain;
import com.qjsoft.laser.controller.facade.dis.domain.DisDpriceSubReDomain;
import com.qjsoft.laser.controller.facade.dis.repository.DisDpriceServiceRepository;
import com.qjsoft.laser.controller.facade.dis.repository.DisDpriceSubServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/dis/dpriceSub"}, name="\u6e20\u9053\u5546\u54c1\u4ef7\u683c\u7ec4")
public class DpriceSubCon
extends SpringmvcController {
    private static String CODE = "dis.dpriceSub.con";
    @Autowired
    private DisDpriceSubServiceRepository disDpriceSubServiceRepository;
    @Autowired
    private DisDpriceServiceRepository disDpriceServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;

    protected String getContext() {
        return "dpriceSub";
    }

    @RequestMapping(value={"saveDpriceSub.json"}, name="\u589e\u52a0\u6e20\u9053\u5546\u54c1\u4ef7\u683c\u7ec4")
    @ResponseBody
    public HtmlJsonReBean saveDpriceSub(HttpServletRequest request, DisDpriceSubDomain dpriceSubDomain) {
        if (null == dpriceSubDomain) {
            this.logger.error(CODE + ".saveDpriceSub", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        String dPriceCode = this.getDpriceCode(dpriceSubDomain.getChannelCode(), tenantCode);
        dpriceSubDomain.setTenantCode(tenantCode);
        dpriceSubDomain.setDpriceCode(dPriceCode);
        return this.disDpriceSubServiceRepository.saveDpriceSub(dpriceSubDomain);
    }

    @RequestMapping(value={"saveDpriceSubBatch.json"}, name="\u6279\u91cf\u589e\u52a0\u6e20\u9053\u5546\u54c1\u4ef7\u683c\u7ec4")
    @ResponseBody
    public HtmlJsonReBean saveDpriceSubBatch(HttpServletRequest request, String dpriceSubDomainStr) {
        if (null == dpriceSubDomainStr) {
            this.logger.error(CODE + ".saveDpriceSub", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List disDpriceSubDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(dpriceSubDomainStr, DisDpriceSubDomain.class);
        String tenantCode = this.getTenantCode(request);
        String dPriceCode = this.getDpriceCode(((DisDpriceSubDomain)disDpriceSubDomainList.get(0)).getChannelCode(), tenantCode);
        StringBuffer skuNoStr = new StringBuffer();
        for (DisDpriceSubDomain disDpriceSubDomain : disDpriceSubDomainList) {
            disDpriceSubDomain.setTenantCode(tenantCode);
            disDpriceSubDomain.setDpriceCode(dPriceCode);
            if (StringUtils.isNotBlank((String)skuNoStr.toString())) {
                skuNoStr.append(",");
            }
            skuNoStr.append(disDpriceSubDomain.getSkuName());
        }
        List<RsResourceGoodsReDomain> resourceGoodsReDomainList = this.queryGoods(tenantCode, skuNoStr.toString());
        for (DisDpriceSubDomain disDpriceSubDomain : disDpriceSubDomainList) {
            for (RsResourceGoodsReDomain rsResourceGoodsReDomain : resourceGoodsReDomainList) {
                if (!disDpriceSubDomain.getSkuName().equals(rsResourceGoodsReDomain.getGoodsShowno())) continue;
                disDpriceSubDomain.setTempFieild5(rsResourceGoodsReDomain.getGoodsProperty1());
            }
        }
        return this.disDpriceSubServiceRepository.saveDpriceSubBatch(disDpriceSubDomainList);
    }

    private List<RsResourceGoodsReDomain> queryGoods(String tenantCode, String skuNoStr) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantCode", tenantCode);
        params.put("colName0", "goodsShowno");
        params.put("colValue0", skuNoStr);
        params.put("goodsOrigin", DisConstants.GOODS_ORIGIN_0);
        SupQueryResult result = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(params);
        return result.getList();
    }

    private String getDpriceCode(String channelCode, String tenantCode) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("channelCode", channelCode);
        params.put("tenantCode", tenantCode);
        SupQueryResult priceResult = this.disDpriceServiceRepository.queryDpricePage(params);
        if (priceResult == null || priceResult.getList() == null || priceResult.getList().isEmpty()) {
            this.logger.error(CODE + ".getDpriceCode.is null", (Object)("channelCode:" + channelCode));
            return null;
        }
        return ((DisDpriceReDomain)priceResult.getList().get(0)).getDpriceCode();
    }

    @RequestMapping(value={"getDpriceSub.json"}, name="\u83b7\u53d6\u6e20\u9053\u5546\u54c1\u4ef7\u683c\u7ec4\u4fe1\u606f")
    @ResponseBody
    public DisDpriceSubReDomain getDpriceSub(Integer dpriceSubId) {
        if (StringUtils.isBlank((Integer)dpriceSubId)) {
            this.logger.error(CODE + ".getDpriceSub", (Object)"param is null");
            return null;
        }
        return this.disDpriceSubServiceRepository.getDpriceSub(dpriceSubId);
    }

    @RequestMapping(value={"updateDpriceSub.json"}, name="\u66f4\u65b0\u6e20\u9053\u5546\u54c1\u4ef7\u683c\u7ec4")
    @ResponseBody
    public HtmlJsonReBean updateDpriceSub(HttpServletRequest request, DisDpriceSubDomain dpriceSubDomain) {
        if (null == dpriceSubDomain) {
            this.logger.error(CODE + ".updateDpriceSub", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        dpriceSubDomain.setTenantCode(this.getTenantCode(request));
        return this.disDpriceSubServiceRepository.updateDpriceSub(dpriceSubDomain);
    }

    @RequestMapping(value={"deleteDpriceSub.json"}, name="\u5220\u9664\u6e20\u9053\u5546\u54c1\u4ef7\u683c\u7ec4")
    @ResponseBody
    public HtmlJsonReBean deleteDpriceSub(Integer dpriceSubId) {
        if (StringUtils.isBlank((Integer)dpriceSubId)) {
            this.logger.error(CODE + ".deleteDpriceSub", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDpriceSubServiceRepository.deleteDpriceSub(dpriceSubId);
    }

    @RequestMapping(value={"queryDpriceSubPage.json"}, name="\u67e5\u8be2\u6e20\u9053\u5546\u54c1\u4ef7\u683c\u7ec4\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisDpriceSubReDomain> queryDpriceSubPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.disDpriceSubServiceRepository.queryDpriceSubPage(param);
    }

    @RequestMapping(value={"updateDpriceSubState.json"}, name="\u66f4\u65b0\u6e20\u9053\u5546\u54c1\u4ef7\u683c\u7ec4\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateDpriceSubState(String dpriceSubId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)dpriceSubId)) {
            this.logger.error(CODE + ".updateDpriceSubState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDpriceSubServiceRepository.updateDpriceSubState(Integer.valueOf(dpriceSubId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"resetDisPriceSub.json"}, name="\u66f4\u65b0\u7279\u4ef7")
    @ResponseBody
    public HtmlJsonReBean resetDisPriceSub(HttpServletRequest request, String channelCodeStr, String skuNoStr) {
        if (StringUtils.isBlank((String)skuNoStr)) {
            this.logger.error(CODE + ".resetDisPriceSub", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "skuNoStr is null");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantCode", tenantCode);
        params.put("channelCodeStr", channelCodeStr);
        params.put("skuNoStr", skuNoStr);
        params.put("dataState", DisConstants.PRICE_SUB_STATE_0);
        params.put("pricesetNprice", BigDecimal.ZERO);
        return this.disDpriceSubServiceRepository.resetDisPriceSub(params);
    }
}

