/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.eq.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.eq.domain.EqAuctionEnrollDomain;
import com.qjsoft.laser.controller.facade.eq.domain.EqAuctionEnrollReDomain;
import com.qjsoft.laser.controller.facade.eq.domain.EqAuctionReDomain;
import com.qjsoft.laser.controller.facade.eq.repository.EqAuctionEnrollServiceRepository;
import com.qjsoft.laser.controller.facade.eq.repository.EqAuctionEnrollfileServiceRepository;
import com.qjsoft.laser.controller.facade.eq.repository.EqAuctionGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.eq.repository.EqAuctionServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/eq/auctionEnroll"}, name="\u8be2\u4ef7\u62a5\u4ef7\u7528\u6237")
public class AuctionEnrollCon
extends SpringmvcController {
    private static String CODE = "eq.auctionEnroll.con";
    @Autowired
    private EqAuctionGoodsServiceRepository eqAuctionGoodsServiceRepository;
    @Autowired
    private EqAuctionServiceRepository eqAuctionServiceRepository;
    @Autowired
    private EqAuctionEnrollfileServiceRepository eqAuctionEnrollfileServiceRepository;
    @Autowired
    private EqAuctionEnrollServiceRepository eqAuctionEnrollServiceRepository;

    protected String getContext() {
        return "auctionEnroll";
    }

    @RequestMapping(value={"saveAuctionEnroll.json"}, name="\u589e\u52a0\u8be2\u4ef7\u62a5\u4ef7\u7528\u6237")
    @ResponseBody
    public HtmlJsonReBean saveAuctionEnroll(HttpServletRequest request, String paramStr) {
        UserSession userSession;
        this.logger.error(CODE + ".paramStr", (Object)paramStr);
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".saveAuctionEnroll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        EqAuctionEnrollReDomain eqAuctionEnrollReDomain = (EqAuctionEnrollReDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, EqAuctionEnrollReDomain.class);
        if (null == eqAuctionEnrollReDomain) {
            this.logger.error(CODE + ".eqAuctionEnrollReDomain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (null != eqAuctionEnrollReDomain) {
            eqAuctionEnrollReDomain.setTenantCode(this.getTenantCode(request));
        }
        if (null != (userSession = this.getUserSession(request))) {
            eqAuctionEnrollReDomain.setMemberCname(userSession.getUserRelname());
            eqAuctionEnrollReDomain.setMemberCcode(userSession.getUserPcode());
        }
        return this.eqAuctionEnrollServiceRepository.saveAuctionEnroll(eqAuctionEnrollReDomain);
    }

    @RequestMapping(value={"getAuctionEnroll.json"}, name="\u83b7\u53d6\u8be2\u4ef7\u62a5\u4ef7\u7528\u6237\u4fe1\u606f")
    @ResponseBody
    public EqAuctionEnrollReDomain getAuctionEnroll(Integer auctionEnrollId) {
        if (StringUtils.isBlank((Integer)auctionEnrollId)) {
            this.logger.error(CODE + ".getAuctionEnroll", (Object)"param is null");
            return null;
        }
        EqAuctionEnrollReDomain eqAuctionEnrollReDomain = this.eqAuctionEnrollServiceRepository.getAuctionEnroll(auctionEnrollId);
        if (eqAuctionEnrollReDomain != null) {
            EqAuctionReDomain auctionByCode;
            SupQueryResult goodsList;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("auctionEnrollCode", eqAuctionEnrollReDomain.getAuctionEnrollCode());
            map.put("tenantCode", eqAuctionEnrollReDomain.getTenantCode());
            SupQueryResult fileList = this.eqAuctionEnrollfileServiceRepository.queryAuctionEnrollfilePage(map);
            if (fileList != null && !fileList.getList().isEmpty()) {
                eqAuctionEnrollReDomain.setEqAuctionEnrollfileDomainList(fileList.getList());
            }
            if ((goodsList = this.eqAuctionGoodsServiceRepository.queryAuctionGoodsPage(map)) != null && !goodsList.getList().isEmpty()) {
                eqAuctionEnrollReDomain.setEqAuctionGoodsDomainList(goodsList.getList());
            }
            if ((auctionByCode = this.eqAuctionServiceRepository.getAuctionByCode(eqAuctionEnrollReDomain.getTenantCode(), eqAuctionEnrollReDomain.getAuctionCode())) != null) {
                eqAuctionEnrollReDomain.setAuctionSupplierCode(auctionByCode.getInvoiceType());
                eqAuctionEnrollReDomain.setAuctionSupplierName(auctionByCode.getInvoiceTaxRate());
                eqAuctionEnrollReDomain.setAuctionPriceType(auctionByCode.getAuctionBrand());
            }
        }
        return eqAuctionEnrollReDomain;
    }

    @RequestMapping(value={"updateAuctionEnroll.json"}, name="\u66f4\u65b0\u8be2\u4ef7\u62a5\u4ef7\u7528\u6237")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnroll(HttpServletRequest request, EqAuctionEnrollDomain eqAuctionEnrollDomain) {
        if (null == eqAuctionEnrollDomain) {
            this.logger.error(CODE + ".updateAuctionEnroll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        eqAuctionEnrollDomain.setTenantCode(this.getTenantCode(request));
        return this.eqAuctionEnrollServiceRepository.updateAuctionEnroll(eqAuctionEnrollDomain);
    }

    @RequestMapping(value={"deleteAuctionEnroll.json"}, name="\u5220\u9664\u8be2\u4ef7\u62a5\u4ef7\u7528\u6237")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionEnroll(Integer auctionEnrollId) {
        if (StringUtils.isBlank((Integer)auctionEnrollId)) {
            this.logger.error(CODE + ".deleteAuctionEnroll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.eqAuctionEnrollServiceRepository.deleteAuctionEnroll(auctionEnrollId);
    }

    @RequestMapping(value={"deleteAuctionEnrollByCode.json"}, name="\u5220\u9664\u8be2\u4ef7\u62a5\u4ef7\u7528\u6237")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionEnrollByCode(HttpServletRequest request, String auctionEnrollCode) {
        if (StringUtils.isBlank((String)auctionEnrollCode)) {
            this.logger.error(CODE + ".deleteAuctionEnrollByCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.eqAuctionEnrollServiceRepository.deleteAuctionEnrollByCode(this.getTenantCode(request), auctionEnrollCode);
    }

    @RequestMapping(value={"queryAuctionEnrollPage.json"}, name="\u67e5\u8be2\u8be2\u4ef7\u62a5\u4ef7\u7528\u6237\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<EqAuctionEnrollReDomain> queryAuctionEnrollPage(HttpServletRequest request) {
        SupQueryResult eqAuctionEnrollReDomain;
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        String userinfoCode = userSession.getUserPcode();
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("memberCcode", userinfoCode);
            param.put("colName1", "DATA_STATE");
            param.put("colValue1", param.get("dataStateStr"));
            param.remove("dataStateStr");
        }
        if ((eqAuctionEnrollReDomain = this.eqAuctionEnrollServiceRepository.queryAuctionEnrollPage(param)) != null && !eqAuctionEnrollReDomain.getList().isEmpty()) {
            for (EqAuctionEnrollReDomain eq : eqAuctionEnrollReDomain.getList()) {
                SupQueryResult goodsList;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("auctionEnrollCode", eq.getAuctionEnrollCode());
                map.put("tenantCode", eq.getTenantCode());
                EqAuctionReDomain auctionByCode = this.eqAuctionServiceRepository.getAuctionByCode(eq.getTenantCode(), eq.getAuctionCode());
                if (auctionByCode == null) continue;
                eq.setAuctionDataState(auctionByCode.getDataState());
                SupQueryResult fileList = this.eqAuctionEnrollfileServiceRepository.queryAuctionEnrollfilePage(map);
                if (fileList != null && !fileList.getList().isEmpty()) {
                    eq.setEqAuctionEnrollfileDomainList(fileList.getList());
                }
                if ((goodsList = this.eqAuctionGoodsServiceRepository.queryAuctionGoodsPage(map)) == null || goodsList.getList().isEmpty()) continue;
                eq.setEqAuctionGoodsDomainList(goodsList.getList());
            }
        }
        return eqAuctionEnrollReDomain;
    }

    @RequestMapping(value={"updateAuctionEnrollState.json"}, name="\u66f4\u65b0\u8be2\u4ef7\u62a5\u4ef7\u7528\u6237\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollState(String auctionEnrollId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)auctionEnrollId)) {
            this.logger.error(CODE + ".updateAuctionEnrollState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.eqAuctionEnrollServiceRepository.updateAuctionEnrollState(Integer.valueOf(auctionEnrollId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"updateAuctionEnrollStateAndMemo.json"}, name="\u66f4\u65b0\u8be2\u4ef7\u62a5\u4ef7\u7528\u6237\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollStateAndMemo(String auctionEnrollId, Integer dataState, Integer oldDataState, String memo) {
        if (StringUtils.isBlank((String)auctionEnrollId)) {
            this.logger.error(CODE + ".updateAuctionEnrollStateAndMemo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memo", memo);
        return this.eqAuctionEnrollServiceRepository.updateAuctionEnrollState(Integer.valueOf(auctionEnrollId), dataState, oldDataState, map);
    }

    @RequestMapping(value={"updateAuctionEnrollData.json"}, name="\u66f4\u65b0\u8be2\u4ef7\u62a5\u4ef7\u7528\u6237")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollData(HttpServletRequest request, EqAuctionEnrollDomain eqAuctionEnrollDomain) {
        if (null == eqAuctionEnrollDomain || null == eqAuctionEnrollDomain.getAuctionEnrollId()) {
            this.logger.error(CODE + ".updateAuctionEnrollData.param is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)eqAuctionEnrollDomain));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        EqAuctionEnrollReDomain auctionEnroll = this.eqAuctionEnrollServiceRepository.getAuctionEnroll(eqAuctionEnrollDomain.getAuctionEnrollId());
        if (auctionEnroll == null) {
            this.logger.error(CODE + ".updateAuctionEnrollData auctionEnroll is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)eqAuctionEnrollDomain));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u627e\u4e0d\u5230\u62a5\u4ef7\u4fe1\u606f");
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)auctionEnroll, (Object)eqAuctionEnrollDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.eqAuctionEnrollServiceRepository.updateAuctionEnroll((EqAuctionEnrollDomain)auctionEnroll);
    }
}

