/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.express.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.core.util.HtmlUtil;
import com.qjsoft.laser.controller.facade.wl.domain.WlExpressDomain;
import com.qjsoft.laser.controller.facade.wl.domain.WlExpressReDomain;
import com.qjsoft.laser.controller.facade.wl.repository.WlExpressServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/wl/express"}, name="\u7269\u6d41\u670d\u52a1")
public class ExpressCon
extends SpringmvcController {
    private static String CODE = "wl.express.con";
    @Autowired
    private WlExpressServiceRepository wlExpressServiceRepository;

    protected String getContext() {
        return "express";
    }

    @RequestMapping(value={"saveExpress.json"}, name="\u589e\u52a0\u7269\u6d41\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveExpress(HttpServletRequest request, WlExpressDomain wlExpressDomain) {
        if (null == wlExpressDomain) {
            this.logger.error(CODE + ".saveExpress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        wlExpressDomain.setTenantCode(this.getTenantCode(request));
        return this.wlExpressServiceRepository.saveExpress(wlExpressDomain);
    }

    @RequestMapping(value={"getExpress.json"}, name="\u83b7\u53d6\u7269\u6d41\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public WlExpressReDomain getExpress(String expressId) {
        if (StringUtils.isBlank((String)expressId)) {
            this.logger.error(CODE + ".getExpress", (Object)"param is null");
            return null;
        }
        return this.wlExpressServiceRepository.getExpress(Integer.valueOf(expressId));
    }

    @RequestMapping(value={"updateExpress.json"}, name="\u66f4\u65b0\u7269\u6d41\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateExpress(HttpServletRequest request, WlExpressDomain wlExpressDomain) {
        if (null == wlExpressDomain) {
            this.logger.error(CODE + ".updateExpress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        wlExpressDomain.setTenantCode(this.getTenantCode(request));
        return this.wlExpressServiceRepository.updateExpress(wlExpressDomain);
    }

    @RequestMapping(value={"deleteExpress.json"}, name="\u5220\u9664\u7269\u6d41\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteExpress(String expressId) {
        if (StringUtils.isBlank((String)expressId)) {
            this.logger.error(CODE + ".deleteExpress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.wlExpressServiceRepository.deleteExpress(Integer.valueOf(expressId));
    }

    @RequestMapping(value={"queryExpressPage.json"}, name="\u67e5\u8be2\u7269\u6d41\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WlExpressReDomain> queryExpressPage(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.wlExpressServiceRepository.queryExpressPage(param);
    }

    @RequestMapping(value={"updateExpressState.json"}, name="\u66f4\u65b0\u7269\u6d41\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateExpressState(String expressId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)expressId)) {
            this.logger.error(CODE + ".updateExpressState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.wlExpressServiceRepository.updateExpressState(Integer.valueOf(expressId), dataState, oldDataState);
    }

    @RequestMapping(value={"deleteExpressBatch.json"}, name="\u6279\u91cf\u5220\u9664\u7269\u6d41\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteExpressBatch(String expressIds) {
        String[] ids;
        if (StringUtils.isBlank((String)expressIds)) {
            this.logger.error(CODE + ".deleteExpress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String id : ids = expressIds.split(",")) {
            if (id == null) continue;
            this.wlExpressServiceRepository.deleteExpress(Integer.valueOf(id));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"execLookExpress.json"}, name="\u6839\u636e\u5feb\u9012\u516c\u53f8\u7f16\u53f7\u548c\u8fd0\u5355\u7f16\u53f7\u67e5\u8be2\u5feb\u9012\u4fe1\u606f")
    @ResponseBody
    public String execLookExpress(HttpServletRequest request) {
        String expressType = request.getParameter("expressType");
        String expressNo = request.getParameter("expressNo");
        return this.queryExpressInfo(expressType, expressNo);
    }

    @RequestMapping(value={"queryExpressPageForProp.json"}, name="\u5546\u5bb6\u67e5\u8be2\u7269\u6d41\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WlExpressReDomain> queryExpressPageForProp(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("orderStr", "DATA_STATE DESC");
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.wlExpressServiceRepository.queryExpressPage(param);
    }

    private String queryExpressInfo(String expressType, String expressNo) {
        try {
            URL url = new URL("https://www.kuaidi100.com/query?type=" + expressType + "&postid=" + expressNo);
            URLConnection con = url.openConnection();
            con.setAllowUserInteraction(false);
            InputStream urlStream = url.openStream();
            String type = URLConnection.guessContentTypeFromStream(urlStream);
            String charSet = null;
            if (type == null) {
                type = con.getContentType();
            }
            if (type == null || type.trim().length() == 0 || !type.trim().contains("text/html")) {
                return "";
            }
            if (type.indexOf("charset=") > 0) {
                charSet = type.substring(type.indexOf("charset=") + 8);
            }
            byte[] b = new byte[10000];
            int numRead = urlStream.read(b);
            StringBuilder content = new StringBuilder(new String(b, 0, numRead));
            while (numRead != -1) {
                numRead = urlStream.read(b);
                if (numRead == -1) continue;
                String newContent = new String(b, 0, numRead, charSet);
                content.append(newContent);
            }
            urlStream.close();
            return content.toString();
        }
        catch (IOException e) {
            this.logger.error(CODE + ".queryExpressInfo", (Throwable)e);
            return "";
        }
    }
}

