/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.express.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.wl.domain.WlExporgDomain;
import com.qjsoft.laser.controller.facade.wl.domain.WlExporgReDomain;
import com.qjsoft.laser.controller.facade.wl.domain.WlTraceDomain;
import com.qjsoft.laser.controller.facade.wl.domain.WlTraceReDomain;
import com.qjsoft.laser.controller.facade.wl.domain.kdniao.bean.KdniaoPush;
import com.qjsoft.laser.controller.facade.wl.domain.kdniao.bean.KdniaoResponse;
import com.qjsoft.laser.controller.facade.wl.repository.WlExporgServiceRepository;
import com.qjsoft.laser.controller.facade.wl.repository.WlThirdServiceRepository;
import com.qjsoft.laser.controller.facade.wl.repository.WlTraceServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/wl/exporg"}, name="\u7269\u6d41\u63a5\u53e3\u670d\u52a1")
public class ExporgCon
extends SpringmvcController {
    private static String CODE = "wl.exporg.con";
    @Autowired
    private WlExporgServiceRepository wlExporgServiceRepository;
    @Autowired
    private WlThirdServiceRepository wlThirdServiceRepository;
    @Autowired
    private WlTraceServiceRepository wlTraceServiceRepository;

    protected String getContext() {
        return "exporg";
    }

    @RequestMapping(value={"saveExporg.json"}, name="\u589e\u52a0\u7269\u6d41\u63a5\u53e3\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveExporg(HttpServletRequest request, WlExporgDomain wlExporgDomain) {
        if (null == wlExporgDomain) {
            this.logger.error(CODE + ".saveExporg", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        wlExporgDomain.setTenantCode(this.getTenantCode(request));
        return this.wlExporgServiceRepository.saveExporg(wlExporgDomain);
    }

    @RequestMapping(value={"getExporg.json"}, name="\u83b7\u53d6\u7269\u6d41\u63a5\u53e3\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public WlExporgReDomain getExporg(Integer exporgId) {
        if (StringUtils.isBlank((Integer)exporgId)) {
            this.logger.error(CODE + ".getExporg", (Object)"param is null");
            return null;
        }
        return this.wlExporgServiceRepository.getExporg(exporgId);
    }

    @RequestMapping(value={"updateExporg.json"}, name="\u66f4\u65b0\u7269\u6d41\u63a5\u53e3\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateExporg(HttpServletRequest request, WlExporgDomain wlExporgDomain) {
        if (null == wlExporgDomain) {
            this.logger.error(CODE + ".updateExporg", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        wlExporgDomain.setTenantCode(this.getTenantCode(request));
        return this.wlExporgServiceRepository.updateExporg(wlExporgDomain);
    }

    @RequestMapping(value={"deleteExporg.json"}, name="\u5220\u9664\u7269\u6d41\u63a5\u53e3\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteExporg(Integer exporgId) {
        if (StringUtils.isBlank((Integer)exporgId)) {
            this.logger.error(CODE + ".deleteExporg", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.wlExporgServiceRepository.deleteExporg(exporgId);
    }

    @RequestMapping(value={"queryExpressInfo.json"}, name="\u67e5\u8be2\u7269\u6d41\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean queryExpressInfo(HttpServletRequest request, String expressType, String expressNo) {
        return this.queryExpInfo(request, expressType, expressNo);
    }

    @RequestMapping(value={"queryExpressInfoForC.json"}, name="\u67e5\u8be2\u7269\u6d41\u4fe1\u606f-C\u7aef")
    @ResponseBody
    public HtmlJsonReBean queryExpressInfoForC(HttpServletRequest request, String expressType, String expressNo) {
        return this.queryExpInfo(request, expressType, expressNo);
    }

    private HtmlJsonReBean queryExpInfo(HttpServletRequest request, String expressType, String expressNo) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.wlExporgServiceRepository.queryExpInfo(expressType, expressNo, this.getTenantCode(request));
    }

    @RequestMapping(value={"updateExporgState.json"}, name="\u66f4\u65b0\u7269\u6d41\u63a5\u53e3\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateExporgState(String exporgId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)exporgId)) {
            this.logger.error(CODE + ".updateExporgState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.wlExporgServiceRepository.updateExporgState(Integer.valueOf(exporgId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryExporgPage.json"}, name="\u67e5\u8be2\u7269\u6d41\u63a5\u53e3\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WlExporgReDomain> queryExporgPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.wlExporgServiceRepository.queryExporgPage(param);
    }

    @RequestMapping(value={"queryExpressInfoKdniao.json"}, name="\u901a\u8fc7\u5feb\u9012\u9e1f\u67e5\u8be2\u7269\u6d41\u4fe1\u606f")
    @ResponseBody
    public WlTraceReDomain queryExpressInfoKdniao(HttpServletRequest request, String expressType, String expressNo) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", false);
        }
        param.put("expressCode", expressType);
        param.put("traceBillno", expressNo);
        String traceRMobile = (String)param.get("traceRMobile");
        WlTraceReDomain wlTrace = this.wlTraceServiceRepository.getTraceByCode(param);
        if (null == wlTrace) {
            this.logger.error("----\u65e0\u8be5\u6761\u6570\u636e------");
            wlTrace = new WlTraceReDomain();
            wlTrace.setExpressCode(expressType);
            wlTrace.setTraceBillno(expressNo);
            wlTrace.setExpressName("\u4e2d\u901a");
            UserSession userSession = this.getUserSession(request);
            wlTrace.setUserCode(userSession.getUserCode());
            wlTrace.setTraceRMobile(traceRMobile);
            wlTrace.setTenantCode(this.getTenantCode(request));
            this.wlTraceServiceRepository.insertTrace((WlTraceDomain)wlTrace);
            WlTraceReDomain wlTraceResult = this.wlThirdServiceRepository.orderKdniao(expressType, expressNo, this.getTenantCode(request));
            try {
                BeanUtils.copyAllPropertysNotNull((Object)wlTrace, (Object)wlTraceResult);
            }
            catch (Exception e) {
                this.logger.error("queryExpressInfoKdniao-copyAllPropertysNotNull", (Throwable)e);
            }
            if (null == wlTrace) {
                this.logger.error("orderKdniao\u8fd4\u56de\u503c=======", (Object)"wlTrace\u4e3a\u7a7a");
            }
            return wlTrace;
        }
        if (wlTrace.getDataState() != 2) {
            this.logger.error("----\u672a\u8ba2\u9605------");
            WlTraceReDomain wlTraceResult = this.wlThirdServiceRepository.orderKdniao(expressType, expressNo, this.getTenantCode(request));
            try {
                BeanUtils.copyAllPropertysNotNull((Object)wlTrace, (Object)wlTraceResult);
            }
            catch (Exception e) {
                this.logger.error("queryExpressInfoKdniao-copyAllPropertysNotNull", (Throwable)e);
            }
            if (null == wlTrace) {
                this.logger.error("orderKdniao\u8fd4\u56de\u503c=======", (Object)"wlTrace\u4e3a\u7a7a");
            }
            return wlTrace;
        }
        String traceResult = this.wlThirdServiceRepository.getThirdTraceByCode(this.getTenantCode(request), expressType, expressNo);
        wlTrace.setTraceDynamic(traceResult);
        return wlTrace;
    }

    @RequestMapping(value={"pushTraces.json"}, name="\u5feb\u9012\u9e1f\u63a8\u9001\u63a5\u53e3")
    @ResponseBody
    public void pushTraces(String RequestData, HttpServletResponse response) {
        if (StringUtils.isBlank((String)RequestData)) {
            this.logger.error("pushTraces", (Object)("param is null  \u3010RequestData-----" + RequestData + "\u3011"));
        } else {
            KdniaoPush kdniaoPush = (KdniaoPush)JsonUtil.buildNormalBinder().getJsonToObject(RequestData, KdniaoPush.class);
            List data = kdniaoPush.getData();
            WlTraceReDomain wlTrace = new WlTraceReDomain();
            ArrayList<WlTraceReDomain> traceList = new ArrayList<WlTraceReDomain>();
            ArrayList traces = new ArrayList();
            for (KdniaoResponse kdniaoResponse : data) {
                List list = kdniaoResponse.getTraces();
                if (list != null && !list.isEmpty()) {
                    for (int i = list.size() - 1; i > -1; --i) {
                        traces.add(list.get(i));
                    }
                }
                kdniaoResponse.setTraces(traces);
                String jsonTrace = JsonUtil.buildNormalBinder().toJson((Object)kdniaoResponse);
                wlTrace.setTraceBillno(kdniaoResponse.getLogisticCode());
                wlTrace.setExpressCode(kdniaoResponse.getShipperCode());
                wlTrace.setTraceDynamic(jsonTrace);
                traceList.add(wlTrace);
                traces.clear();
            }
            this.wlTraceServiceRepository.updateTraceList(traceList);
            String EBusinessID = kdniaoPush.getEBusinessID();
            SimpleDateFormat sdf = new SimpleDateFormat();
            sdf.applyPattern("yyyy-MM-dd HH:mm:ss");
            Date date = new Date();
            String responseResult = "{\"EBusinessID\":\"" + EBusinessID + "\",\"UpdateTime\":\"" + sdf.format(date) + "\",\"Success\":true,\"Reason\":\"\"}";
            try {
                response.getWriter().write(responseResult);
            }
            catch (IOException e) {
                this.logger.error("\u5411\u5feb\u9012\u9e1f\u53d1\u9001\u54cd\u5e94\u5931\u8d25", (Throwable)e);
            }
        }
    }
}

