/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.facade.crms.repository;

import com.qjsoft.laser.controller.common.bean.DisChannel;
import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.common.send.SupperFacade;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.crms.domain.CrmsSOrderDomain;
import com.qjsoft.laser.controller.facade.crms.domain.CrmsSOrderGoodsDomain;
import com.qjsoft.laser.controller.facade.crms.domain.CrmsSOrderReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingGoodsReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.PackageDomain;
import com.qjsoft.laser.controller.facade.oc.domain.SkuDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcShoppingServiceRepository;
import com.qjsoft.laser.controller.facade.org.domain.OrgUserBean;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.RandomUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CrmsSOrderServiceRepository
extends SupperFacade {
    private static String CODE = "crms.CrmsSOrderServiceRepository";
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private OcShoppingServiceRepository ocShoppingServiceRepository;
    private Object UUIDLock = new Object();

    public HtmlJsonReBean saveSOrderBatch(List<CrmsSOrderDomain> crmsSOrderDomainList) {
        PostParamMap pmap = new PostParamMap("crms.sorder.saveSOrderBatch");
        pmap.putParamToJson("crmsSOrderDomainList", crmsSOrderDomainList);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public CrmsSOrderReDomain getSOrder(Integer sorderId) {
        PostParamMap pmap = new PostParamMap("crms.sorder.getSOrder");
        pmap.putParam("sorderId", (Object)sorderId);
        return (CrmsSOrderReDomain)this.htmlIBaseService.senReObject(pmap, CrmsSOrderReDomain.class);
    }

    public HtmlJsonReBean updateSOrder(CrmsSOrderDomain crmsSOrderDomain) {
        PostParamMap pmap = new PostParamMap("crms.sorder.updateSOrder");
        pmap.putParamToJson("crmsSOrderDomain", (Object)crmsSOrderDomain);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean deleteSOrder(Integer sorderId) {
        PostParamMap pmap = new PostParamMap("crms.sorder.deleteSOrder");
        pmap.putParam("sorderId", (Object)sorderId);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public SupQueryResult<CrmsSOrderReDomain> querySOrderPage(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("crms.sorder.querySOrderPage");
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendReSupObject(pmap, CrmsSOrderReDomain.class);
    }

    public HtmlJsonReBean saveSOrder(CrmsSOrderDomain crmsSOrderDomain) {
        PostParamMap pmap = new PostParamMap("crms.sorder.saveSOrder");
        pmap.putParamToJson("crmsSOrderDomain", (Object)crmsSOrderDomain);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean createOrder(List<CrmsSOrderDomain> crmsSOrderDomainList, String contractType, UserSession userSession, String proappCode, String oauthEnvCode, OrgUserBean orgUserBean, String contractProperty) {
        if (ListUtil.isEmpty(crmsSOrderDomainList) || null == userSession) {
            this.logger.error(CODE + ".createOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ArrayList<CrmsSOrderDomain> crmsSOrderDomains = new ArrayList<CrmsSOrderDomain>();
        ArrayList shoppingGoodsIdList = new ArrayList();
        for (CrmsSOrderDomain orderDomain : crmsSOrderDomainList) {
            CrmsSOrderDomain crmsSOrderDomain;
            try {
                crmsSOrderDomain = this.makeContractDomain(orderDomain, contractType, userSession, proappCode, orgUserBean);
                if (null == crmsSOrderDomain) {
                    this.logger.error(CODE + ".createOrder.contractDomain");
                    return new HtmlJsonReBean((Object)(CODE + ".saveContract.contractDomain"));
                }
                if (StringUtils.isNotBlank((String)contractProperty)) {
                    crmsSOrderDomain.setContractProperty(contractProperty);
                }
                if (StringUtils.isBlank((String)crmsSOrderDomain.getContractProperty())) {
                    crmsSOrderDomain.setContractProperty("0");
                }
                for (PackageDomain packageDomain : orderDomain.getPackageList()) {
                    List<CrmsSOrderGoodsDomain> crmsSOrderGoodsDomainList = this.makePackageDomain(packageDomain, crmsSOrderDomain);
                    crmsSOrderDomain.getCrmsSOrderGoodsDomainList().addAll(crmsSOrderGoodsDomainList);
                    if (null == shoppingGoodsIdList || null == packageDomain.getShoppingGoodsIdList()) continue;
                    shoppingGoodsIdList.addAll(packageDomain.getShoppingGoodsIdList());
                }
            }
            catch (Exception e) {
                this.logger.error(CODE + ".createOrder.ex", (Throwable)e);
                return new HtmlJsonReBean(CODE + ".saveContract.ex", e.getMessage());
            }
            HtmlJsonReBean htmlJsonReBean = this.calculateContract(crmsSOrderDomain);
            if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
                return htmlJsonReBean;
            }
            crmsSOrderDomains.add(crmsSOrderDomain);
        }
        HtmlJsonReBean htmlJsonReBean = null;
        HashMap<String, String> result = new HashMap<String, String>();
        if (crmsSOrderDomains.size() > 1) {
            htmlJsonReBean = this.saveSOrderBatch(crmsSOrderDomains);
            if (null != htmlJsonReBean && htmlJsonReBean.isSuccess() && null != htmlJsonReBean.getDataObj()) {
                result.put("contractBbillcode", htmlJsonReBean.getDataObj().toString());
                if (shoppingGoodsIdList != null && shoppingGoodsIdList.size() > 0) {
                    this.ocShoppingServiceRepository.deleteShoppingGoodsBatch(shoppingGoodsIdList);
                }
            }
        } else {
            htmlJsonReBean = this.saveSOrder((CrmsSOrderDomain)crmsSOrderDomains.get(0));
            if (null != htmlJsonReBean && htmlJsonReBean.isSuccess() && null != htmlJsonReBean.getDataObj()) {
                result.put("contractBillcode", htmlJsonReBean.getDataObj().toString());
                if (shoppingGoodsIdList != null && shoppingGoodsIdList.size() > 0) {
                    this.ocShoppingServiceRepository.deleteShoppingGoodsBatch(shoppingGoodsIdList);
                }
            }
        }
        htmlJsonReBean.setDataObj(result);
        return htmlJsonReBean;
    }

    public HtmlJsonReBean calculateContract(CrmsSOrderDomain contractDomain) {
        BigDecimal goodsNum = BigDecimal.ZERO;
        BigDecimal goodsWeight = BigDecimal.ZERO;
        BigDecimal contractInmoney = BigDecimal.ZERO;
        BigDecimal contractMoney = BigDecimal.ZERO;
        BigDecimal dataBnum = BigDecimal.ZERO;
        BigDecimal dataBweight = BigDecimal.ZERO;
        BigDecimal goodsLogmoney = BigDecimal.ZERO;
        BigDecimal pefMoney = BigDecimal.ZERO;
        String memberCode = "";
        boolean teflag = false;
        for (PackageDomain ocPackageDomain : contractDomain.getPackageList()) {
            if (StringUtils.isBlank((String)memberCode)) {
                memberCode = ocPackageDomain.getMemberCode();
            } else if (!memberCode.equals(ocPackageDomain.getMemberCode())) {
                teflag = true;
            }
            contractDomain.setMemberCode(ocPackageDomain.getMemberCode());
            contractDomain.setMemberName(ocPackageDomain.getMemberName());
            if (null == ocPackageDomain.getGoodsNum()) {
                ocPackageDomain.setGoodsNum(BigDecimal.ZERO);
            }
            goodsNum = goodsNum.add(ocPackageDomain.getGoodsNum());
            if (null == ocPackageDomain.getGoodsWeight()) {
                ocPackageDomain.setGoodsWeight(BigDecimal.ZERO);
            }
            goodsWeight = goodsWeight.add(ocPackageDomain.getGoodsWeight());
            if (null == ocPackageDomain.getGoodsMoney()) {
                ocPackageDomain.setGoodsMoney(BigDecimal.ZERO);
            }
            contractInmoney = contractInmoney.add(ocPackageDomain.getGoodsMoney());
            goodsLogmoney = goodsLogmoney.add(new BigDecimal(ocPackageDomain.getPackageFare()));
            if (null == ocPackageDomain.getGoodsPmoney()) {
                ocPackageDomain.setGoodsPmoney(BigDecimal.ZERO);
            }
            contractMoney = contractMoney.add(ocPackageDomain.getGoodsPmoney());
            if (null == ocPackageDomain.getPricesetRefrice()) {
                ocPackageDomain.setPricesetRefrice(BigDecimal.ZERO);
            }
            pefMoney = pefMoney.add(ocPackageDomain.getPricesetRefrice());
        }
        if (ListUtil.isNotEmpty(contractDomain.getPackageList()) && contractDomain.getPackageList().size() == 1 && StringUtils.isBlank((String)contractDomain.getContractRemark())) {
            contractDomain.setContractRemark(contractDomain.getPackageList().get(0).getPackageRemark());
        }
        dataBnum = goodsNum;
        dataBweight = goodsWeight;
        if (null == contractDomain.getContractPaymoney()) {
            contractDomain.setContractPaymoney(BigDecimal.ZERO);
        }
        contractDomain.setPricesetRefrice(pefMoney);
        contractDomain.setGoodsNum(goodsNum);
        contractDomain.setGoodsWeight(goodsWeight);
        contractDomain.setContractInmoney(contractInmoney);
        contractDomain.setGoodsMoney(contractMoney);
        contractDomain.setContractMoney(contractMoney.add(goodsLogmoney));
        contractDomain.setDataBnum(dataBnum);
        contractDomain.setDataBweight(dataBweight);
        if ("06".equals(contractDomain.getContractType()) || "28".equals(contractDomain.getContractType())) {
            contractDomain.setDataBmoney(contractMoney.add(goodsLogmoney).add(contractDomain.getContractPaymoney()));
        } else {
            contractDomain.setDataBmoney(contractMoney.add(goodsLogmoney).add(pefMoney).add(contractDomain.getContractPaymoney()));
        }
        contractDomain.setGoodsLogmoney(goodsLogmoney);
        contractDomain.setGoodsPmoney(contractInmoney.subtract(contractMoney));
        if (teflag) {
            if (StringUtils.isNotBlank((String)contractDomain.getChannelCode())) {
                DisChannel disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-channelCode", (String)(contractDomain.getChannelCode() + "-" + contractDomain.getTenantCode()), DisChannel.class);
                if (null != disChannel) {
                    contractDomain.setMemberCode(disChannel.getMemberCode());
                    contractDomain.setMemberName(disChannel.getMemberName());
                } else {
                    contractDomain.setMemberCode(SupDisUtil.getMap((String)"tmtenant-user-code", (String)contractDomain.getTenantCode()));
                    contractDomain.setMemberName(SupDisUtil.getMap((String)"tmtenant-user-code", (String)contractDomain.getTenantCode()));
                }
            } else {
                contractDomain.setMemberCode(SupDisUtil.getMap((String)"tmtenant-user-code", (String)contractDomain.getTenantCode()));
                contractDomain.setMemberName(SupDisUtil.getMap((String)"tmtenant-user-code", (String)contractDomain.getTenantCode()));
            }
        }
        return new HtmlJsonReBean();
    }

    private List<CrmsSOrderGoodsDomain> makePackageDomain(PackageDomain packageDomain, CrmsSOrderDomain ocContractDomain) throws Exception {
        if (null == packageDomain || null == ocContractDomain) {
            return null;
        }
        ArrayList<CrmsSOrderGoodsDomain> crmsSOrderGoodsDomainList = new ArrayList<CrmsSOrderGoodsDomain>();
        ArrayList<OcContractGoodsDomain> contractGoodsList = new ArrayList<OcContractGoodsDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : packageDomain.getContractGoodsList()) {
            ocContractGoodsDomain.setContractGoodsCode(this.createUUIDString());
            ocContractGoodsDomain.setPackageCode(packageDomain.getPackageCode());
            ocContractGoodsDomain.setGoodsOrdnum(ocContractGoodsDomain.getGoodsCamount());
            ocContractGoodsDomain.setGoodsOrdweight(ocContractGoodsDomain.getGoodsCweight());
            ocContractGoodsDomain.setGoodsNum(ocContractGoodsDomain.getGoodsCamount());
            ocContractGoodsDomain.setGoodsWeight(ocContractGoodsDomain.getGoodsCweight());
            if (null == ocContractGoodsDomain.getPricesetRefrice()) {
                ocContractGoodsDomain.setPricesetRefrice(BigDecimal.ZERO);
            }
            if (StringUtils.isBlank((String)ocContractGoodsDomain.getGinfoCode()) && StringUtils.isNotBlank((String)ocContractGoodsDomain.getShoppingGoodsPm())) {
                ocContractGoodsDomain.setGinfoCode(ocContractGoodsDomain.getShoppingGoodsPm());
            }
            ocContractGoodsDomain.setContractGoodsPefprice(ocContractGoodsDomain.getPricesetRefrice());
            this.makeGoods(ocContractGoodsDomain);
            if (StringUtils.isBlank((String)ocContractDomain.getMemberCcode())) {
                ocContractDomain.setMemberCcode(ocContractGoodsDomain.getMemberCcode());
                ocContractDomain.setMemberCname(ocContractGoodsDomain.getMemberCname());
                packageDomain.setMemberCcode(ocContractGoodsDomain.getMemberCcode());
                packageDomain.setMemberCname(ocContractGoodsDomain.getMemberCname());
            } else {
                packageDomain.setMemberCcode(ocContractDomain.getMemberCcode());
                packageDomain.setMemberCname(ocContractDomain.getMemberCname());
            }
            ocContractDomain.setChannelCode(ocContractGoodsDomain.getChannelCode());
            ocContractDomain.setChannelName(ocContractGoodsDomain.getChannelName());
            ocContractDomain.setMschannelCode(ocContractGoodsDomain.getMschannelCode());
            ocContractDomain.setMschannelName(ocContractGoodsDomain.getMschannelName());
            if (StringUtils.isEmpty((String)ocContractDomain.getMemberBname())) {
                ocContractDomain.setMemberBname(ocContractGoodsDomain.getMemberBname());
            }
            this.makeGoodsAdd(ocContractGoodsDomain, contractGoodsList);
        }
        if (ListUtil.isNotEmpty(contractGoodsList)) {
            for (OcContractGoodsDomain ocContractGoodsDomain : contractGoodsList) {
                CrmsSOrderGoodsDomain crmsSOrderGoodsDomain = new CrmsSOrderGoodsDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)crmsSOrderGoodsDomain, (Object)ocContractGoodsDomain);
                    crmsSOrderGoodsDomain.setGoodsPro("2");
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".makePackageDomain.copyAllPropertys.e", (Throwable)e);
                }
                crmsSOrderGoodsDomainList.add(crmsSOrderGoodsDomain);
            }
        }
        return crmsSOrderGoodsDomainList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createUUIDString() {
        Object object = this.UUIDLock;
        synchronized (object) {
            return UUID.randomUUID().toString().replace("-", "");
        }
    }

    private void makeGoodsAdd(OcContractGoodsDomain ocContractGoodsDomain, List<OcContractGoodsDomain> contractGoodsList) {
        if (null == ocContractGoodsDomain || null == contractGoodsList || ListUtil.isEmpty((Collection)ocContractGoodsDomain.getOcContractGoodsGoodsList())) {
            return;
        }
        for (OcContractGoodsGoodsDomain ocContractGoodsGoodsDomain : ocContractGoodsDomain.getOcContractGoodsGoodsList()) {
            OcContractGoodsDomain tcOcContractGoodsDomain = new OcContractGoodsDomain();
            RsSkuReDomain rsSkuReDomain = this.rsSkuServiceRepository.getChannelSkuBySkuNo(ocContractGoodsGoodsDomain.getSkuNo(), ocContractGoodsDomain.getMemberCode(), ocContractGoodsDomain.getMemberCcode(), ocContractGoodsDomain.getChannelCode(), ocContractGoodsDomain.getTenantCode());
            if (null == rsSkuReDomain) {
                CODE = ".makeGoodsAdd.rsSkuReDomain.null";
                this.logger.error(".makeGoodsAdd.rsSkuReDomain.null", (Object)(ocContractGoodsGoodsDomain.getSkuNo() + ocContractGoodsGoodsDomain.getChannelCode()));
                continue;
            }
            RsResourceGoodsReDomain resourceGoodsByCodeStr = this.rsResourceGoodsServiceRepository.getResourceGoodsByCodeStr(rsSkuReDomain.getGoodsCode(), rsSkuReDomain.getTenantCode());
            if (null == resourceGoodsByCodeStr) {
                CODE = ".makeGoodsAdd.resourceGoodsByCodeStr.null";
                this.logger.error(".makeGoodsAdd.resourceGoodsByCodeStr.null", (Object)(rsSkuReDomain.getGoodsCode() + rsSkuReDomain.getTenantCode()));
                continue;
            }
            try {
                BeanUtils.copyAllPropertys((Object)tcOcContractGoodsDomain, (Object)resourceGoodsByCodeStr);
                BeanUtils.copyAllPropertys((Object)tcOcContractGoodsDomain, (Object)rsSkuReDomain);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".makeGoodsAdd.copyAllPropertys.e", (Throwable)e);
            }
            tcOcContractGoodsDomain.setMemberBcode(ocContractGoodsDomain.getMemberBcode());
            tcOcContractGoodsDomain.setMemberBname(ocContractGoodsDomain.getMemberBname());
            tcOcContractGoodsDomain.setContractGoodsType(Integer.valueOf(3));
            tcOcContractGoodsDomain.setContractGoodsGtype("3");
            tcOcContractGoodsDomain.setContractGoodsOldcode(ocContractGoodsDomain.getContractGoodsCode());
            tcOcContractGoodsDomain.setGoodsMinnum(ocContractGoodsGoodsDomain.getGoodsMinnum());
            tcOcContractGoodsDomain.setGoodsHangnum(ocContractGoodsGoodsDomain.getGoodsHangnum());
            this.logger.error(CODE + ".makeGoodsAdd.ocContractGoodsGoodsDomain", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractGoodsGoodsDomain));
            tcOcContractGoodsDomain.setGoodsAhnum(ocContractGoodsGoodsDomain.getGoodsAhnum());
            tcOcContractGoodsDomain.setGoodsNum(ocContractGoodsGoodsDomain.getGoodsNum());
            tcOcContractGoodsDomain.setPricesetNprice(ocContractGoodsGoodsDomain.getPricesetNprice());
            tcOcContractGoodsDomain.setPricesetMakeprice(ocContractGoodsGoodsDomain.getPricesetMakeprice());
            tcOcContractGoodsDomain.setGoodsOrdnum(ocContractGoodsGoodsDomain.getGoodsNum());
            tcOcContractGoodsDomain.setGoodsOrdweight(ocContractGoodsGoodsDomain.getGoodsWeight());
            tcOcContractGoodsDomain.setGoodsCamount(ocContractGoodsGoodsDomain.getGoodsNum());
            tcOcContractGoodsDomain.setGoodsCweight(ocContractGoodsGoodsDomain.getGoodsWeight());
            if (null == tcOcContractGoodsDomain.getPricesetRefrice()) {
                tcOcContractGoodsDomain.setPricesetRefrice(BigDecimal.ZERO);
            }
            if (StringUtils.isBlank((String)tcOcContractGoodsDomain.getGinfoCode()) && StringUtils.isNotBlank((String)tcOcContractGoodsDomain.getShoppingGoodsPm())) {
                tcOcContractGoodsDomain.setGinfoCode(tcOcContractGoodsDomain.getShoppingGoodsPm());
            }
            tcOcContractGoodsDomain.setContractGoodsPefprice(tcOcContractGoodsDomain.getPricesetRefrice());
            this.makeGoods(tcOcContractGoodsDomain);
            contractGoodsList.add(tcOcContractGoodsDomain);
        }
    }

    public CrmsSOrderDomain makeContractDomain(CrmsSOrderDomain orderDomain, String contractType, UserSession userSession, String proappCode, OrgUserBean orgUserBean) throws Exception {
        if (null == userSession || null == orderDomain) {
            this.logger.error("OcServiceRepository.saveContract", (Object)"UserSession is null");
            return null;
        }
        CrmsSOrderDomain crmsSOrderDomain = new CrmsSOrderDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crmsSOrderDomain, (Object)orderDomain);
            if (null != orgUserBean) {
                BeanUtils.copyAllPropertys((Object)crmsSOrderDomain, (Object)orgUserBean);
            }
        }
        catch (Exception e) {
            this.logger.error("OcServiceRepository.makeContractDomain.ex", (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((String)crmsSOrderDomain.getContractType())) {
            if (StringUtils.isBlank((String)contractType)) {
                contractType = "00";
            }
            crmsSOrderDomain.setContractType(contractType);
        }
        if (StringUtils.isBlank((String)crmsSOrderDomain.getMemberBcode())) {
            crmsSOrderDomain.setMemberBcode(userSession.getUserPcode());
            crmsSOrderDomain.setMemberBname(userSession.getMerberCompname());
        }
        crmsSOrderDomain.setTenantCode(userSession.getTenantCode());
        crmsSOrderDomain.setAppmanageIcode(proappCode);
        crmsSOrderDomain.setContractUserurl(userSession.getUserImgurl());
        crmsSOrderDomain.setUserCode(userSession.getUserCode());
        crmsSOrderDomain.setUserName(userSession.getUserName());
        String randomCode = RandomUtils.generateRandom((int)6, (Integer)2);
        crmsSOrderDomain.setContractDelcode(randomCode);
        return crmsSOrderDomain;
    }

    public List<OcContractGoodsDomain> makeContractGoodsDomainList(String packageCode, List<Integer> shoppingGoodsIdList, List<SkuDomain> skuIdList, CrmsSOrderDomain ocContractDomain) throws Exception {
        if (ListUtil.isEmpty(shoppingGoodsIdList) && ListUtil.isEmpty(skuIdList)) {
            this.logger.info(CODE + ".makeContractGoodsDomainList.shoppingGoodsIdList.empty", (Object)"\u8d2d\u7269\u8f66\u53c2\u6570\u4e3a\u7a7a");
            throw new Exception("\u8d2d\u7269\u8f66\u6570\u636e\u4e3a\u7a7a");
        }
        boolean shop = true;
        shop = !ListUtil.isEmpty(shoppingGoodsIdList);
        ArrayList<OcContractGoodsDomain> contractGoodsDomainList = new ArrayList<OcContractGoodsDomain>();
        if (shop) {
            for (Integer id : shoppingGoodsIdList) {
                OcContractGoodsDomain contractGoodsDomain = new OcContractGoodsDomain();
                OcShoppingGoodsReDomain ocShoppingGoodsReDomain = this.getShoppingGoods(id);
                if (ocShoppingGoodsReDomain == null) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.shoppingGoodsId", (Object)("\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u5b58\u5728  " + id));
                    throw new Exception("\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                if (!ocShoppingGoodsReDomain.getMemberBcode().equals(ocContractDomain.getMemberBcode())) {
                    this.logger.error(CODE, (Object)String.format("\u8d2d\u7269\u8f66\u8d2d\u4e70\u4eba\u4e0e\u767b\u5f55\u8d26\u53f7\u4e0d\u4e00\u81f4\uff0cshoppingGoodsId=%s,\u6240\u6709\u8005\u8d26\u53f7=%s,\u767b\u5f55\u8d26\u53f7=%s", id, ocShoppingGoodsReDomain.getMemberBcode(), ocContractDomain.getMemberBcode()));
                    throw new Exception("\u8d2d\u7269\u8f66\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
                }
                if (StringUtils.isBlank((String)ocContractDomain.getMemberCode())) {
                    ocContractDomain.setMemberCode(ocShoppingGoodsReDomain.getMemberCode());
                    ocContractDomain.setMemberName(ocShoppingGoodsReDomain.getMemberName());
                }
                HashMap<String, String> skumap = new HashMap<String, String>();
                skumap.put("skuCode", ocShoppingGoodsReDomain.getSkuCode());
                skumap.put("tenantCode", ocShoppingGoodsReDomain.getTenantCode());
                RsSkuReDomain rsSkuReDomain = this.rsSkuServiceRepository.getSkuByCode(skumap);
                if (null == rsSkuReDomain) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.skuCode", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + ocShoppingGoodsReDomain.getSkuCode()));
                    throw new Exception("\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                if (1 != rsSkuReDomain.getDataOpbillstate() || null == rsSkuReDomain.getGoodsSupplynum() || rsSkuReDomain.getGoodsSupplynum().intValue() < 0 || rsSkuReDomain.getGoodsSupplynum().subtract(ocShoppingGoodsReDomain.getGoodsCamount()).intValue() < 0) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.rsSkuReDomain", (Object)"GoodsSupplynum is null");
                    throw new Exception("\u5546\u54c1\u4e0d\u5b58\u5728\u6216\u5e93\u5b58\u4e0d\u8db3");
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("goodsCode", ocShoppingGoodsReDomain.getGoodsCode());
                map.put("tenantCode", ocShoppingGoodsReDomain.getTenantCode());
                RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
                if (null == rsResourceGoodsReDomain) {
                    this.logger.error(CODE + ".rsResourceGoodsReDomain.goodsCode", (Object)"\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u5b58\u5728  ");
                    throw new Exception("\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                BeanUtils.copyAllPropertys((Object)contractGoodsDomain, (Object)rsResourceGoodsReDomain);
                BeanUtils.copyAllPropertys((Object)contractGoodsDomain, (Object)ocShoppingGoodsReDomain);
                ocContractDomain.setChannelCode(rsResourceGoodsReDomain.getChannelCode());
                ocContractDomain.setChannelName(rsResourceGoodsReDomain.getChannelName());
                ocContractDomain.setMschannelCode(rsResourceGoodsReDomain.getMschannelCode());
                ocContractDomain.setMschannelName(rsResourceGoodsReDomain.getMschannelName());
                contractGoodsDomain.setMemberBcode(ocContractDomain.getMemberBcode());
                contractGoodsDomain.setMemberBname(ocContractDomain.getMemberBname());
                contractGoodsDomain.setGoodsCamount(ocShoppingGoodsReDomain.getGoodsCamount());
                contractGoodsDomain.setGoodsCweight(ocShoppingGoodsReDomain.getGoodsCweight());
                contractGoodsDomain.setGoodsNum(ocShoppingGoodsReDomain.getGoodsCamount());
                contractGoodsDomain.setGoodsCamount(ocShoppingGoodsReDomain.getGoodsCamount());
                contractGoodsDomain.setGoodsWeight(ocShoppingGoodsReDomain.getGoodsCweight());
                contractGoodsDomain.setPackageCode(packageCode);
                if (null == ocShoppingGoodsReDomain.getPricesetRefrice()) {
                    ocShoppingGoodsReDomain.setPricesetRefrice(BigDecimal.ZERO);
                }
                contractGoodsDomain.setContractGoodsPefprice(ocShoppingGoodsReDomain.getPricesetRefrice());
                this.makeGoods(contractGoodsDomain);
                contractGoodsDomainList.add(contractGoodsDomain);
            }
        } else {
            for (SkuDomain skuDomain : skuIdList) {
                HashMap<String, String> map;
                OcContractGoodsDomain contractGoodsDomain = new OcContractGoodsDomain();
                contractGoodsDomain.setPackageCode(packageCode);
                RsSkuReDomain rsSkuReDomain = null;
                if (null != skuDomain.getSkuId()) {
                    rsSkuReDomain = this.rsSkuServiceRepository.getSku(skuDomain.getSkuId());
                } else if (StringUtils.isNotBlank((String)skuDomain.getSkuCode())) {
                    map = new HashMap<String, String>();
                    map.put("skuCode", skuDomain.getSkuCode());
                    map.put("tenantCode", ocContractDomain.getTenantCode());
                    rsSkuReDomain = this.rsSkuServiceRepository.getSkuByCode(map);
                }
                if (null == rsSkuReDomain) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.skuCode", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuCode()));
                    throw new Exception("\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                if (1 != rsSkuReDomain.getDataOpbillstate() || null == rsSkuReDomain.getGoodsSupplynum() || rsSkuReDomain.getGoodsSupplynum().longValue() <= 0L) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.rsSkuReDomain", (Object)"GoodsSupplynum is null");
                    throw new Exception("\u5546\u54c1\u4e0d\u5b58\u5728\u6216\u5e93\u5b58\u4e0d\u8db3");
                }
                map = new HashMap();
                map.put("goodsCode", rsSkuReDomain.getGoodsCode());
                map.put("tenantCode", rsSkuReDomain.getTenantCode());
                RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
                if (null == rsResourceGoodsReDomain) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.skuId", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuId()));
                    throw new Exception("\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                if (StringUtils.isBlank((String)ocContractDomain.getMemberCode())) {
                    ocContractDomain.setMemberCode(rsResourceGoodsReDomain.getMemberCode());
                    ocContractDomain.setMemberName(rsResourceGoodsReDomain.getMemberName());
                }
                BeanUtils.copyAllPropertys((Object)contractGoodsDomain, (Object)rsResourceGoodsReDomain);
                BeanUtils.copyAllPropertys((Object)contractGoodsDomain, (Object)rsSkuReDomain);
                ocContractDomain.setChannelCode(rsResourceGoodsReDomain.getChannelCode());
                ocContractDomain.setChannelName(rsResourceGoodsReDomain.getChannelName());
                ocContractDomain.setMschannelCode(rsResourceGoodsReDomain.getMschannelCode());
                ocContractDomain.setMschannelName(rsResourceGoodsReDomain.getMschannelName());
                contractGoodsDomain.setMemberBcode(ocContractDomain.getMemberBcode());
                contractGoodsDomain.setMemberBname(ocContractDomain.getMemberBname());
                contractGoodsDomain.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
                contractGoodsDomain.setGoodsCamount(skuDomain.getGoodsNum());
                contractGoodsDomain.setGoodsCweight(null == skuDomain.getGoodsWeght() ? BigDecimal.ZERO : skuDomain.getGoodsWeght());
                contractGoodsDomain.setGoodsNum(skuDomain.getGoodsNum());
                contractGoodsDomain.setGoodsWeight(skuDomain.getGoodsWeght());
                contractGoodsDomain.setPackageCode(packageCode);
                if (StringUtils.isNotBlank((String)skuDomain.getGoodsContract())) {
                    contractGoodsDomain.setGoodsContract(skuDomain.getGoodsContract());
                }
                if (null == rsSkuReDomain.getPricesetRefrice()) {
                    rsSkuReDomain.setPricesetRefrice(BigDecimal.ZERO);
                }
                contractGoodsDomain.setContractGoodsPefprice(rsSkuReDomain.getPricesetRefrice());
                this.makeGoods(contractGoodsDomain);
                contractGoodsDomainList.add(contractGoodsDomain);
            }
        }
        if (ListUtil.isEmpty(contractGoodsDomainList)) {
            this.logger.info(CODE + ".makeContractGoodsDomainList.contractGoodsDomainList.empty", (Object)"\u8d2d\u7269\u8f66\u4e3a\u7a7a");
            throw new Exception("\u8d2d\u7269\u8f66\u4e3a\u7a7a");
        }
        return contractGoodsDomainList;
    }

    public OcShoppingGoodsReDomain getShoppingGoods(Integer shoppingGoodsId) {
        PostParamMap pmap = new PostParamMap("oc.shopping.getShoppingGoods");
        pmap.putParam("shoppingGoodsId", (Object)shoppingGoodsId);
        return (OcShoppingGoodsReDomain)this.htmlIBaseService.senReObject(pmap, OcShoppingGoodsReDomain.class);
    }

    public void makeGoods(OcContractGoodsDomain contractGoodsDomain) {
        if (null == contractGoodsDomain) {
            return;
        }
        if (null == contractGoodsDomain.getGoodsNum()) {
            contractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == contractGoodsDomain.getPricesetNprice()) {
            contractGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
        }
        BigDecimal inmoney = contractGoodsDomain.getPricesetNprice().multiply(contractGoodsDomain.getGoodsNum());
        contractGoodsDomain.setContractGoodsInmoney(inmoney);
        if (null == contractGoodsDomain.getPricesetRefrice()) {
            contractGoodsDomain.setPricesetRefrice(BigDecimal.ZERO);
        }
        BigDecimal refmoney = contractGoodsDomain.getPricesetRefrice().multiply(contractGoodsDomain.getGoodsNum());
        contractGoodsDomain.setContractGoodsPefinmoney(refmoney);
        contractGoodsDomain.setContractGoodsPefmoney(refmoney);
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal contractGoodsMoney = inmoney.subtract(discountAmount);
        if (null != contractGoodsDomain.getGoodsNum() && BigDecimal.ZERO.compareTo(contractGoodsDomain.getGoodsNum()) != 0) {
            contractGoodsDomain.setContractGoodsPrice(contractGoodsMoney.divide(contractGoodsDomain.getGoodsNum(), 2, 4));
        }
        contractGoodsDomain.setContractGoodsMoney(contractGoodsMoney);
        contractGoodsDomain.setContractGoodsAppraise(Integer.valueOf(0));
        contractGoodsDomain.setRefundFlag(Integer.valueOf(0));
    }

    public CrmsSOrderReDomain getSOrderByCode(String tenantCode, String sorderCode) {
        PostParamMap pmap = new PostParamMap("crms.sorder.getSOrderByCode");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("sorderCode", (Object)sorderCode);
        return (CrmsSOrderReDomain)this.htmlIBaseService.senReObject(pmap, CrmsSOrderReDomain.class);
    }

    public HtmlJsonReBean updateSOrderState(Integer sorderId, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("crms.sorder.updateSOrderState");
        pmap.putParam("sorderId", (Object)sorderId);
        pmap.putParam("dataState", (Object)dataState);
        pmap.putParam("oldDataState", (Object)oldDataState);
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateSOrderStateByCode(String tenantCode, String sorderCode, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("crms.sorder.updateSOrderStateByCode");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("sorderCode", (Object)sorderCode);
        pmap.putParam("dataState", (Object)dataState);
        pmap.putParam("oldDataState", (Object)oldDataState);
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean deleteSOrderByCode(String tenantCode, String sorderCode) {
        PostParamMap pmap = new PostParamMap("crms.sorder.deleteSOrderByCode");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("sorderCode", (Object)sorderCode);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }
}

