/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.facade.oc.repository;

import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.common.send.SupperFacade;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.GoodsBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcCflowReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractSettlDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcPackageDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingGoodsReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingpackgeDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OrderDomain;
import com.qjsoft.laser.controller.facade.oc.domain.PackageDomain;
import com.qjsoft.laser.controller.facade.oc.domain.SkuDomain;
import com.qjsoft.laser.controller.facade.oc.domain.TypeBean;
import com.qjsoft.laser.controller.facade.oc.enumc.ContractSettlType;
import com.qjsoft.laser.controller.facade.oc.enumc.ContractType;
import com.qjsoft.laser.controller.facade.pm.domain.PmCheckBean;
import com.qjsoft.laser.controller.facade.pm.domain.PmContractGoodsDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmInfoBean;
import com.qjsoft.laser.controller.facade.pm.domain.PmUserCouponReDomain;
import com.qjsoft.laser.controller.facade.pm.domain.UserBean;
import com.qjsoft.laser.controller.facade.pm.repository.PmPromotionEngineServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.facade.upm.repository.UpmUpointsServiceRepository;
import com.qjsoft.laser.controller.facade.ur.domain.UrOrderUserDomain;
import com.qjsoft.laser.controller.facade.ur.repository.UrUserrightsServiceRepository;
import com.qjsoft.laser.controller.facade.wl.repository.WlFreightTemServiceRepository;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class OcServiceRepository
extends SupperFacade {
    @Autowired
    private UpmUpointsServiceRepository upmUpointsServiceRepository;
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;
    @Autowired
    private WlFreightTemServiceRepository wlFreightTemServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private PmPromotionEngineServiceRepository pmPromotionEngineServiceRepository;
    @Autowired
    private UrUserrightsServiceRepository urUserrightsServiceRepository;
    private static String CODE = "oc.OcServiceRepository";
    String CACHE_KEY_CFLOW = "ocProtCflow";

    public List<OcShoppingReDomain> checkPromotionForShoppingList(List<OcShoppingReDomain> ocShoppingReDomainList, PmCheckBean pmCheckBean) {
        PostParamMap pmap = new PostParamMap("pm.PmPromotion.checkPromotionForShoppingList");
        pmap.putParamToJson("ocShoppingDomainList", ocShoppingReDomainList);
        pmap.putParamToJson("pmCheckBean", (Object)pmCheckBean);
        return this.htmlIBaseService.getForList(pmap, OcShoppingReDomain.class);
    }

    public OcShoppingReDomain checkPromotionForShopping(OcShoppingReDomain ocShoppingReDomain, PmCheckBean pmCheckBean) {
        PostParamMap pmap = new PostParamMap("pm.PmPromotion.checkPromotionForShopping");
        pmap.putParamToJson("ocShoppingReDomain", (Object)ocShoppingReDomain);
        pmap.putParamToJson("pmCheckBean", (Object)pmCheckBean);
        return (OcShoppingReDomain)this.htmlIBaseService.senReObject(pmap, OcShoppingReDomain.class);
    }

    public PmInfoBean checkPm(List<OcContractGoodsDomain> pmContractGoodsDomainList, List<OcContractSettlDomain> ocContractSettlDomainList, PmCheckBean pmCheckBean) {
        PostParamMap pmap = new PostParamMap("pm.pmPromotionEngine.checkPm");
        pmap.putParamToJson("pmContractGoodsDomainList", pmContractGoodsDomainList);
        pmap.putParamToJson("ocContractSettlDomainList", ocContractSettlDomainList);
        pmap.putParamToJson("pmCheckBean", (Object)pmCheckBean);
        return (PmInfoBean)this.htmlIBaseService.senReObject(pmap, PmInfoBean.class);
    }

    public TypeBean getOcSetting(String shoppingType, String tenantCode) {
        String memo;
        OcCflowReDomain ocCflowReDomain;
        TypeBean typeBean = null;
        String json = SupDisUtil.getMap((String)this.CACHE_KEY_CFLOW, (String)(shoppingType + "-" + tenantCode));
        if (StringUtils.isBlank((String)json)) {
            json = SupDisUtil.getMap((String)this.CACHE_KEY_CFLOW, (String)(shoppingType + "-" + "00000000"));
        }
        if (StringUtils.isNotBlank((String)json) && null != (ocCflowReDomain = (OcCflowReDomain)JsonUtil.buildNormalBinder().getJsonToObject(json, OcCflowReDomain.class)) && StringUtils.isNotBlank((String)(memo = ocCflowReDomain.getMemo()))) {
            typeBean = (TypeBean)JsonUtil.buildNormalBinder().getJsonToObject(memo, TypeBean.class);
        }
        return typeBean;
    }

    public boolean checkFreight(TypeBean typeBean) {
        if (null == typeBean) {
            return true;
        }
        return StringUtils.isBlank((String)typeBean.getFreight()) || "0".equals(typeBean.getFreight());
    }

    public boolean checkPm(TypeBean typeBean) {
        if (null == typeBean) {
            return true;
        }
        return StringUtils.isBlank((String)typeBean.getPmpay()) || "0".equals(typeBean.getPmpay());
    }

    public boolean checkIntpay(TypeBean typeBean) {
        if (null == typeBean) {
            return true;
        }
        return StringUtils.isBlank((String)typeBean.getIntpay()) || "0".equals(typeBean.getIntpay());
    }

    public HtmlJsonReBean createOcOrder(List<OrderDomain> orderDomainList, String contractType, UserSession userSession, String proappCode, String oauthEnvCode) {
        if (ListUtil.isEmpty(orderDomainList) || null == userSession) {
            this.logger.error(CODE + ".createOcOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ArrayList<OcContractDomain> ocContractDomainList = new ArrayList<OcContractDomain>();
        ArrayList<Integer> shoppingGoodsIdList = new ArrayList<Integer>();
        String tenantCode = userSession.getTenantCode();
        PmCheckBean pmCheckBean = this.getPmCheckBean(orderDomainList.get(0).getChannelCode(), proappCode, tenantCode, userSession);
        for (OrderDomain orderDomain : orderDomainList) {
            OcContractDomain contractDomain;
            try {
                contractDomain = this.makeContractDomain(orderDomain, contractType, userSession, proappCode);
                if (null == contractDomain) {
                    this.logger.error(CODE + ".createOcOrder.contractDomain");
                    return new HtmlJsonReBean((Object)(CODE + ".saveContract.contractDomain"));
                }
                contractDomain.setPackageList(this.makePackageDomainList(orderDomain.getPackageList(), contractDomain, shoppingGoodsIdList, orderDomain.getGiftSkuIdList(), oauthEnvCode, pmCheckBean));
            }
            catch (Exception e) {
                this.logger.error(CODE + ".createOcOrder.ex", (Throwable)e);
                return new HtmlJsonReBean(CODE + ".saveContract.ex", e.getMessage());
            }
            HtmlJsonReBean htmlJsonReBean = this.calculateContract(contractDomain);
            if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
                return htmlJsonReBean;
            }
            ocContractDomainList.add(contractDomain);
        }
        HtmlJsonReBean htmlJsonReBean = null;
        HashMap<String, String> result = new HashMap<String, String>();
        if (ocContractDomainList.size() > 1) {
            htmlJsonReBean = this.sendBatchContractByDel(ocContractDomainList, shoppingGoodsIdList);
            if (null != htmlJsonReBean && htmlJsonReBean.isSuccess() && null != htmlJsonReBean.getDataObj()) {
                result.put("contractBbillcode", htmlJsonReBean.getDataObj().toString());
            }
        } else {
            htmlJsonReBean = this.sendContractByDel((OcContractDomain)ocContractDomainList.get(0), shoppingGoodsIdList);
            if (null != htmlJsonReBean && htmlJsonReBean.isSuccess() && null != htmlJsonReBean.getDataObj()) {
                result.put("contractBillcode", htmlJsonReBean.getDataObj().toString());
            }
        }
        htmlJsonReBean.setDataObj(result);
        return htmlJsonReBean;
    }

    public void sendOrderBigData(List<OcContractDomain> ocContractDomainList, String tenantCode) {
        if (null == ocContractDomainList || ocContractDomainList.size() == 0) {
            return;
        }
        String bigdataFlag = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-bigdata-bigdataflag"));
        if (StringUtils.isBlank((String)bigdataFlag) || !"true".equals(bigdataFlag)) {
            return;
        }
        for (OcContractDomain ocContractDomain : ocContractDomainList) {
            ocContractDomain.setPackageList(null);
            ocContractDomain.setOcContractSettlList(null);
            String value = "{\"paasLabel\":\"orderPayment\",\"message\":" + JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain) + "}";
            PostParamMap pmap = new PostParamMap("kafka.adapter.sendProducerInfo");
            pmap.putParam("topic", (Object)"paas_business");
            pmap.putParam("value", (Object)value);
            this.htmlIBaseService.sendMesReBeanInAsync(pmap);
        }
    }

    public HtmlJsonReBean sendBatchContractByDel(List<OcContractDomain> ocContractDomainList, List<Integer> shoppingGoodsIdList) {
        PostParamMap pmap = new PostParamMap("oc.shopping.sendBatchContractByDel");
        pmap.putParamToJson("ocContractDomainList", ocContractDomainList);
        pmap.putParamToJson("shoppingGoodsIdList", shoppingGoodsIdList);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public List<OcPackageDomain> makePackageDomainList(List<PackageDomain> packageList, OcContractDomain ocContractDomain, List<Integer> shoppingGoodsIdList, List<SkuDomain> giftSkuIdList, String oauthEnvCode, PmCheckBean pmCheckBean) throws Exception {
        HtmlJsonReBean htmlJsonReBean;
        if (ListUtil.isEmpty(packageList)) {
            throw new Exception("\u5305\u88f9\u4fe1\u606f\u4e3a\u7a7a");
        }
        BigDecimal contractInMoney = ocContractDomain.getContractInmoney();
        BigDecimal goodsPmoney = BigDecimal.ZERO;
        Map<String, BigDecimal> smap = this.getListToMap(ocContractDomain.getOcContractSettlList());
        if (null != smap && null != smap.get(ContractSettlType.INT.getCode()) && null != (htmlJsonReBean = this.upmUpointsServiceRepository.deductible(contractInMoney, ocContractDomain.getTenantCode(), ocContractDomain.getMemberBcode(), "0")) && null != htmlJsonReBean.getDataObj()) {
            Map upmMap = (Map)htmlJsonReBean.getDataObj();
            BigDecimal disamount = (BigDecimal)upmMap.get("disamount");
            BigDecimal intmoney = smap.get(ContractSettlType.INT.getCode());
            if (null != intmoney) {
                if (disamount.compareTo(intmoney) != 0) {
                    throw new Exception("\u79ef\u5206\u4e0d\u4e00\u81f4[" + disamount + "][" + intmoney + "];");
                }
                goodsPmoney = disamount;
            }
        }
        ArrayList<OcPackageDomain> packageDomainList = new ArrayList<OcPackageDomain>();
        ArrayList<OcContractGoodsDomain> allGoodsList = new ArrayList<OcContractGoodsDomain>();
        for (PackageDomain packageDomain : packageList) {
            OcPackageDomain ocPackageDomain = this.makePackageDomain(packageDomain, ocContractDomain, giftSkuIdList, oauthEnvCode, pmCheckBean, allGoodsList);
            packageDomainList.add(ocPackageDomain);
            if (null == shoppingGoodsIdList || null == packageDomain.getShoppingGoodsIdList()) continue;
            shoppingGoodsIdList.addAll(packageDomain.getShoppingGoodsIdList());
        }
        if (null != smap && null != smap.get(ContractSettlType.UR.getCode())) {
            String sysRecode;
            BigDecimal urMoney = smap.get(ContractSettlType.UR.getCode());
            goodsPmoney = goodsPmoney.add(urMoney);
            UrOrderUserDomain urOrderUserDomain = new UrOrderUserDomain();
            urOrderUserDomain.setTenantCode(ocContractDomain.getTenantCode());
            urOrderUserDomain.setUserCode(ocContractDomain.getMemberCode());
            urOrderUserDomain.setDiscountPrice(urMoney);
            ArrayList<RsSkuDomain> rsSkuList = new ArrayList<RsSkuDomain>();
            RsSkuDomain rsSkuDomain = null;
            for (int i = 0; i < allGoodsList.size(); ++i) {
                OcContractGoodsDomain ocContractGoodsDomain = (OcContractGoodsDomain)allGoodsList.get(i);
                rsSkuDomain = new RsSkuDomain();
                rsSkuDomain.setSkuCode(ocContractGoodsDomain.getSkuCode());
                rsSkuDomain.setPricesetAsprice(ocContractGoodsDomain.getPricesetAsprice());
                rsSkuDomain.setPricesetRefrice(ocContractGoodsDomain.getPricesetRefrice());
                rsSkuDomain.setPricesetNprice(ocContractGoodsDomain.getPricesetNprice());
                rsSkuDomain.setGoodsNum(ocContractGoodsDomain.getGoodsCamount());
                rsSkuList.add(rsSkuDomain);
            }
            HtmlJsonReBean htmlJsonReBean2 = this.urUserrightsServiceRepository.commitOrder(urOrderUserDomain, rsSkuList);
            if (null != htmlJsonReBean2 && null != htmlJsonReBean2.getSysRecode() && null != (sysRecode = htmlJsonReBean2.getSysRecode()) && "error".equals(sysRecode)) {
                throw new Exception("\u6743\u76ca\u8ba1\u7b97\u4e0d\u4e00\u81f4;");
            }
        }
        this.calculate(allGoodsList, goodsPmoney, oauthEnvCode);
        if (null != smap && (null != smap.get(ContractSettlType.PM.getCode()) || null != smap.get(ContractSettlType.COP.getCode()))) {
            ArrayList<OcContractSettlDomain> pmContractSettlList = new ArrayList<OcContractSettlDomain>();
            for (OcContractSettlDomain ocContractSettlDomain : ocContractDomain.getOcContractSettlList()) {
                if (ContractSettlType.PM.getCode().equals(ocContractSettlDomain.getContractSettlBlance())) {
                    pmContractSettlList.add(ocContractSettlDomain);
                    continue;
                }
                if (!ContractSettlType.COP.getCode().equals(ocContractSettlDomain.getContractSettlBlance())) continue;
                pmContractSettlList.add(ocContractSettlDomain);
            }
            pmCheckBean.setLogisMoney(ocContractDomain.getGoodsLogmoney());
            PmInfoBean pmInfoBean = this.checkPm(allGoodsList, pmContractSettlList, pmCheckBean);
            if (null == pmInfoBean || !"true".equals(pmInfoBean.getFlag())) {
                throw new Exception(pmInfoBean.getMsg());
            }
            this.setPmoney(allGoodsList, pmInfoBean);
        }
        for (OcPackageDomain ocPackageDomain1 : packageDomainList) {
            this.makePack(ocContractDomain, ocPackageDomain1);
        }
        return packageDomainList;
    }

    private OcPackageDomain makePackageDomain(PackageDomain packageDomain, OcContractDomain ocContractDomain, List<SkuDomain> giftSkuIdList, String oauthEnvCode, PmCheckBean pmCheckBean, List<OcContractGoodsDomain> allGoodsList) throws Exception {
        if (null == allGoodsList || null == pmCheckBean || null == packageDomain || null == ocContractDomain) {
            return null;
        }
        OcPackageDomain ocPackageDomain = new OcPackageDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocPackageDomain, (Object)packageDomain);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".makePackageDomain.ex", (Throwable)e);
            return null;
        }
        if (ListUtil.isEmpty(packageDomain.getContractGoodsList())) {
            List<OcContractGoodsDomain> goodsList = this.makeContractGoodsDomainList(packageDomain.getShoppingGoodsIdList(), packageDomain.getSkuIdList(), ocContractDomain, giftSkuIdList);
            ocPackageDomain.setContractGoodsList(goodsList);
            allGoodsList.addAll(goodsList);
        } else {
            ocPackageDomain.setContractGoodsList(packageDomain.getContractGoodsList());
            for (OcContractGoodsDomain ocContractGoodsDomain : ocPackageDomain.getContractGoodsList()) {
                ocContractGoodsDomain.setShoppingGoodsPm(packageDomain.getPromotionCode());
                ocContractGoodsDomain.setGoodsNum(ocContractGoodsDomain.getGoodsCamount());
                ocContractGoodsDomain.setGoodsWeight(ocContractGoodsDomain.getGoodsCweight());
                if (null == ocContractGoodsDomain.getPricesetRefrice()) {
                    ocContractGoodsDomain.setPricesetRefrice(BigDecimal.ZERO);
                }
                ocContractGoodsDomain.setContractGoodsPefprice(ocContractGoodsDomain.getPricesetRefrice());
                this.makeGoods(ocContractGoodsDomain);
            }
            allGoodsList.addAll(ocPackageDomain.getContractGoodsList());
        }
        return ocPackageDomain;
    }

    private void setPmoney(List<OcContractGoodsDomain> goodsList, PmInfoBean pmInfoBean) {
        if (ListUtil.isEmpty(goodsList) || null == pmInfoBean || ListUtil.isEmpty((Collection)pmInfoBean.getPmContractGoodsDomainList())) {
            return;
        }
        HashMap<String, PmContractGoodsDomain> pmmap = new HashMap<String, PmContractGoodsDomain>();
        for (PmContractGoodsDomain pmContractGoodsDomain : pmInfoBean.getPmContractGoodsDomainList()) {
            pmmap.put(pmContractGoodsDomain.getSkuCode(), pmContractGoodsDomain);
        }
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            PmContractGoodsDomain pmContractGoodsDomain = (PmContractGoodsDomain)pmmap.get(ocContractGoodsDomain.getSkuCode());
            if (null == pmContractGoodsDomain) continue;
            ocContractGoodsDomain.setContractGoodsPrice(pmContractGoodsDomain.getContractGoodsPrice());
            ocContractGoodsDomain.setContractGoodsMoney(pmContractGoodsDomain.getContractGoodsMoney());
        }
    }

    private void calculate(List<OcContractGoodsDomain> goodsList, BigDecimal goodsPmoney, String oauthEnvCode) {
        if (ListUtil.isEmpty(goodsList)) {
            return;
        }
        BigDecimal sumgoodsPmoney = BigDecimal.ZERO;
        BigDecimal onegoodsPmoney = BigDecimal.ZERO;
        BigDecimal goodsInmoney = BigDecimal.ZERO;
        BigDecimal goodsMoney = BigDecimal.ZERO;
        BigDecimal sumgoodsMoney = BigDecimal.ZERO;
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            goodsInmoney = ocContractGoodsDomain.getContractGoodsInmoney();
            if (null == goodsInmoney) {
                goodsInmoney = BigDecimal.ZERO;
            }
            if (null == (goodsMoney = ocContractGoodsDomain.getContractGoodsMoney())) {
                goodsMoney = BigDecimal.ZERO;
            }
            sumgoodsMoney.add(goodsMoney);
            PmContractGoodsDomain pmContractGoodsDomain = new PmContractGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)pmContractGoodsDomain, (Object)ocContractGoodsDomain);
            }
            catch (Exception e) {}
        }
        if (null == goodsPmoney || BigDecimal.ZERO.compareTo(goodsPmoney) == 0) {
            return;
        }
        int len = goodsList.size();
        int i = 0;
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            ++i;
            goodsInmoney = ocContractGoodsDomain.getContractGoodsInmoney();
            if (null == goodsInmoney) {
                goodsInmoney = BigDecimal.ZERO;
            }
            if (null == (goodsMoney = ocContractGoodsDomain.getContractGoodsMoney())) {
                goodsMoney = BigDecimal.ZERO;
            }
            if (sumgoodsMoney != BigDecimal.ZERO) {
                onegoodsPmoney = goodsMoney.divide(sumgoodsMoney).multiply(goodsPmoney);
            }
            sumgoodsPmoney = sumgoodsPmoney.add(onegoodsPmoney);
            ocContractGoodsDomain.setContractGoodsMoney(goodsMoney.subtract(onegoodsPmoney));
            if (i != len) continue;
            goodsMoney = ocContractGoodsDomain.getContractGoodsMoney();
            if (null == goodsMoney) {
                goodsMoney = BigDecimal.ZERO;
            }
            ocContractGoodsDomain.setContractGoodsMoney(goodsMoney.add(goodsPmoney.subtract(sumgoodsPmoney)));
        }
    }

    public PmCheckBean getPmCheckBean(String channelCode, String proappCode, String tenantCode, UserSession userSession) {
        PmCheckBean pmCheckBean = new PmCheckBean();
        pmCheckBean.setChannelCode(channelCode);
        pmCheckBean.setProappCode(proappCode);
        pmCheckBean.setTenantCode(tenantCode);
        if (null == userSession) {
            return pmCheckBean;
        }
        UserBean userBean = new UserBean();
        pmCheckBean.setUserBean(userBean);
        userBean.setMemberCode(userSession.getUserPcode());
        userBean.setMemberName(userSession.getMerberCompname());
        userBean.setProappCode(pmCheckBean.getChannelCode());
        userBean.setTenantCode(pmCheckBean.getTenantCode());
        userBean.setUserName(userSession.getUserName());
        return pmCheckBean;
    }

    public OcShoppingGoodsReDomain getShoppingGoods(Integer shoppingGoodsId) {
        PostParamMap pmap = new PostParamMap("oc.shopping.getShoppingGoods");
        pmap.putParam("shoppingGoodsId", (Object)shoppingGoodsId);
        return (OcShoppingGoodsReDomain)this.htmlIBaseService.senReObject(pmap, OcShoppingGoodsReDomain.class);
    }

    public List<OcContractGoodsDomain> makeContractGoodsDomainList(List<Integer> shoppingGoodsIdList, List<SkuDomain> skuIdList, OcContractDomain ocContractDomain, List<SkuDomain> giftSkuIdList) throws Exception {
        RsResourceGoodsReDomain rsResourceGoodsReDomain;
        HashMap<String, String> map;
        RsSkuReDomain rsSkuReDomain;
        OcContractGoodsDomain contractGoodsDomain;
        if (ListUtil.isEmpty(shoppingGoodsIdList) && ListUtil.isEmpty(skuIdList)) {
            this.logger.info(CODE + ".makeContractGoodsDomainList.shoppingGoodsIdList.empty", (Object)"\u8d2d\u7269\u8f66\u53c2\u6570\u4e3a\u7a7a");
            throw new Exception("\u8d2d\u7269\u8f66\u6570\u636e\u4e3a\u7a7a");
        }
        boolean shop = true;
        shop = !ListUtil.isEmpty(shoppingGoodsIdList);
        ArrayList<OcContractGoodsDomain> contractGoodsDomainList = new ArrayList<OcContractGoodsDomain>();
        if (shop) {
            for (Integer id : shoppingGoodsIdList) {
                contractGoodsDomain = new OcContractGoodsDomain();
                OcShoppingGoodsReDomain ocShoppingGoodsReDomain = this.getShoppingGoods(id);
                if (ocShoppingGoodsReDomain == null) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.shoppingGoodsId", (Object)("\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u5b58\u5728  " + id));
                    throw new Exception("\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                if (!ocShoppingGoodsReDomain.getMemberBcode().equals(ocContractDomain.getMemberBcode())) {
                    this.logger.error(CODE, (Object)String.format("\u8d2d\u7269\u8f66\u8d2d\u4e70\u4eba\u4e0e\u767b\u5f55\u8d26\u53f7\u4e0d\u4e00\u81f4\uff0cshoppingGoodsId=%s,\u6240\u6709\u8005\u8d26\u53f7=%s,\u767b\u5f55\u8d26\u53f7=%s", id, ocShoppingGoodsReDomain.getMemberBcode(), ocContractDomain.getMemberBcode()));
                    throw new Exception("\u8d2d\u7269\u8f66\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
                }
                if (StringUtils.isBlank((String)ocContractDomain.getMemberCode())) {
                    ocContractDomain.setMemberCode(ocShoppingGoodsReDomain.getMemberCode());
                    ocContractDomain.setMemberName(ocShoppingGoodsReDomain.getMemberName());
                }
                HashMap<String, String> skumap = new HashMap<String, String>();
                skumap.put("skuCode", ocShoppingGoodsReDomain.getSkuCode());
                skumap.put("tenantCode", ocContractDomain.getTenantCode());
                RsSkuReDomain rsSkuReDomain2 = this.rsSkuServiceRepository.getSkuByCode(skumap);
                if (null == rsSkuReDomain2) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.skuCode", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + ocShoppingGoodsReDomain.getSkuCode()));
                    throw new Exception("\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                if (1 != rsSkuReDomain2.getDataOpbillstate() || null == rsSkuReDomain2.getGoodsSupplynum() || rsSkuReDomain2.getGoodsSupplynum().intValue() < 0 || rsSkuReDomain2.getGoodsSupplynum().subtract(ocShoppingGoodsReDomain.getGoodsCamount()).intValue() < 0) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.rsSkuReDomain", (Object)"GoodsSupplynum is null");
                    throw new Exception("\u5546\u54c1\u4e0d\u5b58\u5728\u6216\u5e93\u5b58\u4e0d\u8db3");
                }
                HashMap<String, String> map2 = new HashMap<String, String>();
                map2.put("goodsCode", ocShoppingGoodsReDomain.getGoodsCode());
                map2.put("tenantCode", ocShoppingGoodsReDomain.getTenantCode());
                RsResourceGoodsReDomain rsResourceGoodsReDomain2 = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map2);
                if (null == rsResourceGoodsReDomain2) {
                    this.logger.error(CODE + ".rsResourceGoodsReDomain.goodsCode", (Object)"\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u5b58\u5728  ");
                    throw new Exception("\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                BeanUtils.copyAllPropertys((Object)contractGoodsDomain, (Object)rsResourceGoodsReDomain2);
                BeanUtils.copyAllPropertys((Object)contractGoodsDomain, (Object)ocShoppingGoodsReDomain);
                ocContractDomain.setChannelCode(rsResourceGoodsReDomain2.getChannelCode());
                ocContractDomain.setChannelName(rsResourceGoodsReDomain2.getChannelName());
                ocContractDomain.setMschannelCode(rsResourceGoodsReDomain2.getMschannelCode());
                ocContractDomain.setMschannelName(rsResourceGoodsReDomain2.getMschannelName());
                contractGoodsDomain.setMemberBcode(ocContractDomain.getMemberBcode());
                contractGoodsDomain.setMemberBname(ocContractDomain.getMemberBname());
                contractGoodsDomain.setGoodsCamount(ocShoppingGoodsReDomain.getGoodsCamount());
                contractGoodsDomain.setGoodsCweight(ocShoppingGoodsReDomain.getGoodsCweight());
                contractGoodsDomain.setGoodsNum(ocShoppingGoodsReDomain.getGoodsCamount());
                contractGoodsDomain.setGoodsCamount(ocShoppingGoodsReDomain.getGoodsCamount());
                contractGoodsDomain.setGoodsWeight(ocShoppingGoodsReDomain.getGoodsCweight());
                if (null == ocShoppingGoodsReDomain.getPricesetRefrice()) {
                    ocShoppingGoodsReDomain.setPricesetRefrice(BigDecimal.ZERO);
                }
                contractGoodsDomain.setContractGoodsPefprice(ocShoppingGoodsReDomain.getPricesetRefrice());
                this.makeGoods(contractGoodsDomain);
                contractGoodsDomainList.add(contractGoodsDomain);
            }
        } else {
            for (SkuDomain skuDomain : skuIdList) {
                contractGoodsDomain = new OcContractGoodsDomain();
                rsSkuReDomain = null;
                if (null != skuDomain.getSkuId()) {
                    rsSkuReDomain = this.rsSkuServiceRepository.getSku(skuDomain.getSkuId());
                } else if (StringUtils.isNotBlank((String)skuDomain.getSkuCode())) {
                    map = new HashMap<String, String>();
                    map.put("skuCode", skuDomain.getSkuCode());
                    map.put("tenantCode", ocContractDomain.getTenantCode());
                    rsSkuReDomain = this.rsSkuServiceRepository.getSkuByCode(map);
                }
                if (null == rsSkuReDomain) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.skuCode", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuCode()));
                    throw new Exception("\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                if (1 != rsSkuReDomain.getDataOpbillstate() || null == rsSkuReDomain.getGoodsSupplynum() || rsSkuReDomain.getGoodsSupplynum().longValue() <= 0L) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.rsSkuReDomain", (Object)"GoodsSupplynum is null");
                    throw new Exception("\u5546\u54c1\u4e0d\u5b58\u5728\u6216\u5e93\u5b58\u4e0d\u8db3");
                }
                map = new HashMap();
                map.put("goodsCode", rsSkuReDomain.getGoodsCode());
                map.put("tenantCode", rsSkuReDomain.getTenantCode());
                rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
                if (null == rsResourceGoodsReDomain) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.skuId", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuId()));
                    throw new Exception("\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                if (StringUtils.isBlank((String)ocContractDomain.getMemberCode())) {
                    ocContractDomain.setMemberCode(rsResourceGoodsReDomain.getMemberCode());
                    ocContractDomain.setMemberName(rsResourceGoodsReDomain.getMemberName());
                }
                BeanUtils.copyAllPropertys((Object)contractGoodsDomain, (Object)rsResourceGoodsReDomain);
                BeanUtils.copyAllPropertys((Object)contractGoodsDomain, (Object)rsSkuReDomain);
                ocContractDomain.setChannelCode(rsResourceGoodsReDomain.getChannelCode());
                ocContractDomain.setChannelName(rsResourceGoodsReDomain.getChannelName());
                ocContractDomain.setMschannelCode(rsResourceGoodsReDomain.getMschannelCode());
                ocContractDomain.setMschannelName(rsResourceGoodsReDomain.getMschannelName());
                contractGoodsDomain.setMemberBcode(ocContractDomain.getMemberBcode());
                contractGoodsDomain.setMemberBname(ocContractDomain.getMemberBname());
                contractGoodsDomain.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
                contractGoodsDomain.setGoodsCamount(skuDomain.getGoodsNum());
                contractGoodsDomain.setGoodsCweight(null == skuDomain.getGoodsWeght() ? BigDecimal.ZERO : skuDomain.getGoodsWeght());
                contractGoodsDomain.setGoodsNum(skuDomain.getGoodsNum());
                contractGoodsDomain.setGoodsWeight(skuDomain.getGoodsWeght());
                if (StringUtils.isNotBlank((String)skuDomain.getGoodsContract())) {
                    contractGoodsDomain.setGoodsContract(skuDomain.getGoodsContract());
                }
                if (null == rsSkuReDomain.getPricesetRefrice()) {
                    rsSkuReDomain.setPricesetRefrice(BigDecimal.ZERO);
                }
                contractGoodsDomain.setContractGoodsPefprice(rsSkuReDomain.getPricesetRefrice());
                this.makeGoods(contractGoodsDomain);
                contractGoodsDomainList.add(contractGoodsDomain);
            }
        }
        if (null != giftSkuIdList && giftSkuIdList.size() > 0) {
            for (SkuDomain skuDomain : giftSkuIdList) {
                contractGoodsDomain = new OcContractGoodsDomain();
                rsSkuReDomain = null;
                if (null != skuDomain.getSkuId()) {
                    rsSkuReDomain = this.rsSkuServiceRepository.getSku(skuDomain.getSkuId());
                } else if (StringUtils.isNotBlank((String)skuDomain.getSkuCode())) {
                    map = new HashMap();
                    map.put("skuCode", skuDomain.getSkuCode());
                    map.put("tenantCode", ocContractDomain.getTenantCode());
                    rsSkuReDomain = this.rsSkuServiceRepository.getSkuByCode(map);
                }
                if (null == rsSkuReDomain) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.skuId", (Object)("\u8d60\u54c1\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuId()));
                    throw new Exception("\u8d60\u54c1\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                if (1 != rsSkuReDomain.getDataOpbillstate() || null == rsSkuReDomain.getGoodsSupplynum() || rsSkuReDomain.getGoodsSupplynum().longValue() <= 0L) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.rsSkuReDomain", (Object)"GoodsSupplynum is null");
                    throw new Exception("\u8d60\u54c1\u5546\u54c1\u4e0d\u5b58\u5728\u6216\u5e93\u5b58\u4e0d\u8db3");
                }
                map = new HashMap();
                map.put("goodsCode", rsSkuReDomain.getGoodsCode());
                map.put("tenantCode", rsSkuReDomain.getTenantCode());
                rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
                if (null == rsResourceGoodsReDomain) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.skuId", (Object)("\u8d60\u54c1\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuId()));
                    throw new Exception("\u8d60\u54c1\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                if (StringUtils.isBlank((String)ocContractDomain.getMemberCode())) {
                    ocContractDomain.setMemberCode(rsResourceGoodsReDomain.getMemberCode());
                    ocContractDomain.setMemberName(rsResourceGoodsReDomain.getMemberName());
                }
                BeanUtils.copyAllPropertys((Object)contractGoodsDomain, (Object)rsResourceGoodsReDomain);
                BeanUtils.copyAllPropertys((Object)contractGoodsDomain, (Object)rsSkuReDomain);
                contractGoodsDomain.setMemberBcode(ocContractDomain.getMemberBcode());
                contractGoodsDomain.setMemberBname(ocContractDomain.getMemberBname());
                contractGoodsDomain.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
                contractGoodsDomain.setGoodsCamount(skuDomain.getGoodsNum());
                contractGoodsDomain.setGoodsCweight(null == skuDomain.getGoodsWeght() ? BigDecimal.ZERO : skuDomain.getGoodsWeght());
                contractGoodsDomain.setGoodsNum(skuDomain.getGoodsNum());
                contractGoodsDomain.setGoodsWeight(skuDomain.getGoodsWeght());
                contractGoodsDomain.setContractGoodsInmoney(BigDecimal.ZERO);
                contractGoodsDomain.setContractGoodsMoney(BigDecimal.ZERO);
                contractGoodsDomain.setContractGoodsPrice(BigDecimal.ZERO);
                contractGoodsDomain.setContractGoodsPefinmoney(BigDecimal.ZERO);
                contractGoodsDomain.setContractGoodsPefmoney(BigDecimal.ZERO);
                contractGoodsDomain.setContractGoodsPefprice(BigDecimal.ZERO);
                contractGoodsDomain.setContractGoodsAppraise(0);
                contractGoodsDomain.setRefundFlag(0);
                contractGoodsDomainList.add(contractGoodsDomain);
            }
        }
        if (ListUtil.isEmpty(contractGoodsDomainList)) {
            this.logger.info(CODE + ".makeContractGoodsDomainList.contractGoodsDomainList.empty", (Object)"\u8d2d\u7269\u8f66\u4e3a\u7a7a");
            throw new Exception("\u8d2d\u7269\u8f66\u4e3a\u7a7a");
        }
        return contractGoodsDomainList;
    }

    public HtmlJsonReBean sendContractByDel(OcContractDomain ocContractDomain, List<Integer> shoppingGoodsIdList) {
        PostParamMap pmap = new PostParamMap("oc.shopping.sendContractByDel");
        pmap.putParamToJson("ocContractDomain", (Object)ocContractDomain);
        pmap.putParamToJson("shoppingGoodsIdList", shoppingGoodsIdList);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean calculateContract(OcContractDomain contractDomain) {
        BigDecimal goodsNum = BigDecimal.ZERO;
        BigDecimal goodsWeight = BigDecimal.ZERO;
        BigDecimal contractInmoney = BigDecimal.ZERO;
        BigDecimal contractMoney = BigDecimal.ZERO;
        BigDecimal dataBnum = BigDecimal.ZERO;
        BigDecimal dataBweight = BigDecimal.ZERO;
        BigDecimal goodsLogmoney = BigDecimal.ZERO;
        BigDecimal pefMoney = BigDecimal.ZERO;
        String goodsPmbillno = "";
        for (OcPackageDomain ocPackageDomain : contractDomain.getPackageList()) {
            if (null == ocPackageDomain.getGoodsNum()) {
                ocPackageDomain.setGoodsNum(BigDecimal.ZERO);
            }
            goodsNum = goodsNum.add(ocPackageDomain.getGoodsNum());
            if (null == ocPackageDomain.getGoodsWeight()) {
                ocPackageDomain.setGoodsWeight(BigDecimal.ZERO);
            }
            goodsWeight = goodsWeight.add(ocPackageDomain.getGoodsWeight());
            if (null == ocPackageDomain.getGoodsMoney()) {
                ocPackageDomain.setGoodsMoney(BigDecimal.ZERO);
            }
            contractInmoney = contractInmoney.add(ocPackageDomain.getGoodsMoney());
            goodsLogmoney = goodsLogmoney.add(new BigDecimal(ocPackageDomain.getPackageFare()));
            if (null == ocPackageDomain.getGoodsPmoney()) {
                ocPackageDomain.setGoodsPmoney(BigDecimal.ZERO);
            }
            contractMoney = contractMoney.add(ocPackageDomain.getGoodsPmoney());
            if (null == ocPackageDomain.getPricesetRefrice()) {
                ocPackageDomain.setPricesetRefrice(BigDecimal.ZERO);
            }
            pefMoney = pefMoney.add(ocPackageDomain.getPricesetRefrice());
            if (!StringUtils.isNotBlank((String)ocPackageDomain.getGoodsPmbillno())) continue;
            goodsPmbillno = goodsPmbillno + ";" + ocPackageDomain.getGoodsPmbillno();
        }
        if (StringUtils.isNotBlank((String)goodsPmbillno)) {
            goodsPmbillno = goodsPmbillno.substring(1);
        }
        dataBnum = goodsNum;
        dataBweight = goodsWeight;
        List<OcContractSettlDomain> ocContractSettlDomainList = contractDomain.getOcContractSettlList();
        if (null == ocContractSettlDomainList) {
            ocContractSettlDomainList = new ArrayList<OcContractSettlDomain>();
        }
        contractDomain.setOcContractSettlList(ocContractSettlDomainList);
        contractDomain.setPricesetRefrice(pefMoney);
        contractDomain.setGoodsNum(goodsNum);
        contractDomain.setGoodsWeight(goodsWeight);
        contractDomain.setContractInmoney(contractInmoney);
        contractDomain.setContractMoney(contractMoney.add(goodsLogmoney));
        contractDomain.setDataBnum(dataBnum);
        contractDomain.setDataBweight(dataBweight);
        contractDomain.setDataBmoney(contractMoney.add(goodsLogmoney).add(pefMoney));
        contractDomain.setGoodsLogmoney(goodsLogmoney);
        contractDomain.setGoodsPmoney(contractInmoney.subtract(contractMoney));
        contractDomain.setGoodsPmbillno(goodsPmbillno);
        return new HtmlJsonReBean();
    }

    private Map<String, BigDecimal> getListToMap(List<OcContractSettlDomain> ocContractSettlDomainList) {
        if (ListUtil.isEmpty(ocContractSettlDomainList)) {
            return null;
        }
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        HashMap<String, String> settlTypeMap = new HashMap<String, String>();
        for (ContractSettlType contractSettlType : ContractSettlType.values()) {
            settlTypeMap.put(contractSettlType.getCode(), contractSettlType.getType());
        }
        for (OcContractSettlDomain ocContractSettlDomain : ocContractSettlDomainList) {
            BigDecimal sum;
            ocContractSettlDomain.setContractSettlType((String)settlTypeMap.get(ocContractSettlDomain.getContractSettlBlance()));
            if (null == ocContractSettlDomain.getContractSettlPmoney()) {
                ocContractSettlDomain.setContractSettlPmoney(BigDecimal.ZERO);
            }
            if (null == (sum = (BigDecimal)map.get(ocContractSettlDomain.getContractSettlBlance()))) {
                map.put(ocContractSettlDomain.getContractSettlBlance(), ocContractSettlDomain.getContractSettlPmoney());
                continue;
            }
            map.put(ocContractSettlDomain.getContractSettlBlance(), sum.add(ocContractSettlDomain.getContractSettlPmoney()));
        }
        return map;
    }

    public void makePack(OcContractDomain ocContractDomain, OcPackageDomain ocPackageDomain) throws Exception {
        if (null == ocPackageDomain || null == ocContractDomain) {
            return;
        }
        BigDecimal goodsMoney = BigDecimal.ZERO;
        BigDecimal goodsInmoney = BigDecimal.ZERO;
        BigDecimal goodsPef = BigDecimal.ZERO;
        BigDecimal packageGoodsWeight = BigDecimal.ZERO;
        BigDecimal packageGoodsNum = BigDecimal.ZERO;
        for (OcContractGoodsDomain ocContractGoodsDomain : ocPackageDomain.getContractGoodsList()) {
            if (null == ocContractGoodsDomain.getGoodsNum()) {
                ocContractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
            }
            packageGoodsNum = packageGoodsNum.add(ocContractGoodsDomain.getGoodsNum());
            if (null == ocContractGoodsDomain.getContractGoodsInmoney()) {
                ocContractGoodsDomain.setContractGoodsInmoney(BigDecimal.ZERO);
            }
            goodsInmoney = goodsInmoney.add(ocContractGoodsDomain.getContractGoodsInmoney());
            if (null == ocContractGoodsDomain.getContractGoodsMoney()) {
                ocContractGoodsDomain.setContractGoodsMoney(BigDecimal.ZERO);
            }
            goodsMoney = goodsMoney.add(ocContractGoodsDomain.getContractGoodsMoney());
            if (null == ocContractGoodsDomain.getContractGoodsPefinmoney()) {
                ocContractGoodsDomain.setContractGoodsPefinmoney(BigDecimal.ZERO);
            }
            goodsPef = goodsPef.add(ocContractGoodsDomain.getContractGoodsPefinmoney());
            if (null == ocContractGoodsDomain.getGoodsWeight()) {
                ocContractGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
            }
            packageGoodsWeight = packageGoodsWeight.add(ocContractGoodsDomain.getGoodsWeight());
            if (StringUtils.isBlank((String)ocContractDomain.getMemberCode())) {
                ocContractDomain.setMemberCode(ocContractGoodsDomain.getMemberCode());
                ocContractDomain.setMemberName(ocContractGoodsDomain.getMemberName());
            }
            if (!StringUtils.isBlank((String)ocPackageDomain.getMemberCode())) continue;
            ocPackageDomain.setMemberCode(ocContractGoodsDomain.getMemberCode());
            ocPackageDomain.setMemberName(ocContractGoodsDomain.getMemberName());
        }
        ocPackageDomain.setGoodsWeight(packageGoodsWeight);
        ocPackageDomain.setGoodsNum(packageGoodsNum);
        ocPackageDomain.setWarehouseName(ocContractDomain.getWarehouseName());
        ocPackageDomain.setMemberBcode(ocContractDomain.getMemberBcode());
        ocPackageDomain.setMemberBname(ocContractDomain.getMemberBname());
        BigDecimal freightFare = BigDecimal.ZERO;
        TypeBean typeBean = this.getOcSetting(ocContractDomain.getContractType(), ocContractDomain.getTenantCode());
        if (null == typeBean || this.checkFreight(typeBean)) {
            freightFare = this.getFreightFare(ocPackageDomain.getContractGoodsList(), ocContractDomain.getAreaCode());
        }
        if (null == freightFare) {
            freightFare = BigDecimal.ZERO;
        }
        ocPackageDomain.setPackageFare(freightFare.toString());
        ocPackageDomain.setGoodsMoney(goodsInmoney);
        ocPackageDomain.setPricesetRefrice(goodsPef);
        ocPackageDomain.setGoodsPmoney(goodsMoney);
    }

    public BigDecimal getFreightFare(List<OcContractGoodsDomain> ocContractGoodsDomainList, String areaCode) throws Exception {
        String freightExpCode;
        if (ListUtil.isEmpty(ocContractGoodsDomainList)) {
            throw new Exception("\u5546\u54c1\u5217\u8868\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)areaCode)) {
            return BigDecimal.ZERO;
        }
        HashMap<String, String> skuParamMap = new HashMap<String, String>();
        HashMap<String, String> expParamMap = new HashMap<String, String>();
        HashMap<String, BigDecimal> quantityMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> weightMap = new HashMap<String, BigDecimal>();
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractGoodsDomainList) {
            RsSkuReDomain rsSkuReDomain;
            skuParamMap.clear();
            skuParamMap.put("skuCode", ocContractGoodsDomain.getSkuCode());
            if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getTenantCode())) {
                skuParamMap.put("tenantCode", ocContractGoodsDomain.getTenantCode());
            }
            if ((rsSkuReDomain = this.rsSkuServiceRepository.getSkuByCode(skuParamMap)) == null) {
                throw new Exception("\u5546\u54c1sku\u4fe1\u606f\u6709\u8bef" + ((Object)skuParamMap).toString());
            }
            freightExpCode = rsSkuReDomain.getFreightTemCode();
            if (StringUtils.isBlank((String)freightExpCode)) continue;
            BigDecimal cquantity = (BigDecimal)quantityMap.get(freightExpCode);
            if (cquantity == null) {
                cquantity = BigDecimal.ZERO;
            }
            if (null == ocContractGoodsDomain.getGoodsCamount()) {
                ocContractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
            }
            cquantity = cquantity.add(ocContractGoodsDomain.getGoodsCamount());
            quantityMap.put(freightExpCode, cquantity);
            BigDecimal cweight = (BigDecimal)weightMap.get(freightExpCode);
            if (cweight == null) {
                cweight = BigDecimal.ZERO;
            }
            if (ocContractGoodsDomain.getGoodsOneweight() != null) {
                cweight = ocContractGoodsDomain.getGoodsCamount().multiply(ocContractGoodsDomain.getGoodsOneweight());
            }
            if ((null == cweight || cweight.compareTo(BigDecimal.ZERO) == 0) && ocContractGoodsDomain.getGoodsWeight() != null) {
                cweight = cweight.add(ocContractGoodsDomain.getGoodsWeight());
            }
            weightMap.put(freightExpCode, cweight);
        }
        BigDecimal freightFare = BigDecimal.ZERO;
        for (Map.Entry entry : quantityMap.entrySet()) {
            freightExpCode = (String)entry.getKey();
            expParamMap.clear();
            expParamMap.put("freightExpCode", freightExpCode);
            expParamMap.put("areaCode", areaCode);
            expParamMap.put("quantity", (String)entry.getValue());
            expParamMap.put("weight", (String)weightMap.get(freightExpCode));
            BigDecimal fare = this.wlFreightTemServiceRepository.getFreightFare(expParamMap);
            if (fare == null) continue;
            freightFare = freightFare.add(fare);
        }
        return freightFare;
    }

    public void makeGoods(OcContractGoodsDomain contractGoodsDomain) {
        if (null == contractGoodsDomain) {
            return;
        }
        if (null == contractGoodsDomain.getGoodsNum()) {
            contractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == contractGoodsDomain.getPricesetNprice()) {
            contractGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
        }
        BigDecimal inmoney = contractGoodsDomain.getPricesetNprice().multiply(contractGoodsDomain.getGoodsNum());
        contractGoodsDomain.setContractGoodsInmoney(inmoney);
        if (null == contractGoodsDomain.getPricesetRefrice()) {
            contractGoodsDomain.setPricesetRefrice(BigDecimal.ZERO);
        }
        BigDecimal refmoney = contractGoodsDomain.getPricesetRefrice().multiply(contractGoodsDomain.getGoodsNum());
        contractGoodsDomain.setContractGoodsPefinmoney(refmoney);
        contractGoodsDomain.setContractGoodsPefmoney(refmoney);
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal contractGoodsMoney = inmoney.subtract(discountAmount);
        if (null != contractGoodsDomain.getGoodsNum() && BigDecimal.ZERO.compareTo(contractGoodsDomain.getGoodsNum()) != 0) {
            contractGoodsDomain.setContractGoodsPrice(contractGoodsMoney.divide(contractGoodsDomain.getGoodsNum(), 2, 4));
        }
        contractGoodsDomain.setContractGoodsMoney(contractGoodsMoney);
        contractGoodsDomain.setContractGoodsAppraise(0);
        contractGoodsDomain.setRefundFlag(0);
    }

    public OcContractDomain makeContractDomain(OrderDomain orderDomain, String contractType, UserSession userSession, String proappCode) throws Exception {
        TypeBean typeBean;
        if (null == userSession || null == orderDomain) {
            this.logger.error("OcServiceRepository.saveContract", (Object)"UserSession is null");
            return null;
        }
        OcContractDomain contractDomain = new OcContractDomain();
        try {
            BeanUtils.copyAllPropertys((Object)contractDomain, (Object)orderDomain);
        }
        catch (Exception e) {
            this.logger.error("OcServiceRepository.makeContractDomain.ex", (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((String)contractDomain.getContractType())) {
            if (StringUtils.isBlank((String)contractType)) {
                contractType = ContractType.CON.getCode();
            }
            contractDomain.setContractType(contractType);
        }
        if (null != (typeBean = this.getOcSetting(contractDomain.getContractType(), contractDomain.getTenantCode()))) {
            if (StringUtils.isBlank((String)contractDomain.getContractBlance())) {
                contractDomain.setContractBlance(typeBean.getBlance());
            }
            if (StringUtils.isBlank((String)contractDomain.getContractPmode())) {
                contractDomain.setContractPmode(typeBean.getPmode());
            }
        }
        this.createPackageDomainListOnOrder_temp(orderDomain);
        contractDomain.setMemberBcode(userSession.getUserPcode());
        contractDomain.setMemberBname(userSession.showUserName());
        contractDomain.setTenantCode(userSession.getTenantCode());
        contractDomain.setAppmanageIcode(proappCode);
        return contractDomain;
    }

    private List<PackageDomain> createPackageDomainListOnOrder_temp(OrderDomain orderDomain) {
        PackageDomain packageDomain;
        List<PackageDomain> packageDomainList = orderDomain.getPackageList();
        if (packageDomainList != null) {
            return packageDomainList;
        }
        packageDomainList = new ArrayList<PackageDomain>();
        if (packageDomainList.isEmpty()) {
            packageDomain = new PackageDomain();
            packageDomainList.add(packageDomain);
            orderDomain.setPackageList(packageDomainList);
        } else {
            packageDomain = packageDomainList.get(0);
        }
        if (StringUtils.isNotBlank((String)orderDomain.getPackageMode())) {
            packageDomain.setPackageMode(orderDomain.getPackageMode());
        } else {
            packageDomain.setPackageMode("0");
        }
        packageDomain.setShoppingGoodsIdList(orderDomain.getShoppingGoodsIdList());
        packageDomain.setSkuIdList(orderDomain.getSkuIdList());
        return packageDomainList;
    }

    public OcShoppingDomain makeOcShoppingDomain(UserSession userSession, GoodsBean goodsBean) {
        ArrayList<GoodsBean> skuCodeList = new ArrayList<GoodsBean>();
        skuCodeList.add(goodsBean);
        List<OcShoppingDomain> list = this.makeOcShoppingDomainList(userSession, skuCodeList);
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    private void createShoppingpackgeGroupby(GoodsBean goodsBean, UserSession userSession, String str, OcShoppingDomain ocShopping, OcShoppingGoodsDomain ocShoppingGoodsDomain, Map<String, OcShoppingpackgeDomain> shoppingpackgeMap) {
        List<OcShoppingGoodsDomain> shoppingGoodsList;
        if (null == goodsBean || null == userSession || null == ocShoppingGoodsDomain || null == shoppingpackgeMap || null == ocShopping) {
            return;
        }
        String mapKey = "";
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)str)) {
            String[] param = str.split("\\|");
            Object obj = null;
            for (String s : param) {
                obj = BeanUtils.forceGetProperty((Object)ocShoppingGoodsDomain, (String)s);
                if (null == obj) continue;
                parammap.put(s, obj);
                if (StringUtils.isNotBlank((String)mapKey)) {
                    mapKey = mapKey + "-";
                }
                mapKey = mapKey + obj;
            }
        } else {
            parammap.put("memberCode", ocShoppingGoodsDomain.getMemberCode());
            if (StringUtils.isNotBlank((String)mapKey)) {
                mapKey = mapKey + "-";
            }
            mapKey = mapKey + ocShoppingGoodsDomain.getMemberCode();
        }
        if (StringUtils.isNotBlank((String)mapKey)) {
            mapKey = mapKey + "-";
        }
        mapKey = mapKey + ocShopping.getShoppingCode();
        parammap.put("shoppingCode", ocShopping.getShoppingCode());
        if (StringUtils.isNotBlank((String)mapKey)) {
            mapKey = mapKey + "-";
        }
        mapKey = mapKey + ocShoppingGoodsDomain.getMemberBcode();
        parammap.put("memberBcode", ocShoppingGoodsDomain.getMemberBcode());
        if (StringUtils.isNotBlank((String)mapKey)) {
            mapKey = mapKey + "-";
        }
        mapKey = mapKey + ocShoppingGoodsDomain.getChannelCode();
        parammap.put("channelCode", ocShoppingGoodsDomain.getChannelCode());
        if (StringUtils.isNotBlank((String)mapKey)) {
            mapKey = mapKey + "-";
        }
        mapKey = mapKey + ocShoppingGoodsDomain.getTenantCode();
        parammap.put("tenantCode", ocShoppingGoodsDomain.getTenantCode());
        OcShoppingpackgeDomain ocShoppingpackge = null;
        ocShoppingpackge = shoppingpackgeMap.get(mapKey);
        if (null == ocShoppingGoodsDomain.getGoodsCamount()) {
            ocShoppingGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
        }
        if (null == ocShoppingGoodsDomain.getGoodsCweight()) {
            ocShoppingGoodsDomain.setGoodsCweight(BigDecimal.ZERO);
        }
        if (null == ocShoppingpackge) {
            ocShoppingpackge = this.createShoppingpackgeByGoods(ocShopping, ocShoppingGoodsDomain);
            ocShoppingpackge.setPmCheckBean(this.getPmCheckBean(goodsBean.getChannelCode(), goodsBean.getProappCode(), ocShoppingGoodsDomain.getTenantCode(), userSession));
            List<OcShoppingpackgeDomain> ocShoppingpackgeList = ocShopping.getShoppingpackageList();
            if (null == ocShoppingpackgeList) {
                ocShoppingpackgeList = new ArrayList<OcShoppingpackgeDomain>();
            }
            ocShoppingpackgeList.add(ocShoppingpackge);
            ocShopping.setShoppingpackageList(ocShoppingpackgeList);
            ocShoppingGoodsDomain.setShoppingpackgeCode(ocShoppingpackge.getShoppingpackgeCode());
            shoppingpackgeMap.put(mapKey, ocShoppingpackge);
            shoppingGoodsList = new ArrayList<OcShoppingGoodsDomain>();
            ocShoppingpackge.setShoppingGoodsList(shoppingGoodsList);
            shoppingGoodsList.add(ocShoppingGoodsDomain);
        } else {
            shoppingGoodsList = ocShoppingpackge.getShoppingGoodsList();
            if (null == shoppingGoodsList) {
                shoppingGoodsList = new ArrayList<OcShoppingGoodsDomain>();
                ocShoppingpackge.setShoppingGoodsList(shoppingGoodsList);
            }
            shoppingGoodsList.add(ocShoppingGoodsDomain);
            if (null == ocShoppingpackge.getGoodsNum()) {
                ocShoppingpackge.setGoodsNum(BigDecimal.ZERO);
            }
            if (null == ocShoppingpackge.getGoodsWeight()) {
                ocShoppingpackge.setGoodsWeight(BigDecimal.ZERO);
            }
            ocShoppingpackge.setGoodsNum(ocShoppingpackge.getGoodsNum().add(ocShoppingGoodsDomain.getGoodsCamount()));
            ocShoppingpackge.setGoodsWeight(ocShoppingpackge.getGoodsWeight().add(ocShoppingGoodsDomain.getGoodsCweight()));
            if (null == ocShoppingGoodsDomain.getPricesetNprice()) {
                ocShoppingGoodsDomain.setPricesetNprice(new BigDecimal("0"));
            }
            ocShoppingpackge.setGoodsMoney(ocShoppingpackge.getGoodsMoney().add(ocShoppingGoodsDomain.getGoodsCamount().multiply(ocShoppingGoodsDomain.getPricesetNprice())));
            if (null == ocShoppingGoodsDomain.getPricesetRefrice()) {
                ocShoppingGoodsDomain.setPricesetRefrice(new BigDecimal("0"));
            }
            ocShoppingpackge.setPricesetRefrice(ocShoppingpackge.getPricesetRefrice().add(ocShoppingGoodsDomain.getGoodsCamount().multiply(ocShoppingGoodsDomain.getPricesetRefrice())));
        }
    }

    private OcShoppingpackgeDomain createShoppingpackgeByGoods(OcShoppingDomain ocShopping, OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        if (ocShoppingGoodsDomain == null || null == ocShopping) {
            return null;
        }
        OcShoppingpackgeDomain ocShoppingpackge = new OcShoppingpackgeDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocShoppingpackge, (Object)ocShoppingGoodsDomain);
            BeanUtils.copyAllPropertys((Object)ocShoppingpackge, (Object)ocShopping);
        }
        catch (Exception e) {
            // empty catch block
        }
        ocShoppingpackge.setGoodsNum(ocShoppingGoodsDomain.getGoodsCamount());
        ocShoppingpackge.setGoodsWeight(ocShoppingGoodsDomain.getGoodsCweight());
        if (null == ocShoppingGoodsDomain.getPricesetNprice()) {
            ocShoppingGoodsDomain.setPricesetNprice(new BigDecimal("0"));
        }
        ocShoppingpackge.setGoodsMoney(ocShoppingGoodsDomain.getGoodsCamount().multiply(ocShoppingGoodsDomain.getPricesetNprice()));
        if (null == ocShoppingGoodsDomain.getPricesetRefrice()) {
            ocShoppingGoodsDomain.setPricesetRefrice(new BigDecimal("0"));
        }
        ocShoppingpackge.setPricesetRefrice(ocShoppingGoodsDomain.getGoodsCamount().multiply(ocShoppingGoodsDomain.getPricesetRefrice()));
        return ocShoppingpackge;
    }

    private OcShoppingDomain getShoppingGroupby(String str, OcShoppingGoodsDomain ocShoppingGoodsDomain, Map<String, OcShoppingDomain> shoppingMap) {
        if (null == ocShoppingGoodsDomain || null == shoppingMap) {
            return null;
        }
        String mapKey = "";
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)str)) {
            String[] param = str.split("\\|");
            Object obj = null;
            for (String s : param) {
                obj = BeanUtils.forceGetProperty((Object)ocShoppingGoodsDomain, (String)s);
                if (null == obj) continue;
                parammap.put(s, obj);
                if (StringUtils.isNotBlank((String)mapKey)) {
                    mapKey = mapKey + "-";
                }
                mapKey = mapKey + obj;
            }
        } else {
            parammap.put("memberCode", ocShoppingGoodsDomain.getMemberCode());
            if (StringUtils.isNotBlank((String)mapKey)) {
                mapKey = mapKey + "-";
            }
            mapKey = mapKey + ocShoppingGoodsDomain.getMemberCode();
        }
        if (StringUtils.isNotBlank((String)mapKey)) {
            mapKey = mapKey + "-";
        }
        mapKey = mapKey + ocShoppingGoodsDomain.getMemberBcode();
        parammap.put("memberBcode", ocShoppingGoodsDomain.getMemberBcode());
        if (StringUtils.isNotBlank((String)mapKey)) {
            mapKey = mapKey + "-";
        }
        mapKey = mapKey + ocShoppingGoodsDomain.getChannelCode();
        parammap.put("channelCode", ocShoppingGoodsDomain.getChannelCode());
        if (StringUtils.isNotBlank((String)mapKey)) {
            mapKey = mapKey + "-";
        }
        mapKey = mapKey + ocShoppingGoodsDomain.getTenantCode();
        parammap.put("tenantCode", ocShoppingGoodsDomain.getTenantCode());
        String shoppingType = StringUtils.isBlank((String)ocShoppingGoodsDomain.getShoppingType()) ? ocShoppingGoodsDomain.getGoodsType() : ocShoppingGoodsDomain.getShoppingType();
        parammap.put("shoppingType", shoppingType);
        if (StringUtils.isNotBlank((String)mapKey)) {
            mapKey = mapKey + "-";
        }
        mapKey = mapKey + parammap.get("shoppingType");
        OcShoppingDomain ocShoppingDomain = null;
        ocShoppingDomain = shoppingMap.get(mapKey);
        if (null == ocShoppingGoodsDomain.getGoodsCamount()) {
            ocShoppingGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
        }
        if (null == ocShoppingGoodsDomain.getGoodsCweight()) {
            ocShoppingGoodsDomain.setGoodsCweight(BigDecimal.ZERO);
        }
        if (null == ocShoppingDomain) {
            ocShoppingDomain = this.createShoppingByGoods(ocShoppingGoodsDomain);
            ocShoppingDomain.setShoppingType(shoppingType);
            ocShoppingGoodsDomain.setShoppingCode(ocShoppingDomain.getShoppingCode());
            shoppingMap.put(mapKey, ocShoppingDomain);
        } else {
            if (null == ocShoppingDomain.getShoppingCamount()) {
                ocShoppingDomain.setShoppingCamount(BigDecimal.ZERO);
            }
            if (null == ocShoppingDomain.getShoppingCweight()) {
                ocShoppingDomain.setShoppingCweight(BigDecimal.ZERO);
            }
            ocShoppingDomain.setShoppingCamount(ocShoppingDomain.getShoppingCamount().add(ocShoppingGoodsDomain.getGoodsCamount()));
            ocShoppingDomain.setShoppingCweight(ocShoppingDomain.getShoppingCweight().add(ocShoppingGoodsDomain.getGoodsCweight()));
            if (null == ocShoppingGoodsDomain.getPricesetNprice()) {
                ocShoppingGoodsDomain.setPricesetNprice(new BigDecimal("0"));
            }
            ocShoppingDomain.setGoodsMoney(ocShoppingDomain.getGoodsMoney().add(ocShoppingDomain.getShoppingCamount().multiply(ocShoppingGoodsDomain.getPricesetNprice())));
            if (null == ocShoppingGoodsDomain.getPricesetRefrice()) {
                ocShoppingGoodsDomain.setPricesetRefrice(new BigDecimal("0"));
            }
            ocShoppingDomain.setPricesetRefrice(ocShoppingDomain.getPricesetRefrice().add(ocShoppingDomain.getShoppingCamount().multiply(ocShoppingGoodsDomain.getPricesetRefrice())));
        }
        return ocShoppingDomain;
    }

    private OcShoppingDomain createShoppingByGoods(OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        if (ocShoppingGoodsDomain == null) {
            return null;
        }
        OcShoppingDomain ocShopping = new OcShoppingDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocShopping, (Object)ocShoppingGoodsDomain);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (StringUtils.isEmpty((String)ocShopping.getShoppingType())) {
            String shoppingType = StringUtils.isBlank((String)ocShoppingGoodsDomain.getShoppingType()) ? ocShoppingGoodsDomain.getGoodsType() : ocShoppingGoodsDomain.getShoppingType();
            ocShopping.setShoppingType(shoppingType);
        }
        ocShopping.setShoppingCamount(ocShoppingGoodsDomain.getGoodsCamount());
        ocShopping.setShoppingCweight(ocShoppingGoodsDomain.getGoodsCweight());
        if (null == ocShoppingGoodsDomain.getPricesetNprice()) {
            ocShoppingGoodsDomain.setPricesetNprice(new BigDecimal("0"));
        }
        ocShopping.setGoodsMoney(ocShopping.getShoppingCamount().multiply(ocShoppingGoodsDomain.getPricesetNprice()));
        if (null == ocShoppingGoodsDomain.getPricesetRefrice()) {
            ocShoppingGoodsDomain.setPricesetRefrice(new BigDecimal("0"));
        }
        ocShopping.setPricesetRefrice(ocShopping.getShoppingCamount().multiply(ocShoppingGoodsDomain.getPricesetRefrice()));
        return ocShopping;
    }

    public OcShoppingGoodsDomain createShoppingGoodsDomain(UserSession userSession, GoodsBean goodsBean) {
        RsSkuReDomain rsSkuReDomain;
        if (null == goodsBean) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (null == goodsBean.getSkuId()) {
            map.put("skuCode", goodsBean.getSkuCode());
            map.put("tenantCode", userSession.getTenantCode());
            rsSkuReDomain = this.rsSkuServiceRepository.getSkuByCode(map);
        } else {
            rsSkuReDomain = this.rsSkuServiceRepository.getSku(goodsBean.getSkuId());
        }
        if (null == rsSkuReDomain) {
            return null;
        }
        if (null == rsSkuReDomain.getGoodsSupplynum()) {
            rsSkuReDomain.setGoodsSupplynum(BigDecimal.ZERO);
        }
        if (null == goodsBean.getGoodsNum()) {
            goodsBean.setGoodsNum(BigDecimal.ZERO);
        }
        if (1 != rsSkuReDomain.getDataOpbillstate() || rsSkuReDomain.getGoodsSupplynum().subtract(goodsBean.getGoodsNum()).compareTo(BigDecimal.ZERO) < 0) {
            this.logger.error(CODE + ".insertBatchShoppingGoods.rsSkuReDomain", (Object)"GoodsSupplynum is null");
            return null;
        }
        map.put("goodsCode", rsSkuReDomain.getGoodsCode());
        map.put("tenantCode", rsSkuReDomain.getTenantCode());
        map.put("unwantedRelatedData", "unwantedRelatedData");
        RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
        if (null == rsResourceGoodsReDomain) {
            return null;
        }
        OcShoppingGoodsDomain ocShoppingGoodsDomain = new OcShoppingGoodsDomain();
        try {
            String shoppingType;
            BeanUtils.copyAllPropertys((Object)ocShoppingGoodsDomain, (Object)rsResourceGoodsReDomain);
            BeanUtils.copyAllPropertys((Object)ocShoppingGoodsDomain, (Object)rsSkuReDomain);
            ocShoppingGoodsDomain.setShoppingGoodsAmount(rsSkuReDomain.getGoodsSupplynum());
            ocShoppingGoodsDomain.setShoppingGoodsWeight(rsSkuReDomain.getGoodsSupplyweight());
            ocShoppingGoodsDomain.setGoodsCamount(goodsBean.getGoodsNum());
            ocShoppingGoodsDomain.setGoodsCweight(goodsBean.getGoodsWeght());
            ocShoppingGoodsDomain.setMemberBcode(userSession.getUserPcode());
            ocShoppingGoodsDomain.setMemberBname(userSession.getMerberCompname());
            ocShoppingGoodsDomain.setTenantCode(rsSkuReDomain.getTenantCode());
            ocShoppingGoodsDomain.setShoppingGoodsPm(goodsBean.getShoppingGoodsPm());
            if (StringUtils.isNotBlank((String)goodsBean.getGoodsContract())) {
                ocShoppingGoodsDomain.setGoodsContract(goodsBean.getGoodsContract());
            }
            if (StringUtils.isNotBlank((String)(shoppingType = goodsBean.getShoppingType()))) {
                ocShoppingGoodsDomain.setShoppingType(shoppingType);
            } else {
                ocShoppingGoodsDomain.setShoppingType(StringUtils.fillLeft((String)ocShoppingGoodsDomain.getGoodsType(), (char)'0', (int)2));
            }
        }
        catch (Exception e) {
            this.logger.error(CODE + ".insertBatchShoppingGoods.e1", (Throwable)e);
            return null;
        }
        return ocShoppingGoodsDomain;
    }

    public List<OcShoppingDomain> makeOcShoppingDomainList(UserSession userSession, List<GoodsBean> skuCodeList) {
        String shoppingpackgeStr;
        if (ListUtil.isEmpty(skuCodeList) || null == userSession) {
            this.logger.error(CODE + ".makeOcShoppingDomainList.param", (Object)"param is null");
            return null;
        }
        HashMap<String, OcShoppingDomain> shoppingMap = new HashMap<String, OcShoppingDomain>();
        HashMap<String, OcShoppingpackgeDomain> shoppingpackgeMap = new HashMap<String, OcShoppingpackgeDomain>();
        OcShoppingDomain ocShoppingDomain = null;
        String tenantCode = userSession.getTenantCode();
        String shoppingStr = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-shopping-shoppingkey"));
        if (StringUtils.isBlank((String)shoppingStr)) {
            shoppingStr = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-shopping-shoppingkey");
        }
        if (StringUtils.isBlank((String)(shoppingpackgeStr = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-shopping-shoppingpackgekey"))))) {
            shoppingpackgeStr = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-shopping-shoppingpackgekey");
        }
        ArrayList<OcShoppingDomain> ocShoppingList = new ArrayList<OcShoppingDomain>();
        for (GoodsBean goodsBean : skuCodeList) {
            OcShoppingGoodsDomain ocShoppingGoodsDomain = this.createShoppingGoodsDomain(userSession, goodsBean);
            if (null == ocShoppingGoodsDomain) {
                this.logger.error(CODE + ".makeOcShoppingDomainList.ocShoppingGoodsDomain");
                return null;
            }
            ocShoppingDomain = this.createShoppingDomain(userSession, shoppingMap, shoppingStr, ocShoppingGoodsDomain, goodsBean);
            if (null == ocShoppingDomain) {
                this.logger.error(CODE + ".makeOcShoppingDomainList.ocShoppingDomain");
                return null;
            }
            this.createShoppingpackgeGroupby(goodsBean, userSession, shoppingpackgeStr, ocShoppingDomain, ocShoppingGoodsDomain, shoppingpackgeMap);
            ocShoppingList.add(ocShoppingDomain);
        }
        return ocShoppingList;
    }

    private OcShoppingDomain createShoppingDomain(UserSession userSession, Map<String, OcShoppingDomain> shoppingMap, String shoppingStr, OcShoppingGoodsDomain ocShoppingGoodsDomain, GoodsBean goodsBean) {
        if (null == goodsBean || null == shoppingMap || null == userSession || null == ocShoppingGoodsDomain) {
            return null;
        }
        OcShoppingDomain ocShoppingDomain = this.getShoppingGroupby(shoppingStr, ocShoppingGoodsDomain, shoppingMap);
        if (null == ocShoppingDomain) {
            this.logger.error(CODE + ".insertBatchShoppingGoods.ocShoppingDomain");
            return null;
        }
        String shoppingType = goodsBean.getShoppingType();
        if (StringUtils.isNotBlank((String)shoppingType)) {
            ocShoppingDomain.setShoppingType(shoppingType);
        } else {
            ocShoppingDomain.setShoppingType(StringUtils.fillLeft((String)ocShoppingGoodsDomain.getGoodsType(), (char)'0', (int)2));
        }
        String pricesetType = goodsBean.getPricesetType();
        if (StringUtils.isNotBlank((String)pricesetType)) {
            ocShoppingDomain.setPricesetType(pricesetType);
        } else {
            ocShoppingDomain.setPricesetType(StringUtils.fillLeft((String)(StringUtils.isBlank((String)ocShoppingGoodsDomain.getGoodsPro()) ? "0" : ocShoppingGoodsDomain.getGoodsPro()), (char)'0', (int)2));
        }
        ocShoppingDomain.setMemberBcode(userSession.getUserPcode());
        ocShoppingDomain.setMemberBname(userSession.getMerberCompname());
        ocShoppingDomain.setTenantCode(ocShoppingGoodsDomain.getTenantCode());
        ocShoppingDomain.setGoodsOrigin(ocShoppingGoodsDomain.getGoodsOrigin());
        ocShoppingDomain.setContractNbillcode(goodsBean.getContractNbillcode());
        return ocShoppingDomain;
    }

    public List<OcShoppingReDomain> queryToContractDomain(OcShoppingDomain ocShoppingDomain, String platMemberCode, PmCheckBean pmCheckBean) {
        if (null == ocShoppingDomain) {
            return null;
        }
        List<OcShoppingReDomain> list = new ArrayList<OcShoppingReDomain>();
        OcShoppingReDomain ocShoppingReDomain = new OcShoppingReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocShoppingReDomain, (Object)ocShoppingDomain);
        }
        catch (Exception e) {
            return null;
        }
        list.add(ocShoppingReDomain);
        list = this.makePm(list, platMemberCode, pmCheckBean);
        return list;
    }

    public List<OcShoppingReDomain> queryToContractDomainList(List<OcShoppingDomain> ocShoppingDomainList, String platMemberCode, PmCheckBean pmCheckBean) {
        if (ListUtil.isEmpty(ocShoppingDomainList)) {
            return null;
        }
        List<OcShoppingReDomain> list = new ArrayList<OcShoppingReDomain>();
        for (OcShoppingDomain ocShoppingDomain : ocShoppingDomainList) {
            OcShoppingReDomain ocShoppingReDomain = new OcShoppingReDomain();
            try {
                BeanUtils.copyAllPropertys((Object)ocShoppingReDomain, (Object)ocShoppingDomain);
            }
            catch (Exception e) {
                return null;
            }
            list.add(ocShoppingReDomain);
        }
        list = this.makePm(list, platMemberCode, pmCheckBean);
        return list;
    }

    public List<OcShoppingReDomain> makePm(List<OcShoppingReDomain> ocShoppingReDomainList, String platMemberCode, PmCheckBean pmCheckBean) {
        if (ListUtil.isEmpty(ocShoppingReDomainList)) {
            return null;
        }
        List<OcShoppingReDomain> reOcShoppingReDomainList = this.checkPromotionForShoppingList(ocShoppingReDomainList, pmCheckBean);
        if (ListUtil.isEmpty(reOcShoppingReDomainList)) {
            reOcShoppingReDomainList = ocShoppingReDomainList;
        }
        TypeBean typeBean = null;
        for (OcShoppingReDomain ocShoppingReDomain : reOcShoppingReDomainList) {
            HtmlJsonReBean htmlJsonReBean;
            BigDecimal contractMoney = BigDecimal.ZERO;
            String tenantCode = ocShoppingReDomain.getTenantCode();
            if (null == ocShoppingReDomain.getShoppingCamount()) {
                ocShoppingReDomain.setShoppingCamount(BigDecimal.ZERO);
            }
            if (null == ocShoppingReDomain.getShoppingCweight()) {
                ocShoppingReDomain.setShoppingCweight(BigDecimal.ZERO);
            }
            if (null == ocShoppingReDomain.getGoodsMoney()) {
                ocShoppingReDomain.setGoodsMoney(BigDecimal.ZERO);
            }
            if (null == ocShoppingReDomain.getGoodsPmoney()) {
                ocShoppingReDomain.setGoodsPmoney(BigDecimal.ZERO);
            }
            if (!this.checkIntpay(typeBean = this.getOcSetting(ocShoppingReDomain.getShoppingType(), tenantCode)) || null == (htmlJsonReBean = this.upmUpointsServiceRepository.deductible(contractMoney, tenantCode, platMemberCode, "0")) || null == htmlJsonReBean.getDataObj()) continue;
            Map upmMap = (Map)htmlJsonReBean.getDataObj();
            ocShoppingReDomain.setUpmMap(upmMap);
        }
        return reOcShoppingReDomainList;
    }

    public List<PmUserCouponReDomain> queryUserCon(List<PmContractGoodsDomain> pmContractGoodsDomainList, PmCheckBean pmCheckBean) {
        return this.pmPromotionEngineServiceRepository.queryUserCon(pmContractGoodsDomainList, pmCheckBean);
    }
}

