/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.facade.rs.repository;

import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.common.send.SupperFacade;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuOneDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuOneReDomain;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class RsSkuOneServiceRepository
extends SupperFacade {
    public static final String stkey = "SkuOne-ChannelCode-TenantCode";

    public HtmlJsonReBean makeSaleminnum(String rsSkuDomainJson, UserSession userSession, String channelCode, String tenantCode) {
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        if (null == rsSkuDomainJson || null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d77\u8ba2\u91cf\u53c2\u6570\u9519\u8bef");
        }
        this.logger.error("\u8d77\u8ba2\u91cf-\u53c2\u6570\uff1aocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsSkuDomainJson));
        this.logger.error("\u8d77\u8ba2\u91cf-\u53c2\u6570\uff1auserSession", (Object)JsonUtil.buildNormalBinder().toJson((Object)userSession));
        this.logger.error("\u8d77\u8ba2\u91cf-\u53c2\u6570\uff1achannelCode :", (Object)channelCode);
        if (StringUtils.isBlank((String)channelCode)) {
            channelCode = "all";
        }
        ArrayList<RsSkuOneDomain> skuOneDomainList = new ArrayList<RsSkuOneDomain>();
        List rsSkuDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(rsSkuDomainJson, RsSkuDomain.class);
        for (RsSkuDomain rsSkuDomain : rsSkuDomainList) {
            RsSkuOneDomain skuOneDomain;
            List<RsSkuOneDomain> saleminnumList = this.getSaleminnum(rsSkuDomain, channelCode, tenantCode);
            if (ListUtil.isNotEmpty(saleminnumList) || null != (skuOneDomain = this.checkSaleminnum(saleminnumList, userSession))) continue;
            skuOneDomainList.add(skuOneDomain);
        }
        htmlJsonReBean.setDataObj(skuOneDomainList);
        return htmlJsonReBean;
    }

    private List<RsSkuOneDomain> getSaleminnum(RsSkuDomain rsSkuDomain, String channelCode, String tenantCode) {
        String key;
        List saleminnumList;
        if (null == rsSkuDomain.getSkuNo()) {
            rsSkuDomain.setSkuNo("all");
        }
        if (ListUtil.isEmpty((Collection)(saleminnumList = SupDisUtil.getMapListJson((String)stkey, (String)(key = channelCode + "-" + rsSkuDomain.getGoodsNo() + "-" + rsSkuDomain.getSkuNo() + "-" + tenantCode), RsSkuOneDomain.class)))) {
            saleminnumList = SupDisUtil.getMapListJson((String)stkey, (String)(channelCode + "-" + rsSkuDomain.getGoodsNo() + "-" + "all" + "-" + tenantCode), RsSkuOneDomain.class);
            if (ListUtil.isNotEmpty((Collection)saleminnumList)) {
                return saleminnumList;
            }
            saleminnumList = SupDisUtil.getMapListJson((String)stkey, (String)("all-" + rsSkuDomain.getGoodsNo() + "-" + rsSkuDomain.getSkuNo() + "-" + tenantCode), RsSkuOneDomain.class);
            if (ListUtil.isNotEmpty((Collection)saleminnumList)) {
                return saleminnumList;
            }
            saleminnumList = SupDisUtil.getMapListJson((String)stkey, (String)("all-" + rsSkuDomain.getGoodsNo() + "-" + rsSkuDomain.getSkuNo() + "-" + tenantCode), RsSkuOneDomain.class);
            if (ListUtil.isNotEmpty((Collection)saleminnumList)) {
                return saleminnumList;
            }
            saleminnumList = SupDisUtil.getMapListJson((String)stkey, (String)("all-" + rsSkuDomain.getGoodsNo() + "-" + "all" + "-" + tenantCode), RsSkuOneDomain.class);
            if (ListUtil.isNotEmpty((Collection)saleminnumList)) {
                return saleminnumList;
            }
        }
        return null;
    }

    private RsSkuOneDomain checkSaleminnum(List<RsSkuOneDomain> rsSkuOneDomains, UserSession userSession) {
        if (ListUtil.isEmpty(rsSkuOneDomains) || null == userSession) {
            return null;
        }
        Map<String, Object> objMap = this.makeObject(userSession);
        HashMap<String, Object> rsSkuOneMap = new HashMap<String, Object>();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        this.makeMem(rsSkuOneDomains, rsSkuOneMap, map);
        this.logger.error("\u8d77\u8ba2\u91cf-\u53c2\u6570\uff1amap", (Object)((Object)map).toString());
        String key = this.checkConf(map, objMap);
        this.logger.error("\u8d77\u8ba2\u91cf-\u53c2\u6570\uff1akey", (Object)key);
        this.logger.error("\u8d77\u8ba2\u91cf-\u53c2\u6570\uff1asaleminnumMap", (Object)((Object)rsSkuOneMap).toString());
        if (StringUtils.isNotBlank((String)key)) {
            key = "all|=-all";
        }
        return (RsSkuOneDomain)rsSkuOneMap.get(key);
    }

    private void makeMem(List<RsSkuOneDomain> saleminnumList, Map<String, Object> rsSkuOneMap, Map<String, List<String>> map) {
        if (ListUtil.isEmpty(saleminnumList)) {
            return;
        }
        Object object = null;
        String key = null;
        for (RsSkuOneDomain rsSkuOneDomain : saleminnumList) {
            List<String> list;
            if (StringUtils.isBlank((String)rsSkuOneDomain.getSkuOneType())) {
                rsSkuOneDomain.setSkuOneTerm("=");
            }
            if (null == (list = map.get(rsSkuOneDomain.getSkuOneType() + "|" + rsSkuOneDomain.getSkuOneTerm()))) {
                list = new ArrayList<String>();
                map.put(rsSkuOneDomain.getSkuOneType() + "|" + rsSkuOneDomain.getSkuOneTerm(), list);
            }
            list.add(rsSkuOneDomain.getSkuOneValue());
            key = rsSkuOneDomain.getSkuOneType() + "|" + rsSkuOneDomain.getSkuOneTerm() + "-" + rsSkuOneDomain.getSkuOneValue();
            object = rsSkuOneMap.get(key);
            if (null != object) continue;
            rsSkuOneMap.put(key, rsSkuOneDomain);
        }
    }

    private Map<String, Object> makeObject(UserSession userSession) {
        if (null == userSession) {
            return null;
        }
        Map obj = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)userSession), String.class, Object.class);
        return obj;
    }

    private String checkConf(Map<String, List<String>> map, Object obj) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        String flag = null;
        block0: for (String keys : map.keySet()) {
            Object objValue = BeanUtils.newForceGetProperty((Object)obj, (String)keys);
            List<String> valueList = map.get(keys);
            if (objValue instanceof String && null != objValue && objValue.toString().indexOf(",") > 0) {
                String[] otrs = objValue.toString().split("\\,");
                flag = null;
                for (String o : otrs) {
                    if (!this.cond(valueList, o)) continue;
                    flag = keys + "-" + o;
                    continue block0;
                }
                continue;
            }
            if (!this.cond(valueList, objValue)) continue;
            flag = keys + "-" + objValue;
            break;
        }
        return flag;
    }

    private boolean cond(List<String> valueList, Object objValue) {
        if (ListUtil.isEmpty(valueList)) {
            return false;
        }
        boolean flag = true;
        if (null == objValue) {
            objValue = "";
        }
        if (!valueList.contains(objValue.toString())) {
            flag = false;
        }
        return flag;
    }

    public HtmlJsonReBean deleteSkuOne(Integer skuOneId) {
        PostParamMap pmap = new PostParamMap("rs.skuOne.deleteSkuOne");
        pmap.putParam("skuOneId", (Object)skuOneId);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateSkuOne(RsSkuOneDomain rsSkuOneDomain) {
        PostParamMap pmap = new PostParamMap("rs.skuOne.updateSkuOne");
        pmap.putParamToJson("rsSkuOneDomain", (Object)rsSkuOneDomain);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean saveSkuOne(RsSkuOneDomain rsSkuOneDomain) {
        PostParamMap pmap = new PostParamMap("rs.skuOne.saveSkuOne");
        pmap.putParamToJson("rsSkuOneDomain", (Object)rsSkuOneDomain);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public RsSkuOneReDomain getSkuOne(Integer skuOneId) {
        PostParamMap pmap = new PostParamMap("rs.skuOne.getSkuOne");
        pmap.putParam("skuOneId", (Object)skuOneId);
        return (RsSkuOneReDomain)this.htmlIBaseService.senReObject(pmap, RsSkuOneReDomain.class);
    }

    public HtmlJsonReBean updateSkuOneStateByCode(String tenantCode, String skuOneCode, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("rs.skuOne.updateSkuOneStateByCode");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("skuOneCode", (Object)skuOneCode);
        pmap.putParam("dataState", (Object)dataState);
        pmap.putParam("oldDataState", (Object)oldDataState);
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean saveSkuOneBatch(List<RsSkuOneDomain> rsSkuOneDomainList) {
        PostParamMap pmap = new PostParamMap("rs.skuOne.saveSkuOneBatch");
        pmap.putParamToJson("rsSkuOneDomainList", rsSkuOneDomainList);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateSkuOneState(Integer skuOneId, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("rs.skuOne.updateSkuOneState");
        pmap.putParam("skuOneId", (Object)skuOneId);
        pmap.putParam("dataState", (Object)dataState);
        pmap.putParam("oldDataState", (Object)oldDataState);
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean deleteSkuOneByCode(String tenantCode, String skuOneCode) {
        PostParamMap pmap = new PostParamMap("rs.skuOne.deleteSkuOneByCode");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("skuOneCode", (Object)skuOneCode);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public SupQueryResult<RsSkuOneReDomain> querySkuOnePage(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("rs.skuOne.querySkuOnePage");
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendReSupObject(pmap, RsSkuOneReDomain.class);
    }

    public RsSkuOneReDomain getSkuOneByCode(String tenantCode, String skuOneCode) {
        PostParamMap pmap = new PostParamMap("rs.skuOne.getSkuOneByCode");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("skuOneCode", (Object)skuOneCode);
        return (RsSkuOneReDomain)this.htmlIBaseService.senReObject(pmap, RsSkuOneReDomain.class);
    }
}

