/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.facade.st.repository;

import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.common.send.SupperFacade;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.st.domain.OcContractDomain;
import com.qjsoft.laser.controller.facade.st.domain.OcContractGoodsDomain;
import com.qjsoft.laser.controller.facade.st.domain.StSaleminnumDomain;
import com.qjsoft.laser.controller.facade.st.domain.StSaleminnumReDomain;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class StSaleminnumServiceRepository
extends SupperFacade {
    public static final String stkey = "ChannelCode-TenantCode";

    public HtmlJsonReBean makeSaleminnum(OcContractDomain ocContractDomain, UserSession userSession, String channelCode, String tenantCode) {
        List saleminnumList;
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        if (null == ocContractDomain || ListUtil.isEmpty(ocContractDomain.getGoodsList()) || null == userSession) {
            return htmlJsonReBean;
        }
        this.logger.error("\u8d77\u8ba2\u91cf-\u53c2\u6570\uff1aocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        this.logger.error("\u8d77\u8ba2\u91cf-\u53c2\u6570\uff1auserSession", (Object)JsonUtil.buildNormalBinder().toJson((Object)userSession));
        this.logger.error("\u8d77\u8ba2\u91cf-\u53c2\u6570\uff1achannelCode :", (Object)channelCode);
        if (StringUtils.isBlank((String)channelCode)) {
            channelCode = "all";
        }
        if (ListUtil.isEmpty((Collection)(saleminnumList = SupDisUtil.getMapListJson((String)stkey, (String)(channelCode + "-" + tenantCode), StSaleminnumDomain.class)))) {
            if (!"all".equals(channelCode)) {
                saleminnumList = SupDisUtil.getMapListJson((String)stkey, (String)("all-" + tenantCode), StSaleminnumDomain.class);
                if (ListUtil.isEmpty((Collection)saleminnumList)) {
                    return htmlJsonReBean;
                }
            } else {
                return htmlJsonReBean;
            }
        }
        this.logger.error("\u8d77\u8ba2\u91cf-\u53c2\u6570\uff1asaleminnumList", (Object)JsonUtil.buildNormalBinder().toJson((Object)saleminnumList));
        StSaleminnumDomain stSaleminnumDomain = this.checkSaleminnum(saleminnumList, userSession);
        this.logger.error("\u8d77\u8ba2\u91cf-\u53c2\u6570\uff1astSaleminnumDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)stSaleminnumDomain));
        if (null == stSaleminnumDomain) {
            return htmlJsonReBean;
        }
        BigDecimal goodsMoneySum = new BigDecimal(0);
        BigDecimal goodsCweightSum = new BigDecimal(0);
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getGoodsList()) {
            goodsMoneySum = goodsMoneySum.add(ocContractGoodsDomain.getContractGoodsMoney());
            goodsCweightSum = goodsCweightSum.add(ocContractGoodsDomain.getGoodsCweight());
        }
        if ("0".equals(stSaleminnumDomain.getSaleminnumNumtype())) {
            if (goodsCweightSum.intValue() >= stSaleminnumDomain.getSaleminnumNum().intValue()) {
                htmlJsonReBean.setDataObj((Object)stSaleminnumDomain);
                return htmlJsonReBean;
            }
        } else if ("1".equals(stSaleminnumDomain.getSaleminnumNumtype()) && goodsMoneySum.intValue() >= stSaleminnumDomain.getSaleminnumNum().intValue()) {
            htmlJsonReBean.setDataObj((Object)stSaleminnumDomain);
            return htmlJsonReBean;
        }
        if (this.checkContractSum(ocContractDomain, stSaleminnumDomain)) {
            htmlJsonReBean.setDataObj((Object)stSaleminnumDomain);
            return htmlJsonReBean;
        }
        return htmlJsonReBean;
    }

    private boolean checkContractSum(OcContractDomain ocContractDomain, StSaleminnumDomain stSaleminnumDomain) {
        Integer sumDataBmoney;
        Integer sumDataBweight;
        String startDate = this.getStartDate(stSaleminnumDomain);
        String endDate = DateUtil.getDateString((Date)new Date(), (String)"yyyy-MM-dd HH:mm");
        HashMap<String, Object> ocMap = new HashMap<String, Object>();
        ocMap.put("startDate", startDate);
        ocMap.put("endDate", endDate);
        ocMap.put("memberCode", ocContractDomain.getMemberCode());
        ocMap.put("tenantCode", ocContractDomain.getTenantCode());
        ocMap.put("dateState", "2,3,4");
        HtmlJsonReBean htmlJsonReBean = this.saveSaleminnum(ocMap);
        this.logger.error("\u8d77\u8ba2\u91cf-\u53c2\u6570\uff1ahtmlJsonReBean", (Object)JsonUtil.buildNormalBinder().toJson((Object)htmlJsonReBean));
        Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(htmlJsonReBean.getDataObj().toString(), String.class, Integer.class);
        this.logger.error("\u8d77\u8ba2\u91cf-\u53c2\u6570\uff1amap", (Object)JsonUtil.buildNormalBinder().toJson((Object)map));
        return "0".equals(stSaleminnumDomain.getSaleminnumNumtype()) ? (sumDataBweight = (Integer)map.get("sumDataBweight")) >= stSaleminnumDomain.getSaleminnumNum().intValue() : "1".equals(stSaleminnumDomain.getSaleminnumNumtype()) && (sumDataBmoney = (Integer)map.get("sumDataBmoney")) >= stSaleminnumDomain.getSaleminnumNum().intValue();
    }

    public String getStartDate(StSaleminnumDomain stSaleminnumDomain) {
        Date date = new Date();
        String startDate = null;
        Date currentHour = DateUtil.dateToDate((Date)new Date(), (String)"HH:mm");
        String endDate1 = DateUtil.getEndDate((Date)new Date(), (int)0, (int)-1, (String)"yyyy-MM-dd");
        if ("0".equals(stSaleminnumDomain.getSaleminnumType())) {
            Date saleminnumHour = DateUtil.getDateToString((String)stSaleminnumDomain.getSaleminnumValue(), (String)"HH:mm");
            startDate = saleminnumHour.getTime() < currentHour.getTime() ? DateUtil.getDateString((Date)date, (String)"yyyy-MM-dd") + " " + stSaleminnumDomain.getSaleminnumValue() : DateUtil.getEndDate((Date)date, (int)0, (int)-1, (String)"yyyy-MM-dd") + " " + stSaleminnumDomain.getSaleminnumValue();
        } else if ("1".equals(stSaleminnumDomain.getSaleminnumType())) {
            String[] split = stSaleminnumDomain.getSaleminnumValue().split(";");
            int saleminnumWeek = Integer.valueOf(split[0]);
            String hours = split[1];
            Date saleminnumHour = DateUtil.getDateToString((String)split[1], (String)"HH:mm");
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            int week_index = cal.get(7) - 1;
            if (week_index < 0) {
                week_index = 0;
            }
            startDate = saleminnumWeek == week_index ? (saleminnumHour.getTime() < currentHour.getTime() ? DateUtil.getDateString((Date)date, (String)"yyyy-MM-dd") + " " + hours : DateUtil.getEndDate((Date)date, (int)0, (int)-7, (String)"yyyy-MM-dd") + " " + hours) : (saleminnumWeek > week_index ? DateUtil.getEndDate((Date)date, (int)0, (int)(saleminnumWeek - week_index - 7), (String)"yyyy-MM-dd") + " " + hours : DateUtil.getEndDate((Date)date, (int)0, (int)(saleminnumWeek - week_index), (String)"yyyy-MM-dd") + " " + hours);
        } else if ("2".equals(stSaleminnumDomain.getSaleminnumType())) {
            String[] split = stSaleminnumDomain.getSaleminnumValue().split(";");
            int saleminnumDay = Integer.valueOf(split[0]);
            String hours = split[1];
            Date saleminnumHour = DateUtil.getDateToString((String)split[1], (String)"HH:mm");
            int day = Integer.parseInt(DateUtil.getDateString((Date)date, (String)"dd"));
            if (saleminnumDay == day) {
                startDate = saleminnumHour.getTime() < currentHour.getTime() ? DateUtil.getDateString((Date)date, (String)"yyyy-MM-dd") + " " + hours : DateUtil.getEndDate((Date)date, (int)-1, (int)0, (String)"yyyy-MM-dd") + " " + hours;
            } else if (saleminnumDay < day) {
                startDate = DateUtil.getEndDate((Date)date, (int)0, (int)(saleminnumDay - day), (String)"yyyy-MM-dd") + " " + hours;
            } else {
                Date upmonth = DateUtil.getDateToString((String)DateUtil.getEndDate((Date)date, (int)-1, (int)0, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
                if (saleminnumDay > 28) {
                    saleminnumDay = StSaleminnumServiceRepository.getLastday(upmonth, saleminnumDay);
                }
                startDate = DateUtil.getDateString((Date)upmonth, (String)"yyyy-MM") + "-" + saleminnumDay + " " + hours;
            }
        }
        return startDate;
    }

    private static int getLastday(Date date, int saleminnumDay) {
        SimpleDateFormat format = new SimpleDateFormat("dd");
        Calendar cale = Calendar.getInstance();
        cale.setTime(date);
        cale.add(2, 1);
        cale.set(5, 0);
        Integer lastday = Integer.valueOf(format.format(cale.getTime()));
        if (lastday > saleminnumDay) {
            lastday = saleminnumDay;
        }
        return lastday;
    }

    private StSaleminnumDomain checkSaleminnum(List<StSaleminnumDomain> saleminnumList, UserSession userSession) {
        if (ListUtil.isEmpty(saleminnumList) || null == userSession) {
            return null;
        }
        StSaleminnumDomain stSaleminnumDomain = null;
        Map<String, Object> objMap = this.makeObject(userSession);
        HashMap<String, Object> saleminnumMap = new HashMap<String, Object>();
        Map<String, List<String>> map = this.makeMem(saleminnumList, saleminnumMap);
        String key = this.checkConf(map, objMap);
        this.logger.error("\u8d77\u8ba2\u91cf-\u53c2\u6570\uff1akey", (Object)JsonUtil.buildNormalBinder().toJson((Object)key));
        if (StringUtils.isNotBlank((String)key)) {
            stSaleminnumDomain = (StSaleminnumDomain)JsonUtil.buildNormalBinder().getJsonToObject(saleminnumMap.get(key).toString(), StSaleminnumDomain.class);
        }
        return stSaleminnumDomain;
    }

    private Map<String, List<String>> makeMem(List<StSaleminnumDomain> saleminnumList, Map<String, Object> saleminnumMap) {
        if (ListUtil.isEmpty(saleminnumList)) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Object object = null;
        String key = null;
        for (StSaleminnumDomain stSaleminnumDomain : saleminnumList) {
            ArrayList<String> list = (ArrayList<String>)map.get(stSaleminnumDomain.getSaleminnumUpro());
            if (null == list) {
                list = new ArrayList<String>();
                map.put(stSaleminnumDomain.getSaleminnumUpro(), list);
            }
            list.add(stSaleminnumDomain.getSaleminnumUprovalue());
            key = stSaleminnumDomain.getSaleminnumUpro() + "-" + stSaleminnumDomain.getSaleminnumUprovalue();
            object = saleminnumMap.get(key);
            if (null != object) continue;
            saleminnumMap.put(key, stSaleminnumDomain);
        }
        return map;
    }

    private Map<String, Object> makeObject(UserSession userSession) {
        if (null == userSession) {
            return null;
        }
        Map obj = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)userSession), String.class, Object.class);
        return obj;
    }

    private String checkConf(Map<String, List<String>> map, Object obj) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        String flag = null;
        block0: for (String keys : map.keySet()) {
            Object objValue = BeanUtils.newForceGetProperty((Object)obj, (String)keys);
            List<String> valueList = map.get(keys);
            if (objValue instanceof String && null != objValue && objValue.toString().indexOf(",") > 0) {
                String[] otrs = objValue.toString().split("\\,");
                flag = null;
                for (String o : otrs) {
                    if (!this.cond(valueList, o)) continue;
                    flag = keys + "-" + o;
                    continue block0;
                }
                continue;
            }
            if (!this.cond(valueList, objValue)) continue;
            flag = keys + "-" + objValue;
            break;
        }
        return flag;
    }

    private boolean cond(List<String> valueList, Object objValue) {
        if (ListUtil.isEmpty(valueList)) {
            return false;
        }
        boolean flag = true;
        if (null == objValue) {
            objValue = "";
        }
        if (!valueList.contains(objValue.toString())) {
            flag = false;
        }
        return flag;
    }

    public HtmlJsonReBean saveSaleminnum(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("oc.contract.queryContractSum");
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean saveSaleminnum(StSaleminnumDomain stSaleminnumDomain) {
        PostParamMap pmap = new PostParamMap("st.saleminnum.saveSaleminnum");
        pmap.putParamToJson("stSaleminnumDomain", (Object)stSaleminnumDomain);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean saveSaleminnumBatch(List<StSaleminnumDomain> stSaleminnumDomainList) {
        PostParamMap pmap = new PostParamMap("st.saleminnum.saveSaleminnumBatch");
        pmap.putParamToJson("stSaleminnumDomainList", stSaleminnumDomainList);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateSaleminnumState(Integer saleminnumId, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("st.saleminnum.updateSaleminnumState");
        pmap.putParam("saleminnumId", (Object)saleminnumId);
        pmap.putParam("dataState", (Object)dataState);
        pmap.putParam("oldDataState", (Object)oldDataState);
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateSaleminnumStateByCode(String tenantCode, String saleminnumCode, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("st.saleminnum.updateSaleminnumStateByCode");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("saleminnumCode", (Object)saleminnumCode);
        pmap.putParam("dataState", (Object)dataState);
        pmap.putParam("oldDataState", (Object)oldDataState);
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateSaleminnum(StSaleminnumDomain stSaleminnumDomain) {
        PostParamMap pmap = new PostParamMap("st.saleminnum.updateSaleminnum");
        pmap.putParamToJson("stSaleminnumDomain", (Object)stSaleminnumDomain);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public SupQueryResult<StSaleminnumReDomain> querySaleminnumPage(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("st.saleminnum.querySaleminnumPage");
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendReSupObject(pmap, StSaleminnumReDomain.class);
    }

    public StSaleminnumReDomain getSaleminnumByCode(String tenantCode, String saleminnumCode) {
        PostParamMap pmap = new PostParamMap("st.saleminnum.getSaleminnumByCode");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("saleminnumCode", (Object)saleminnumCode);
        return (StSaleminnumReDomain)this.htmlIBaseService.senReObject(pmap, StSaleminnumReDomain.class);
    }

    public HtmlJsonReBean deleteSaleminnum(Integer saleminnumId) {
        PostParamMap pmap = new PostParamMap("st.saleminnum.deleteSaleminnum");
        pmap.putParam("saleminnumId", (Object)saleminnumId);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean deleteSaleminnumByCode(String tenantCode, String saleminnumCode) {
        PostParamMap pmap = new PostParamMap("st.saleminnum.deleteSaleminnumByCode");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("saleminnumCode", (Object)saleminnumCode);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public StSaleminnumReDomain getSaleminnum(Integer saleminnumId) {
        PostParamMap pmap = new PostParamMap("st.saleminnum.getSaleminnum");
        pmap.putParam("saleminnumId", (Object)saleminnumId);
        return (StSaleminnumReDomain)this.htmlIBaseService.senReObject(pmap, StSaleminnumReDomain.class);
    }
}

