/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.facade.um.repository;

import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.common.send.SupperFacade;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.rd.repository.RdRandomListServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmQualityReDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmUserDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserReDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserRegBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoapplyDomain;
import com.qjsoft.laser.controller.facade.um.repository.UmQualityServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class UserBaseServiceRepository
extends SupperFacade {
    private static String CODE = "UserBaseServiceRepository";
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private UmQualityServiceRepository umQualityServiceRepository;
    @Autowired
    private RdRandomListServiceRepository rdRandomListServiceRepository;

    public String getQualityCode(String tenantCode, String qualityCode) {
        UmQualityReDomain umQualityReDomain = this.umQualityServiceRepository.getQualityByCode(tenantCode, qualityCode);
        if (umQualityReDomain == null || StringUtils.isBlank((String)umQualityReDomain.getQualityCode())) {
            umQualityReDomain = this.umQualityServiceRepository.getQualityByCode("00000000", qualityCode);
        }
        String qualityRole = null;
        if (null != umQualityReDomain && StringUtils.isNotBlank((String)umQualityReDomain.getQualityRole())) {
            qualityRole = umQualityReDomain.getQualityRole();
        }
        if (StringUtils.isBlank(qualityRole)) {
            this.logger.error(CODE + ".getQualityCode", (Object)"\u6570\u636e\u4e3a\u7a7a");
            return null;
        }
        return qualityRole;
    }

    public UmQualityReDomain getQuality(String tenantCode, String qualityCode) {
        UmQualityReDomain umQualityReDomain = this.umQualityServiceRepository.getQualityByCode(tenantCode, qualityCode);
        if (umQualityReDomain == null || StringUtils.isBlank((String)umQualityReDomain.getQualityCode())) {
            umQualityReDomain = this.umQualityServiceRepository.getQualityByCode("00000000", qualityCode);
        }
        if (null == umQualityReDomain) {
            this.logger.error(CODE + ".getQuality", (Object)("\u6570\u636e\u4e3a\u7a7a:" + tenantCode + "-" + qualityCode));
            return null;
        }
        return umQualityReDomain;
    }

    public Map<String, Object> checkExecuteRandomValidity(String businessType, String host, String random, String app_id, String tenantCode, Boolean isSendUser) {
        Map<String, Object> result_code = new HashMap<String, Object>();
        try {
            this.logger.error("\u4f20\u503c\u4e3a\uff1a", (Object)("businessType" + businessType + "host:" + host + ",random:" + random + ",app_id:" + app_id + ",tenantCode:" + tenantCode + ",isSendUser:" + isSendUser));
            result_code = this.rdRandomListServiceRepository.executeRandomValidity(businessType, host, random, app_id, tenantCode);
        }
        catch (Exception e) {
            result_code.put("flag", false);
            result_code.put("message", "\u9a8c\u8bc1\u7801\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6");
            this.logger.error(CODE + ".checkExecuteRandomValidity.e", (Throwable)e);
            return result_code;
        }
        if (!((Boolean)result_code.get("flag")).booleanValue()) {
            if (isSendUser.booleanValue()) {
                result_code.put("send", true);
            }
            result_code.put("message", "\u9a8c\u8bc1\u7801\u8f93\u5165\u9519\u8bef");
            this.logger.error(CODE + ".checkExecuteRandomValidity.e", (Object)"\u9a8c\u8bc1\u7801\u8f93\u5165\u9519\u8bef");
            return result_code;
        }
        return result_code;
    }

    public HtmlJsonReBean checkUserinfoCompname(String tenantCode, String userinfoCompname) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)userinfoCompname)) {
            this.logger.error(CODE + ".checkUserPhone", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoCompname", userinfoCompname);
        map.put("tenantCode", tenantCode);
        SupQueryResult<UmUserinfoReDomainBean> umUserReDomainBeanList = this.userServiceRepository.queryUserinfoPage(map);
        if (null != umUserReDomainBeanList.getList() && umUserReDomainBeanList.getList().size() > 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u5df2\u7ecf\u6ce8\u518c");
        }
        return new HtmlJsonReBean();
    }

    public HtmlJsonReBean checkUserPhone(String tenantCode, String userPhone) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)userPhone)) {
            this.logger.error(CODE + ".checkUserPhone", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userPhone", userPhone);
        map.put("tenantCode", tenantCode);
        SupQueryResult<UmUserReDomainBean> umUserReDomainBeanList = this.userServiceRepository.queryUserPage(map);
        if (null != umUserReDomainBeanList.getList() && umUserReDomainBeanList.getList().size() > 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        return new HtmlJsonReBean();
    }

    public HtmlJsonReBean checkUserEmial(String tenantCode, String userEmial) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)userEmial)) {
            this.logger.error(CODE + ".checkUserEmial", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userEmial", userEmial);
        map.put("tenantCode", tenantCode);
        SupQueryResult<UmUserReDomainBean> umUserReDomainBeanList = this.userServiceRepository.queryUserPage(map);
        if (null != umUserReDomainBeanList.getList() && umUserReDomainBeanList.getList().size() > 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u90ae\u7bb1\u5df2\u5b58\u5728");
        }
        return new HtmlJsonReBean();
    }

    public HtmlJsonReBean saveUmuser(UmUserRegBean umUserRegBean) {
        return this.saveUmusercom(umUserRegBean, false);
    }

    public HtmlJsonReBean saveUmusercom(UmUserRegBean umUserRegBean, boolean stop) {
        if (null == umUserRegBean || StringUtils.isBlank((String)umUserRegBean.getTenantCode())) {
            return new HtmlJsonReBean("error", "\u53c2\u6570\u5f02\u5e38");
        }
        if (StringUtils.isBlank((String)umUserRegBean.getUserinfoQuality())) {
            umUserRegBean.setUserinfoQuality("buy");
        }
        if (StringUtils.isBlank((Integer)umUserRegBean.getUserinfoType())) {
            umUserRegBean.setUserinfoType(1);
        }
        UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
        try {
            BeanUtils.copyAllPropertys((Object)umUserDomainBean, (Object)umUserRegBean);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".saveUmuser.e", (Throwable)e);
        }
        String compname = umUserRegBean.getUserRelname();
        if (StringUtils.isBlank((String)compname)) {
            compname = umUserRegBean.getUserName();
        }
        if (StringUtils.isBlank((String)compname)) {
            compname = umUserRegBean.getUserName();
        }
        if (StringUtils.isBlank((String)compname)) {
            compname = umUserRegBean.getUserPhone();
        }
        if (StringUtils.isBlank((String)compname)) {
            compname = umUserRegBean.getUserEmial();
        }
        umUserDomainBean.setUserinfoCompname(compname);
        umUserDomainBean.setProvinceCode(umUserRegBean.getProvinceCode());
        umUserDomainBean.setCityCode(umUserRegBean.getCityCode());
        umUserDomainBean.setAreaCode(umUserRegBean.getAreaCode());
        umUserDomainBean.setProvinceName(umUserRegBean.getProvinceName());
        umUserDomainBean.setCityName(umUserRegBean.getCityName());
        umUserDomainBean.setAreaName(umUserRegBean.getAreaName());
        if (!umUserRegBean.isAutoCheck()) {
            ArrayList<UmUserinfoapplyDomain> umUserinfoapplyDomainList = new ArrayList<UmUserinfoapplyDomain>();
            UmUserinfoapplyDomain umUserinfoapplyDomain = new UmUserinfoapplyDomain();
            umUserinfoapplyDomainList.add(umUserinfoapplyDomain);
            try {
                BeanUtils.copyAllPropertys((Object)umUserinfoapplyDomain, (Object)umUserDomainBean);
            }
            catch (Exception exception) {
                // empty catch block
            }
            umUserDomainBean.setUmUserinfoapplyDomainList(umUserinfoapplyDomainList);
        }
        HtmlJsonReBean htmlJsonReBean = stop ? this.userServiceRepository.sendOpenUserinfoForSc(umUserDomainBean) : this.userServiceRepository.sendOpenUserinfo(umUserDomainBean);
        return htmlJsonReBean;
    }

    public HtmlJsonReBean saveUmuserForSc(UmUserRegBean umUserRegBean) {
        return this.saveUmusercom(umUserRegBean, true);
    }

    public void sendUserBigData(UmUserDomainBean umUserDomainBean) {
        if (null == umUserDomainBean) {
            return;
        }
        String bigdataFlag = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(umUserDomainBean.getTenantCode() + "-bigdata-bigdataflag"));
        if (StringUtils.isBlank((String)bigdataFlag) || !"true".equals(bigdataFlag)) {
            return;
        }
        String value = "{\"paasLabel\":\"userInfo\",\"message\":" + JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean) + "}";
        PostParamMap pmap = new PostParamMap("kafka.adapter.sendProducerInfo");
        pmap.putParam("topic", (Object)"paas_business");
        pmap.putParam("value", (Object)value);
        this.htmlIBaseService.sendMesReBeanInAsync(pmap);
    }

    public SupQueryResult<UmUserinfoReDomain> queryUserinfoPage(Map<String, Object> map) {
        PostParamMap pmap = new PostParamMap("um.userbase.queryUserinfoPage");
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendReSupObject(pmap, UmUserinfoReDomain.class);
    }
}

