/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.facade.vd.domain;

import com.qjsoft.laser.controller.facade.vd.domain.VdFaccountDirectionEnum;
import com.qjsoft.laser.controller.facade.vd.domain.VdFaccountFundEnum;
import com.qjsoft.laser.controller.facade.vd.domain.VdFaccountInnerDomain;
import com.qjsoft.laser.controller.facade.vd.domain.VdFaccountInnerSubsetDomain;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.core.convert.converter.Converter;

public class VdFaccountInnerInfo {
    private Integer faccountInnerId;
    private String faccountInnerNo;
    private String faccountInnerName;
    private String faccountTitileCode;
    private String currencyCode;
    private String currencyDirection;
    private String faccountDirection;
    private String faccountType;
    private String faccountLevel;
    private BigDecimal faccountAmount;
    private BigDecimal faccountPortion;
    private BigDecimal faccountPrice;
    private String tenantCode;
    private Date gmtCreate;
    private Date gmtModified;
    private String memo;
    private Integer dataState;
    private String fundType;

    public void setInfoValueWhenFundTypeEquals(List<VdFaccountInnerSubsetDomain> subsetList) {
        if (subsetList == null || subsetList.isEmpty()) {
            return;
        }
        if (StringUtils.isBlank((String)this.getFundType())) {
            this.setFundType(VdFaccountFundEnum.DEBIT.getFundCode());
        }
        for (VdFaccountInnerSubsetDomain subset : subsetList) {
            if (!this.getFundType().equals(subset.getFundType())) continue;
            this.setCurrencyDirection(subset.getCurrencyDirection());
            this.setFaccountDirection(subset.getFaccountDirection());
            this.setCurrencyCode(subset.getCurrencyCode());
            this.setFaccountAmount(subset.getFaccountAmount());
            this.setFaccountPortion(subset.getFaccountPortion());
            this.setFaccountPrice(subset.getFaccountPrice());
        }
    }

    public VdFaccountInnerInfo convertToVdFaccountInnerInfo(VdFaccountInnerDomain vdFaccountInner) {
        VdFaccountInfoConvert convert = new VdFaccountInfoConvert();
        return convert.convert(vdFaccountInner);
    }

    public Integer getFaccountInnerId() {
        return this.faccountInnerId;
    }

    public void setFaccountInnerId(Integer faccountInnerId) {
        this.faccountInnerId = faccountInnerId;
    }

    public String getFaccountInnerNo() {
        return this.faccountInnerNo;
    }

    public void setFaccountInnerNo(String faccountInnerNo) {
        this.faccountInnerNo = faccountInnerNo;
    }

    public String getFaccountInnerName() {
        return this.faccountInnerName;
    }

    public void setFaccountInnerName(String faccountInnerName) {
        this.faccountInnerName = faccountInnerName;
    }

    public String getFaccountTitileCode() {
        return this.faccountTitileCode;
    }

    public void setFaccountTitileCode(String faccountTitileCode) {
        this.faccountTitileCode = faccountTitileCode;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public String getCurrencyDirection() {
        if (StringUtils.isBlank((String)this.currencyDirection) && VdFaccountDirectionEnum.DIRECTION_TWO_WAY.getCode().equals(this.faccountDirection)) {
            if (VdFaccountDirectionEnum.DIRECTION_TWO_WAY.getCode().equals(this.faccountDirection)) {
                return VdFaccountDirectionEnum.DIRECTION_DEBIT.getCode();
            }
            return this.faccountDirection;
        }
        return this.currencyDirection;
    }

    public void setCurrencyDirection(String currencyDirection) {
        this.currencyDirection = currencyDirection;
    }

    public String getFaccountDirection() {
        return this.faccountDirection;
    }

    public void setFaccountDirection(String faccountDirection) {
        this.faccountDirection = faccountDirection;
    }

    public String getFaccountType() {
        return this.faccountType;
    }

    public void setFaccountType(String faccountType) {
        this.faccountType = faccountType;
    }

    public String getFaccountLevel() {
        return this.faccountLevel;
    }

    public void setFaccountLevel(String faccountLevel) {
        this.faccountLevel = faccountLevel;
    }

    public BigDecimal getFaccountAmount() {
        return this.faccountAmount;
    }

    public void setFaccountAmount(BigDecimal faccountAmount) {
        this.faccountAmount = faccountAmount;
    }

    public BigDecimal getFaccountPortion() {
        return this.faccountPortion;
    }

    public void setFaccountPortion(BigDecimal faccountPortion) {
        this.faccountPortion = faccountPortion;
    }

    public BigDecimal getFaccountPrice() {
        return this.faccountPrice;
    }

    public void setFaccountPrice(BigDecimal faccountPrice) {
        this.faccountPrice = faccountPrice;
    }

    public String getTenantCode() {
        return this.tenantCode;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public Date getGmtCreate() {
        return this.gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return this.gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getDataState() {
        return this.dataState;
    }

    public void setDataState(Integer dataState) {
        this.dataState = dataState;
    }

    public String getFundType() {
        return this.fundType;
    }

    public void setFundType(String fundType) {
        this.fundType = fundType;
    }

    private static class VdFaccountInfoConvert
    implements Converter<VdFaccountInnerDomain, VdFaccountInnerInfo> {
        private VdFaccountInfoConvert() {
        }

        public VdFaccountInnerInfo convert(VdFaccountInnerDomain source) {
            VdFaccountInnerInfo info = new VdFaccountInnerInfo();
            BeanUtils.copyProperties((Object)source, (Object)info);
            return info;
        }
    }
}

