/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.fc.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.fc.domain.FcTraintemDomain;
import com.qjsoft.laser.controller.facade.fc.domain.FcTraintemEntryDomain;
import com.qjsoft.laser.controller.facade.fc.domain.FcTraintemEntryReDomain;
import com.qjsoft.laser.controller.facade.fc.domain.FcTraintemReDomain;
import com.qjsoft.laser.controller.facade.fc.repository.FcTraintemEntryServiceRepository;
import com.qjsoft.laser.controller.facade.fc.repository.FcTraintemServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/fc/traintem"}, name="\u57f9\u8bad\u670d\u52a1")
public class TraintemCon
extends SpringmvcController {
    private static String CODE = "fc.traintem.con";
    @Autowired
    private FcTraintemServiceRepository fcTraintemServiceRepository;
    @Autowired
    private FcTraintemEntryServiceRepository fcTraintemEntryServiceRepository;

    protected String getContext() {
        return "traintem";
    }

    @RequestMapping(value={"saveTraintem.json"}, name="\u589e\u52a0\u57f9\u8bad\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveTraintem(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveGift", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveGift", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        FcTraintemDomain fcTraintemDomain = (FcTraintemDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, FcTraintemDomain.class);
        if (null == fcTraintemDomain || fcTraintemDomain.getFcTraintemEntryReDomainList().size() == 0) {
            this.logger.error(CODE + ".saveTraintem.fcTraintemDomain", (Object)"fcTraintemEntryReDomainList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u57f9\u8bad\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        fcTraintemDomain.setTenantCode(this.getTenantCode(request));
        HtmlJsonReBean htmlJsonReBean = this.fcTraintemServiceRepository.saveTraintem(fcTraintemDomain);
        if (null != htmlJsonReBean) {
            String traintemCode = htmlJsonReBean.getDataObj().toString();
            List fcTraintemEntryReDomainList = fcTraintemDomain.getFcTraintemEntryReDomainList();
            if (!traintemCode.isEmpty()) {
                for (FcTraintemEntryReDomain fcTraintemEntryReDomain : fcTraintemEntryReDomainList) {
                    fcTraintemEntryReDomain.setTraintemCode(traintemCode);
                    fcTraintemEntryReDomain.setTenantCode(this.getTenantCode(request));
                    fcTraintemEntryReDomain.setTraintemEntryType("0");
                    fcTraintemEntryReDomain.setTraintemEntryInfo(fcTraintemDomain.getTraintemInfo());
                }
                ArrayList fcTraintemEntryDomainList = new ArrayList();
                try {
                    BeanUtils.copyAllPropertys(fcTraintemEntryDomainList, (Object)fcTraintemEntryReDomainList);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.fcTraintemEntryServiceRepository.saveTraintemEntryBatch(fcTraintemEntryDomainList);
            }
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"getTraintem.json"}, name="\u83b7\u53d6\u57f9\u8bad\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public FcTraintemReDomain getTraintem(Integer traintemId) {
        if (StringUtils.isBlank((Integer)traintemId)) {
            this.logger.error(CODE + ".getTraintem", (Object)"param is null");
            return null;
        }
        FcTraintemReDomain fcTraintemReDomain = this.fcTraintemServiceRepository.getTraintem(traintemId);
        if (null != fcTraintemReDomain) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("traintemCode", fcTraintemReDomain.getTraintemCode());
            map.put("tenantCode", fcTraintemReDomain.getTenantCode());
            SupQueryResult fcTraintemEntryReDomainList = this.fcTraintemEntryServiceRepository.queryTraintemEntryPage(map);
            List fcTraintemEntryReDomainArr = new ArrayList();
            if (null != fcTraintemEntryReDomainList) {
                fcTraintemEntryReDomainArr = fcTraintemEntryReDomainList.getList();
            }
            fcTraintemReDomain.setFcTraintemEntryReDomainList(fcTraintemEntryReDomainArr);
        }
        return fcTraintemReDomain;
    }

    @RequestMapping(value={"updateTraintem.json"}, name="\u66f4\u65b0\u57f9\u8bad\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateTraintem(HttpServletRequest request, FcTraintemDomain fcTraintemDomain) {
        if (null == fcTraintemDomain) {
            this.logger.error(CODE + ".updateTraintem", (Object)"fcTraintemDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List fcTraintemEntryReDomainArr = fcTraintemDomain.getFcTraintemEntryReDomainList();
        if (null != fcTraintemEntryReDomainArr || fcTraintemEntryReDomainArr.size() > 0) {
            for (FcTraintemEntryReDomain fcTraintemEntryReDomain : fcTraintemEntryReDomainArr) {
                fcTraintemEntryReDomain.setTenantCode(this.getTenantCode(request));
                this.fcTraintemEntryServiceRepository.updateTraintemEntry((FcTraintemEntryDomain)fcTraintemEntryReDomain);
            }
        }
        fcTraintemDomain.setTenantCode(this.getTenantCode(request));
        return this.fcTraintemServiceRepository.updateTraintem(fcTraintemDomain);
    }

    @RequestMapping(value={"deleteTraintem.json"}, name="\u5220\u9664\u57f9\u8bad\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteTraintem(Integer traintemId) {
        if (StringUtils.isBlank((Integer)traintemId)) {
            this.logger.error(CODE + ".deleteTraintem", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        FcTraintemReDomain fcTraintemReDomain = this.fcTraintemServiceRepository.getTraintem(traintemId);
        HtmlJsonReBean htmlJsonReBean = this.fcTraintemServiceRepository.updateTraintemState(traintemId, Integer.valueOf(-1), fcTraintemReDomain.getDataState());
        List fcTraintemEntryReDomainList = fcTraintemReDomain.getFcTraintemEntryReDomainList();
        if (null != fcTraintemEntryReDomainList || fcTraintemEntryReDomainList.size() > 0) {
            for (FcTraintemEntryReDomain fcTraintemEntryReDomain : fcTraintemEntryReDomainList) {
                this.fcTraintemEntryServiceRepository.updateTraintemEntryState(fcTraintemEntryReDomain.getTraintemEntryId(), Integer.valueOf(-1), fcTraintemEntryReDomain.getDataState());
            }
        }
        return this.fcTraintemServiceRepository.deleteTraintem(traintemId);
    }

    @RequestMapping(value={"queryTraintemPage.json"}, name="\u67e5\u8be2\u57f9\u8bad\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<FcTraintemReDomain> queryTraintemPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        SupQueryResult fcTraintemReDomainList = this.fcTraintemServiceRepository.queryTraintemPage(param);
        List fcTraintemReDomainArr = new ArrayList();
        if (null == fcTraintemReDomainList) {
            fcTraintemReDomainArr = fcTraintemReDomainList.getList();
        }
        for (FcTraintemReDomain fcTraintemReDomain : fcTraintemReDomainArr) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("traintemCode", fcTraintemReDomain.getTraintemCode());
            map.put("tenantCode", fcTraintemReDomain.getTenantCode());
            SupQueryResult fcTraintemEntryReDomainList = this.fcTraintemEntryServiceRepository.queryTraintemEntryPage(map);
            List fcTraintemEntryReDomainArr = new ArrayList();
            if (null != fcTraintemEntryReDomainList) {
                fcTraintemEntryReDomainArr = fcTraintemEntryReDomainList.getList();
            }
            fcTraintemReDomain.setFcTraintemEntryReDomainList(fcTraintemEntryReDomainArr);
        }
        return fcTraintemReDomainList;
    }

    @RequestMapping(value={"updateTraintemState.json"}, name="\u66f4\u65b0\u57f9\u8bad\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateTraintemState(String traintemId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)traintemId)) {
            this.logger.error(CODE + ".updateTraintemState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.fcTraintemServiceRepository.updateTraintemState(Integer.valueOf(traintemId), dataState, oldDataState);
    }
}

